/* -*- Mode: C; indent-tabs-mode: t; c-basic-offset: 4; tab-width: 4 -*- */
/*
 *  ianjuta-debugger-variable.h -- Autogenerated from libanjuta.idl
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

#ifndef _IANJUTA_DEBUGGER_VARIABLE_H_
#define _IANJUTA_DEBUGGER_VARIABLE_H_

#include <glib-object.h>
#include <libanjuta/interfaces/ianjuta-debugger.h>

G_BEGIN_DECLS

#define IANJUTA_TYPE_DEBUGGER_VARIABLE (ianjuta_debugger_variable_get_type ())
#define IANJUTA_DEBUGGER_VARIABLE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), IANJUTA_TYPE_DEBUGGER_VARIABLE, IAnjutaDebuggerVariable))
#define IANJUTA_IS_DEBUGGER_VARIABLE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), IANJUTA_TYPE_DEBUGGER_VARIABLE))
#define IANJUTA_DEBUGGER_VARIABLE_GET_IFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), IANJUTA_TYPE_DEBUGGER_VARIABLE, IAnjutaDebuggerVariableIface))

#define IANJUTA_DEBUGGER_VARIABLE_ERROR ianjuta_debugger_variable_error_quark()

typedef struct _IAnjutaDebuggerVariable IAnjutaDebuggerVariable;
typedef struct _IAnjutaDebuggerVariableIface IAnjutaDebuggerVariableIface;

typedef struct _IAnjutaDebuggerVariableObject IAnjutaDebuggerVariableObject;
struct _IAnjutaDebuggerVariableObject {
	gchar *name;
	gchar *expression;
	gchar *type;
	gchar *value;
	gboolean changed;
	gboolean exited;
	gboolean deleted;
	gint children;
	gboolean has_more;
};


struct _IAnjutaDebuggerVariableIface {
	IAnjutaDebuggerIface g_iface;
	

	gboolean (*assign) (IAnjutaDebuggerVariable *obj, const gchar *name,  const gchar *value, GError **err);
	gboolean (*create) (IAnjutaDebuggerVariable *obj, const gchar *expression,  IAnjutaDebuggerCallback callback,  gpointer user_data, GError **err);
	gboolean (*destroy) (IAnjutaDebuggerVariable *obj, const gchar *name, GError **err);
	gboolean (*evaluate) (IAnjutaDebuggerVariable *obj, const gchar *name,  IAnjutaDebuggerCallback callback,  gpointer user_data, GError **err);
	gboolean (*list_children) (IAnjutaDebuggerVariable *obj, const gchar *name,  IAnjutaDebuggerCallback callback,  gpointer user_data, GError **err);
	gboolean (*update) (IAnjutaDebuggerVariable *obj, IAnjutaDebuggerCallback callback,  gpointer user_data, GError **err);

};


GQuark ianjuta_debugger_variable_error_quark     (void);
GType  ianjuta_debugger_variable_get_type        (void);

gboolean ianjuta_debugger_variable_assign (IAnjutaDebuggerVariable *obj, const gchar *name,  const gchar *value, GError **err);

gboolean ianjuta_debugger_variable_create (IAnjutaDebuggerVariable *obj, const gchar *expression,  IAnjutaDebuggerCallback callback,  gpointer user_data, GError **err);

gboolean ianjuta_debugger_variable_destroy (IAnjutaDebuggerVariable *obj, const gchar *name, GError **err);

gboolean ianjuta_debugger_variable_evaluate (IAnjutaDebuggerVariable *obj, const gchar *name,  IAnjutaDebuggerCallback callback,  gpointer user_data, GError **err);

gboolean ianjuta_debugger_variable_list_children (IAnjutaDebuggerVariable *obj, const gchar *name,  IAnjutaDebuggerCallback callback,  gpointer user_data, GError **err);

gboolean ianjuta_debugger_variable_update (IAnjutaDebuggerVariable *obj, IAnjutaDebuggerCallback callback,  gpointer user_data, GError **err);


G_END_DECLS

#endif
