/*
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#ifndef __XKB_CAPPLET_PRIVATE_H__
#define __XKB_CAPPLET_PRIVATE_H__

#include "gswitchit_capplet.h"

#define OPTION_CONTROLS_LIST_PROPERTY "optionControlsList"

#define LAYOUTS_TREE_VIEW_PROPERTY "layoutsTreeView"

#define LAYOUTS_POPUP_PROPERTY "layoutsPopup"

#define BONOBO_PREVIEW_PROPERTY "bonoboPreview"

#define CURRENT_GROUP_NO_PROPERTY "__currentGroupNo"

#define CURRENT_ITEM_PROPERTY "__currentItem"

#define CURRENT_LIST_PROPERTY "__currentList"

#define CURRENT_MENU_PROPERTY "__currentMenu"

#define CURRENT_OPTION_GROUP_NAME_PROPERTY "__currentOptionGroupName"

#define CURRENT_LAYOUT_NAME_PROPERTY "__currentLayoutName"

#define CURRENT_NODE_PROPERTY "__currentNode"

#define NODE_TO_SHOW_PROPERTY "__node2Show"

#define FULL_LAYOUT_NAME_BTN_PROPERTY "fullLayoutName"

#define GROUP_NO_PROPERTY "groupNo"

extern void XkbCappletSetup( GSwitchItCapplet * gswic );

extern void XkbCappletOk( GtkWidget * w, GSwitchItCapplet * gswic );

extern void XkbCappletCancel( GtkWidget * w, GSwitchItCapplet * gswic );

extern void XkbCappletHelp( GtkWidget * w, GSwitchItCapplet * gswic );

extern void XkbCappletSetStateToChanged( GObject * o,
                                         GSwitchItCapplet * gswic );

extern void XkbCappletLayoutTreeItemSelected( GtkTreeSelection * selection,
                                              GSwitchItCapplet * gswic );

extern void XkbCappletUseCustomXkbSettingsButtonToggled( GtkToggleButton *
                                                         togglebutton,
                                                         GSwitchItCapplet *
                                                         gswic );

extern void XkbCappletUseGlobalXkbSettingsButtonToggled( GtkToggleButton *
                                                         togglebutton,
                                                         GSwitchItCapplet *
                                                         gswic );

extern void XkbCappletUseSomeXkbSettingsButtonToggled( GtkToggleButton *
                                                       togglebutton,
                                                       GSwitchItCapplet *
                                                       gswic,
                                                       gboolean custom );

extern void XkbCappletLayoutButtonClicked( GtkButton * layoutButton,
                                           GSwitchItCapplet * gswic );

extern void XkbCappletClearLayoutButtonClicked( GtkButton *
                                                clearLayoutButton,
                                                GSwitchItCapplet * gswic );

extern void XkbCappletPrepareWidget( const GSwitchItCapplet * gswic,
                                     GtkWidget * widget,
                                     const char *ctlName,
                                     const char *dataKey );

extern void XkbCappletPreviewClicked( GtkButton * button,
                                      GSwitchItCapplet * gswic );

extern void XkbCappletUpdateConfigFromGui( GSwitchItCapplet * gswic );

extern void XkbCappletUpdateGuiFromConfig( GSwitchItCapplet * gswic );

extern GtkWidget *XkbCappletGetGladeWidget( GSwitchItCapplet * gswic,
                                            const char *name );

extern void XkbCappletPopupLayoutTree( GSwitchItCapplet * gswic,
                                       int groupNumber );

extern const char *XkbCappletLayout2Id( const int groupNumber,
                                        const char *ctlType );

extern const char *XkbModelName2Id( const char *name );

extern const char *XkbOptionGroupName2Id( const char *groupName,
                                          const char *ctlType );

extern const char *XkbOptionName2Id( const char *groupName,
                                     const char *optionName );

extern const char *XkbCappletConfigItemDesc( XklConfigItem * ci );

extern void XkbCappletUpdateLayoutButtonsFromConfig( GSwitchItCapplet *
                                                     gswic );

extern void XkbCappletInitLayoutButtons( GSwitchItCapplet * gswic );

extern void XkbCappletPreviewZoomIn( GtkWidget * w,
                                     GSwitchItCapplet * gswic );

extern void XkbCappletPreviewZoomOut( GtkWidget * w,
                                      GSwitchItCapplet * gswic );

extern void XkbCappletPreviewZoomFit( GtkWidget * w,
                                      GSwitchItCapplet * gswic );

extern void XkbCappletPreviewZoomDefault( GtkWidget * w,
                                          GSwitchItCapplet * gswic );

#endif
