/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.core.internal.security;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.spec.InvalidKeySpecException;
import java.util.Random;
import javax.crypto.Cipher;
import javax.crypto.CipherInputStream;
import javax.crypto.CipherOutputStream;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.PBEKeySpec;
import javax.crypto.spec.SecretKeySpec;
import org.xmind.core.CoreException;
import org.xmind.core.IEncryptionData;
import org.xmind.core.IEntryStreamNormalizer;
import org.xmind.core.IFileEntry;
import org.xmind.core.internal.security.Base64;
import org.xmind.core.internal.security.ChecksumInputStream;
import org.xmind.core.internal.security.ChecksumOutputStream;
import org.xmind.core.internal.security.PKCS12KeyGenerator;
import org.xmind.core.io.ChecksumTrackingOutputStream;
import org.xmind.core.io.ChecksumVerifiedInputStream;

public class PasswordProtectedNormalizer
implements IEntryStreamNormalizer {
    private static final String ALGORITHM_NAME = "AES/CBC/PKCS5Padding";
    private static final String OLD37_KEY_DERIVATION_ALGORITHM_NAME = "PKCS12";
    private static final String KEY_DERIVATION_ALGORITHM_NAME = "PBKDF2WithHmacSHA512";
    private static final String KEY_DERIVATION_ITERATION_COUNT = "1024";
    private static final String CHECKSUM_TYPE = "MD5";
    private static final String KEY_DERIVATION_SIZE = "128";
    private static Random random = null;
    private final String password;

    public PasswordProtectedNormalizer(String password) {
        if (password == null) {
            throw new IllegalArgumentException("password is null");
        }
        this.password = password;
    }

    public OutputStream normalizeOutputStream(OutputStream stream, IFileEntry fileEntry) throws IOException, CoreException {
        fileEntry.deleteEncryptionData();
        IEncryptionData encData = fileEntry.createEncryptionData();
        encData.setAttribute(ALGORITHM_NAME, new String[]{"algorithm", "algorithm-name"});
        encData.setAttribute(KEY_DERIVATION_ALGORITHM_NAME, new String[]{"key-derivation", "key-derivation-name"});
        encData.setAttribute(PasswordProtectedNormalizer.generateSalt(), new String[]{"key-derivation", "salt"});
        encData.setAttribute(KEY_DERIVATION_ITERATION_COUNT, new String[]{"key-derivation", "iteration-count"});
        encData.setAttribute(KEY_DERIVATION_SIZE, new String[]{"key-derivation", "size"});
        encData.setAttribute(PasswordProtectedNormalizer.generateIV(), new String[]{"key-derivation", "iv"});
        encData.setChecksumType(CHECKSUM_TYPE);
        boolean oldEncrptWay = this.beforeEncrpt37(encData);
        Cipher cipher = this.createCipher(true, oldEncrptWay, encData, this.password);
        CipherOutputStream out = new CipherOutputStream(stream, cipher);
        if (encData.getChecksumType() != null) {
            out = new ChecksumTrackingOutputStream(encData, (OutputStream)new ChecksumOutputStream(out));
        }
        return out;
    }

    private boolean beforeEncrpt37(IEncryptionData encData) {
        String keyAlgoName = encData.getAttribute(new String[]{"key-derivation", "key-derivation-name"});
        return OLD37_KEY_DERIVATION_ALGORITHM_NAME.equals(keyAlgoName);
    }

    public InputStream normalizeInputStream(InputStream stream, IFileEntry fileEntry) throws IOException, CoreException {
        IEncryptionData encData = fileEntry.getEncryptionData();
        if (encData == null) {
            return stream;
        }
        boolean oldEncrptWay = this.beforeEncrpt37(encData);
        Cipher oldCipher = this.createCipher(false, oldEncrptWay, encData, this.password);
        CipherInputStream in = new CipherInputStream(stream, oldCipher);
        if (encData.getChecksumType() != null) {
            in = new ChecksumVerifiedInputStream((InputStream)new ChecksumInputStream(in), encData.getChecksum());
        }
        return in;
    }

    private Cipher createCipher(boolean encrypt, boolean oldWay, IEncryptionData encData, String password) throws CoreException {
        this.checkEncryptionData(encData);
        Key aesKey = this.createKey(oldWay, encData, password);
        byte[] iv = this.getIV(encData);
        IvParameterSpec ivParameter = new IvParameterSpec(iv);
        Cipher cipher = null;
        try {
            cipher = Cipher.getInstance(ALGORITHM_NAME);
        }
        catch (NoSuchAlgorithmException e) {
            throw new CoreException(16, (Throwable)e);
        }
        catch (NoSuchPaddingException e) {
            throw new CoreException(16, (Throwable)e);
        }
        try {
            cipher.init(encrypt ? 1 : 2, aesKey, ivParameter);
        }
        catch (InvalidKeyException e) {
            throw new CoreException(17, (Throwable)e);
        }
        catch (InvalidAlgorithmParameterException e) {
            throw new CoreException(16, (Throwable)e);
        }
        return cipher;
    }

    private Key createKey(boolean old, IEncryptionData encData, String password) throws CoreException {
        byte[] key = old ? this.getOldKeyByte(encData, password) : this.getKeyByte(encData, password);
        return new SecretKeySpec(key, "AES");
    }

    private byte[] getKeyByte(IEncryptionData encData, String password) throws CoreException {
        SecretKeyFactory keyFactory = null;
        try {
            keyFactory = SecretKeyFactory.getInstance(KEY_DERIVATION_ALGORITHM_NAME);
        }
        catch (NoSuchAlgorithmException e) {
            throw new CoreException(16, (Throwable)e);
        }
        PBEKeySpec keySpec = new PBEKeySpec(password.toCharArray(), this.getSalt(encData), this.getIterationCount(encData), this.getKeySize(encData));
        try {
            return keyFactory.generateSecret(keySpec).getEncoded();
        }
        catch (InvalidKeySpecException e) {
            throw new CoreException(17, (Throwable)e);
        }
    }

    private byte[] getOldKeyByte(IEncryptionData encData, String password) throws CoreException {
        PKCS12KeyGenerator keyGen = null;
        try {
            keyGen = new PKCS12KeyGenerator(MessageDigest.getInstance(CHECKSUM_TYPE));
        }
        catch (NoSuchAlgorithmException e) {
            throw new CoreException(16, (Throwable)e);
        }
        byte[] pwBytes = password == null ? new byte[]{} : PKCS12KeyGenerator.PKCS12PasswordToBytes(password.toCharArray());
        keyGen.init(pwBytes, this.getSalt(encData), this.getIterationCount(encData));
        byte[] key = keyGen.generateDerivedKey(this.getKeySize(encData));
        return key;
    }

    private void checkEncryptionData(IEncryptionData encData) throws CoreException {
        String algoName = encData.getAttribute(new String[]{"algorithm", "algorithm-name"});
        if (algoName == null || !ALGORITHM_NAME.equals(algoName)) {
            throw new CoreException(16);
        }
        String keyAlgoName = encData.getAttribute(new String[]{"key-derivation", "key-derivation-name"});
        if (keyAlgoName == null || !KEY_DERIVATION_ALGORITHM_NAME.equals(keyAlgoName) && !OLD37_KEY_DERIVATION_ALGORITHM_NAME.equals(keyAlgoName)) {
            throw new CoreException(16);
        }
    }

    private int getIterationCount(IEncryptionData encData) {
        return encData.getIntAttribute(1024, new String[]{"key-derivation", "iteration-count"});
    }

    private byte[] getSalt(IEncryptionData encData) throws CoreException {
        String saltString = encData.getAttribute(new String[]{"key-derivation", "salt"});
        if (saltString == null) {
            throw new CoreException(16);
        }
        return Base64.base64ToByteArray(saltString);
    }

    private byte[] getIV(IEncryptionData encData) throws CoreException {
        String ivString = encData.getAttribute(new String[]{"key-derivation", "iv"});
        if (ivString == null) {
            return new byte[16];
        }
        return Base64.base64ToByteArray(ivString);
    }

    private int getKeySize(IEncryptionData encData) throws CoreException {
        String keySizeString = encData.getAttribute(new String[]{"key-derivation", "size"});
        if (keySizeString != null) {
            try {
                return Integer.parseInt(keySizeString);
            }
            catch (NumberFormatException numberFormatException) {}
        }
        return Integer.parseInt(KEY_DERIVATION_SIZE);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || !(obj instanceof PasswordProtectedNormalizer)) {
            return false;
        }
        PasswordProtectedNormalizer that = (PasswordProtectedNormalizer)obj;
        return this.password.equals(that.password);
    }

    public int hashCode() {
        return 0x25 ^ this.password.hashCode();
    }

    private static Random getRandom() {
        if (random == null) {
            random = new Random();
        }
        return random;
    }

    private static String generateSalt() {
        return Base64.byteArrayToBase64(PasswordProtectedNormalizer.generateSaltBytes());
    }

    private static String generateIV() {
        return Base64.byteArrayToBase64(PasswordProtectedNormalizer.generateIVBytes());
    }

    private static byte[] generateSaltBytes() {
        byte[] bytes = new byte[8];
        PasswordProtectedNormalizer.getRandom().nextBytes(bytes);
        return bytes;
    }

    private static byte[] generateIVBytes() {
        byte[] bytes = new byte[16];
        PasswordProtectedNormalizer.getRandom().nextBytes(bytes);
        return bytes;
    }
}

