/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.internal.iconfinder;

import java.lang.reflect.Field;
import java.util.List;
import org.eclipse.jface.dialogs.PopupDialog;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseTrackListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.forms.widgets.AbstractHyperlink;
import org.eclipse.ui.forms.widgets.Hyperlink;

public class ListDialog<T>
extends PopupDialog {
    private List<T> input;
    private Rectangle aroundBounds = null;

    public ListDialog(Shell parent, List<T> input) {
        super(parent, 8, true, false, false, false, false, null, null);
        this.input = input;
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout(2, true));
        composite.setLayoutData((Object)new GridData(4, 4, true, true));
        int size = this.input.size();
        int half = size / 2;
        int leftSize = size - half;
        Composite leftComposite = new Composite(composite, 0);
        leftComposite.setLayout((Layout)new GridLayout());
        leftComposite.setLayoutData((Object)new GridData(0x1000000, 1, true, true));
        int i = 0;
        while (i < leftSize) {
            Hyperlink item = this.createItem(leftComposite);
            this.configItem(item, this.input.get(i));
            ++i;
        }
        Composite rightComposite = new Composite(composite, 0);
        rightComposite.setLayout((Layout)new GridLayout());
        rightComposite.setLayoutData((Object)new GridData(0x1000000, 1, true, true));
        int i2 = leftSize;
        while (i2 < size) {
            Hyperlink item = this.createItem(rightComposite);
            this.configItem(item, this.input.get(i2));
            ++i2;
        }
        return composite;
    }

    protected void configItem(Hyperlink item, T t) {
    }

    private Hyperlink createItem(Composite parent) {
        final Hyperlink item = new Hyperlink(parent, 0);
        try {
            Field fPaintFocus = AbstractHyperlink.class.getDeclaredField("paintFocus");
            fPaintFocus.setAccessible(true);
            fPaintFocus.set(item, false);
        }
        catch (Throwable throwable) {}
        item.addMouseTrackListener(new MouseTrackListener(){

            public void mouseHover(MouseEvent e) {
            }

            public void mouseExit(MouseEvent e) {
                item.setUnderlined(false);
                item.setCaret(null);
            }

            public void mouseEnter(MouseEvent e) {
                item.setUnderlined(true);
                item.setCursor(item.getDisplay().getSystemCursor(21));
            }
        });
        return item;
    }

    public int open(Rectangle aroundBounds) {
        this.aroundBounds = aroundBounds;
        return super.open();
    }

    public int open(Point location) {
        if (location != null) {
            this.aroundBounds = new Rectangle(location.x, location.y, 1, 1);
        }
        return super.open();
    }

    private Point calcLocation(Rectangle aroundBounds, Point shellSize) {
        Point loc = new Point(aroundBounds.x, aroundBounds.y);
        Rectangle area = this.getShell().getDisplay().getClientArea();
        if (aroundBounds.x + shellSize.x > area.x + area.width) {
            loc.x = aroundBounds.x + aroundBounds.width - shellSize.x;
        }
        loc.y = aroundBounds.y + aroundBounds.height + shellSize.y > area.y + area.height ? aroundBounds.y - shellSize.y : aroundBounds.y + aroundBounds.height;
        return loc;
    }

    protected Point getInitialLocation(Point initialSize) {
        if (this.aroundBounds != null) {
            return this.calcLocation(this.aroundBounds, initialSize);
        }
        return super.getInitialLocation(initialSize);
    }

    protected Color getBackground() {
        return Display.getCurrent().getSystemColor(1);
    }
}

