/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.internal.presentation.slide;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.xmind.core.IAdaptable;
import org.xmind.core.IBoundary;
import org.xmind.core.IExtensionElement;
import org.xmind.core.IRelationship;
import org.xmind.core.IResourceRef;
import org.xmind.core.ISummary;
import org.xmind.core.ITopic;
import org.xmind.core.IWorkbook;
import org.xmind.core.IWorkbookComponent;
import org.xmind.core.IWorkbookExtensionElement;
import org.xmind.ui.internal.presentation.slide.IPresentationEventListener;
import org.xmind.ui.internal.presentation.slide.PresentationEvent;
import org.xmind.ui.internal.presentation.slide.PresentationSlide;
import org.xmind.ui.internal.presentation.slide.SelectionSpliter;
import org.xmind.ui.internal.presentation.slide.SlidePreviewGenerator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PresentationStory {
    public static final Comparator<ITopic> TOPIC_COMPARATOR_BY_LEVEL = new Comparator<ITopic>(){

        @Override
        public int compare(ITopic t1, ITopic t2) {
            Integer t2Level;
            Integer t1Level = t1.getPath().toTopicList().indexOf(t1);
            if (t1Level.equals(t2Level = Integer.valueOf(t2.getPath().toTopicList().indexOf(t2)))) {
                Integer t1Index = t1.getIndex();
                Integer t2Index = t2.getIndex();
                return t1Index.compareTo(t2Index);
            }
            return t1Level.compareTo(t2Level);
        }
    };
    private IWorkbookExtensionElement element;
    private List<IPresentationEventListener> listeners = new ArrayList<IPresentationEventListener>();
    private List<PresentationSlide> slides = new ArrayList<PresentationSlide>();

    public PresentationStory(IWorkbookExtensionElement element) {
        this.element = element;
        this.init();
    }

    public IWorkbook getOwnedWorkbook() {
        return this.element.getOwnedWorkbook();
    }

    private void init() {
        if (this.element != null) {
            List es = this.element.getChildren("slide");
            for (IWorkbookExtensionElement e : es) {
                PresentationSlide slide = new PresentationSlide(this, e);
                slide.init();
                this.slides.add(slide);
            }
        }
    }

    protected IWorkbookExtensionElement getImplementation() {
        return this.element;
    }

    public void setName(String name) {
        this.element.setAttribute("name", name);
    }

    public String getName() {
        return this.element.getAttribute("name");
    }

    public String getId() {
        return this.element.getAttribute("id");
    }

    public List<PresentationSlide> getSlides() {
        return this.slides;
    }

    public int getSlidesSize() {
        return this.getSlides().size();
    }

    public int getSlideIndex(PresentationSlide slide) {
        return this.slides.indexOf(slide);
    }

    public List<PresentationSlide> createSlides(IStructuredSelection selections) {
        SelectionSpliter spliter = SelectionSpliter.instance;
        if (!spliter.canSplit(selections)) {
            return Collections.emptyList();
        }
        ArrayList<PresentationSlide> ss = new ArrayList<PresentationSlide>();
        for (IAdaptable[] as : spliter.split(selections)) {
            ss.add(this.createSlide(Arrays.asList(as)));
        }
        return ss;
    }

    public PresentationSlide createSlide(PresentationSlide slide) {
        return this.createSlide(slide.getSelections());
    }

    private PresentationSlide createSlide(List<IAdaptable> selections) {
        if (selections == null || selections.isEmpty()) {
            throw new IllegalArgumentException();
        }
        IAdaptable parent = this.getParent(selections);
        String type = this.getType(parent);
        PresentationSlide slide = new PresentationSlide(this, (IWorkbookExtensionElement)this.element.createChild("slide"));
        slide.setSelections(selections);
        slide.setParent(parent);
        slide.setType(type);
        IResourceRef ref = SlidePreviewGenerator.generate(slide);
        if (ref != null) {
            slide.setResourceRef(ref);
        }
        return slide;
    }

    private IAdaptable getParent(List<IAdaptable> selections) {
        IAdaptable firstElement = selections.get(0);
        if (firstElement instanceof IBoundary) {
            return firstElement;
        }
        if (firstElement instanceof IRelationship) {
            return firstElement;
        }
        if (firstElement instanceof ISummary) {
            return firstElement;
        }
        if (firstElement instanceof ITopic) {
            ArrayList<ITopic> ts = new ArrayList<ITopic>();
            for (IAdaptable selection : selections) {
                ts.add((ITopic)selection);
            }
            Collections.sort(ts, TOPIC_COMPARATOR_BY_LEVEL);
            return (IAdaptable)ts.get(0);
        }
        throw new IllegalArgumentException();
    }

    private String getType(IAdaptable parent) {
        if (parent instanceof IBoundary) {
            return "boundary";
        }
        if (parent instanceof IRelationship) {
            return "relationship";
        }
        if (parent instanceof ISummary) {
            return "summary";
        }
        if (parent instanceof ITopic) {
            return "topic";
        }
        throw new IllegalArgumentException();
    }

    public void addSlide(PresentationSlide slide) {
        this.addSlide(slide, -1);
    }

    public void addSlide(PresentationSlide slide, int index) {
        if (slide != null) {
            IResourceRef ref = slide.getResourceRef();
            if (ref != null) {
                this.element.getExtension().addResourceRef(ref);
            }
            if (index > -1 && index < this.slides.size()) {
                if (!this.slides.contains(slide)) {
                    this.slides.add(index, slide);
                }
                this.element.addChild((IExtensionElement)slide.getElement(), index);
            } else {
                if (!this.slides.contains(slide)) {
                    this.slides.add(slide);
                }
                this.element.addChild((IExtensionElement)slide.getElement(), -1);
            }
            this.fireSlideEvent(slide, "addSlide");
        }
    }

    public void deleteSlide(PresentationSlide slide) {
        if (slide != null) {
            IResourceRef ref = slide.getResourceRef();
            if (ref != null) {
                this.element.getExtension().removeResourceRef(ref);
            }
            this.element.deleteChild((IExtensionElement)slide.getElement());
            this.slides.remove(slide);
            this.fireSlideEvent(slide, "removeSlide");
        }
    }

    public void refreshSlides() {
        ArrayList<PresentationSlide> ss = new ArrayList<PresentationSlide>(this.slides);
        for (PresentationSlide s : ss) {
            if (!this.isOrphan(s.getParent())) continue;
            if ("relationship".equals(s.getType())) {
                ArrayList<IAdaptable> newSelections = new ArrayList<IAdaptable>(s.getSelections().size());
                for (IAdaptable a : s.getSelections()) {
                    if (this.isOrphan(a)) continue;
                    newSelections.add(a);
                }
                if (!newSelections.isEmpty()) {
                    s.setParent((IAdaptable)newSelections.get(0));
                    s.setSelections(newSelections);
                    continue;
                }
            }
            this.deleteSlide(s);
        }
    }

    private boolean isOrphan(IAdaptable a) {
        if (a instanceof IWorkbookComponent) {
            return ((IWorkbookComponent)a).isOrphan();
        }
        return true;
    }

    public void registerSlideEventListener(IPresentationEventListener listener) {
        if (!this.listeners.contains(listener)) {
            this.listeners.add(listener);
        }
    }

    public void unregisterSlideEventListener(IPresentationEventListener listener) {
        if (this.listeners.contains(listener)) {
            this.listeners.remove(listener);
        }
    }

    private void fireSlideEvent(PresentationSlide source, String type) {
        PresentationEvent e = new PresentationEvent(source, type);
        for (IPresentationEventListener l : this.listeners) {
            l.handleEvent(e);
        }
    }
}

