/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.gantt2.gefext;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.draw2d.Layer;
import org.xmind.gef.ILayerManager;
import org.xmind.gef.part.IPart;
import org.xmind.ui.gantt2.gefext.IConnectionManager;
import org.xmind.ui.mindmap.IConnectionPart;
import org.xmind.ui.mindmap.INodePart;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ConnectionManager
implements IConnectionManager {
    private IPart parent;
    private ILayerManager layerManager;
    private Map<Object, List<PendingConnection>> pendingSources = new HashMap<Object, List<PendingConnection>>();
    private Map<Object, List<PendingConnection>> pendingTargets = new HashMap<Object, List<PendingConnection>>();

    public ConnectionManager(IPart parent, ILayerManager layerManager) {
        this.parent = parent;
        this.layerManager = layerManager;
    }

    @Override
    public IPart getParent() {
        return this.parent;
    }

    @Override
    public ILayerManager getLayerManager() {
        return this.layerManager;
    }

    @Override
    public void addPendingSource(Object source, Object connection, Object target) {
        List<PendingConnection> list = this.pendingSources.get(source);
        if (list == null) {
            list = new ArrayList<PendingConnection>();
            this.pendingSources.put(source, list);
        }
        list.add(new PendingConnection(connection, source, target));
    }

    @Override
    public void addPendingTarget(Object target, Object connection, Object source) {
        List<PendingConnection> list = this.pendingTargets.get(target);
        if (list == null) {
            list = new ArrayList<PendingConnection>();
            this.pendingTargets.put(target, list);
        }
        list.add(new PendingConnection(connection, source, target));
    }

    @Override
    public void removePendingSource(Object source, Object connection, Object target) {
        List<PendingConnection> list = this.pendingSources.get(source);
        if (list != null) {
            list.remove(new PendingConnection(connection, source, target));
            if (list.isEmpty()) {
                this.pendingSources.remove(source);
            }
        }
    }

    @Override
    public void removePendingTarget(Object target, Object connection, Object source) {
        List<PendingConnection> list = this.pendingTargets.get(target);
        if (list != null) {
            list.remove(new PendingConnection(connection, source, target));
            if (list.isEmpty()) {
                this.pendingTargets.remove(target);
            }
        }
    }

    @Override
    public void removeAllPendingSources(Object target) {
        this.removeAllPendingConnections(this.pendingSources, target, true);
    }

    @Override
    public void removeAllPendingTargets(Object sourcel) {
        this.removeAllPendingConnections(this.pendingTargets, sourcel, false);
    }

    private void removeAllPendingConnections(Map<Object, List<PendingConnection>> map, Object value, boolean valueIsTarget) {
        Object[] objectArray = map.keySet().toArray();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object key = objectArray[n2];
            List<PendingConnection> list = map.get(key);
            Object[] objectArray2 = list.toArray();
            int n3 = objectArray2.length;
            int n4 = 0;
            while (n4 < n3) {
                Object c = objectArray2[n4];
                PendingConnection pc = (PendingConnection)c;
                if (valueIsTarget ? pc.getTarget().equals(value) : pc.getSource().equals(value)) {
                    list.remove(c);
                }
                ++n4;
            }
            if (list.isEmpty()) {
                map.remove(key);
            }
            ++n2;
        }
    }

    @Override
    public void solvePendingSource(Object source) {
        this.solvePendingConnections(this.pendingSources, source);
    }

    @Override
    public void solvePendingTarget(Object target) {
        this.solvePendingConnections(this.pendingTargets, target);
    }

    private void solvePendingConnections(Map<Object, List<PendingConnection>> map, Object key) {
        List<PendingConnection> pendingConnections = map.remove(key);
        if (pendingConnections != null && !pendingConnections.isEmpty()) {
            Object[] objectArray = pendingConnections.toArray();
            int n = objectArray.length;
            int n2 = 0;
            while (n2 < n) {
                Object pendingConnection = objectArray[n2];
                this.createPendingConnection((PendingConnection)pendingConnection);
                ++n2;
            }
        }
    }

    protected Layer getLayer(Object layerKey) {
        return this.getLayerManager().getLayer(layerKey);
    }

    protected IPart createPart(Object model) {
        return this.parent.getSite().getViewer().getPartFactory().createPart(this.getParent(), model);
    }

    protected IPart findPart(Object model) {
        return this.parent.getSite().getViewer().getPartRegistry().getPartByModel(model);
    }

    protected INodePart findNodePart(Object model) {
        IPart part = this.findPart(model);
        return part instanceof INodePart ? (INodePart)part : null;
    }

    protected void createPendingConnection(PendingConnection pendingConnection) {
        this.createConnection(pendingConnection.getConnection(), pendingConnection.getSource(), pendingConnection.getTarget());
    }

    @Override
    public void createConnection(Object connection, Object source, Object target) {
        INodePart sourcePart = this.findNodePart(source);
        INodePart targetPart = this.findNodePart(target);
        boolean hasSource = this.isSourcePartAvailable(sourcePart);
        boolean hasTarget = this.isTargetPartAvailable(targetPart);
        if (hasSource && hasTarget) {
            this.doCreateConnection(connection, sourcePart, targetPart);
        } else {
            if (!hasSource) {
                this.addPendingSource(source, connection, target);
            }
            if (!hasTarget) {
                this.addPendingTarget(target, connection, source);
            }
        }
    }

    protected boolean isSourcePartAvailable(INodePart part) {
        return this.isPartAvailable(part);
    }

    protected boolean isTargetPartAvailable(INodePart part) {
        return this.isPartAvailable(part);
    }

    protected boolean isPartAvailable(INodePart part) {
        return part != null && part.getStatus().isActive();
    }

    protected boolean doCreateConnection(Object connection, INodePart source, INodePart target) {
        IPart connectionPart = this.findPart(connection);
        if (connectionPart != null) {
            return false;
        }
        connectionPart = this.createPart(connection);
        if (connectionPart instanceof IConnectionPart) {
            this.activateConnection((IConnectionPart)connectionPart, source, target);
            return true;
        }
        return false;
    }

    protected void activateConnection(IConnectionPart connection, INodePart source, INodePart target) {
        connection.setSourceNode(source);
        connection.setTargetNode(target);
        source.addSourceConnection(connection);
        target.addTargetConnection(connection);
        connection.setParent(this.getParent());
        this.addConnectionView(connection);
        connection.addNotify();
        connection.getStatus().activate();
    }

    protected void addConnectionView(IConnectionPart connection) {
        this.getConnectionLayer(connection).add(connection.getFigure());
    }

    protected abstract Layer getConnectionLayer(IConnectionPart var1);

    @Override
    public void deleteConnection(IConnectionPart connectionPart) {
        connectionPart.getStatus().deactivate();
        connectionPart.removeNotify();
        this.removeConnectionView(connectionPart);
        connectionPart.setParent(null);
        if (connectionPart.getTargetNode() != null) {
            connectionPart.getTargetNode().removeTargetConnection(connectionPart);
        }
        if (connectionPart.getSourceNode() != null) {
            connectionPart.getSourceNode().removeSourceConnection(connectionPart);
        }
        connectionPart.setTargetNode(null);
        connectionPart.setSourceNode(null);
    }

    protected void removeConnectionView(IConnectionPart connection) {
        this.getConnectionLayer(connection).remove(connection.getFigure());
    }

    private static class PendingConnection {
        private Object connection;
        private Object source;
        private Object target;

        public PendingConnection(Object connection, Object source, Object target) {
            this.connection = connection;
            this.source = source;
            this.target = target;
        }

        public Object getConnection() {
            return this.connection;
        }

        public Object getSource() {
            return this.source;
        }

        public Object getTarget() {
            return this.target;
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj == null || !(obj instanceof PendingConnection)) {
                return false;
            }
            PendingConnection that = (PendingConnection)obj;
            return this.connection.equals(that.connection) && this.source.equals(that.source) && this.target.equals(that.target);
        }
    }
}

