/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.internal.prefs;

import org.eclipse.jface.preference.BooleanFieldEditor;
import org.eclipse.jface.preference.FieldEditor;
import org.eclipse.jface.preference.FieldEditorPreferencePage;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.IntegerFieldEditor;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.xmind.ui.internal.MindMapUIPlugin;
import org.xmind.ui.internal.prefs.PrefMessages;

public class EditorPrefPage
extends FieldEditorPreferencePage
implements IWorkbenchPreferencePage {
    public EditorPrefPage() {
        super(PrefMessages.EditorPage_title, 0);
    }

    protected IPreferenceStore doGetPreferenceStore() {
        return MindMapUIPlugin.getDefault().getPreferenceStore();
    }

    protected void createFieldEditors() {
        this.addPreviewField();
        this.addUndoRedoField();
        this.addTopicPositioningGroup();
        this.addAnimationField();
        this.addShadowField();
        this.addZoomField();
    }

    private void addUndoRedoField() {
        Composite parent = this.createGroup(PrefMessages.EditorPage_UndoLimit_title);
        this.addField((FieldEditor)new IntegerFieldEditor("undoLimit", PrefMessages.EditorPage_UndoLimit_label, this.createFieldContainer(parent)));
        Label descriptionLabel = new Label(parent, 64);
        descriptionLabel.setLayoutData((Object)new GridData(4, 0x1000000, false, false));
        ((GridData)descriptionLabel.getLayoutData()).widthHint = 400;
        descriptionLabel.setText(PrefMessages.EditorPage_UndoRedo_description);
    }

    private void addTopicPositioningGroup() {
        Composite parent = this.createGroup(PrefMessages.EditorPage_TopicPositioning_title);
        this.addAllowOverlapsField(this.createFieldContainer(parent));
        this.addAllowManualLayoutField(this.createFieldContainer(parent));
        this.addAllowFreePositionField(this.createFieldContainer(parent));
        Label descriptionLabel = new Label(parent, 64);
        descriptionLabel.setLayoutData((Object)new GridData(4, 0x1000000, false, false));
        ((GridData)descriptionLabel.getLayoutData()).widthHint = 400;
        descriptionLabel.setText(PrefMessages.EditorPage_TopicPositioning_FreePositioning_description);
    }

    private void addAnimationField() {
        this.addField((FieldEditor)new BooleanFieldEditor("animationEnabled", PrefMessages.EditorPage_EnableAnimation_text, this.getFieldEditorParent()));
    }

    private void addShadowField() {
        this.addField((FieldEditor)new BooleanFieldEditor("shadowEnabled", PrefMessages.EditorPage_EnableShadow_text, this.getFieldEditorParent()));
    }

    private void addPreviewField() {
        this.addField((FieldEditor)new BooleanFieldEditor("previewSkipped", PrefMessages.EditorPage_Preview_text, this.getFieldEditorParent()));
    }

    private Composite createGroup(String groupTitle) {
        Composite parent = this.getFieldEditorParent();
        GridLayout gridLayout = new GridLayout(1, false);
        gridLayout.marginWidth = 0;
        gridLayout.marginHeight = 0;
        gridLayout.verticalSpacing = 0;
        gridLayout.horizontalSpacing = 0;
        parent.setLayout((Layout)gridLayout);
        Group group = new Group(parent, 0);
        group.setLayoutData((Object)new GridData(4, 4, true, true));
        group.setLayout((Layout)new GridLayout(1, false));
        group.setText(groupTitle);
        return group;
    }

    private Composite createFieldContainer(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayoutData((Object)new GridData(4, 4, true, true));
        composite.setLayout((Layout)new GridLayout(1, false));
        return composite;
    }

    private void addAllowOverlapsField(Composite parent) {
        this.addField((FieldEditor)new BooleanFieldEditor("overlapsAllowed", PrefMessages.EditorPage_TopicPositioning_AllowOverlaps, parent));
    }

    private void addAllowManualLayoutField(Composite parent) {
        this.addField((FieldEditor)new BooleanFieldEditor("manualLayoutAllowed", PrefMessages.EditorPage_TopicPositioning_AllowManualLayout, parent));
    }

    private void addAllowFreePositionField(Composite parent) {
        this.addField((FieldEditor)new BooleanFieldEditor("freePositionAllowed", PrefMessages.EditorPage_TopicPositioning_AllowFreePosition, parent));
    }

    private void addZoomField() {
        if (this.getPreferenceStore().getInt("zoome_value") == 0) {
            this.getPreferenceStore().setValue("zoome_value", 100);
        }
        this.addField((FieldEditor)new IntegerFieldEditor("zoome_value", PrefMessages.EditorPage_Zoom_Scale_text, this.getFieldEditorParent()));
    }

    public void init(IWorkbench workbench) {
    }
}

