/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.internal.branch;

import java.util.HashSet;
import java.util.Set;
import org.xmind.gef.graphicalpolicy.IStyleSelector;
import org.xmind.gef.part.IGraphicalPart;
import org.xmind.gef.part.IPart;
import org.xmind.ui.mindmap.IBranchPart;
import org.xmind.ui.mindmap.ICacheManager;
import org.xmind.ui.util.MindMapUtils;

public class ParentValueProvider {
    private static final String CACHE_PARENT_VALUE_PROVIDER = "org.xmind.ui.branchCache.parentValueProvider";
    private static final String PREFIX = "org.xmind.ui.branchCache.style.";
    private static final String USER_PREFIX = "org.xmind.ui.branchCache.style.user.";
    private IBranchPart branch;
    private Set<String> cachedKeys = null;

    private ParentValueProvider(IBranchPart branch) {
        this.branch = branch;
    }

    public String getParentValue(String key) {
        String cacheKey = PREFIX + key;
        String value = (String)MindMapUtils.getCache((IPart)this.branch, cacheKey);
        if (value == null) {
            value = this.getParentCachedValue(this.branch, key, cacheKey);
            if (value == null) {
                value = "$NULL$";
            }
            MindMapUtils.setCache((IPart)this.branch, cacheKey, value);
            if (this.cachedKeys == null) {
                this.cachedKeys = new HashSet<String>();
            }
            this.cachedKeys.add(cacheKey);
        }
        if ("$NULL$".equals(value)) {
            return null;
        }
        return value;
    }

    private String getParentCachedValue(IBranchPart branch, String key, String cacheKey) {
        IBranchPart parent = branch.getParentBranch();
        if (parent != null) {
            ParentValueProvider parentProvider = ParentValueProvider.getValueProvider(parent);
            return parentProvider.getCachedValue(parent, key, cacheKey);
        }
        return null;
    }

    private String getCachedValue(IBranchPart branch, String key, String cacheKey) {
        String userCacheKey = USER_PREFIX + key;
        String value = (String)MindMapUtils.getCache((IPart)branch, userCacheKey);
        if (value == null) {
            value = this.getValue(branch, key, cacheKey);
            if (value == null) {
                value = "$NULL$";
            }
            MindMapUtils.setCache((IPart)branch, userCacheKey, value);
            if (this.cachedKeys == null) {
                this.cachedKeys = new HashSet<String>();
            }
            this.cachedKeys.add(userCacheKey);
        }
        if ("$NULL$".equals(value)) {
            return null;
        }
        return value;
    }

    protected String getValue(IBranchPart branch, String key, String cacheKey) {
        IStyleSelector ss = branch.getBranchPolicy().getStyleSelector(branch);
        String value = ss.getStyleValue((IGraphicalPart)branch, key);
        if (value != null) {
            return value;
        }
        return this.getParentCachedValue(branch, key, cacheKey);
    }

    public static ParentValueProvider getValueProvider(IBranchPart branch) {
        ParentValueProvider valueProvider = (ParentValueProvider)MindMapUtils.getCache((IPart)branch, CACHE_PARENT_VALUE_PROVIDER);
        if (valueProvider == null) {
            valueProvider = new ParentValueProvider(branch);
            MindMapUtils.setCache((IPart)branch, CACHE_PARENT_VALUE_PROVIDER, valueProvider);
        }
        return valueProvider;
    }

    public static void flush(IBranchPart branch) {
        ICacheManager cacheManager = MindMapUtils.getCacheManager((IPart)branch);
        ParentValueProvider valueProvider = (ParentValueProvider)cacheManager.getCache(CACHE_PARENT_VALUE_PROVIDER);
        if (valueProvider != null && valueProvider.cachedKeys != null) {
            for (String cachedKey : valueProvider.cachedKeys) {
                cacheManager.flush(cachedKey);
            }
        }
        cacheManager.flush(CACHE_PARENT_VALUE_PROVIDER);
    }
}

