/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.viewers;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;

public class SelectionSynchronizer {
    private Map<ISelectionProvider, SelectionMonitor> monitors = new HashMap<ISelectionProvider, SelectionMonitor>();
    private boolean syncing = false;

    public void addPrimary(ISelectionProvider source) {
        this.add(source, true);
    }

    public void add(ISelectionProvider source) {
        this.add(source, false);
    }

    private void add(ISelectionProvider source, boolean primary) {
        if (this.monitors.containsKey(source)) {
            return;
        }
        this.monitors.put(source, new SelectionMonitor(source));
        if (!this.monitors.isEmpty()) {
            if (primary) {
                ISelection selection = source.getSelection();
                for (ISelectionProvider target : this.monitors.keySet()) {
                    target.setSelection(selection);
                }
            } else {
                source.setSelection(this.monitors.keySet().iterator().next().getSelection());
            }
        }
    }

    public void remove(ISelectionProvider source) {
        SelectionMonitor monitor = this.monitors.remove(source);
        if (monitor != null) {
            monitor.dispose();
        }
    }

    private void syncSelection(ISelectionProvider source, SelectionChangedEvent event) {
        if (this.syncing) {
            return;
        }
        this.syncing = true;
        ISelection selection = event.getSelection();
        Object[] objectArray = this.monitors.values().toArray();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object monitor = objectArray[n2];
            this.syncSelection(source, selection, (SelectionMonitor)monitor);
            ++n2;
        }
        this.syncing = false;
    }

    private void syncSelection(ISelectionProvider source, ISelection selection, SelectionMonitor monitor) {
        if (monitor.getSource() == source) {
            return;
        }
        monitor.getSource().setSelection(selection);
    }

    public void clear() {
        Object[] objectArray = this.monitors.keySet().toArray();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object source = objectArray[n2];
            this.remove((ISelectionProvider)source);
            ++n2;
        }
    }

    private class SelectionMonitor
    implements ISelectionChangedListener {
        private ISelectionProvider source;

        public SelectionMonitor(ISelectionProvider source) {
            this.source = source;
            this.source.addSelectionChangedListener((ISelectionChangedListener)this);
        }

        public void selectionChanged(SelectionChangedEvent event) {
            SelectionSynchronizer.this.syncSelection(this.source, event);
        }

        public ISelectionProvider getSource() {
            return this.source;
        }

        public void dispose() {
            this.source.removeSelectionChangedListener((ISelectionChangedListener)this);
        }
    }
}

