/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.gef.draw2d.geometry;

import org.xmind.gef.draw2d.geometry.PrecisionDimension;
import org.xmind.gef.draw2d.geometry.PrecisionPoint;
import org.xmind.gef.draw2d.geometry.PrecisionRectangle;

public class PrecisionPointList {
    private int size;
    private PrecisionPoint[] points;
    private PrecisionRectangle bounds;

    public PrecisionPointList() {
        this(0);
    }

    public PrecisionPointList(int size) {
        this.size = size;
        this.points = new PrecisionPoint[size];
        this.bounds = null;
    }

    public void addAll(PrecisionPointList source) {
        this.ensureCapacity(this.size + source.size);
        System.arraycopy(source.points, 0, this.points, this.size, source.size);
        this.size += source.size;
    }

    public void addPoint(PrecisionPoint p) {
        this.addPoint(p.x, p.y);
    }

    public void addPoint(double x, double y) {
        this.bounds = null;
        int index = this.size;
        this.ensureCapacity(this.size + 1);
        this.points[index] = new PrecisionPoint(x, y);
        ++this.size;
    }

    private void ensureCapacity(int newSize) {
        if (this.points.length < newSize) {
            PrecisionPoint[] old = this.points;
            this.points = new PrecisionPoint[newSize];
            System.arraycopy(old, 0, this.points, 0, this.size);
        }
    }

    public PrecisionRectangle getBounds() {
        if (this.bounds == null) {
            this.bounds = new PrecisionRectangle();
            if (this.size > 0) {
                this.bounds.setLocation(this.getPoint(0));
                int i = 1;
                while (i < this.size) {
                    this.bounds.union(this.getPoint(i));
                    ++i;
                }
            }
        }
        return this.bounds;
    }

    public PrecisionPointList getCopy() {
        PrecisionPointList result = this.create();
        this.copyTo(result);
        return result;
    }

    protected void copyTo(PrecisionPointList result) {
        result.setSize(this.size);
        int i = 0;
        while (i < this.size) {
            result.setPoint(this.getPoint(i), i);
            ++i;
        }
        result.bounds = null;
    }

    protected PrecisionPointList create() {
        return new PrecisionPointList(this.size);
    }

    public PrecisionPoint getFirstPoint() {
        return this.getPoint(0);
    }

    public PrecisionPoint getLastPoint() {
        return this.getPoint(this.size - 1);
    }

    public PrecisionPoint getMidPoint() {
        if (this.size % 2 == 0) {
            return this.getPoint(this.size / 2 - 1).getCenter(this.getPoint(this.size / 2));
        }
        return this.getPoint(this.size / 2);
    }

    public PrecisionPoint getPoint(int index) {
        if (index < 0 || index >= this.size) {
            throw new IndexOutOfBoundsException("Index: " + index + ", Size: " + this.size);
        }
        return this.points[index];
    }

    public void insertPoint(PrecisionPoint p, int index) {
        if (this.bounds != null && !this.bounds.contains(p)) {
            this.bounds = null;
        }
        if (index < 0 || index >= this.size) {
            throw new IndexOutOfBoundsException("Index: " + index + ", Size: " + this.size);
        }
        int length = this.points.length;
        PrecisionPoint[] old = this.points;
        this.points = new PrecisionPoint[length + 1];
        System.arraycopy(old, 0, this.points, 0, index);
        System.arraycopy(old, index, this.points, index + 1, length - index);
        if (p == null) {
            this.points[index] = null;
        } else if (this.points[index] == null) {
            this.points[index] = new PrecisionPoint(p);
        } else {
            this.points[index].setLocation(p);
        }
        ++this.size;
    }

    public boolean isEmpty() {
        return this.size == 0;
    }

    public void scale(double amount) {
        PrecisionPoint[] precisionPointArray = this.points;
        int n = this.points.length;
        int n2 = 0;
        while (n2 < n) {
            PrecisionPoint p = precisionPointArray[n2];
            if (p != null) {
                p.scale(amount);
            }
            ++n2;
        }
        this.bounds = null;
    }

    public void translate(double dx, double dy) {
        if (dx == 0.0 && dy == 0.0) {
            return;
        }
        PrecisionPoint[] precisionPointArray = this.points;
        int n = this.points.length;
        int n2 = 0;
        while (n2 < n) {
            PrecisionPoint p = precisionPointArray[n2];
            if (p != null) {
                p.translate(dx, dy);
            }
            ++n2;
        }
        if (this.bounds != null) {
            this.bounds.translate(dx, dy);
        }
    }

    public void translate(PrecisionDimension d) {
        this.translate(d.width, d.height);
    }

    public void removeAllPoints() {
        this.bounds = null;
        this.size = 0;
    }

    public PrecisionPoint removePoint(int index) {
        this.bounds = null;
        if (index < 0 || index >= this.size) {
            throw new IndexOutOfBoundsException("Index: " + index + ", Size: " + this.size);
        }
        PrecisionPoint p = this.getPoint(index);
        if (index != this.size - 1) {
            System.arraycopy(this.points, index + 1, this.points, index, this.size - index - 1);
        }
        --this.size;
        return p;
    }

    public void reverse() {
        int i = 0;
        int j = this.size - 1;
        while (i < this.size) {
            PrecisionPoint temp = this.points[i];
            this.points[i] = this.points[j];
            this.points[j] = temp;
            ++i;
            --j;
        }
    }

    public void setPoint(PrecisionPoint p, int index) {
        if (index < 0 || index >= this.size) {
            throw new IndexOutOfBoundsException("Index: " + index + ", Size: " + this.size);
        }
        if (this.bounds != null && !this.bounds.contains(p)) {
            this.bounds = null;
        }
        if (p == null) {
            this.points[index] = null;
        } else if (this.points[index] == null) {
            this.points[index] = new PrecisionPoint(p);
        } else {
            this.points[index].setLocation(p);
        }
    }

    public void setSize(int newSize) {
        if (this.points.length > newSize) {
            this.size = newSize;
            return;
        }
        PrecisionPoint[] newArray = new PrecisionPoint[newSize];
        System.arraycopy(this.points, 0, newArray, 0, this.points.length);
        this.points = newArray;
        this.size = newSize;
    }

    public int size() {
        return this.size;
    }

    public PrecisionPoint[] toArray() {
        if (this.points.length != this.size) {
            PrecisionPoint[] old = this.points;
            this.points = new PrecisionPoint[this.size];
            System.arraycopy(old, 0, this.points, 0, this.size());
        }
        return this.points;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer(this.size * 20 + 22);
        sb.append("PrecisionPointList:[");
        int i = 0;
        while (i < this.size) {
            PrecisionPoint p = this.getPoint(i);
            if (p != null) {
                sb.append("(" + p.x + "," + p.y + ")");
            }
            if (i < this.size - 1) {
                sb.append(",");
            }
            ++i;
        }
        sb.append("]");
        return sb.toString();
    }
}

