test_setup()
{
    request=$'/foo.dcgi\r\n'

    cat >"$docroot"/foo.dcgi <<EOF
#!/bin/sh

cat <<NESTED
Welcome!

Have fun browsing this server.

[0|About this server|about.txt|server|port]
[0|A quote|/random/quote.txt|server|port]
[1|Pics|/pics|server|port]
[1|My friend's server|/foo|friend.org|70]
[h|A web page|!URL:http://www.example.com|server|port]
NESTED
EOF
    chmod +x "$docroot"/foo.dcgi
}

test_set_assumptions()
{
    echo 0 >"$work"/exitcode.expected
    touch "$work"/stderr.expected

    (
        printf 'iWelcome!\t-\t-\t0\r\n'
        printf 'i\t-\t-\t0\r\n'
        printf 'iHave fun browsing this server.\t-\t-\t0\r\n'
        printf 'i\t-\t-\t0\r\n'
        printf '0About this server\t/about.txt\tlocalhost\t70\r\n'
        printf '0A quote\t/random/quote.txt\tlocalhost\t70\r\n'
        printf '1Pics\t/pics\tlocalhost\t70\r\n'
        printf '1My friend%ss server\t/foo\tfriend.org\t70\r\n' "'"
        printf 'hA web page\tURL:http://www.example.com\tlocalhost\t70\r\n'
    ) >"$work"/stdout.expected
}
