/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.logic.importer.fileformat;

import java.io.BufferedReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import org.jabref.logic.importer.Importer;
import org.jabref.logic.importer.ParserResult;
import org.jabref.logic.util.StandardFileType;
import org.jabref.model.entry.BibEntry;

public class BiblioscapeImporter
extends Importer {
    @Override
    public String getName() {
        return "Biblioscape";
    }

    @Override
    public StandardFileType getFileType() {
        return StandardFileType.TXT;
    }

    @Override
    public String getDescription() {
        return "Imports a Biblioscape Tag File.\nSeveral Biblioscape field types are ignored. Others are only included in the BibTeX field \"comment\".";
    }

    @Override
    public boolean isRecognizedFormat(BufferedReader reader) {
        Objects.requireNonNull(reader);
        return true;
    }

    @Override
    public ParserResult importDatabase(BufferedReader reader) throws IOException {
        String line;
        ArrayList<BibEntry> bibItems = new ArrayList<BibEntry>();
        HashMap<String, String> hm = new HashMap<String, String>();
        HashMap<String, StringBuilder> lines = new HashMap<String, StringBuilder>();
        StringBuilder previousLine = null;
        while ((line = reader.readLine()) != null) {
            if (line.isEmpty()) continue;
            if ("------".equals(line)) {
                String[] type = new String[2];
                String[] pages = new String[2];
                String country = null;
                String address = null;
                String titleST = null;
                String titleTI = null;
                ArrayList<String> comments = new ArrayList<String>();
                for (Map.Entry entry : lines.entrySet()) {
                    if ("AU".equals(entry.getKey())) {
                        hm.put("author", ((StringBuilder)entry.getValue()).toString());
                        continue;
                    }
                    if ("TI".equals(entry.getKey())) {
                        titleTI = ((StringBuilder)entry.getValue()).toString();
                        continue;
                    }
                    if ("ST".equals(entry.getKey())) {
                        titleST = ((StringBuilder)entry.getValue()).toString();
                        continue;
                    }
                    if ("YP".equals(entry.getKey())) {
                        hm.put("year", ((StringBuilder)entry.getValue()).toString());
                        continue;
                    }
                    if ("VL".equals(entry.getKey())) {
                        hm.put("volume", ((StringBuilder)entry.getValue()).toString());
                        continue;
                    }
                    if ("NB".equals(entry.getKey())) {
                        hm.put("number", ((StringBuilder)entry.getValue()).toString());
                        continue;
                    }
                    if ("PS".equals(entry.getKey())) {
                        pages[0] = ((StringBuilder)entry.getValue()).toString();
                        continue;
                    }
                    if ("PE".equals(entry.getKey())) {
                        pages[1] = ((StringBuilder)entry.getValue()).toString();
                        continue;
                    }
                    if ("KW".equals(entry.getKey())) {
                        hm.put("keywords", ((StringBuilder)entry.getValue()).toString());
                        continue;
                    }
                    if ("RT".equals(entry.getKey())) {
                        type[0] = ((StringBuilder)entry.getValue()).toString();
                        continue;
                    }
                    if ("SB".equals(entry.getKey())) {
                        comments.add("Subject: " + entry.getValue());
                        continue;
                    }
                    if ("SA".equals(entry.getKey())) {
                        comments.add("Secondary Authors: " + entry.getValue());
                        continue;
                    }
                    if ("NT".equals(entry.getKey())) {
                        hm.put("note", ((StringBuilder)entry.getValue()).toString());
                        continue;
                    }
                    if ("PB".equals(entry.getKey())) {
                        hm.put("publisher", ((StringBuilder)entry.getValue()).toString());
                        continue;
                    }
                    if ("TA".equals(entry.getKey())) {
                        comments.add("Tertiary Authors: " + entry.getValue());
                        continue;
                    }
                    if ("TT".equals(entry.getKey())) {
                        comments.add("Tertiary Title: " + entry.getValue());
                        continue;
                    }
                    if ("ED".equals(entry.getKey())) {
                        hm.put("edition", ((StringBuilder)entry.getValue()).toString());
                        continue;
                    }
                    if ("TW".equals(entry.getKey())) {
                        type[1] = ((StringBuilder)entry.getValue()).toString();
                        continue;
                    }
                    if ("QA".equals(entry.getKey())) {
                        comments.add("Quaternary Authors: " + entry.getValue());
                        continue;
                    }
                    if ("QT".equals(entry.getKey())) {
                        comments.add("Quaternary Title: " + entry.getValue());
                        continue;
                    }
                    if ("IS".equals(entry.getKey())) {
                        hm.put("isbn", ((StringBuilder)entry.getValue()).toString());
                        continue;
                    }
                    if ("AB".equals(entry.getKey())) {
                        hm.put("abstract", ((StringBuilder)entry.getValue()).toString());
                        continue;
                    }
                    if ("AD".equals(entry.getKey())) {
                        address = ((StringBuilder)entry.getValue()).toString();
                        continue;
                    }
                    if ("LG".equals(entry.getKey())) {
                        hm.put("language", ((StringBuilder)entry.getValue()).toString());
                        continue;
                    }
                    if ("CO".equals(entry.getKey())) {
                        country = ((StringBuilder)entry.getValue()).toString();
                        continue;
                    }
                    if ("UR".equals(entry.getKey()) || "AT".equals(entry.getKey())) {
                        String s2 = ((StringBuilder)entry.getValue()).toString().trim();
                        hm.put(s2.startsWith("http://") || s2.startsWith("ftp://") ? "url" : "pdf", ((StringBuilder)entry.getValue()).toString());
                        continue;
                    }
                    if ("C1".equals(entry.getKey())) {
                        comments.add("Custom1: " + entry.getValue());
                        continue;
                    }
                    if ("C2".equals(entry.getKey())) {
                        comments.add("Custom2: " + entry.getValue());
                        continue;
                    }
                    if ("C3".equals(entry.getKey())) {
                        comments.add("Custom3: " + entry.getValue());
                        continue;
                    }
                    if ("C4".equals(entry.getKey())) {
                        comments.add("Custom4: " + entry.getValue());
                        continue;
                    }
                    if ("C5".equals(entry.getKey())) {
                        comments.add("Custom5: " + entry.getValue());
                        continue;
                    }
                    if ("C6".equals(entry.getKey())) {
                        comments.add("Custom6: " + entry.getValue());
                        continue;
                    }
                    if ("DE".equals(entry.getKey())) {
                        hm.put("annote", ((StringBuilder)entry.getValue()).toString());
                        continue;
                    }
                    if ("CA".equals(entry.getKey())) {
                        comments.add("Categories: " + entry.getValue());
                        continue;
                    }
                    if ("TH".equals(entry.getKey())) {
                        comments.add("Short Title: " + entry.getValue());
                        continue;
                    }
                    if (!"SE".equals(entry.getKey())) continue;
                    hm.put("chapter", ((StringBuilder)entry.getValue()).toString());
                }
                String bibtexType = "misc";
                for (int i = 1; i >= 0 && "misc".equals(bibtexType); --i) {
                    if (type[i] == null) continue;
                    type[i] = type[i].toLowerCase(Locale.ROOT);
                    if (type[i].contains("article")) {
                        bibtexType = "article";
                        continue;
                    }
                    if (type[i].contains("journal")) {
                        bibtexType = "article";
                        continue;
                    }
                    if (type[i].contains("book section")) {
                        bibtexType = "inbook";
                        continue;
                    }
                    if (type[i].contains("book")) {
                        bibtexType = "book";
                        continue;
                    }
                    if (type[i].contains("conference")) {
                        bibtexType = "inproceedings";
                        continue;
                    }
                    if (type[i].contains("proceedings")) {
                        bibtexType = "inproceedings";
                        continue;
                    }
                    if (type[i].contains("report")) {
                        bibtexType = "techreport";
                        continue;
                    }
                    if (type[i].contains("thesis") && type[i].contains("master")) {
                        bibtexType = "mastersthesis";
                        continue;
                    }
                    if (!type[i].contains("thesis")) continue;
                    bibtexType = "phdthesis";
                }
                if ("article".equals(bibtexType)) {
                    if (titleST != null) {
                        hm.put("journal", titleST);
                    }
                    if (titleTI != null) {
                        hm.put("title", titleTI);
                    }
                } else if ("inbook".equals(bibtexType)) {
                    if (titleST != null) {
                        hm.put("booktitle", titleST);
                    }
                    if (titleTI != null) {
                        hm.put("title", titleTI);
                    }
                } else {
                    if (titleST != null) {
                        hm.put("booktitle", titleST);
                    }
                    if (titleTI != null) {
                        hm.put("title", titleTI);
                    }
                }
                if (pages[0] != null || pages[1] != null) {
                    hm.put("pages", (pages[0] == null ? "" : pages[0]) + (pages[1] == null ? "" : "--" + pages[1]));
                }
                if (address != null) {
                    hm.put("address", address + (country == null ? "" : ", " + country));
                }
                if (!comments.isEmpty()) {
                    hm.put("comment", String.join((CharSequence)";", comments));
                }
                BibEntry b = new BibEntry(bibtexType);
                b.setField(hm);
                bibItems.add(b);
                hm.clear();
                lines.clear();
                previousLine = null;
                continue;
            }
            if (line.startsWith("--") && line.length() >= 7 && "-- ".equals(line.substring(4, 7))) {
                previousLine = new StringBuilder(line.substring(7));
                lines.put(line.substring(2, 4), previousLine);
                continue;
            }
            if (previousLine == null) {
                return new ParserResult();
            }
            previousLine.append(line.trim());
        }
        return new ParserResult(bibItems);
    }
}

