/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.gui.preftabs;

import com.jgoodies.forms.builder.DefaultFormBuilder;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.BorderLayout;
import java.awt.Component;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import org.jabref.Globals;
import org.jabref.gui.preftabs.PrefsTab;
import org.jabref.logic.l10n.Localization;
import org.jabref.model.entry.InternalBibtexFields;
import org.jabref.preferences.JabRefPreferences;

class TablePrefsTab
extends JPanel
implements PrefsTab {
    private final JabRefPreferences prefs;
    private final JCheckBox autoResizeMode;
    private final JCheckBox priDesc;
    private final JCheckBox secDesc;
    private final JCheckBox terDesc;
    private final JCheckBox floatMarked;
    private final JRadioButton namesAsIs;
    private final JRadioButton namesFf;
    private final JRadioButton namesFl;
    private final JRadioButton namesNatbib;
    private final JRadioButton abbrNames;
    private final JRadioButton noAbbrNames;
    private final JRadioButton lastNamesOnly;
    private final JTextField priField;
    private final JTextField secField;
    private final JTextField terField;
    private final JTextField numericFields;
    private final JComboBox<String> priSort;
    private final JComboBox<String> secSort;
    private final JComboBox<String> terSort;

    public TablePrefsTab(JabRefPreferences prefs) {
        this.prefs = prefs;
        this.setLayout(new BorderLayout());
        List<String> fieldNames = InternalBibtexFields.getAllPublicFieldNames();
        fieldNames.add("bibtexkey");
        Collections.sort(fieldNames);
        String[] allPlusKey = fieldNames.toArray(new String[fieldNames.size()]);
        this.priSort = new JComboBox<String>(allPlusKey);
        this.secSort = new JComboBox<String>(allPlusKey);
        this.terSort = new JComboBox<String>(allPlusKey);
        this.autoResizeMode = new JCheckBox(Localization.lang("Fit table horizontally on screen", new String[0]));
        this.namesAsIs = new JRadioButton(Localization.lang("Show names unchanged", new String[0]));
        this.namesFf = new JRadioButton(Localization.lang("Show 'Firstname Lastname'", new String[0]));
        this.namesFl = new JRadioButton(Localization.lang("Show 'Lastname, Firstname'", new String[0]));
        this.namesNatbib = new JRadioButton(Localization.lang("Natbib style", new String[0]));
        this.noAbbrNames = new JRadioButton(Localization.lang("Do not abbreviate names", new String[0]));
        this.abbrNames = new JRadioButton(Localization.lang("Abbreviate names", new String[0]));
        this.lastNamesOnly = new JRadioButton(Localization.lang("Show last names only", new String[0]));
        this.floatMarked = new JCheckBox(Localization.lang("Float marked entries", new String[0]));
        this.priField = new JTextField(10);
        this.secField = new JTextField(10);
        this.terField = new JTextField(10);
        this.numericFields = new JTextField(30);
        this.priSort.insertItemAt(Localization.lang("<select>", new String[0]), 0);
        this.secSort.insertItemAt(Localization.lang("<select>", new String[0]), 0);
        this.terSort.insertItemAt(Localization.lang("<select>", new String[0]), 0);
        this.priSort.addActionListener(e -> {
            if (this.priSort.getSelectedIndex() > 0) {
                this.priField.setText(this.priSort.getSelectedItem().toString());
                this.priSort.setSelectedIndex(0);
            }
        });
        this.secSort.addActionListener(e -> {
            if (this.secSort.getSelectedIndex() > 0) {
                this.secField.setText(this.secSort.getSelectedItem().toString());
                this.secSort.setSelectedIndex(0);
            }
        });
        this.terSort.addActionListener(e -> {
            if (this.terSort.getSelectedIndex() > 0) {
                this.terField.setText(this.terSort.getSelectedItem().toString());
                this.terSort.setSelectedIndex(0);
            }
        });
        ButtonGroup nameStyle = new ButtonGroup();
        nameStyle.add(this.namesAsIs);
        nameStyle.add(this.namesNatbib);
        nameStyle.add(this.namesFf);
        nameStyle.add(this.namesFl);
        ButtonGroup nameAbbrev = new ButtonGroup();
        nameAbbrev.add(this.lastNamesOnly);
        nameAbbrev.add(this.abbrNames);
        nameAbbrev.add(this.noAbbrNames);
        this.priDesc = new JCheckBox(Localization.lang("Descending", new String[0]));
        this.secDesc = new JCheckBox(Localization.lang("Descending", new String[0]));
        this.terDesc = new JCheckBox(Localization.lang("Descending", new String[0]));
        FormLayout layout = new FormLayout("1dlu, 8dlu, left:pref, 4dlu, fill:pref, 4dlu, fill:60dlu, 4dlu, fill:pref", "");
        DefaultFormBuilder builder = new DefaultFormBuilder(layout);
        JPanel pan = new JPanel();
        builder.appendSeparator(Localization.lang("Format of author and editor names", new String[0]));
        DefaultFormBuilder nameBuilder = new DefaultFormBuilder(new FormLayout("left:pref, 8dlu, left:pref", ""));
        nameBuilder.append(this.namesAsIs);
        nameBuilder.append(this.noAbbrNames);
        nameBuilder.nextLine();
        nameBuilder.append(this.namesFf);
        nameBuilder.append(this.abbrNames);
        nameBuilder.nextLine();
        nameBuilder.append(this.namesFl);
        nameBuilder.append(this.lastNamesOnly);
        nameBuilder.nextLine();
        nameBuilder.append(this.namesNatbib);
        builder.append(pan);
        builder.append(nameBuilder.getPanel());
        builder.nextLine();
        builder.appendSeparator(Localization.lang("Default sort criteria", new String[0]));
        FormLayout layout2 = new FormLayout("left:pref, 8dlu, fill:pref, 4dlu, fill:60dlu, 4dlu, left:pref", "");
        DefaultFormBuilder builder2 = new DefaultFormBuilder(layout2);
        JLabel lab = new JLabel(Localization.lang("Primary sort criterion", new String[0]));
        builder2.append(lab);
        builder2.append(this.priSort);
        builder2.append(this.priField);
        builder2.append(this.priDesc);
        builder2.nextLine();
        lab = new JLabel(Localization.lang("Secondary sort criterion", new String[0]));
        builder2.append(lab);
        builder2.append(this.secSort);
        builder2.append(this.secField);
        builder2.append(this.secDesc);
        builder2.nextLine();
        lab = new JLabel(Localization.lang("Tertiary sort criterion", new String[0]));
        builder2.append(lab);
        builder2.append(this.terSort);
        builder2.append(this.terField);
        builder2.append(this.terDesc);
        builder.nextLine();
        builder.append(pan);
        builder.append(builder2.getPanel());
        builder.nextLine();
        builder.append(pan);
        builder.append(this.floatMarked);
        builder.nextLine();
        builder.append(pan);
        builder2 = new DefaultFormBuilder(new FormLayout("left:pref, 8dlu, fill:pref", ""));
        builder2.append(Localization.lang("Sort the following fields as numeric fields", new String[0]) + ':');
        builder2.append(this.numericFields);
        builder.append((Component)builder2.getPanel(), 5);
        builder.nextLine();
        builder.appendSeparator(Localization.lang("General", new String[0]));
        builder.append(pan);
        builder.append(this.autoResizeMode);
        builder.nextLine();
        pan = builder.getPanel();
        pan.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.add((Component)pan, "Center");
        this.namesNatbib.addChangeListener(e -> {
            this.abbrNames.setEnabled(!this.namesNatbib.isSelected());
            this.lastNamesOnly.setEnabled(!this.namesNatbib.isSelected());
            this.noAbbrNames.setEnabled(!this.namesNatbib.isSelected());
        });
    }

    @Override
    public void setValues() {
        this.autoResizeMode.setSelected(this.prefs.getInt("autoResizeMode") == 4);
        this.priField.setText(this.prefs.get("priSort"));
        this.secField.setText(this.prefs.get("secSort"));
        this.terField.setText(this.prefs.get("terSort"));
        this.priSort.setSelectedIndex(0);
        this.secSort.setSelectedIndex(0);
        this.terSort.setSelectedIndex(0);
        if (this.prefs.getBoolean("namesAsIs")) {
            this.namesAsIs.setSelected(true);
        } else if (this.prefs.getBoolean("namesFf")) {
            this.namesFf.setSelected(true);
        } else if (this.prefs.getBoolean("namesNatbib")) {
            this.namesNatbib.setSelected(true);
        } else {
            this.namesFl.setSelected(true);
        }
        if (this.prefs.getBoolean("abbrAuthorNames")) {
            this.abbrNames.setSelected(true);
        } else if (this.prefs.getBoolean("namesLastOnly")) {
            this.lastNamesOnly.setSelected(true);
        } else {
            this.noAbbrNames.setSelected(true);
        }
        this.priDesc.setSelected(this.prefs.getBoolean("priDescending"));
        this.secDesc.setSelected(this.prefs.getBoolean("secDescending"));
        this.terDesc.setSelected(this.prefs.getBoolean("terDescending"));
        this.floatMarked.setSelected(this.prefs.getBoolean("floatMarkedEntries"));
        this.abbrNames.setEnabled(!this.namesNatbib.isSelected());
        this.lastNamesOnly.setEnabled(!this.namesNatbib.isSelected());
        this.noAbbrNames.setEnabled(!this.namesNatbib.isSelected());
        String numF = this.prefs.get("numericFields");
        if (numF == null) {
            this.numericFields.setText("");
        } else {
            this.numericFields.setText(numF);
        }
    }

    @Override
    public void storeSettings() {
        this.prefs.putBoolean("namesAsIs", this.namesAsIs.isSelected());
        this.prefs.putBoolean("namesFf", this.namesFf.isSelected());
        this.prefs.putBoolean("namesNatbib", this.namesNatbib.isSelected());
        this.prefs.putBoolean("namesLastOnly", this.lastNamesOnly.isSelected());
        this.prefs.putBoolean("abbrAuthorNames", this.abbrNames.isSelected());
        this.prefs.putInt("autoResizeMode", this.autoResizeMode.isSelected() ? 4 : 0);
        this.prefs.putBoolean("priDescending", this.priDesc.isSelected());
        this.prefs.putBoolean("secDescending", this.secDesc.isSelected());
        this.prefs.putBoolean("terDescending", this.terDesc.isSelected());
        this.prefs.put("priSort", this.priField.getText().toLowerCase(Locale.ROOT).trim());
        this.prefs.put("secSort", this.secField.getText().toLowerCase(Locale.ROOT).trim());
        this.prefs.put("terSort", this.terField.getText().toLowerCase(Locale.ROOT).trim());
        this.prefs.putBoolean("floatMarkedEntries", this.floatMarked.isSelected());
        String oldVal = this.prefs.get("numericFields");
        String newVal = this.numericFields.getText().trim();
        if (newVal.isEmpty()) {
            newVal = null;
        }
        if (!Objects.equals(oldVal, newVal)) {
            this.prefs.put("numericFields", newVal);
            InternalBibtexFields.setNumericFields(Globals.prefs.getStringList("numericFields"));
        }
    }

    @Override
    public boolean validateSettings() {
        return true;
    }

    @Override
    public String getTabName() {
        return Localization.lang("Entry table", new String[0]);
    }
}

