/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.gui.menus;

import java.awt.event.ActionEvent;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import javax.swing.AbstractAction;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import org.jabref.Globals;
import org.jabref.gui.BasePanel;
import org.jabref.gui.IconTheme;
import org.jabref.gui.JabRefFrame;
import org.jabref.gui.copyfiles.CopyFilesAction;
import org.jabref.gui.filelist.FileListTableModel;
import org.jabref.gui.keyboard.KeyBinding;
import org.jabref.gui.menus.ChangeEntryTypeMenu;
import org.jabref.gui.mergeentries.FetchAndMergeEntry;
import org.jabref.gui.specialfields.SpecialFieldMenuAction;
import org.jabref.gui.specialfields.SpecialFieldValueViewModel;
import org.jabref.gui.specialfields.SpecialFieldViewModel;
import org.jabref.gui.worker.MarkEntriesAction;
import org.jabref.logic.citationstyle.CitationStyle;
import org.jabref.logic.l10n.Localization;
import org.jabref.model.entry.BibEntry;
import org.jabref.model.entry.specialfields.SpecialField;
import org.jabref.model.entry.specialfields.SpecialFieldValue;
import org.jabref.preferences.PreviewPreferences;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RightClickMenu
extends JPopupMenu
implements PopupMenuListener {
    private static final Logger LOGGER = LoggerFactory.getLogger(RightClickMenu.class);
    private final BasePanel panel;
    private final JMenuItem groupAdd;
    private final JMenuItem groupRemove;
    private final JMenuItem groupMoveTo;

    public RightClickMenu(JabRefFrame frame, BasePanel panel) {
        this.panel = panel;
        JMenu typeMenu = new ChangeEntryTypeMenu().getChangeEntryTypeMenu(panel);
        boolean multiple = this.areMultipleEntriesSelected();
        BibEntry be = null;
        if (panel.getMainTable().getSelectedRowCount() == 1) {
            be = (BibEntry)panel.getMainTable().getSelected().get(0);
        }
        this.addPopupMenuListener(this);
        JMenu copySpecialMenu = new JMenu(Localization.lang("Copy", new String[0]) + "...");
        copySpecialMenu.add(new GeneralAction("copyTitle", Localization.lang("Copy title", new String[0]), KeyBinding.COPY_TITLE));
        copySpecialMenu.add(new GeneralAction("copyKey", Localization.lang("Copy BibTeX key", new String[0]), KeyBinding.COPY_BIBTEX_KEY));
        copySpecialMenu.add(new GeneralAction("copyCiteKey", Localization.lang("Copy \\cite{BibTeX key}", new String[0]), KeyBinding.COPY_CITE_BIBTEX_KEY));
        copySpecialMenu.add(new GeneralAction("copyKeyAndTitle", Localization.lang("Copy BibTeX key and title", new String[0]), KeyBinding.COPY_BIBTEX_KEY_AND_TITLE));
        copySpecialMenu.add(new GeneralAction("copyKeyAndLink", Localization.lang("Copy BibTeX key and link", new String[0]), KeyBinding.COPY_BIBTEX_KEY_AND_LINK));
        PreviewPreferences previewPreferences = Globals.prefs.getPreviewPreferences();
        String style = previewPreferences.getPreviewCycle().get(previewPreferences.getPreviewCyclePosition());
        if (CitationStyle.isCitationStyleFile(style)) {
            copySpecialMenu.add(new GeneralAction("copyCitaitonHtml", Localization.menuTitle("Copy citation", new String[0]) + " (HTML)", KeyBinding.COPY_PREVIEW));
            JMenu copyCitationMenu = new JMenu(Localization.menuTitle("Copy citation", new String[0]) + "...");
            copyCitationMenu.add(new GeneralAction("copyCitaitonText", "Text"));
            copyCitationMenu.add(new GeneralAction("copyCitaitonRtf", "RTF"));
            copyCitationMenu.add(new GeneralAction("copyCitaitonAsciidoc", "AsciiDoc"));
            copyCitationMenu.add(new GeneralAction("copyCitaitonFo", "XSL-FO"));
            copySpecialMenu.add(copyCitationMenu);
        } else {
            copySpecialMenu.add(new GeneralAction("copyCitaitonHtml", Localization.lang("Copy preview", new String[0]), KeyBinding.COPY_PREVIEW));
        }
        copySpecialMenu.add(new GeneralAction("exportToClipboard", Localization.lang("Export to clipboard", new String[0]), IconTheme.JabRefIcon.EXPORT_TO_CLIPBOARD.getSmallIcon()));
        this.add(new GeneralAction("copy", Localization.lang("Copy", new String[0]), IconTheme.JabRefIcon.COPY.getSmallIcon(), KeyBinding.COPY));
        this.add(copySpecialMenu);
        this.add(new GeneralAction("paste", Localization.lang("Paste", new String[0]), IconTheme.JabRefIcon.PASTE.getSmallIcon(), KeyBinding.PASTE));
        this.add(new GeneralAction("cut", Localization.lang("Cut", new String[0]), IconTheme.JabRefIcon.CUT.getSmallIcon(), KeyBinding.CUT));
        this.add(new GeneralAction("delete", Localization.lang("Delete", new String[0]), IconTheme.JabRefIcon.DELETE_ENTRY.getSmallIcon(), KeyBinding.DELETE_ENTRY));
        GeneralAction printPreviewAction = new GeneralAction("printPreview", Localization.lang("Print entry preview", new String[0]), IconTheme.JabRefIcon.PRINTED.getSmallIcon());
        printPreviewAction.setEnabled(!multiple);
        this.add(printPreviewAction);
        this.addSeparator();
        this.add(new GeneralAction("sendAsEmail", Localization.lang("Send as email", new String[0]), IconTheme.JabRefIcon.EMAIL.getSmallIcon()));
        this.addSeparator();
        this.add(new CopyFilesAction());
        JMenu markSpecific = JabRefFrame.subMenu(Localization.menuTitle("Mark specific color", new String[0]));
        markSpecific.setIcon(IconTheme.JabRefIcon.MARK_ENTRIES.getSmallIcon());
        for (int i = 0; i < 5; ++i) {
            markSpecific.add(new MarkEntriesAction(frame, i).getMenuItem());
        }
        if (multiple) {
            this.add(new GeneralAction("markEntries", Localization.lang("Mark entries", new String[0]), IconTheme.JabRefIcon.MARK_ENTRIES.getSmallIcon(), KeyBinding.MARK_ENTRIES));
            this.add(markSpecific);
            this.add(new GeneralAction("unmarkEntries", Localization.lang("Unmark entries", new String[0]), IconTheme.JabRefIcon.UNMARK_ENTRIES.getSmallIcon(), KeyBinding.UNMARK_ENTRIES));
        } else if (be != null) {
            Optional<String> marked = be.getField("__markedentry");
            if (!marked.isPresent() || marked.get().isEmpty()) {
                this.add(new GeneralAction("markEntries", Localization.lang("Mark entry", new String[0]), IconTheme.JabRefIcon.MARK_ENTRIES.getSmallIcon(), KeyBinding.MARK_ENTRIES));
                this.add(markSpecific);
            } else {
                this.add(markSpecific);
                this.add(new GeneralAction("unmarkEntries", Localization.lang("Unmark entry", new String[0]), IconTheme.JabRefIcon.UNMARK_ENTRIES.getSmallIcon(), KeyBinding.UNMARK_ENTRIES));
            }
        }
        if (Globals.prefs.getBoolean("specialFieldsEnabled")) {
            if (Globals.prefs.getBoolean("showRankingColumn")) {
                JMenu rankingMenu = new JMenu();
                RightClickMenu.populateSpecialFieldMenu(rankingMenu, SpecialField.RANKING, frame);
                this.add(rankingMenu);
            }
            if (Globals.prefs.getBoolean("showRelevanceColumn")) {
                this.add(new SpecialFieldMenuAction(new SpecialFieldValueViewModel(SpecialField.RELEVANCE.getValues().get(0)), frame));
            }
            if (Globals.prefs.getBoolean("showQualityColumn")) {
                this.add(new SpecialFieldMenuAction(new SpecialFieldValueViewModel(SpecialField.QUALITY.getValues().get(0)), frame));
            }
            if (Globals.prefs.getBoolean("showPrintedColumn")) {
                this.add(new SpecialFieldMenuAction(new SpecialFieldValueViewModel(SpecialField.PRINTED.getValues().get(0)), frame));
            }
            if (Globals.prefs.getBoolean("showPriorityColumn")) {
                JMenu priorityMenu = new JMenu();
                RightClickMenu.populateSpecialFieldMenu(priorityMenu, SpecialField.PRIORITY, frame);
                this.add(priorityMenu);
            }
            if (Globals.prefs.getBoolean("showReadColumn")) {
                JMenu readStatusMenu = new JMenu();
                RightClickMenu.populateSpecialFieldMenu(readStatusMenu, SpecialField.READ_STATUS, frame);
                this.add(readStatusMenu);
            }
        }
        this.addSeparator();
        GeneralAction openFolderAction = new GeneralAction("openFolder", Localization.lang("Open folder", new String[0]), KeyBinding.OPEN_FOLDER);
        openFolderAction.setEnabled(this.isFieldSetForSelectedEntry("file"));
        this.add(openFolderAction);
        GeneralAction openFileAction = new GeneralAction("openExternalFile", Localization.lang("Open file", new String[0]), this.getFileIconForSelectedEntry(), KeyBinding.OPEN_FILE);
        openFileAction.setEnabled(this.isFieldSetForSelectedEntry("file"));
        this.add(openFileAction);
        GeneralAction openUrlAction = new GeneralAction("openUrl", Localization.lang("Open URL or DOI", new String[0]), IconTheme.JabRefIcon.WWW.getSmallIcon(), KeyBinding.OPEN_URL_OR_DOI);
        openUrlAction.setEnabled(this.isFieldSetForSelectedEntry("url") || this.isFieldSetForSelectedEntry("doi"));
        this.add(openUrlAction);
        this.addSeparator();
        this.add(typeMenu);
        GeneralAction mergeFetchedEntryAction = new GeneralAction("mergeWithFetchedEntry", Localization.lang("Get BibTeX data from %0", FetchAndMergeEntry.getDisplayNameOfSupportedFields()));
        mergeFetchedEntryAction.setEnabled(this.isAnyFieldSetForSelectedEntry(FetchAndMergeEntry.SUPPORTED_FIELDS));
        this.add(mergeFetchedEntryAction);
        this.add(frame.getMassSetField());
        GeneralAction attachFileAction = new GeneralAction("addFileLink", Localization.lang("Attach file", new String[0]), IconTheme.JabRefIcon.ATTACH_FILE.getSmallIcon());
        attachFileAction.setEnabled(!multiple);
        this.add(attachFileAction);
        this.add(frame.getManageKeywords());
        GeneralAction mergeEntriesAction = new GeneralAction("mergeEntries", Localization.lang("Merge entries", new String[0]) + "...", IconTheme.JabRefIcon.MERGE_ENTRIES.getSmallIcon());
        mergeEntriesAction.setEnabled(this.areExactlyTwoEntriesSelected());
        this.add(mergeEntriesAction);
        this.addSeparator();
        this.groupAdd = new JMenuItem(new GeneralAction("addToGroup", Localization.lang("Add to group", new String[0])));
        this.add(this.groupAdd);
        this.groupRemove = new JMenuItem(new GeneralAction("removeFromGroup", Localization.lang("Remove from group", new String[0])));
        this.add(this.groupRemove);
        this.groupMoveTo = this.add(new GeneralAction("moveToGroup", Localization.lang("Move to group", new String[0])));
        this.add(this.groupMoveTo);
        frame.createDisabledIconsForMenuEntries(this);
    }

    public static void populateSpecialFieldMenu(JMenu menu, SpecialField field2, JabRefFrame frame) {
        SpecialFieldViewModel viewModel = new SpecialFieldViewModel(field2);
        menu.setText(viewModel.getLocalization());
        menu.setIcon(viewModel.getRepresentingIcon());
        for (SpecialFieldValue val : field2.getValues()) {
            menu.add(new SpecialFieldMenuAction(new SpecialFieldValueViewModel(val), frame));
        }
    }

    private boolean areMultipleEntriesSelected() {
        return this.panel.getMainTable().getSelectedRowCount() > 1;
    }

    private boolean areExactlyTwoEntriesSelected() {
        return this.panel.getMainTable().getSelectedRowCount() == 2;
    }

    @Override
    public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
        boolean groupsPresent = this.panel.getBibDatabaseContext().getMetaData().getGroups().isPresent();
        this.groupAdd.setEnabled(groupsPresent);
        this.groupRemove.setEnabled(groupsPresent);
        this.groupMoveTo.setEnabled(groupsPresent);
    }

    @Override
    public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
    }

    @Override
    public void popupMenuCanceled(PopupMenuEvent e) {
    }

    private boolean isFieldSetForSelectedEntry(String fieldname) {
        return this.isAnyFieldSetForSelectedEntry(Arrays.asList(fieldname));
    }

    private boolean isAnyFieldSetForSelectedEntry(List<String> fieldnames) {
        if (this.panel.getMainTable().getSelectedRowCount() == 1) {
            BibEntry entry = (BibEntry)this.panel.getMainTable().getSelected().get(0);
            return !Collections.disjoint(fieldnames, entry.getFieldNames());
        }
        return false;
    }

    private Icon getFileIconForSelectedEntry() {
        JLabel label;
        BibEntry entry;
        if (this.panel.getMainTable().getSelectedRowCount() == 1 && (entry = (BibEntry)this.panel.getMainTable().getSelected().get(0)).hasField("file") && (label = FileListTableModel.getFirstLabel(entry.getField("file").get())) != null) {
            return label.getIcon();
        }
        return IconTheme.JabRefIcon.FILE.getSmallIcon();
    }

    class GeneralAction
    extends AbstractAction {
        private final String command;

        public GeneralAction(String command, String name) {
            super(name);
            this.command = command;
        }

        public GeneralAction(String command, String name, Icon icon) {
            super(name, icon);
            this.command = command;
        }

        public GeneralAction(String command, String name, KeyBinding key) {
            super(name);
            this.command = command;
            this.putValue("AcceleratorKey", Globals.getKeyPrefs().getKey(key));
        }

        public GeneralAction(String command, String name, Icon icon, KeyBinding key) {
            super(name, icon);
            this.command = command;
            this.putValue("AcceleratorKey", Globals.getKeyPrefs().getKey(key));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            try {
                RightClickMenu.this.panel.runCommand(this.command);
            }
            catch (Throwable ex) {
                LOGGER.debug("Cannot execute command " + this.command + ".", ex);
            }
        }
    }
}

