/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.gui.groups;

import com.jgoodies.forms.builder.ButtonBarBuilder;
import com.jgoodies.forms.builder.DefaultFormBuilder;
import com.jgoodies.forms.builder.FormBuilder;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ItemListener;
import java.io.IOException;
import java.nio.file.Paths;
import java.util.Optional;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import javafx.scene.Node;
import javafx.scene.paint.Color;
import javafx.scene.text.Text;
import javafx.scene.text.TextFlow;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.event.CaretListener;
import org.jabref.Globals;
import org.jabref.JabRefGUI;
import org.jabref.gui.Dialog;
import org.jabref.gui.JabRefDialog;
import org.jabref.gui.JabRefFrame;
import org.jabref.gui.fieldeditors.TextField;
import org.jabref.gui.groups.GroupDescriptions;
import org.jabref.gui.keyboard.KeyBinding;
import org.jabref.gui.search.rules.describer.SearchDescribers;
import org.jabref.gui.util.TooltipTextUtil;
import org.jabref.logic.auxparser.DefaultAuxParser;
import org.jabref.logic.l10n.Localization;
import org.jabref.logic.search.SearchQuery;
import org.jabref.model.database.BibDatabase;
import org.jabref.model.entry.Keyword;
import org.jabref.model.groups.AbstractGroup;
import org.jabref.model.groups.AutomaticKeywordGroup;
import org.jabref.model.groups.AutomaticPersonsGroup;
import org.jabref.model.groups.ExplicitGroup;
import org.jabref.model.groups.GroupHierarchyType;
import org.jabref.model.groups.GroupTreeNode;
import org.jabref.model.groups.RegexKeywordGroup;
import org.jabref.model.groups.SearchGroup;
import org.jabref.model.groups.TexGroup;
import org.jabref.model.groups.WordKeywordGroup;
import org.jabref.model.strings.StringUtil;

class GroupDialog
extends JabRefDialog
implements Dialog<AbstractGroup> {
    private static final int INDEX_EXPLICIT_GROUP = 0;
    private static final int INDEX_KEYWORD_GROUP = 1;
    private static final int INDEX_SEARCH_GROUP = 2;
    private static final int INDEX_AUTO_GROUP = 3;
    private static final int INDEX_TEX_GROUP = 4;
    private static final int TEXTFIELD_LENGTH = 30;
    private final JTextField nameField = new JTextField(30);
    private final JRadioButton explicitRadioButton = new JRadioButton(Localization.lang("Statically group entries by manual assignment", new String[0]));
    private final JRadioButton keywordsRadioButton = new JRadioButton(Localization.lang("Dynamically group entries by searching a field for a keyword", new String[0]));
    private final JRadioButton searchRadioButton = new JRadioButton(Localization.lang("Dynamically group entries by a free-form search expression", new String[0]));
    private final JRadioButton autoRadioButton = new JRadioButton(Localization.lang("Automatically create groups", new String[0]));
    private final JRadioButton texRadioButton = new JRadioButton(Localization.lang("Group containing entries cited in a given TeX file", new String[0]));
    private final JRadioButton independentButton = new JRadioButton(Localization.lang("Independent group: When selected, view only this group's entries", new String[0]));
    private final JRadioButton intersectionButton = new JRadioButton(Localization.lang("Refine supergroup: When selected, view entries contained in both this group and its supergroup", new String[0]));
    private final JRadioButton unionButton = new JRadioButton(Localization.lang("Include subgroups: When selected, view entries contained in this group or its subgroups", new String[0]));
    private final JTextField colorField = new JTextField(30);
    private final JTextField descriptionField = new JTextField(30);
    private final JTextField iconField = new JTextField(30);
    private final JTextField keywordGroupSearchField = new JTextField(30);
    private final TextField keywordGroupSearchTerm = new TextField("keywords", "", false);
    private final JCheckBox keywordGroupCaseSensitive = new JCheckBox(Localization.lang("Case sensitive", new String[0]));
    private final JCheckBox keywordGroupRegExp = new JCheckBox(Localization.lang("regular expression", new String[0]));
    private final JTextField searchGroupSearchExpression = new JTextField(30);
    private final JCheckBox searchGroupCaseSensitive = new JCheckBox(Localization.lang("Case sensitive", new String[0]));
    private final JCheckBox searchGroupRegExp = new JCheckBox(Localization.lang("regular expression", new String[0]));
    private final JRadioButton autoGroupKeywordsOption = new JRadioButton(Localization.lang("Generate groups from keywords in a BibTeX field", new String[0]));
    private final JTextField autoGroupKeywordsField = new JTextField(60);
    private final JTextField autoGroupKeywordsDeliminator = new JTextField(60);
    private final JTextField autoGroupKeywordsHierarchicalDeliminator = new JTextField(60);
    private final JRadioButton autoGroupPersonsOption = new JRadioButton(Localization.lang("Generate groups for author last names", new String[0]));
    private final JTextField autoGroupPersonsField = new JTextField(60);
    private final JTextField texGroupFilePath = new JTextField(60);
    private final JButton okButton = new JButton(Localization.lang("OK", new String[0]));
    private final JPanel optionsPanel = new JPanel();
    private final JLabel descriptionLabel = new JLabel(){

        @Override
        public Dimension getPreferredSize() {
            Dimension d = super.getPreferredSize();
            d.width = 1;
            return d;
        }
    };
    private final CardLayout optionsLayout = new CardLayout();
    private boolean isOkPressed;
    private AbstractGroup resultingGroup;

    public GroupDialog(JabRefFrame jabrefFrame, AbstractGroup editedGroup) {
        super((Frame)jabrefFrame, editedGroup == null ? Localization.lang("Add group", new String[0]) : Localization.lang("Edit group", new String[0]), true, GroupDialog.class);
        this.keywordGroupSearchField.setText(jabrefFrame.prefs().get("groupsDefaultField"));
        ButtonGroup groupType = new ButtonGroup();
        groupType.add(this.explicitRadioButton);
        groupType.add(this.keywordsRadioButton);
        groupType.add(this.searchRadioButton);
        groupType.add(this.autoRadioButton);
        groupType.add(this.texRadioButton);
        ButtonGroup groupHierarchy = new ButtonGroup();
        groupHierarchy.add(this.independentButton);
        groupHierarchy.add(this.intersectionButton);
        groupHierarchy.add(this.unionButton);
        this.descriptionLabel.setVerticalAlignment(1);
        this.getRootPane().setDefaultButton(this.okButton);
        this.optionsPanel.setLayout(this.optionsLayout);
        this.optionsPanel.add((Component)new JPanel(), String.valueOf(0));
        FormLayout layoutKG = new FormLayout("right:pref, 4dlu, fill:1dlu:grow, 2dlu, left:pref");
        DefaultFormBuilder builderKG = new DefaultFormBuilder(layoutKG);
        builderKG.append(Localization.lang("Field", new String[0]));
        builderKG.append((Component)this.keywordGroupSearchField, 3);
        builderKG.nextLine();
        builderKG.append(Localization.lang("Keyword", new String[0]));
        builderKG.append(this.keywordGroupSearchTerm);
        builderKG.nextLine();
        builderKG.append((Component)this.keywordGroupCaseSensitive, 3);
        builderKG.nextLine();
        builderKG.append((Component)this.keywordGroupRegExp, 3);
        this.optionsPanel.add((Component)builderKG.getPanel(), String.valueOf(1));
        FormLayout layoutSG = new FormLayout("right:pref, 4dlu, fill:1dlu:grow");
        DefaultFormBuilder builderSG = new DefaultFormBuilder(layoutSG);
        builderSG.append(Localization.lang("Search expression", new String[0]));
        builderSG.append(this.searchGroupSearchExpression);
        builderSG.nextLine();
        builderSG.append((Component)this.searchGroupCaseSensitive, 3);
        builderSG.nextLine();
        builderSG.append((Component)this.searchGroupRegExp, 3);
        this.optionsPanel.add((Component)builderSG.getPanel(), String.valueOf(2));
        ButtonGroup bg = new ButtonGroup();
        bg.add(this.autoGroupKeywordsOption);
        bg.add(this.autoGroupPersonsOption);
        FormLayout layoutAutoGroup = new FormLayout("left:20dlu, 4dlu, left:pref, 4dlu, fill:60dlu", "p, 2dlu, p, 2dlu, p, p, 2dlu, p, 2dlu, p");
        FormBuilder builderAutoGroup = FormBuilder.create();
        builderAutoGroup.layout(layoutAutoGroup);
        builderAutoGroup.add(this.autoGroupKeywordsOption).xyw(1, 1, 5);
        builderAutoGroup.add(Localization.lang("Field to group by", new String[0]) + ":", new Object[0]).xy(3, 3);
        builderAutoGroup.add(this.autoGroupKeywordsField).xy(5, 3);
        builderAutoGroup.add(Localization.lang("Use the following delimiter character(s):", new String[0]), new Object[0]).xy(3, 5);
        builderAutoGroup.add(this.autoGroupKeywordsDeliminator).xy(5, 5);
        builderAutoGroup.add(this.autoGroupKeywordsHierarchicalDeliminator).xy(5, 6);
        builderAutoGroup.add(this.autoGroupPersonsOption).xyw(1, 8, 5);
        builderAutoGroup.add(Localization.lang("Field to group by", new String[0]) + ":", new Object[0]).xy(3, 10);
        builderAutoGroup.add(this.autoGroupPersonsField).xy(5, 10);
        this.optionsPanel.add((Component)builderAutoGroup.build(), String.valueOf(3));
        this.autoGroupKeywordsOption.setSelected(true);
        this.autoGroupKeywordsField.setText(Globals.prefs.get("groupsDefaultField"));
        this.autoGroupKeywordsDeliminator.setText(Globals.prefs.get("groupKeywordSeparator"));
        this.autoGroupKeywordsHierarchicalDeliminator.setText(Keyword.DEFAULT_HIERARCHICAL_DELIMITER.toString());
        this.autoGroupPersonsField.setText("author");
        FormLayout layoutTG = new FormLayout("right:pref, 4dlu, fill:1dlu:grow");
        DefaultFormBuilder builderTG = new DefaultFormBuilder(layoutTG);
        builderTG.append(Localization.lang("Aux file", new String[0]));
        builderTG.append(this.texGroupFilePath);
        this.optionsPanel.add((Component)builderTG.getPanel(), String.valueOf(4));
        FormLayout layoutBP = new FormLayout("pref, 4dlu, pref", "p");
        layoutBP.setColumnGroups(new int[][]{{1, 3}});
        ButtonBarBuilder builderBP = new ButtonBarBuilder();
        builderBP.addGlue();
        builderBP.addButton((JComponent)this.okButton);
        JButton mCancel = new JButton(Localization.lang("Cancel", new String[0]));
        builderBP.addButton((JComponent)mCancel);
        builderBP.addGlue();
        builderBP.getPanel().setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        FormLayout layoutAll = new FormLayout("right:pref, 4dlu, fill:600px, 4dlu, fill:pref", "p, 3dlu, p, 3dlu, p, 3dlu, p, 3dlu, p, 3dlu, p, 0dlu, p, 0dlu, p, 0dlu, p, 0dlu, p, 3dlu, p, 3dlu, p, 0dlu, p, 0dlu, p, 3dlu, p, 3dlu, p, 3dlu, p, 3dlu, top:80dlu, 9dlu, p, 9dlu, p");
        DefaultFormBuilder builderAll = new DefaultFormBuilder(layoutAll);
        builderAll.appendSeparator(Localization.lang("General", new String[0]));
        builderAll.nextLine();
        builderAll.nextLine();
        builderAll.append(Localization.lang("Name", new String[0]));
        builderAll.append(this.nameField);
        builderAll.nextLine();
        builderAll.nextLine();
        builderAll.append(Localization.lang("Description", new String[0]));
        builderAll.append(this.descriptionField);
        builderAll.nextLine();
        builderAll.nextLine();
        builderAll.append(Localization.lang("Color", new String[0]));
        builderAll.append(this.colorField);
        builderAll.nextLine();
        builderAll.nextLine();
        builderAll.append(Localization.lang("Icon", new String[0]));
        builderAll.append(this.iconField);
        builderAll.nextLine();
        builderAll.nextLine();
        builderAll.append((Component)this.explicitRadioButton, 5);
        builderAll.nextLine();
        builderAll.nextLine();
        builderAll.append((Component)this.keywordsRadioButton, 5);
        builderAll.nextLine();
        builderAll.nextLine();
        builderAll.append((Component)this.searchRadioButton, 5);
        builderAll.nextLine();
        builderAll.nextLine();
        builderAll.append((Component)this.autoRadioButton, 5);
        builderAll.nextLine();
        builderAll.nextLine();
        builderAll.append((Component)this.texRadioButton, 5);
        builderAll.nextLine();
        builderAll.nextLine();
        builderAll.appendSeparator(Localization.lang("Hierarchical context", new String[0]));
        builderAll.nextLine();
        builderAll.nextLine();
        builderAll.append((Component)this.independentButton, 5);
        builderAll.nextLine();
        builderAll.nextLine();
        builderAll.append((Component)this.intersectionButton, 5);
        builderAll.nextLine();
        builderAll.nextLine();
        builderAll.append((Component)this.unionButton, 5);
        builderAll.nextLine();
        builderAll.nextLine();
        builderAll.appendSeparator(Localization.lang("Options", new String[0]));
        builderAll.nextLine();
        builderAll.nextLine();
        builderAll.append((Component)this.optionsPanel, 5);
        builderAll.nextLine();
        builderAll.nextLine();
        builderAll.appendSeparator(Localization.lang("Description", new String[0]));
        builderAll.nextLine();
        builderAll.nextLine();
        JScrollPane sp2 = new JScrollPane(this.descriptionLabel, 20, 30){

            @Override
            public Dimension getPreferredSize() {
                return this.getMaximumSize();
            }
        };
        builderAll.append((Component)sp2, 5);
        builderAll.nextLine();
        builderAll.nextLine();
        builderAll.appendSeparator();
        builderAll.nextLine();
        builderAll.nextLine();
        Container cp = this.getContentPane();
        cp.add((Component)builderAll.getPanel(), "Center");
        cp.add((Component)builderBP.getPanel(), "South");
        this.pack();
        this.setResizable(false);
        this.updateComponents();
        this.setLayoutForSelectedGroup();
        this.setLocationRelativeTo(jabrefFrame);
        ItemListener radioButtonItemListener = e -> {
            this.setLayoutForSelectedGroup();
            this.updateComponents();
        };
        this.explicitRadioButton.addItemListener(radioButtonItemListener);
        this.keywordsRadioButton.addItemListener(radioButtonItemListener);
        this.searchRadioButton.addItemListener(radioButtonItemListener);
        this.autoRadioButton.addItemListener(radioButtonItemListener);
        this.texRadioButton.addItemListener(radioButtonItemListener);
        AbstractAction cancelAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GroupDialog.this.dispose();
            }
        };
        mCancel.addActionListener(cancelAction);
        builderAll.getPanel().getInputMap(2).put(Globals.getKeyPrefs().getKey(KeyBinding.CLOSE_DIALOG), "close");
        builderAll.getPanel().getActionMap().put("close", cancelAction);
        this.okButton.addActionListener(e -> {
            this.isOkPressed = true;
            try {
                String groupName = this.nameField.getText().trim();
                if (this.explicitRadioButton.isSelected()) {
                    Optional<GroupTreeNode> rootGroup;
                    Character keywordDelimiter = Globals.prefs.getKeywordDelimiter();
                    if (groupName.contains(Character.toString(keywordDelimiter.charValue()))) {
                        jabrefFrame.showMessage(Localization.lang("The group name contains the keyword separator \"%0\" and thus probably does not work as expected.", Character.toString(keywordDelimiter.charValue())));
                    }
                    if ((rootGroup = jabrefFrame.getCurrentBasePanel().getBibDatabaseContext().getMetaData().getGroups()).isPresent()) {
                        int groupsWithSameName = rootGroup.get().findChildrenSatisfying(group -> group.getName().equals(groupName)).size();
                        boolean warnAboutSameName = false;
                        if (editedGroup == null && groupsWithSameName > 0) {
                            warnAboutSameName = true;
                        }
                        if (editedGroup != null && !editedGroup.getName().equals(groupName) && groupsWithSameName > 0) {
                            warnAboutSameName = true;
                        }
                        if (warnAboutSameName) {
                            jabrefFrame.showMessage(Localization.lang("There exists already a group with the same name.", Character.toString(keywordDelimiter.charValue())));
                            return;
                        }
                    }
                    this.resultingGroup = new ExplicitGroup(groupName, this.getContext(), keywordDelimiter);
                } else if (this.keywordsRadioButton.isSelected()) {
                    this.resultingGroup = this.keywordGroupRegExp.isSelected() ? new RegexKeywordGroup(groupName, this.getContext(), this.keywordGroupSearchField.getText().trim(), this.keywordGroupSearchTerm.getText().trim(), this.keywordGroupCaseSensitive.isSelected()) : new WordKeywordGroup(groupName, this.getContext(), this.keywordGroupSearchField.getText().trim(), this.keywordGroupSearchTerm.getText().trim(), this.keywordGroupCaseSensitive.isSelected(), Globals.prefs.getKeywordDelimiter(), false);
                } else if (this.searchRadioButton.isSelected()) {
                    try {
                        this.resultingGroup = new SearchGroup(groupName, this.getContext(), this.searchGroupSearchExpression.getText().trim(), this.isCaseSensitive(), this.isRegex());
                    }
                    catch (Exception exception) {}
                } else if (this.autoRadioButton.isSelected()) {
                    this.resultingGroup = this.autoGroupKeywordsOption.isSelected() ? new AutomaticKeywordGroup(groupName, this.getContext(), this.autoGroupKeywordsField.getText().trim(), Character.valueOf(this.autoGroupKeywordsDeliminator.getText().charAt(0)), Character.valueOf(this.autoGroupKeywordsHierarchicalDeliminator.getText().charAt(0))) : new AutomaticPersonsGroup(groupName, this.getContext(), this.autoGroupPersonsField.getText().trim());
                } else if (this.texRadioButton.isSelected()) {
                    this.resultingGroup = new TexGroup(groupName, this.getContext(), Paths.get(this.texGroupFilePath.getText().trim(), new String[0]), new DefaultAuxParser(new BibDatabase()), Globals.getFileUpdateMonitor());
                }
                try {
                    this.resultingGroup.setColor(Color.valueOf((String)this.colorField.getText()));
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    // empty catch block
                }
                this.resultingGroup.setDescription(this.descriptionField.getText());
                this.resultingGroup.setIconName(this.iconField.getText());
                this.dispose();
            }
            catch (IOException | IllegalArgumentException exception) {
                jabrefFrame.showMessage(exception.getLocalizedMessage());
            }
        });
        CaretListener caretListener = e -> this.updateComponents();
        ItemListener itemListener = e -> this.updateComponents();
        this.nameField.addCaretListener(caretListener);
        this.colorField.addCaretListener(caretListener);
        this.descriptionField.addCaretListener(caretListener);
        this.iconField.addCaretListener(caretListener);
        this.keywordGroupSearchField.addCaretListener(caretListener);
        this.keywordGroupSearchTerm.addCaretListener(caretListener);
        this.keywordGroupCaseSensitive.addItemListener(itemListener);
        this.keywordGroupRegExp.addItemListener(itemListener);
        this.searchGroupSearchExpression.addCaretListener(caretListener);
        this.searchGroupRegExp.addItemListener(itemListener);
        this.searchGroupCaseSensitive.addItemListener(itemListener);
        if (editedGroup == null) {
            this.explicitRadioButton.setSelected(true);
            this.setContext(GroupHierarchyType.INDEPENDENT);
        } else {
            this.nameField.setText(editedGroup.getName());
            this.colorField.setText(editedGroup.getColor().map(Color::toString).orElse(""));
            this.descriptionField.setText(editedGroup.getDescription().orElse(""));
            this.iconField.setText(editedGroup.getIconName().orElse(""));
            if (editedGroup.getClass() == WordKeywordGroup.class) {
                WordKeywordGroup group = (WordKeywordGroup)editedGroup;
                this.keywordGroupSearchField.setText(group.getSearchField());
                this.keywordGroupSearchTerm.setText(group.getSearchExpression());
                this.keywordGroupCaseSensitive.setSelected(group.isCaseSensitive());
                this.keywordGroupRegExp.setSelected(false);
                this.keywordsRadioButton.setSelected(true);
                this.setContext(editedGroup.getHierarchicalContext());
            } else if (editedGroup.getClass() == RegexKeywordGroup.class) {
                RegexKeywordGroup group = (RegexKeywordGroup)editedGroup;
                this.keywordGroupSearchField.setText(group.getSearchField());
                this.keywordGroupSearchTerm.setText(group.getSearchExpression());
                this.keywordGroupCaseSensitive.setSelected(group.isCaseSensitive());
                this.keywordGroupRegExp.setSelected(true);
                this.keywordsRadioButton.setSelected(true);
                this.setContext(editedGroup.getHierarchicalContext());
            } else if (editedGroup.getClass() == SearchGroup.class) {
                SearchGroup group = (SearchGroup)editedGroup;
                this.searchGroupSearchExpression.setText(group.getSearchExpression());
                this.searchGroupCaseSensitive.setSelected(group.isCaseSensitive());
                this.searchGroupRegExp.setSelected(group.isRegularExpression());
                this.searchRadioButton.setSelected(true);
                this.setContext(editedGroup.getHierarchicalContext());
            } else if (editedGroup.getClass() == ExplicitGroup.class) {
                this.explicitRadioButton.setSelected(true);
                this.setContext(editedGroup.getHierarchicalContext());
            } else if (editedGroup.getClass() == AutomaticKeywordGroup.class) {
                this.autoRadioButton.setSelected(true);
                this.setContext(editedGroup.getHierarchicalContext());
                if (editedGroup.getClass() == AutomaticKeywordGroup.class) {
                    AutomaticKeywordGroup group = (AutomaticKeywordGroup)editedGroup;
                    this.autoGroupKeywordsDeliminator.setText(group.getKeywordDelimiter().toString());
                    this.autoGroupKeywordsHierarchicalDeliminator.setText(group.getKeywordHierarchicalDelimiter().toString());
                    this.autoGroupKeywordsField.setText(group.getField());
                } else if (editedGroup.getClass() == AutomaticPersonsGroup.class) {
                    AutomaticPersonsGroup group = (AutomaticPersonsGroup)editedGroup;
                    this.autoGroupPersonsField.setText(group.getField());
                }
            } else if (editedGroup.getClass() == TexGroup.class) {
                this.texRadioButton.setSelected(true);
                this.setContext(editedGroup.getHierarchicalContext());
                TexGroup group = (TexGroup)editedGroup;
                this.texGroupFilePath.setText(group.getFilePath().toString());
            }
        }
    }

    public GroupDialog() {
        this(JabRefGUI.getMainFrame(), null);
    }

    public GroupDialog(AbstractGroup editedGroup) {
        this(JabRefGUI.getMainFrame(), editedGroup);
    }

    private static String formatRegExException(String regExp, Exception e) {
        String[] sa = e.getMessage().split("\\n");
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < sa.length; ++i) {
            if (i > 0) {
                sb.append("<br>");
            }
            sb.append(StringUtil.quoteForHTML(sa[i]));
        }
        String s2 = Localization.lang("The regular expression <b>%0</b> is invalid:", StringUtil.quoteForHTML(regExp)) + "<p><tt>" + sb + "</tt>";
        if (!(e instanceof PatternSyntaxException)) {
            return s2;
        }
        int lastNewline = s2.lastIndexOf("<br>");
        int hat = s2.lastIndexOf(94);
        if (lastNewline >= 0 && hat >= 0 && hat > lastNewline) {
            return s2.substring(0, lastNewline + 4) + s2.substring(lastNewline + 4).replace(" ", "&nbsp;");
        }
        return s2;
    }

    public boolean okPressed() {
        return this.isOkPressed;
    }

    public AbstractGroup getResultingGroup() {
        return this.resultingGroup;
    }

    private void setLayoutForSelectedGroup() {
        if (this.explicitRadioButton.isSelected()) {
            this.optionsLayout.show(this.optionsPanel, String.valueOf(0));
        } else if (this.keywordsRadioButton.isSelected()) {
            this.optionsLayout.show(this.optionsPanel, String.valueOf(1));
        } else if (this.searchRadioButton.isSelected()) {
            this.optionsLayout.show(this.optionsPanel, String.valueOf(2));
        } else if (this.autoRadioButton.isSelected()) {
            this.optionsLayout.show(this.optionsPanel, String.valueOf(3));
        } else if (this.texRadioButton.isSelected()) {
            this.optionsLayout.show(this.optionsPanel, String.valueOf(4));
        }
    }

    private void updateComponents() {
        boolean okEnabled;
        boolean bl = okEnabled = !this.nameField.getText().trim().isEmpty();
        if (!okEnabled) {
            this.setDescription(Localization.lang("Please enter a name for the group.", new String[0]));
            this.okButton.setEnabled(false);
            return;
        }
        if (this.keywordsRadioButton.isSelected()) {
            String s1 = this.keywordGroupSearchField.getText().trim();
            okEnabled = okEnabled && s1.matches("\\w+");
            String s2 = this.keywordGroupSearchTerm.getText().trim();
            boolean bl2 = okEnabled = okEnabled && !s2.isEmpty();
            if (okEnabled) {
                if (this.keywordGroupRegExp.isSelected()) {
                    try {
                        Pattern.compile(s2);
                        this.setDescription(GroupDescriptions.getDescriptionForPreview(s1, s2, this.keywordGroupCaseSensitive.isSelected(), this.keywordGroupRegExp.isSelected()));
                    }
                    catch (PatternSyntaxException e) {
                        okEnabled = false;
                        this.setDescription(GroupDialog.formatRegExException(s2, e));
                    }
                } else {
                    this.setDescription(GroupDescriptions.getDescriptionForPreview(s1, s2, this.keywordGroupCaseSensitive.isSelected(), this.keywordGroupRegExp.isSelected()));
                }
            } else {
                this.setDescription(Localization.lang("Please enter the field to search (e.g. <b>keywords</b>) and the keyword to search it for (e.g. <b>electrical</b>).", new String[0]));
            }
            this.setNameFontItalic(true);
        } else if (this.searchRadioButton.isSelected()) {
            String s1 = this.searchGroupSearchExpression.getText().trim();
            if (okEnabled &= !s1.isEmpty()) {
                this.setDescription(this.fromTextFlowToHTMLString(SearchDescribers.getSearchDescriberFor(new SearchQuery(s1, this.isCaseSensitive(), this.isRegex())).getDescription()));
                if (this.isRegex()) {
                    try {
                        Pattern.compile(s1);
                    }
                    catch (PatternSyntaxException e) {
                        okEnabled = false;
                        this.setDescription(GroupDialog.formatRegExException(s1, e));
                    }
                }
            } else {
                this.setDescription(Localization.lang("Please enter a search term. For example, to search all fields for <b>Smith</b>, enter:<p><tt>smith</tt><p>To search the field <b>Author</b> for <b>Smith</b> and the field <b>Title</b> for <b>electrical</b>, enter:<p><tt>author=smith and title=electrical</tt>", new String[0]));
            }
            this.setNameFontItalic(true);
        } else if (this.explicitRadioButton.isSelected()) {
            this.setDescription(GroupDescriptions.getDescriptionForPreview());
            this.setNameFontItalic(false);
        }
        this.okButton.setEnabled(okEnabled);
    }

    private String fromTextFlowToHTMLString(TextFlow textFlow) {
        StringBuilder htmlStringBuilder = new StringBuilder();
        for (Node node : textFlow.getChildren()) {
            if (!(node instanceof Text)) continue;
            htmlStringBuilder.append(TooltipTextUtil.textToHTMLString((Text)node));
        }
        return htmlStringBuilder.toString();
    }

    private boolean isRegex() {
        return this.searchGroupRegExp.isSelected();
    }

    private boolean isCaseSensitive() {
        return this.searchGroupCaseSensitive.isSelected();
    }

    private void setDescription(String description) {
        this.descriptionLabel.setText("<html>" + description + "</html>");
    }

    private void setNameFontItalic(boolean italic) {
        Font f = this.nameField.getFont();
        if (f.isItalic() != italic) {
            f = f.deriveFont(italic ? 2 : 0);
            this.nameField.setFont(f);
        }
    }

    private GroupHierarchyType getContext() {
        if (this.independentButton.isSelected()) {
            return GroupHierarchyType.INDEPENDENT;
        }
        if (this.intersectionButton.isSelected()) {
            return GroupHierarchyType.REFINING;
        }
        if (this.unionButton.isSelected()) {
            return GroupHierarchyType.INCLUDING;
        }
        return GroupHierarchyType.INDEPENDENT;
    }

    private void setContext(GroupHierarchyType context) {
        if (context == GroupHierarchyType.REFINING) {
            this.intersectionButton.setSelected(true);
        } else if (context == GroupHierarchyType.INCLUDING) {
            this.unionButton.setSelected(true);
        } else {
            this.independentButton.setSelected(true);
        }
    }

    @Override
    public Optional<AbstractGroup> showAndWait() {
        this.setVisible(true);
        if (this.okPressed()) {
            AbstractGroup newGroup = this.getResultingGroup();
            return Optional.of(newGroup);
        }
        return Optional.empty();
    }
}

