/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.gui.actions;

import java.awt.event.ActionEvent;
import java.util.Optional;
import javafx.scene.control.TextArea;
import javax.swing.AbstractAction;
import org.jabref.JabRefGUI;
import org.jabref.gui.ClipBoardManager;
import org.jabref.logic.l10n.Localization;
import org.jabref.model.entry.identifier.DOI;

public class CopyDoiUrlAction
extends AbstractAction {
    private TextArea component = null;
    private String identifier;

    public CopyDoiUrlAction(String identifier) {
        super(Localization.menuTitle("Copy DOI url", new String[0]));
        this.identifier = identifier;
    }

    public CopyDoiUrlAction(TextArea component) {
        this(component.getText());
        this.component = component;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this.identifier = this.component == null ? this.identifier : this.component.getText();
        Optional<String> urlOptional = DOI.parse(this.identifier).map(DOI::getURIAsASCIIString);
        if (urlOptional.isPresent()) {
            ClipBoardManager clipBoard = new ClipBoardManager();
            clipBoard.setClipboardContents(urlOptional.get());
            JabRefGUI.getMainFrame().output(Localization.lang("The link has been copied to the clipboard.", new String[0]));
        } else {
            JabRefGUI.getMainFrame().output(Localization.lang("Invalid DOI: '%0'.", this.identifier));
        }
    }
}

