/*
 * Decompiled with CFR 0.152.
 */
package difflib.event;

import difflib.DiffUtils;
import difflib.Patch;
import difflib.Utils;
import difflib.event.PatchHandler;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import javax.annotation.Nonnull;

public class UnifiedPatchParser {
    public void parse(File unifiedPatch, @Nonnull PatchHandler<String> handler) throws IOException {
        try (BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(unifiedPatch), Utils.UTF_8));){
            String line = reader.readLine();
            do {
                ArrayList<String> patch = new ArrayList<String>();
                while (!line.startsWith("---")) {
                    line = reader.readLine();
                }
                assert (line.startsWith("---"));
                patch.add(line);
                String originalFileName = line.substring(4);
                line = reader.readLine();
                assert (line.startsWith("+++"));
                patch.add(line);
                String revisedFileName = line.substring(4);
                line = reader.readLine();
                do {
                    patch.add(line);
                } while ((line = reader.readLine()) != null && (line.startsWith("@@ ") || line.startsWith(" ") || line.startsWith("+") || line.startsWith("-")));
                Patch<String> parsed = DiffUtils.parseUnifiedDiff(patch);
                handler.handle(originalFileName, revisedFileName, parsed);
            } while (line != null);
        }
    }
}

