/*
 * Decompiled with CFR 0.152.
 */
package de.saxsys.mvvmfx.utils.validation.visualization;

import de.saxsys.mvvmfx.utils.validation.ValidationMessage;
import de.saxsys.mvvmfx.utils.validation.ValidationStatus;
import de.saxsys.mvvmfx.utils.validation.visualization.ValidationVisualizer;
import java.util.Optional;
import javafx.application.Platform;
import javafx.scene.control.Control;

public abstract class ValidationVisualizerBase
implements ValidationVisualizer {
    @Override
    public void initVisualization(ValidationStatus result, Control control, boolean required) {
        if (required) {
            this.applyRequiredVisualization(control, required);
        }
        this.applyVisualization(control, result.getHighestMessage(), required);
        result.getMessages().addListener(c -> {
            while (c.next()) {
                Platform.runLater(() -> this.applyVisualization(control, result.getHighestMessage(), required));
            }
        });
    }

    abstract void applyRequiredVisualization(Control var1, boolean var2);

    abstract void applyVisualization(Control var1, Optional<ValidationMessage> var2, boolean var3);
}

