/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.applicationinsights.core.dependencies.http.impl.client;

import com.microsoft.applicationinsights.core.dependencies.http.HttpEntity;
import com.microsoft.applicationinsights.core.dependencies.http.HttpResponse;
import com.microsoft.applicationinsights.core.dependencies.http.StatusLine;
import com.microsoft.applicationinsights.core.dependencies.http.annotation.Contract;
import com.microsoft.applicationinsights.core.dependencies.http.annotation.ThreadingBehavior;
import com.microsoft.applicationinsights.core.dependencies.http.client.HttpResponseException;
import com.microsoft.applicationinsights.core.dependencies.http.client.ResponseHandler;
import com.microsoft.applicationinsights.core.dependencies.http.util.EntityUtils;
import java.io.IOException;

@Contract(threading=ThreadingBehavior.IMMUTABLE)
public abstract class AbstractResponseHandler<T>
implements ResponseHandler<T> {
    @Override
    public T handleResponse(HttpResponse response) throws HttpResponseException, IOException {
        StatusLine statusLine = response.getStatusLine();
        HttpEntity entity = response.getEntity();
        if (statusLine.getStatusCode() >= 300) {
            EntityUtils.consume(entity);
            throw new HttpResponseException(statusLine.getStatusCode(), statusLine.getReasonPhrase());
        }
        return entity == null ? null : (T)this.handleEntity(entity);
    }

    public abstract T handleEntity(HttpEntity var1) throws IOException;
}

