/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.wasm.resolve.diagnostics;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.MemberDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyDescriptor;
import org.jetbrains.kotlin.descriptors.TypeParameterDescriptor;
import org.jetbrains.kotlin.descriptors.ValueParameterDescriptor;
import org.jetbrains.kotlin.js.resolve.diagnostics.SourceLocationUtilsKt;
import org.jetbrains.kotlin.js.translate.utils.AnnotationsUtils;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.BindingTrace;
import org.jetbrains.kotlin.resolve.checkers.DeclarationChecker;
import org.jetbrains.kotlin.resolve.checkers.DeclarationCheckerContext;
import org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilsKt;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.wasm.resolve.diagnostics.ErrorsWasm;
import org.jetbrains.kotlin.wasm.resolve.diagnostics.WasmJsInteropTypesCheckerKt;
import org.jetbrains.kotlin.wasm.util.JsCodeUtilsKt;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J \u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016\u00a8\u0006\u000b"}, d2={"Lorg/jetbrains/kotlin/wasm/resolve/diagnostics/WasmJsInteropTypesChecker;", "Lorg/jetbrains/kotlin/resolve/checkers/DeclarationChecker;", "()V", "check", "", "declaration", "Lorg/jetbrains/kotlin/psi/KtDeclaration;", "descriptor", "Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;", "context", "Lorg/jetbrains/kotlin/resolve/checkers/DeclarationCheckerContext;", "wasm.frontend"})
public final class WasmJsInteropTypesChecker
implements DeclarationChecker {
    @NotNull
    public static final WasmJsInteropTypesChecker INSTANCE = new WasmJsInteropTypesChecker();

    private WasmJsInteropTypesChecker() {
    }

    @Override
    public void check(@NotNull KtDeclaration declaration, @NotNull DeclarationDescriptor descriptor2, @NotNull DeclarationCheckerContext context) {
        block10: {
            DeclarationDescriptor declarationDescriptor;
            BindingTrace trace;
            block11: {
                block9: {
                    Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
                    Intrinsics.checkNotNullParameter((Object)descriptor2, (String)"descriptor");
                    Intrinsics.checkNotNullParameter((Object)context, (String)"context");
                    if (!(descriptor2 instanceof MemberDescriptor)) {
                        return;
                    }
                    trace = context.getTrace();
                    BindingContext bindingContext = trace.getBindingContext();
                    Intrinsics.checkNotNullExpressionValue((Object)bindingContext, (String)"trace.bindingContext");
                    BindingContext bindingContext2 = bindingContext;
                    if (!(WasmJsInteropTypesChecker.check$isExternalJsInteropDeclaration(descriptor2) || WasmJsInteropTypesChecker.check$isJsCodeDeclaration(descriptor2, bindingContext2) || WasmJsInteropTypesChecker.check$isJsExportDeclaration(descriptor2, bindingContext2))) {
                        return;
                    }
                    declarationDescriptor = descriptor2;
                    if (!(declarationDescriptor instanceof ClassDescriptor)) break block9;
                    for (TypeParameterDescriptor typeParameter2 : ((ClassDescriptor)descriptor2).getDeclaredTypeParameters()) {
                        Intrinsics.checkNotNullExpressionValue((Object)typeParameter2, (String)"typeParameter");
                        WasmJsInteropTypesChecker.check$checkJsInteropTypeParameter(typeParameter2, declaration, trace);
                    }
                    break block10;
                }
                if (!(declarationDescriptor instanceof PropertyDescriptor)) break block11;
                for (TypeParameterDescriptor typeParameter3 : ((PropertyDescriptor)descriptor2).getTypeParameters()) {
                    Intrinsics.checkNotNullExpressionValue((Object)typeParameter3, (String)"typeParameter");
                    WasmJsInteropTypesChecker.check$checkJsInteropTypeParameter(typeParameter3, declaration, trace);
                }
                KotlinType kotlinType = ((PropertyDescriptor)descriptor2).getType();
                Intrinsics.checkNotNullExpressionValue((Object)kotlinType, (String)"descriptor.type");
                WasmJsInteropTypesChecker.check$checkJsInteropType$default(kotlinType, trace, "external property", declaration, false, 8, null);
                break block10;
            }
            if (!(declarationDescriptor instanceof FunctionDescriptor)) break block10;
            for (TypeParameterDescriptor typeParameter4 : ((FunctionDescriptor)descriptor2).getTypeParameters()) {
                Intrinsics.checkNotNullExpressionValue((Object)typeParameter4, (String)"typeParameter");
                WasmJsInteropTypesChecker.check$checkJsInteropTypeParameter(typeParameter4, declaration, trace);
            }
            for (ValueParameterDescriptor parameter2 : ((FunctionDescriptor)descriptor2).getValueParameters()) {
                KotlinType kotlinType = parameter2.getVarargElementType();
                if (kotlinType == null) {
                    KotlinType kotlinType2 = parameter2.getType();
                    kotlinType = kotlinType2;
                    Intrinsics.checkNotNullExpressionValue((Object)kotlinType2, (String)"parameter.type");
                }
                KotlinType typeToCheck = kotlinType;
                Intrinsics.checkNotNullExpressionValue((Object)parameter2, (String)"parameter");
                PsiElement psiElement = SourceLocationUtilsKt.findPsi(parameter2);
                if (psiElement == null) {
                    psiElement = declaration;
                }
                WasmJsInteropTypesChecker.check$checkJsInteropType$default(typeToCheck, trace, "external function parameter", psiElement, false, 8, null);
            }
            KotlinType kotlinType = ((FunctionDescriptor)descriptor2).getReturnType();
            if (kotlinType != null) {
                WasmJsInteropTypesChecker.check$checkJsInteropType(kotlinType, trace, "external function return", declaration, true);
            }
        }
    }

    private static final boolean check$isExternalJsInteropDeclaration(DeclarationDescriptor $descriptor) {
        return DescriptorUtilsKt.isEffectivelyExternal((MemberDescriptor)$descriptor) && !$descriptor.getAnnotations().hasAnnotation(new FqName("kotlin.wasm.WasmImport"));
    }

    private static final boolean check$isJsCodeDeclaration(DeclarationDescriptor $descriptor, BindingContext bindingContext) {
        return $descriptor instanceof FunctionDescriptor && JsCodeUtilsKt.hasValidJsCodeBody((FunctionDescriptor)$descriptor, bindingContext) || $descriptor instanceof PropertyDescriptor && JsCodeUtilsKt.hasValidJsCodeBody((PropertyDescriptor)$descriptor, bindingContext);
    }

    private static final boolean check$isJsExportDeclaration(DeclarationDescriptor $descriptor, BindingContext bindingContext) {
        return AnnotationsUtils.isExportedObject($descriptor, bindingContext);
    }

    private static final void check$checkJsInteropType(KotlinType $this$check_u24checkJsInteropType, BindingTrace trace, String typePositionDescription, PsiElement reportOn, boolean isInFunctionReturnPosition) {
        if (!WasmJsInteropTypesCheckerKt.access$isTypeSupportedInJsInterop($this$check_u24checkJsInteropType, isInFunctionReturnPosition)) {
            trace.report(ErrorsWasm.WRONG_JS_INTEROP_TYPE.on(reportOn, typePositionDescription, $this$check_u24checkJsInteropType));
        }
    }

    static /* synthetic */ void check$checkJsInteropType$default(KotlinType kotlinType, BindingTrace bindingTrace, String string2, PsiElement psiElement, boolean bl, int n, Object object) {
        if ((n & 8) != 0) {
            bl = false;
        }
        WasmJsInteropTypesChecker.check$checkJsInteropType(kotlinType, bindingTrace, string2, psiElement, bl);
    }

    private static final void check$checkJsInteropTypeParameter(TypeParameterDescriptor $this$check_u24checkJsInteropTypeParameter, KtDeclaration $declaration, BindingTrace trace) {
        for (KotlinType upperBound : $this$check_u24checkJsInteropTypeParameter.getUpperBounds()) {
            Intrinsics.checkNotNullExpressionValue((Object)upperBound, (String)"upperBound");
            if (WasmJsInteropTypesCheckerKt.access$isTypeSupportedInJsInterop(upperBound, false)) continue;
            PsiElement psiElement = SourceLocationUtilsKt.findPsi($this$check_u24checkJsInteropTypeParameter);
            if (psiElement == null) {
                psiElement = $declaration;
            }
            PsiElement reportOn = psiElement;
            trace.report(ErrorsWasm.WRONG_JS_INTEROP_TYPE.on(reportOn, "type parameter upper bound", upperBound));
        }
    }
}

