/*
 * Decompiled with CFR 0.152.
 */
package org.slf4j.helpers;

import java.util.ArrayDeque;
import java.util.Deque;
import java.util.HashMap;
import java.util.Map;

public class ThreadLocalMapOfStacks {
    final ThreadLocal<Map<String, Deque<String>>> tlMapOfStacks = new ThreadLocal();

    public void pushByKey(String key2, String value) {
        Deque<String> deque;
        if (key2 == null) {
            return;
        }
        Map<String, Deque<String>> map = this.tlMapOfStacks.get();
        if (map == null) {
            map = new HashMap<String, Deque<String>>();
            this.tlMapOfStacks.set(map);
        }
        if ((deque = map.get(key2)) == null) {
            deque = new ArrayDeque<String>();
        }
        deque.push(value);
        map.put(key2, deque);
    }

    public String popByKey(String key2) {
        if (key2 == null) {
            return null;
        }
        Map<String, Deque<String>> map = this.tlMapOfStacks.get();
        if (map == null) {
            return null;
        }
        Deque<String> deque = map.get(key2);
        if (deque == null) {
            return null;
        }
        return deque.pop();
    }

    public Deque<String> getCopyOfDequeByKey(String key2) {
        if (key2 == null) {
            return null;
        }
        Map<String, Deque<String>> map = this.tlMapOfStacks.get();
        if (map == null) {
            return null;
        }
        Deque<String> deque = map.get(key2);
        if (deque == null) {
            return null;
        }
        return new ArrayDeque<String>(deque);
    }

    public void clearDequeByKey(String key2) {
        if (key2 == null) {
            return;
        }
        Map<String, Deque<String>> map = this.tlMapOfStacks.get();
        if (map == null) {
            return;
        }
        Deque<String> deque = map.get(key2);
        if (deque == null) {
            return;
        }
        deque.clear();
    }
}

