/*
 * Decompiled with CFR 0.152.
 */
package mill.scalalib;

import java.io.Serializable;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.time.temporal.ChronoUnit;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import mill.api.Ctx;
import mill.api.Result;
import mill.moduledefs.Scaladoc;
import mill.testrunner.TestResult;
import mill.util.Util$;
import os.Path;
import os.PathChunk;
import os.ReadablePath;
import os.read$lines$;
import os.read$stream$;
import sbt.testing.Status;
import scala.$less$colon$less$;
import scala.Array;
import scala.Array$;
import scala.Array$UnapplySeqWrapper$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Predef$ArrowAssoc$;
import scala.Some;
import scala.Tuple2;
import scala.Tuple2$mcJJ$sp;
import scala.collection.ArrayOps$;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.Seq;
import scala.collection.SeqFactory;
import scala.collection.SeqFactory$UnapplySeqWrapper$;
import scala.collection.SeqOps;
import scala.collection.SetOps;
import scala.collection.StringOps$;
import scala.collection.immutable.$colon$colon;
import scala.collection.immutable.Iterable;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.math.Numeric$LongIsIntegral$;
import scala.math.Ordering$String$;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LongRef;
import scala.runtime.Nothing$;
import scala.runtime.ScalaRunTime$;
import scala.xml.Elem;
import scala.xml.MetaData;
import scala.xml.Node;
import scala.xml.NodeBuffer;
import scala.xml.NodeSeq$;
import scala.xml.Null$;
import scala.xml.Text;
import scala.xml.TopScope$;
import scala.xml.UnprefixedAttribute;
import scala.xml.XML$;
import scala.xml.dtd.DocType;
import ujson.Readable$;
import upickle.default$;

public final class TestModuleUtil$ {
    public static final TestModuleUtil$ MODULE$ = new TestModuleUtil$();
    private static final int FailedTestReportCount = 5;
    private static final String ErrorStatus = Status.Error.name();
    private static final String FailureStatus = Status.Failure.name();
    private static final Set<String> SkippedStates = (Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{Status.Ignored.name(), Status.Skipped.name(), Status.Pending.name()}));

    public <T> T mill$scalalib$TestModuleUtil$$withTestProgressTickerThread(long totalClassCount, Function2<ConcurrentMap<Path, Function1<String, BoxedUnit>>, ConcurrentMap<Path, BoxedUnit>, T> body, Ctx ctx) {
        T t;
        ConcurrentHashMap workerStatusMap = new ConcurrentHashMap();
        ConcurrentHashMap workerResultSet = new ConcurrentHashMap();
        ConcurrentHashMap testClassTimeMap = new ConcurrentHashMap();
        ScheduledExecutorService executor = Executors.newScheduledThreadPool(1);
        try {
            executor.scheduleWithFixedDelay(() -> {
                long now = System.currentTimeMillis();
                workerStatusMap.forEach((claimLog, callback) -> read$lines$.MODULE$.apply((ReadablePath)claimLog).lastOption().foreach((Function1<String, Object> & Serializable)currentTestClass -> {
                    TestModuleUtil$.$anonfun$withTestProgressTickerThread$3(testClassTimeMap, now, callback, currentTestClass);
                    return BoxedUnit.UNIT;
                }));
                LongRef totalSuccess = LongRef.create(0L);
                LongRef totalFailure = LongRef.create(0L);
                workerResultSet.forEach((resultLog, x$34) -> {
                    Tuple2<Object, Object> tuple2 = default$.MODULE$.read(Readable$.MODULE$.fromReadable(read$stream$.MODULE$.apply((ReadablePath)resultLog), Predef$.MODULE$.$conforms()), default$.MODULE$.read$default$2(), default$.MODULE$.Tuple2Reader(default$.MODULE$.LongReader(), default$.MODULE$.LongReader()));
                    if (tuple2 == null) {
                        throw new MatchError(tuple2);
                    }
                    long success = tuple2._1$mcJ$sp();
                    long failure = tuple2._2$mcJ$sp();
                    Tuple2$mcJJ$sp tuple2$mcJJ$sp = new Tuple2$mcJJ$sp(success, failure);
                    long success2 = ((Tuple2)tuple2$mcJJ$sp)._1$mcJ$sp();
                    long failure2 = ((Tuple2)tuple2$mcJJ$sp)._2$mcJ$sp();
                    totalSuccess$1.elem += success2;
                    totalFailure$1.elem += failure2;
                });
                ctx.log().ticker(new StringBuilder(11).append(totalSuccess.elem + totalFailure.elem).append("/").append(totalClassCount).append(" completed").append((Object)(totalFailure.elem > 0L ? new StringBuilder(12).append(", ").append(totalFailure.elem).append(" failures.").toString() : ".")).toString());
            }, 0L, 20L, TimeUnit.MILLISECONDS);
            t = body.apply(workerStatusMap, workerResultSet);
        }
        finally {
            executor.shutdown();
        }
        return t;
    }

    public Tuple2<scala.collection.immutable.Seq<String>, Map<? extends String, String>> loadArgsAndProps(boolean useArgsFile, scala.collection.immutable.Seq<String> forkArgs) {
        if (useArgsFile) {
            Tuple2 tuple2 = forkArgs.partition((Function1<String, Object> & Serializable)x$36 -> BoxesRunTime.boxToBoolean(x$36.startsWith("-D")));
            if (tuple2 == null) {
                throw new MatchError(tuple2);
            }
            scala.collection.immutable.Seq props = (scala.collection.immutable.Seq)tuple2._1();
            scala.collection.immutable.Seq jvmArgs = (scala.collection.immutable.Seq)tuple2._2();
            Tuple2<scala.collection.immutable.Seq, scala.collection.immutable.Seq> tuple22 = new Tuple2<scala.collection.immutable.Seq, scala.collection.immutable.Seq>(props, jvmArgs);
            scala.collection.immutable.Seq props2 = tuple22._1();
            scala.collection.immutable.Seq jvmArgs2 = tuple22._2();
            Map sysProps = ((IterableOnceOps)((IterableOps)props2.map((Function1<String, String[]> & Serializable)x$38 -> StringOps$.MODULE$.drop$extension(Predef$.MODULE$.augmentString((String)x$38), 2).split("[=]", 2))).map((Function1<String[], Tuple2> & Serializable)x0$1 -> {
                Object object;
                Object object2;
                String[] stringArray = x0$1;
                if (stringArray != null && !Array$UnapplySeqWrapper$.MODULE$.isEmpty$extension(object2 = Array$.MODULE$.unapplySeq(stringArray)) && new Array.UnapplySeqWrapper(Array$UnapplySeqWrapper$.MODULE$.get$extension(object2)) != null && Array$UnapplySeqWrapper$.MODULE$.lengthCompare$extension(Array$UnapplySeqWrapper$.MODULE$.get$extension(object2), 2) == 0) {
                    String k = (String)Array$UnapplySeqWrapper$.MODULE$.apply$extension(Array$UnapplySeqWrapper$.MODULE$.get$extension(object2), 0);
                    String v = (String)Array$UnapplySeqWrapper$.MODULE$.apply$extension(Array$UnapplySeqWrapper$.MODULE$.get$extension(object2), 1);
                    return Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(k), v);
                }
                if (stringArray != null && !Array$UnapplySeqWrapper$.MODULE$.isEmpty$extension(object = Array$.MODULE$.unapplySeq(stringArray)) && new Array.UnapplySeqWrapper(Array$UnapplySeqWrapper$.MODULE$.get$extension(object)) != null && Array$UnapplySeqWrapper$.MODULE$.lengthCompare$extension(Array$UnapplySeqWrapper$.MODULE$.get$extension(object), 1) == 0) {
                    String k = (String)Array$UnapplySeqWrapper$.MODULE$.apply$extension(Array$UnapplySeqWrapper$.MODULE$.get$extension(object), 0);
                    return Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(k), "");
                }
                throw new MatchError(stringArray);
            })).toMap($less$colon$less$.MODULE$.refl());
            return Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(jvmArgs2), sysProps);
        }
        return Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(forkArgs), Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)Nil$.MODULE$));
    }

    public Result<Tuple2<String, scala.collection.immutable.Seq<TestResult>>> handleResults(String doneMsg, scala.collection.immutable.Seq<TestResult> results) {
        return this.handleResults(doneMsg, results, None$.MODULE$);
    }

    public Result<Tuple2<String, scala.collection.immutable.Seq<TestResult>>> handleResults(String doneMsg, scala.collection.immutable.Seq<TestResult> results, Option<Ctx.Env> ctx) {
        scala.collection.immutable.Seq badTests = (scala.collection.immutable.Seq)results.filter((Function1<TestResult, Object> & Serializable)x -> BoxesRunTime.boxToBoolean(TestModuleUtil$.$anonfun$handleResults$1(x)));
        if (badTests.isEmpty()) {
            return new Result.Success<Tuple2<String, scala.collection.immutable.Seq<TestResult>>>(new Tuple2<String, scala.collection.immutable.Seq<TestResult>>(doneMsg, results));
        }
        int reportCount = BoxesRunTime.unboxToBoolean(ctx.fold(() -> false, (Function1<Ctx.Env, Object> & Serializable)x$39 -> BoxesRunTime.boxToBoolean(TestModuleUtil$.$anonfun$handleResults$3(x$39)))) ? badTests.length() : this.FailedTestReportCount();
        String suffix = badTests.length() <= reportCount ? "" : new StringBuilder(16).append("\n  and ").append(badTests.length() - reportCount).append(" more ...").toString();
        String msg = new StringBuilder(15).append(badTests.size()).append(" tests failed: ").append(((IterableOnceOps)((IterableOps)badTests.take(reportCount)).map((Function1<TestResult, String> & Serializable)t -> new StringBuilder(1).append(t.fullyQualifiedName()).append(" ").append(t.selector()).toString())).mkString("\n  ", "\n  ", "")).append(suffix).toString();
        return new Result.Failure<Tuple2<String, scala.collection.immutable.Seq<TestResult>>>(msg, new Some<Tuple2<String, scala.collection.immutable.Seq<TestResult>>>(new Tuple2<String, scala.collection.immutable.Seq<TestResult>>(doneMsg, results)));
    }

    public Result<Tuple2<String, scala.collection.immutable.Seq<TestResult>>> handleResults(String doneMsg, scala.collection.immutable.Seq<TestResult> results, Ctx.Env ctx, Option<String> testReportXml, Option<Map<String, String>> props) {
        testReportXml.map((Function1<String, Tuple2> & Serializable)fileName -> {
            Path path = ((Ctx.Dest)((Object)ctx)).dest().$div(new PathChunk.StringPathChunk((String)fileName));
            return new Tuple2<String, Path>((String)fileName, path);
        }).flatMap((Function1<Tuple2, Option> & Serializable)x$42 -> {
            Tuple2 tuple2 = x$42;
            if (tuple2 != null) {
                Path path = (Path)tuple2._2();
                return MODULE$.genTestXmlReport(results, Instant.now(), (Map)props.getOrElse((Function0<Map> & Serializable)() -> Predef$.MODULE$.Map().empty())).map((Function1<Elem, Tuple2> & Serializable)xml -> {
                    String x$1 = path.toString();
                    Elem x$2 = xml;
                    boolean x$3 = true;
                    String x$4 = XML$.MODULE$.save$default$3();
                    DocType x$5 = XML$.MODULE$.save$default$5();
                    XML$.MODULE$.save(x$1, x$2, x$4, true, x$5);
                    BoxedUnit x$40 = BoxedUnit.UNIT;
                    return new Tuple2<Elem, BoxedUnit>((Elem)xml, x$40);
                }).map((Function1<Tuple2, Object> & Serializable)x$41 -> {
                    TestModuleUtil$.$anonfun$handleResults$9(x$41);
                    return BoxedUnit.UNIT;
                });
            }
            throw new MatchError(tuple2);
        });
        return this.handleResults(doneMsg, results, new Some<Ctx.Env>(ctx));
    }

    public Option<Map<String, String>> handleResults$default$5() {
        return None$.MODULE$;
    }

    private int FailedTestReportCount() {
        return FailedTestReportCount;
    }

    private String ErrorStatus() {
        return ErrorStatus;
    }

    private String FailureStatus() {
        return FailureStatus;
    }

    private Set<String> SkippedStates() {
        return SkippedStates;
    }

    public Option<Elem> genTestXmlReport(scala.collection.immutable.Seq<TestResult> results0, Instant timestamp, Map<String, String> props) {
        Iterable suites = (Iterable)results0.groupBy((Function1<TestResult, String> & Serializable)x$43 -> x$43.fullyQualifiedName()).map((Function1<Tuple2, Elem> & Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                String fqn = (String)tuple2._1();
                scala.collection.immutable.Seq testResults = (scala.collection.immutable.Seq)tuple2._2();
                scala.collection.immutable.Seq cases = (scala.collection.immutable.Seq)testResults.map((Function1<TestResult, Elem> & Serializable)testResult -> {
                    void var3_3;
                    String testName = TestModuleUtil$.testcaseName$1(testResult);
                    MetaData $md = Null$.MODULE$;
                    $md = new UnprefixedAttribute("time", TestModuleUtil$.durationAsString$1(testResult.duration()), $md);
                    $md = new UnprefixedAttribute("name", testName, $md);
                    $md = new UnprefixedAttribute("classname", testResult.fullyQualifiedName(), $md);
                    NodeBuffer $buf = new NodeBuffer();
                    $buf.$amp$plus(new Text("\n          "));
                    $buf.$amp$plus(MODULE$.testCaseStatus((TestResult)testResult).orNull($less$colon$less$.MODULE$.refl()));
                    $buf.$amp$plus(new Text("\n        "));
                    return new Elem(null, "testcase", $md, TopScope$.MODULE$, false, NodeSeq$.MODULE$.seqToNodeSeq((Seq<Node>)var3_3));
                });
                MetaData $md = Null$.MODULE$;
                $md = new UnprefixedAttribute("timestamp", MODULE$.formatTimestamp(timestamp), $md);
                $md = new UnprefixedAttribute("time", TestModuleUtil$.durationAsString$1(BoxesRunTime.unboxToLong(((IterableOnceOps)testResults.map((Function1<TestResult, Object> & Serializable)x$46 -> BoxesRunTime.boxToLong(x$46.duration()))).sum(Numeric$LongIsIntegral$.MODULE$))), $md);
                $md = new UnprefixedAttribute("skipped", Integer.toString(testResults.count((Function1<TestResult, Object> & Serializable)testResult -> BoxesRunTime.boxToBoolean(TestModuleUtil$.$anonfun$genTestXmlReport$6(testResult)))), $md);
                $md = new UnprefixedAttribute("errors", Integer.toString(testResults.count((Function1<TestResult, Object> & Serializable)x$45 -> BoxesRunTime.boxToBoolean(TestModuleUtil$.$anonfun$genTestXmlReport$7(x$45)))), $md);
                $md = new UnprefixedAttribute("failures", Integer.toString(testResults.count((Function1<TestResult, Object> & Serializable)x$44 -> BoxesRunTime.boxToBoolean(TestModuleUtil$.$anonfun$genTestXmlReport$8(x$44)))), $md);
                $md = new UnprefixedAttribute("tests", Integer.toString(testResults.length()), $md);
                $md = new UnprefixedAttribute("name", fqn, $md);
                NodeBuffer $buf = new NodeBuffer();
                $buf.$amp$plus(new Text("\n        "));
                $buf.$amp$plus(TestModuleUtil$.properties$1(props));
                $buf.$amp$plus(new Text("\n        "));
                $buf.$amp$plus(cases);
                $buf.$amp$plus(new Text("\n      "));
                return new Elem(null, "testsuite", $md, TopScope$.MODULE$, false, NodeSeq$.MODULE$.seqToNodeSeq($buf));
            }
            throw new MatchError(tuple2);
        });
        MetaData $md = Null$.MODULE$;
        $md = new UnprefixedAttribute("time", TestModuleUtil$.durationAsString$1(BoxesRunTime.unboxToLong(((IterableOnceOps)results0.map((Function1<TestResult, Object> & Serializable)x$49 -> BoxesRunTime.boxToLong(x$49.duration()))).sum(Numeric$LongIsIntegral$.MODULE$))), $md);
        $md = new UnprefixedAttribute("skipped", Integer.toString(results0.count((Function1<TestResult, Object> & Serializable)testResult -> BoxesRunTime.boxToBoolean(TestModuleUtil$.$anonfun$genTestXmlReport$10(testResult)))), $md);
        $md = new UnprefixedAttribute("errors", Integer.toString(results0.count((Function1<TestResult, Object> & Serializable)x$48 -> BoxesRunTime.boxToBoolean(TestModuleUtil$.$anonfun$genTestXmlReport$11(x$48)))), $md);
        $md = new UnprefixedAttribute("failures", Integer.toString(results0.count((Function1<TestResult, Object> & Serializable)x$47 -> BoxesRunTime.boxToBoolean(TestModuleUtil$.$anonfun$genTestXmlReport$12(x$47)))), $md);
        $md = new UnprefixedAttribute("tests", Integer.toString(results0.size()), $md);
        NodeBuffer $buf = new NodeBuffer();
        $buf.$amp$plus(new Text("\n        "));
        $buf.$amp$plus(suites);
        $buf.$amp$plus(new Text("\n      "));
        Elem xml = new Elem(null, "testsuites", $md, TopScope$.MODULE$, false, NodeSeq$.MODULE$.seqToNodeSeq($buf));
        if (results0.nonEmpty()) {
            return new Some<Elem>(xml);
        }
        return None$.MODULE$;
    }

    private String formatTimestamp(Instant timestamp) {
        return DateTimeFormatter.ISO_LOCAL_DATE_TIME.format(LocalDateTime.ofInstant(timestamp.truncatedTo(ChronoUnit.SECONDS), ZoneId.of("UTC")));
    }

    private Option<Elem> testCaseStatus(TestResult e) {
        String trace = (String)e.exceptionTrace().map((Function1<scala.collection.immutable.Seq, String> & Serializable)stackTraceTrace -> ((IterableOnceOps)stackTraceTrace.map((Function1<StackTraceElement, String> & Serializable)t -> new StringBuilder(4).append(t.getClassName()).append(".").append(t.getMethodName()).append("(").append(t.getFileName()).append(":").append(t.getLineNumber()).append(")").toString())).mkString(new StringBuilder(10).append(e.exceptionName().getOrElse((Function0<String> & Serializable)() -> "")).append(": ").append(e.exceptionMsg().getOrElse((Function0<String> & Serializable)() -> "")).append("\n    at ").toString(), "\n    at ", "")).getOrElse((Function0<String> & Serializable)() -> "");
        boolean bl = false;
        String string = null;
        boolean bl2 = false;
        String string2 = null;
        String string3 = e.status();
        String string4 = this.ErrorStatus();
        String string5 = string3;
        if (!(string4 != null ? !string4.equals(string5) : string5 != null)) {
            bl = true;
            string = string3;
            if (e.exceptionMsg().isDefined() && e.exceptionName().isDefined()) {
                MetaData $md = Null$.MODULE$;
                $md = new UnprefixedAttribute("type", e.exceptionName().get(), $md);
                $md = new UnprefixedAttribute("message", e.exceptionMsg().get(), $md);
                NodeBuffer $buf = new NodeBuffer();
                $buf.$amp$plus(new Text("\n          "));
                $buf.$amp$plus(trace);
                $buf.$amp$plus(new Text("\n        "));
                return new Some<Elem>(new Elem(null, "error", $md, TopScope$.MODULE$, false, NodeSeq$.MODULE$.seqToNodeSeq($buf)));
            }
        }
        if (bl) {
            MetaData $md = Null$.MODULE$;
            $md = new UnprefixedAttribute("message", new Text("No Exception or message provided"), $md);
            return new Some<Elem>(new Elem(null, "error", $md, TopScope$.MODULE$, true, Nil$.MODULE$));
        }
        String string6 = this.FailureStatus();
        String string7 = string3;
        if (!(string6 != null ? !string6.equals(string7) : string7 != null)) {
            bl2 = true;
            string2 = string3;
            if (e.exceptionMsg().isDefined() && e.exceptionName().isDefined()) {
                MetaData $md = Null$.MODULE$;
                $md = new UnprefixedAttribute("type", e.exceptionName().get(), $md);
                $md = new UnprefixedAttribute("message", e.exceptionMsg().get(), $md);
                NodeBuffer $buf = new NodeBuffer();
                $buf.$amp$plus(new Text("\n          "));
                $buf.$amp$plus(trace);
                $buf.$amp$plus(new Text("\n        "));
                return new Some<Elem>(new Elem(null, "failure", $md, TopScope$.MODULE$, false, NodeSeq$.MODULE$.seqToNodeSeq($buf)));
            }
        }
        if (bl2) {
            MetaData $md = Null$.MODULE$;
            $md = new UnprefixedAttribute("message", new Text("No Exception or message provided"), $md);
            return new Some<Elem>(new Elem(null, "failure", $md, TopScope$.MODULE$, true, Nil$.MODULE$));
        }
        if (this.SkippedStates().contains(string3)) {
            return new Some<Elem>(new Elem(null, "skipped", Null$.MODULE$, TopScope$.MODULE$, true, Nil$.MODULE$));
        }
        return None$.MODULE$;
    }

    @Scaladoc(value="/**\n   * Shorten the long list of fully qualified class names by truncating\n   * repetitive segments so we can see more stuff on a single line\n   */")
    public scala.collection.immutable.Seq<String> collapseTestClassNames(scala.collection.immutable.Seq<String> names0) {
        scala.collection.immutable.Seq names = (scala.collection.immutable.Seq)names0.sorted(Ordering$String$.MODULE$);
        return (scala.collection.immutable.Seq)new $colon$colon<Nothing$>((Nothing$)((Object)((String)names.head())), Nil$.MODULE$).$plus$plus((IterableOnce)names.sliding(2).map((Function1<scala.collection.immutable.Seq, String> & Serializable)x0$1 -> {
            SeqOps seqOps;
            scala.collection.immutable.Seq seq = x0$1;
            if (seq != null && !SeqFactory$UnapplySeqWrapper$.MODULE$.isEmpty$extension(seqOps = package$.MODULE$.Seq().unapplySeq(seq)) && new SeqFactory.UnapplySeqWrapper(SeqFactory$UnapplySeqWrapper$.MODULE$.get$extension(seqOps)) != null && SeqFactory$UnapplySeqWrapper$.MODULE$.lengthCompare$extension(SeqFactory$UnapplySeqWrapper$.MODULE$.get$extension(seqOps), 2) == 0) {
                String prev = (String)SeqFactory$UnapplySeqWrapper$.MODULE$.apply$extension(SeqFactory$UnapplySeqWrapper$.MODULE$.get$extension(seqOps), 0);
                String next = (String)SeqFactory$UnapplySeqWrapper$.MODULE$.apply$extension(SeqFactory$UnapplySeqWrapper$.MODULE$.get$extension(seqOps), 1);
                String[] prevSegments = StringOps$.MODULE$.split$extension(Predef$.MODULE$.augmentString(prev), '.');
                String[] nextSegments = StringOps$.MODULE$.split$extension(Predef$.MODULE$.augmentString(next), '.');
                return Predef$.MODULE$.genericWrapArray(ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps(ArrayOps$.MODULE$.zipWithIndex$extension(Predef$.MODULE$.refArrayOps(nextSegments))), (Function1<Tuple2, Object> & Serializable)x0$2 -> {
                    Tuple2 tuple2 = x0$2;
                    if (tuple2 != null) {
                        String s = (String)tuple2._1();
                        int i = tuple2._2$mcI$sp();
                        if (Predef$.MODULE$.wrapRefArray((Object[])prevSegments).lift().apply(BoxesRunTime.boxToInteger(i)).contains(s)) {
                            return BoxesRunTime.boxToCharacter(StringOps$.MODULE$.head$extension(Predef$.MODULE$.augmentString(s)));
                        }
                        return s;
                    }
                    throw new MatchError(tuple2);
                }, ClassTag$.MODULE$.Any())).mkString(".");
            }
            throw new MatchError(seq);
        }));
    }

    public static final /* synthetic */ void $anonfun$withTestProgressTickerThread$3(ConcurrentHashMap testClassTimeMap$1, long now$1, Function1 callback$1, String currentTestClass) {
        testClassTimeMap$1.putIfAbsent(currentTestClass, BoxesRunTime.boxToLong(now$1));
        long last = BoxesRunTime.unboxToLong(testClassTimeMap$1.get(currentTestClass));
        callback$1.apply(new StringBuilder(0).append(currentTestClass).append(Util$.MODULE$.renderSecondsSuffix(now$1 - last)).toString());
    }

    public static final /* synthetic */ boolean $anonfun$handleResults$1(TestResult x) {
        return ((SetOps)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"Error", "Failure"}))).contains(x.status());
    }

    public static final /* synthetic */ boolean $anonfun$handleResults$3(Ctx.Env x$39) {
        return x$39.env().contains("CI");
    }

    public static final /* synthetic */ void $anonfun$handleResults$9(Tuple2 x$41) {
        Tuple2 tuple2 = x$41;
        if (tuple2 != null) {
            return;
        }
        throw new MatchError(tuple2);
    }

    private static final String durationAsString$1(long value) {
        return Double.toString((double)value / 1000.0);
    }

    private static final String testcaseName$1(TestResult testResult) {
        return testResult.selector().replace(new StringBuilder(1).append(testResult.fullyQualifiedName()).append(".").toString(), "");
    }

    /*
     * WARNING - void declaration
     */
    private static final Elem properties$1(Map props$2) {
        void var2_2;
        Iterable ps = (Iterable)props$2.map((Function1<Tuple2, Elem> & Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                String key2 = (String)tuple2._1();
                String value = (String)tuple2._2();
                MetaData $md = Null$.MODULE$;
                $md = new UnprefixedAttribute("value", value, $md);
                $md = new UnprefixedAttribute("name", key2, $md);
                return new Elem(null, "property", $md, TopScope$.MODULE$, true, Nil$.MODULE$);
            }
            throw new MatchError(tuple2);
        });
        NodeBuffer $buf = new NodeBuffer();
        $buf.$amp$plus(new Text("\n        "));
        $buf.$amp$plus(ps);
        $buf.$amp$plus(new Text("\n      "));
        return new Elem(null, "properties", Null$.MODULE$, TopScope$.MODULE$, false, NodeSeq$.MODULE$.seqToNodeSeq((Seq<Node>)var2_2));
    }

    public static final /* synthetic */ boolean $anonfun$genTestXmlReport$6(TestResult testResult) {
        return MODULE$.SkippedStates().contains(testResult.status());
    }

    public static final /* synthetic */ boolean $anonfun$genTestXmlReport$7(TestResult x$45) {
        String string = x$45.status();
        String string2 = MODULE$.ErrorStatus();
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$genTestXmlReport$8(TestResult x$44) {
        String string = x$44.status();
        String string2 = MODULE$.FailureStatus();
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$genTestXmlReport$10(TestResult testResult) {
        return MODULE$.SkippedStates().contains(testResult.status());
    }

    public static final /* synthetic */ boolean $anonfun$genTestXmlReport$11(TestResult x$48) {
        String string = x$48.status();
        String string2 = MODULE$.ErrorStatus();
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$genTestXmlReport$12(TestResult x$47) {
        String string = x$47.status();
        String string2 = MODULE$.FailureStatus();
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    private TestModuleUtil$() {
    }
}

