/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.rules;

import com.izforge.izpack.adaptator.IXMLElement;
import com.izforge.izpack.rules.Condition;
import com.izforge.izpack.rules.RulesEngine;
import com.izforge.izpack.util.Debug;

public class NotCondition
extends Condition {
    private static final long serialVersionUID = 3194843222487006309L;
    protected Condition operand;

    public NotCondition() {
    }

    public NotCondition(Condition condition) {
        this.operand = condition;
        if (condition != null) {
            this.operand.setInstalldata(this.installdata);
        }
    }

    public void readFromXML(IXMLElement iXMLElement) {
        try {
            if (iXMLElement.getChildrenCount() != 1) {
                Debug.log("not-condition needs one condition as operand");
                return;
            }
            this.operand = RulesEngine.analyzeCondition(iXMLElement.getChildAtIndex(0));
        }
        catch (Exception exception) {
            Debug.log("missing element in not-condition");
        }
    }

    public boolean isTrue() {
        if (this.operand == null) {
            Debug.trace("Operand of condition " + this.id + " not initialized correctly.");
            return false;
        }
        this.operand.setInstalldata(this.installdata);
        return !this.operand.isTrue();
    }

    public String getDependenciesDetails() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.id);
        stringBuffer.append(" depends on:<ul><li>NOT ");
        stringBuffer.append(this.operand.getDependenciesDetails());
        stringBuffer.append("</li></ul>");
        return stringBuffer.toString();
    }

    public void makeXMLData(IXMLElement iXMLElement) {
        IXMLElement iXMLElement2 = RulesEngine.createConditionElement(this.operand, iXMLElement);
        this.operand.makeXMLData(iXMLElement2);
        iXMLElement.addChild(iXMLElement2);
    }
}

