/*
 * Decompiled with CFR 0.152.
 */
package com.jgoodies.chart;

import com.jgoodies.chart.AbstractChartModel;
import com.jgoodies.chart.ChartModel;
import java.awt.Color;
import java.util.Arrays;
import java.util.Comparator;
import javax.swing.Icon;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public final class FilteredChartModel<T>
extends AbstractChartModel<T> {
    private final ChartModel<T> delegate;
    private int itemLimit;
    private float minimumFraction;
    private String collapsedText;
    private Color collapsedColor;
    private int[] mappedIndices;
    private long collapsedSize;

    public FilteredChartModel(ChartModel<T> chartModel, int itemLimit, float minimumFraction, String collapsedText, Color collapsedColor) {
        FilteredChartModel.assertValidItemLimit(itemLimit);
        FilteredChartModel.assertValidMinimumFraction(minimumFraction);
        this.delegate = chartModel;
        this.itemLimit = itemLimit;
        this.minimumFraction = minimumFraction;
        this.collapsedText = collapsedText;
        this.collapsedColor = collapsedColor;
        this.filter();
        this.delegate.addChangeListener(new DelegateChangeHandler());
    }

    public int getItemLimit() {
        return this.itemLimit;
    }

    public void setItemLimit(int newItemLimit) {
        FilteredChartModel.assertValidItemLimit(newItemLimit);
        this.itemLimit = newItemLimit;
        this.changed();
    }

    public float getMinimumFraction() {
        return this.minimumFraction;
    }

    public void setMinimumFraction(float newMinimumFraction) {
        FilteredChartModel.assertValidMinimumFraction(newMinimumFraction);
        this.minimumFraction = newMinimumFraction;
        this.changed();
    }

    public String getCollapsedText() {
        return this.collapsedText;
    }

    public void setCollapsedText(String newCollapsedText) {
        this.collapsedText = newCollapsedText;
        this.changed();
    }

    public Color getCollapsedColor() {
        return this.collapsedColor;
    }

    public void setCollapsedColor(Color newCollapsedColor) {
        this.collapsedColor = newCollapsedColor;
        this.changed();
    }

    @Override
    public int getItemCount() {
        return this.isFiltering() ? this.itemLimit : this.delegate.getItemCount();
    }

    @Override
    public T getData(int index) {
        return this.delegate.getData(this.mappedIndex(index));
    }

    @Override
    public Icon getIcon(int index) {
        return this.isFiltering() && index == this.itemLimit - 1 ? null : this.delegate.getIcon(this.mappedIndex(index));
    }

    @Override
    public String getText(int index) {
        return this.isFiltering() && index == this.itemLimit - 1 ? this.getCollapsedText() : this.delegate.getText(this.mappedIndex(index));
    }

    @Override
    public long getSize(int index) {
        return this.isFiltering() && index == this.itemLimit - 1 ? this.collapsedSize : this.delegate.getSize(this.mappedIndex(index));
    }

    @Override
    public Color getColor(int index) {
        return this.isFiltering() && index == this.itemLimit - 1 ? this.collapsedColor : this.delegate.getColor(this.mappedIndex(index));
    }

    private void filter() {
        this.mappedIndices = null;
        int delegateItemCount = this.delegate.getItemCount();
        if (delegateItemCount <= this.itemLimit) {
            return;
        }
        this.collapsedSize = 0L;
        Integer[] sortedIndices = new Integer[delegateItemCount];
        for (int i = 0; i < delegateItemCount; ++i) {
            sortedIndices[i] = i;
        }
        Arrays.sort(sortedIndices, new IndexComparator(this.delegate));
        int[] reversedSorted = new int[delegateItemCount];
        for (int i = 0; i < delegateItemCount; ++i) {
            reversedSorted[sortedIndices[i].intValue()] = i;
        }
        this.mappedIndices = new int[this.itemLimit - 1];
        int mappedIndexCount = 0;
        for (int index = 0; index < delegateItemCount; ++index) {
            long size = this.delegate.getSize(index);
            int reversedSortedIndex = reversedSorted[index];
            if (reversedSortedIndex < this.itemLimit - 1) {
                this.mappedIndices[mappedIndexCount++] = index;
                continue;
            }
            this.collapsedSize += size;
        }
    }

    private boolean isFiltering() {
        return this.mappedIndices != null;
    }

    private int mappedIndex(int index) {
        if (!this.isFiltering()) {
            return index;
        }
        return index == this.itemLimit - 1 ? index : this.mappedIndices[index];
    }

    private static void assertValidItemLimit(int limit) {
        if (limit < 3) {
            throw new IllegalArgumentException("The item limit must be >= 2.");
        }
    }

    private static void assertValidMinimumFraction(float fraction) {
        if (fraction < 1.0E-5f) {
            throw new IllegalArgumentException("The minimum fraction must be >= 0.001%");
        }
    }

    private void changed() {
        this.filter();
        this.fireStateChanged();
    }

    private final class DelegateChangeHandler
    implements ChangeListener {
        private DelegateChangeHandler() {
        }

        @Override
        public void stateChanged(ChangeEvent e) {
            FilteredChartModel.this.changed();
        }
    }

    private static final class IndexComparator
    implements Comparator<Integer> {
        private final ChartModel<?> source;

        IndexComparator(ChartModel<?> source) {
            this.source = source;
        }

        @Override
        public int compare(Integer o1, Integer o2) {
            long size2;
            long size1 = this.source.getSize(o1);
            return size1 > (size2 = this.source.getSize(o2)) ? -1 : (size1 == size2 ? 0 : 1);
        }
    }
}

