/* wptHotkey.h - Hotkey registration
 *	Copyright (C) 2001-2004 Timo Schulz
 *
 * This file is part of WinPT.
 *
 * WinPT is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License 
 * as published by the Free Software Foundation; either version 2 
 * of the License, or (at your option) any later version.
 *  
 * WinPT is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License 
 * along with WinPT; if not, write to the Free Software Foundation, 
 * Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA 
 */

#ifndef WPT_HOTKEY_H
#define WPT_HOTKEY_H

enum {
    WPT_CLIP_ENCRYPT_ID	          = 0x3000,
    WPT_CLIP_DECRYPT_VERIFY_ID    = 0x3001,
    WPT_CLIP_SIGN_ID              = 0x3002,
    WPT_CLIP_SIGN_ENCRYPT_ID      = 0x3003,
    WPT_CURRWND_ENCRYPT_ID        = 0x4000,
    WPT_CURRWND_DECRYPT_VERIFY_ID = 0x4001,
    WPT_CURRWND_SIGN_ID           = 0x4002,
    WPT_CURRWND_SIGN_ENCRYPT_ID   = 0x4003,
    WPT_AGENT_FORGET_ID           = 0x5000,
};


struct hotkey_s {
    int enabled;
    int id;
    int alt_ctrl;
    int alt_shift;
    int key;	
};
typedef struct hotkey_s * hotkey_t;

static hotkey_s wpt_hotkeys[]  = {
    {1, WPT_CLIP_ENCRYPT_ID,           1, 0, 0x45}, /* alt+ctrl+e */
    {1, WPT_CLIP_DECRYPT_VERIFY_ID,    1, 0, 0x44}, /* alt+ctrl+d */
    {1, WPT_CLIP_SIGN_ID,              1, 0, 0x53}, /* alt+ctrl+s */
    {1, WPT_CLIP_SIGN_ENCRYPT_ID,      1, 0, 0x42}, /* alt+ctrl+b */
    {1, WPT_CURRWND_ENCRYPT_ID,        0, 1, 0x45}, /* alt+shift+e */
    {1, WPT_CURRWND_DECRYPT_VERIFY_ID, 0, 1, 0x44}, /* alt+shift+d */
    {1, WPT_CURRWND_SIGN_ID,           0, 1, 0x53}, /* alt+shift+s */
    {1, WPT_CURRWND_SIGN_ENCRYPT_ID,   0, 1, 0x42}, /* alt+shift+b */
    {1, WPT_AGENT_FORGET_ID,           1, 0, 0x46}, /* alt+ctrl+f */
    {0}
};

const char * hotkeys_strerror (void);
int hotkeys_register (HWND wnd);
int hotkeys_unregister (HWND wnd);
int hotkey_register_single (HWND wnd, hotkey_t hk);
int hotkey_unregister_single (HWND wnd, hotkey_t hk);

#endif /* WPT_HOTKEY_H */