/* wptCard.h
 *	Copyright (C) 2003, 2004, 2005 Timo Schulz
 *
 * This file is part of WinPT.
 *
 * WinPT is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * WinPT is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with WinPT; if not, write to the Free Software Foundation, 
 * Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA
 */

#ifndef WPT_CARD_H
#define WPT_CARD_H

enum {
    CARD_STATE_NONE=0,
    CARD_STATE_UNAWARE,
    CARD_STATE_UNAVAIL,
    CARD_STATE_PRESENT,
    CARD_STATE_EXCLUSI,
    CARD_STATE_EMPTY,
    CARD_STATE_INUSE,
    CARD_STATE_MUTE
};

struct gpgme_card_s;
typedef struct gpgme_card_s * gpgme_card_t;


struct pin_cb_ctx_s {
    gpgme_edit_card_t which;
    char *info_text;
    char *apin; /* admin */
    char *upin; /* user */
};

struct card_cb_s {
    int cancel;
    int init;
    int code;
    char val[128];
};

struct pcsc_reader_s;
typedef struct pcsc_reader_s * pcsc_reader_t;


unsigned     get_card_status (void);
int          show_card_status (void);
gpgme_card_t gpg_load_scard (void);

/*-- wptCardManager.cpp --*/
const char * card_callback (int code, void *opaque);

/*-- wptCardPCSC.c --*/
#ifdef __cplusplus
extern "C" {
#endif

int          pcsc_loadlib (int scard_support);
void         pcsc_free_readers (pcsc_reader_t rd);
const char * pcsc_get_reader (pcsc_reader_t rd, int idx, int *ret_nrd);
int          pcsc_scan_readers (pcsc_reader_t *ret_rd);
int          pcsc_get_card_status (void);

#ifdef __cplusplus
}
#endif

#endif /*WPT_CARD_H*/