/**************************************************************/
/////////////////////  4.7.6 ///////////////////////////////////
/**************************************************************/

#ifndef __RFM_TYPES_H__
#define __RFM_TYPES_H__
#include <string.h>
#include <stdlib.h>
#include <gtk/gtk.h>
#include <time.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <unistd.h>
#include <X11/Xlib.h>
#include <X11/Xatom.h>
#include <semaphore.h>
#include <gmodule.h>
#include <glob.h>

/* increment this MACRO whenever any change is done to structures
 * (to avoid incorrect memory accesses by modules)
 * Must be an integer. 
 * */
#define LIBRFM_SERIAL 445
#define  LIBRFM_MODULE \
void *module_sanity(void){ \
    return (GINT_TO_POINTER(LIBRFM_SERIAL)); \
}

typedef struct rfm_global_t
{
  gint 		argc; 		/* partial argument list */
  gchar 	**argv; 	/* partial argument list */
  // main thread, which should keep control of the gtk loop
  GThread	*self;	
  pid_t		pid;
  GtkWidget 	*window; 		// main  window 
  // list of valid views (necessary for tabbed iconview)
  GSList	*window_view_list;
  GSList	*bookmarks;
  sem_t 	*setup_semaphore;   
  GStaticRWLock icon_theme_lock;
  GStaticRWLock	view_list_lock;
  GCond		*janitor_signal;
  
}
rfm_global_t;


/**************************************************************/
/////////////////////  view_geometry_t /////////////////////////
/**************************************************************/


typedef struct view_geometry_t {
    gdouble scrollX;
    int x;
    int y;
    int w;
    int h;
} view_geometry_t;


/**************************************************************/
/////////////////////  view_preferences_t //////////////////////
/**************************************************************/


typedef struct view_preferences_t {
    int preferences;
    int sortcolumn;
    int icon_size;
} view_preferences_t;


/**************************************************************/
/////////////////////  record_entry_t //////////////////////////
/**************************************************************/

typedef struct record_entry_t	/* was: record_entry_t */ 
{
    gint type;			
    struct stat *st;
    gchar *mimetype;
    gchar *mimemagic;
    gchar *filetype;
    gchar *encoding;
    gchar *tag;
    gchar *path;
    gchar *pseudo_path;
    const gchar *module;	/* module name, or NULL for local files */
    const gchar *parent_module;	/* module name, or NULL for local files */
}
record_entry_t;


/**************************************************************/
/////////////////////  xfdir_t /////////////////////////////////
/**************************************************************/

typedef struct dir_t
{
    gchar		*pathv;		/* matched pathname.  */
    record_entry_t	 *en;

}
dir_t;


typedef struct xfdir_t
{
    size_t 		pathc;		/* Count of paths matched */
    dir_t 		*gl;
    void 		*data;
    off_t 		tama;
    guint		monitor_id;
    guint		view_id;
    //flags
    gboolean		reload;
    gboolean		invalidate_icons;
    gint		ascending;
    gint		sort_column;
    struct view_t	*view_p;
    GThread 		*thread;
    void		*control_p;
    record_entry_t	*en;

}
xfdir_t;

/**************************************************************/
/////////////////////   population_t ///////////////////////////
/**************************************************************/


typedef struct population_t {
    struct view_t	*view_p;
    record_entry_t 	*en;
    gint 		population_serial;
    const gchar 	*module;	
    gchar		*icon_id;
    gboolean		content_icon;

    GdkPixbuf 		*pixbuf; // no reference here
    gint 		pixbufW;
    gint 		pixbufH;

    GdkPixbuf 		*preview_pixbuf;  // referenced: for tooltip and properties preview
    gint		flags;
// normal_tip: preview was tried but not accomplished
			// normal_tip	POPULATION_NORMAL_TIP
			// preview_done	POPULATION_PREVIEW_DONE
 // preview_busy: for tooltip and properties preview
			// preview_busy	POPULATION_PREVIEW_BUSY
			// selected	POPULATION_SELECTED
			// saturated	POPULATION_SATURATED
			// thumbnailed	POPULATION_THUMBNAILED
			// cut		POPULATION_CUT
			// copied	POPULATION_COPIED
			// short_icon	POPULATION_SHORT_ICON
    
    gint 		row;   
    gint 		column;
    
    gint 		labelX;
    gint 		labelY;
    // this is a key value to keep threads in sync.
    gint 		serial;  
    GdkRectangle 	rect;    

    PangoLayout 	*layout;
    PangoRectangle 	logical_rect;
    PangoLayout 	*layout2;
    PangoRectangle 	logical_rect2;
    PangoLayout 	*layout_full;
    PangoRectangle 	logical_rect_full;
} population_t;


/**************************************************************/
/////////////////////  widgets_t ///////////////////////////////
/**************************************************************/

typedef struct widgets_t { 
    struct view_t	*view_p;		// view_t * parent
    gchar		*workdir;		// current workdir

    void 		*data;			// Available to plugins

    GtkWidget 		*window; 		// main  window 
    GtkWidget 		*paper; 		// drawing area
    GtkWidget 		**diagnostics;		// diagnostics text area
    GtkWidget 		**diagnostics_window;	// window to place diagnostics
    GtkWidget 		*status;		// status text area
    GtkWidget 		*progress;		// load progress bar
    GtkWidget 		*popup;			// popup menu
    GtkWidget 		*rename;		// rename entry box
    GtkWidget 		*vpane;			// drawing/diagnostics pane
    GtkWidget 		*button_space;		// little button space
    GtkWidget 		*clear_button;		// clear text area button
    GtkWidget 		*navigation_popup;	// navigation popup menu
    GtkWidget 		*size_scale;		// navigation popup menu
    GtkScrolledWindow 	*scrolled_window;	// viewport for drawing area

    // notebook is only for gridview
    GtkWidget 		**notebook; 		// notebook
    GtkWidget 		*page_child; 		// notebook page
    GtkWidget 		*page_icon; 		// notebook tab icon
    GtkWidget 		*page_label; 		// notebook tab label
    GtkWidget 		*page_button; 		// notebook remove button
    GtkWidget 		*page_menu_label; 	// notebook remove button

} widgets_t;

/**************************************************************/
///////////////////// subthread_t //////////////////////////////
/**************************************************************/
typedef struct subthread_t
{
  widgets_t	widgets;	
  widgets_t	*widgets_p;	
  GSList	*selection_list;
  GtkWidget     *diagnostics;
  GtkWidget     *diagnostics_window;
}
subthread_t;

/**************************************************************/
/////////////////////   eyecandy_t  ////////////////////////////
/**************************************************************/

typedef struct eyecandy_t {
    Pixmap	 	pixmap;  
    gchar		*desktop_bg_file;
    gchar		*desktop_color;
    gchar		*iconview_color;
    gint 		progress_count;
    gint 		progress_total;
}eyecandy_t;

/**************************************************************/
/////////////////////   tip_event_t    /////////////////////////
/**************************************************************/

typedef struct tip_event_t {
    gboolean 		tooltip_active;		// tooltip status   
    record_entry_t	*tooltip_entry;  	// tooltip record_entry
    GdkPixbuf		*tooltip_pixbuf;	// tooltip image preview
    gchar 		*tooltip_text;		// tooltip status   
    gint 		tip_timer;	//
}tip_event_t;

/**************************************************************/
/////////////////////   mouse_event_t  /////////////////////////
/**************************************************************/

typedef struct mouse_event_t {
    // mouse events
    guint32 		eventtime;  	/* eventtime for module popup menu */  
    gboolean		rubberbanding;
    gint 		single_click_mode_state;
    GdkDragAction 	drag_action;
    GdkEventDND 	drag_event;
    GdkPixbuf 		*dnd_pixbuf;
    GtkTargetList	*target_list;
    gint 		current_mouseX;	//
    gint 		current_mouseY;	//
    gint 		old_X;		//
    gint 		old_Y;		//
    gint 		boxX;		//
    gint 		boxY;		//
    gdouble 		initial_x;
    gdouble 		mouseX;
    gdouble 		initial_y;
    gdouble 		mouseY;
    gdouble 		offset_x;
    gdouble 		offset_y;
    const population_t 	*selected_p;
    const population_t 	*doing_drag_p;
    const population_t 	*saturated_p;
    const population_t 	*label_p;	
    gboolean 		dragstate;
} mouse_event_t;

/**************************************************************/
/////////////////////   view_geometry_t  ///////////////////////
/**************************************************************/

typedef struct view_layout_t {
    gint 		icon_size;
    gint 		paperX;			// configuration parameter
    gint 		paperY;			// configuration parameter
    gint		margin_top;
    gint		margin_bottom;
    gint		margin_left;
    gint		margin_right;
    gint 		grid_rows;
    gint 		grid_columns;   
    gint 		grid_area;	// 
    gint 		max_elements;	//
    gint 		text_height;	//
    gint 		column_width;	//
    gint 		root_w;
    gint 		root_h;
    gint 		root_d;
    gint		name_width;
    gint		details_width;
} view_layout_t;

/**************************************************************/
/////////////////////   mutexes_t   ////////////////////////////
/**************************************************************/

typedef struct mutexes_t {
    GMutex		*reload_mutex;
    GMutex		*status_mutex;

    GMutex		*population_serial;
    GMutex		*monitor_loop;
    GMutex		*monitor_id; 
    GMutex		*monitor_control; 
    GCond		*monitor_signal;
    GStaticRWLock	population_rwlock;
    GStaticRWLock	view_lock;
} mutexes_t;

/**************************************************************/
/////////////////////   flags_t     ////////////////////////////
/**************************************************************/

typedef struct flags_t {
    gboolean		refresh;

    gboolean 		enable_buffer_surface;   
    // redraw deskview buffer pixbuf
    gboolean 		user_wants_lock;
    gboolean 		monitor_enabled;
    gboolean 		thumbnailer_active;
    gboolean 		thumbnailer_exit;
    gboolean		disable_toggle_refresh;	// flag for popup setup
    gboolean		monitor_go;
    gboolean		active_monitor;
    gboolean		no_expose;
    gint 		preferences;	//
    gint 		serial;
    gint 		type;		// iconview type:
    gint 		sortcolumn;	//
    gint 		count; 		// to monitor load progress
    gint 		status;
    gint 		monitor_id;
    gint		pasteboard_serial;
    gint		bookmark_serial;
    gint		population_serial;   
} flags_t;

/**************************************************************/
/////////////////////   view_t /////////////////////////////////
/**************************************************************/

typedef struct view_t {
						// 1. DESKVIEW_TYPE 
						// 2. ICONVIEW_TYPE
    gchar 		*desktop_dir;		// used by deskview
    record_entry_t 	*en;			// folder entry
    widgets_t 		widgets;

    view_layout_t	view_layout;
    mouse_event_t	mouse_event;
    tip_event_t		tip_event;
    eyecandy_t		eyecandy;
    mutexes_t		mutexes;
    flags_t		flags;

    GSList 		*selection_list;
    GList 		*go_list;
    GList 		*sh_command;
    GSList		*controller_list;
    gint 		sh_command_counter;
    
    
    pthread_rwlock_t 	*population_rwlock;

    gchar 		*xbuffer; 
    gchar 		*deepest_dir; 

    population_t 	**population_pp;

    const gchar 	*module;
    /* constructor functions: */
    struct view_t	*(*constructor)(record_entry_t *en); 		
    void 		(*child_constructor)(struct widgets_t *widgets_p, 
				    gchar *path);
    void 		(*tab_constructor)(struct widgets_t *widgets_p, 
				    const gchar *path);
    void		*user_data;

} view_t;
    

#endif
