/*   tubo.h */

/*  A program independent forking object module for gtk based programs.
 *  
 *  Copyright (C) 2000-2012  Edscott Wilson Garcia under GNU GPL
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
*/
/* public stuff */

/* Tubo() returns void pointer to tubo object 
*  usage: see example below */
#include <sys/types.h>
#include <unistd.h>
#include <pthread.h>

/**
 * tubo_t:
 *
 **/
#define tubo_t void


/**
 * Tubo_threads:
 * @fork_function: pointer to function to execute after forking. This is
 * executed by the main calling process.
 * @fork_function_data: pointer to data to be sent to @fork_function, or NULL.
 * @stdin_fd: pointer for file descriptor for stdin, or NULL
 * @stdout_f: pointer to thread safe function to process stdout, or NULL.
 * @stderr_f: pointer to thread safe function to process stderr, or NULL.
 * @tubo_done_f: pointer to function to execute when remote process has terminated.
 * Execution of this function does not mean all pipe data has been processed yet.
 * @user_function_data: pointer to data to be sent to @stdout_f, @stderr_f 
 * and @tubo_done_f (yeah, same data block for all three).
 * @reap_child: flag to reap child. Set to TRUE to have the child process reaped.
 * If this is set to FALSE, then the user is responsible to reap the child 
 * (i.e., with waitpid()) to avoid leaving a zombie.
 * @check_valid_ansi_sequence: flag to filter out non printer safe output.
 * If set to TRUE, output to stdout/stderr will be checked
 * for escape sequences that are not valid on a printer terminal and if any such
 * sequence is found, the child will be terminated without much more ado.
 * 
 * Returns: pid of spawned process (child pid). This pid is not the pid of the program
 * being executed. It is a process that ensures pipes will remain open while pipe
 * output is still to be read. To send a TERM signal to the actual process which
 * is executing the remote command, send a USR1 signal to child_pid. To send a KILL
 * to the actual process which is executing the remote command, send a USR1 signal
 * to child_pid.
 *
 **/

pid_t Tubo_threads (
    void (*fork_function) (void *),
    void *fork_function_data,
    int *stdin_fd,
    void (*stdout_f) (void *stdout_data,
                      void *stream,
                      int childFD),
    void (*stderr_f) (void *stderr_data,
                      void *stream,
                      int childFD),
    void (*tubo_done_f) (void *),
    void *user_function_data,
    int reap_child,
    int check_valid_ansi_sequence
    );

unsigned 
Tubo_id(void);

/***********************************************************/
