#ifndef RODENT_MOUSE_H
#define RODENT_MOUSE_H

void rodent_time_out(widgets_t *widgets_p, const gchar *path);
gboolean rodent_entry_available(widgets_t *widgets_p, record_entry_t *en);

void
  rodent_create_target_list (view_t * view_p);

void
rodent_saturate_item (view_t *view_p, const population_t * population_p);

void
rodent_unsaturate_item (view_t *view_p);

void
  rodent_select_pixbuf (view_t * view_p, const population_t * population_p);

void
  rodent_double_click (view_t * view_p, const population_t * population_p, gboolean control);

void
rodent_label_event (view_t * view_p, population_t * population_p);

void
  rodent_unselect_all_pixbuf (view_t * view_p);

gboolean 
  rodent_tip_function (GtkWidget * widget, gint x, gint y, gboolean keyboard_mode, GtkTooltip * tooltip, gpointer user_data);


gboolean 
  rodent_signal_on_button_press (GtkWidget * widget, 
	  GdkEventButton * event, gpointer data);

gboolean 
  rodent_signal_on_button_release (GtkWidget * widget, 
	  GdkEventButton * event, gpointer data);

gboolean 
  rodent_signal_on_motion (GtkWidget * widget, 
	  GdkEventMotion * event, gpointer data);

gboolean 
  rodent_signal_on_enter (GtkWidget * widget, 
	  GdkEventCrossing * event, gpointer data);

gboolean
  rodent_signal_on_leave_paper (GtkWidget * widget, 
	  GdkEventCrossing * event, gpointer data);
    
gboolean 
  rodent_signal_on_leave (GtkWidget * widget, 
	  GdkEventCrossing * event, gpointer data);

void
  rodent_signal_drag_data (GtkWidget * widget,
          GdkDragContext * context,
          gint x, gint y, GtkSelectionData * selection_data, 
	  guint info, guint time, gpointer data);

void
  rodent_signal_drag_leave (GtkWidget * widget, 
	  GdkDragContext * drag_context, guint time, gpointer data);

void
  rodent_signal_drag_delete (GtkWidget * widget, 
	  GdkDragContext * context, gpointer data);

void
  rodent_signal_drag_end (GtkWidget * widget, 
	  GdkDragContext * context, gpointer data);

gboolean 
  rodent_signal_drag_motion (GtkWidget * widget, 
	  GdkDragContext * dc, gint x, gint y, guint t, gpointer data);

void
  rodent_signal_drag_data_get (GtkWidget * widget,
	  GdkDragContext * context, GtkSelectionData * selection_data, 
	  guint info, guint time, gpointer data);

void
  rodent_signal_drag_begin (GtkWidget * widget, 
	  GdkDragContext * drag_context, gpointer data);

#endif
