#ifndef RFM_PRIMARY_H
# define RFM_PRIMARY_H

#ifdef HAVE_FEATURES_H
# include <features.h>
#endif

/*
 * #define _GNU_SOURCE
 * Defining this  macro  (with  any  value)  is  equivalent  to  defining  
 * _BSD_SOURCE, _SVID_SOURCE, _ATFILE_SOURCE, _LARGEFILE64_SOURCE,
 * _ISOC99_SOURCE, _XOPEN_SOURCE_EXTENDED, _POSIX_SOURCE, _POSIX_C_SOURCE
 * with  the  value   200809L (200112L  in  glibc  versions  before  2.10;
 * 199506L  in glibc versions before 2.5; 199309L in glibc versions before 2.1)
 * and _XOPEN_SOURCE with the value 700  (600  in glibc versions before 2.10;
 * 500 in glibc versions before 2.2).  In addition, various GNU-specific
 * extensions are also exposed.  Where standards conflict,
 * BSD definitions are disfavored.
 *
 * This is defined in autogenerated config.h, if available.
 */


#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <sys/wait.h>

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>
#include <errno.h>
#include <limits.h>
#include <pwd.h>
#include <grp.h>
#include <math.h>
#include <locale.h>

#ifdef HAVE_STDARG_H
# include <stdarg.h>
#elif HAVE_VARARGS_H
# include <varargs.h>
#endif

#include <ctype.h>
#include <glob.h>
#include <memory.h>
#include <signal.h>
#include <dirent.h>
#include <regex.h>

#include <X11/Xlib.h>
#ifdef HAVE_LIBSM
# include <X11/SM/SMlib.h>
#endif
# include <X11/Xmd.h>
# include <X11/SM/SMlib.h>
#include <X11/Xproto.h>
#include <X11/Xatom.h>

#include <cairo-xlib.h>
#include <gio/gio.h>
#include <gtk/gtk.h>
#include <gdk/gdkx.h>
#include <gdk/gdkkeysyms.h>
#ifdef USE_GTK2
# include "gdk2_3_key_compat.h"
#endif
#include <gmodule.h>
#include <time.h>
// deprecated: #include <sys/timeb.h>
#include <sys/mman.h>

#ifdef HAVE_PTHREAD_TRYJOIN
# ifndef _GNU_SOURCE
#  define _GNU_SOURCE
# endif
# include <pthread.h>
#endif

#include <libxml/parser.h>
#include <libxml/tree.h>
#include <magic.h>


#include "primary-environment.i"
void
decrement_view_ref_no_signal(view_t *view_p);

void
decrement_view_ref(view_t *view_p);

void
increment_view_ref(view_t *view_p);

view_t *
rfm_new_view(void);

view_t *
rfm_destroy_view(view_t *view_p);

void 
rfm_get_drawable_geometry(Drawable drawable, 
	gint *x, gint *y, gint *w, gint *h, gint *d);

gchar *
rfm_get_hash_key (const gchar * key, gint size);


gint
rfm_get_default_size(void);

population_t *
rfm_locate_path(view_t *view_p, const gchar *pathname);

gboolean
rfm_g_file_test(const gchar *path, GFileTest test);

gboolean
rfm_g_file_test_with_wait(const gchar *path, GFileTest test);

gchar *
rfm_get_paste_buffer (void );

void
rfm_clear_paste_buffer(void);

void
rfm_store_paste_buffer(gchar *buffer, gint len);

GtkWidget *
rfm_dialog_button (const char *icon_id, const char *text);

gboolean 
rfm_get_population_rect(view_t * view_p, const population_t * population_p, GdkRectangle *rect);

gboolean 
rfm_get_population_icon_rect(view_t * view_p, const population_t * population_p, GdkRectangle *rect);

gboolean 
rfm_get_population_label_rect(view_t * view_p, const population_t * population_p, GdkRectangle *rect);

void
rfm_thread_expose_rect (view_t *view_p, GdkRectangle * rect);

void
rfm_expose_item (view_t * view_p, const population_t * population_p);

void
rfm_expose_icon (view_t * view_p, const population_t * population_p);

void
rfm_expose_label (view_t * view_p, const population_t * population_p);

void
  smc_connect (gint argc, gchar ** argv, CARD8 style_hint);

void
rfm_layout_full_dimensions(view_t * view_p,
	const population_t * population_p,
	gint *width, gint *height);
//

gboolean
  rfm_write_ok (struct stat *st);
gboolean
  rfm_read_ok (struct stat *st);

  // deprecated:
GtkWidget *
  rfm_get_widget_by_name (GtkWidget * parent, const gchar * name);

  // deprecated:
void
  rfm_set_widget_by_name (GtkWidget * parent, const gchar * name, 
	  GtkWidget * widget);

void
rfm_unlock (void);

void
rfm_lock (void);


int
  rfm_mkdir (const gchar * dir);

void
  rfm_save_to_go_history (char *p);

void
  rfm_threadwait (void);

void
  rfm_init_env (void);

// rfm_setenv() is an internal command. If you want to set environment
// for child processes, please use ../mods/mcs_set_var:
// void *
// mcs_set_var (const gchar * setting_name, const gchar * setting_value)
void
  rfm_setenv (const char *name, char *value, gboolean verbose);

gchar *
  rfm_esc_string (const gchar * string);

const gchar *
  rfm_chop_excess (gchar * b);

gchar *
  rfm_time_to_string (time_t when);

gchar *
  rfm_mode_string (mode_t mode);

gchar *
rfm_user_string (struct stat *st);

gchar *
rfm_group_string (struct stat *st);

gchar *
rfm_date_string (time_t the_time);

gchar *
rfm_date_access_string (struct stat *st);

gchar *
rfm_date_status_string (struct stat *st);


gchar *
  rfm_utf_string (const gchar * t);

gchar *
  rfm_sizetag (off_t tama, gint count);

gchar *
  rfm_host_name (Window xid);

#ifdef HAVE_LIBPTHREAD
pthread_rwlock_t *new_rwlock(void);
#endif

gboolean 
  rfm_population_write_lock (view_t * view_p);

gboolean 
  rfm_population_try_write_lock (view_t * view_p);

void
  rfm_population_write_unlock (view_t * view_p);

gboolean 
  rfm_population_read_lock (view_t * view_p);

gboolean 
  rfm_population_try_read_lock (view_t * view_p);

void
  rfm_population_read_unlock (view_t * view_p);

int
  rfm_valid_pasteboard (view_t * view_p);

int
  rfm_in_pasteboard (view_t * view_p, record_entry_t * en);

gboolean 
  rfm_update_pasteboard (view_t * view_p);

void
  rfm_soft_reload (view_t * view_p);

    void
rfm_save_view_preferences (view_t * view_p, record_entry_t *target_en);


view_preferences_t *
rfm_get_view_preferences (gint type, record_entry_t *target_en);

void
rfm_set_view_preferences (view_t * view_p, view_preferences_t *view_preferences_p);

gboolean
rfm_write_ok_path(const gchar *path);

gboolean
rfm_read_ok_path(const gchar *target_path);

gchar *
rfm_shell(void);

gchar *
rfm_xterm_shell(void);

/// gtk+3.2 compatibility section 
// gtk_box
GtkWidget *
rfm_hbox_new(gboolean homogeneous, gint spacing);

GtkWidget *
rfm_vbox_new(gboolean homogeneous, gint spacing);
// gtk paned
GtkWidget *
rfm_vpaned_new(void);

GtkWidget *
rfm_hpaned_new(void);
GtkWidget *
rfm_vbutton_box_new(void);

GtkWidget *
rfm_hbutton_box_new(void);

GtkWidget *
rfm_hscale_new_with_range(gdouble min, gdouble max, gdouble step);
#endif
