/*
 * Copyright (C) 2002-2012 Edscott Wilson Garcia
 * EMail: edscott@xfce.org
 *
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */
static gchar *
substitute(const gchar *string, const gchar *expression, const gchar *replacement) {
   GRegex *regex = g_regex_new (expression, 0, 0, NULL);
   gchar *newstring = g_regex_replace_literal (regex,
                                   string, -1, 0,
				   replacement,
				    0 , NULL);
		g_regex_unref (regex);
    if (!newstring) newstring=g_strdup(string);
    return newstring;
}

static gchar *
compact_line(const gchar *line){
    gchar **p;
    gchar *charlist[]={">","<",  "&&", "||",  ";",NULL};
    //gchar *newline= g_strdup(line); 
    gchar *newline= substitute(line, "\\s\\s", " "); 

    for (p=charlist; p && *p; p++) {
        if (strstr(line, *p)){
	     gchar *exp=g_strdup_printf("\\s%s", *p);
	     gchar *newerline= substitute(newline, exp, *p);
	     g_free(exp);
	     g_free(newline);

	     newline=newerline;
	     exp=g_strdup_printf("%s\\s", *p);
	     newerline= substitute(newline, exp, *p);
	     g_free(exp);
	     g_free(newline);

	     newline=newerline;
	     exp=g_strdup_printf(" %s ", *p);
	     newerline= substitute(newline, *p, exp);
	     g_free(exp);
	     g_free(newline);
	     newline=newerline;

	    NOOP("%s ===>>> %s\n", line, newline);
        }
    }
    g_strstrip(newline);
    return newline;
	    
}

static GList *
find_in_history_list(GList *list, const gchar *string){
    GList *tmp=g_list_first(list);
    for (;tmp && tmp->data; tmp=tmp->next){
	if (strcmp((gchar *)tmp->data, string)==0) {
	    return tmp;
	}
    }
    return NULL;
}


