#ifndef PRIMARY_MODULES_H
# define PRIMARY_MODULES_H

# include <gtk/gtk.h>
const gchar *
rfm_get_module_popup_id(void);

void
  rfm_sanity_check (int argc, char **argv, int librfm_serial);

void *
  rfm_void (const gchar * librarydir, const gchar * module_name, 
	  const gchar * function_id);

/* integers */
void *
  rfm_natural (const gchar * librarydir, const gchar * module_name, 
	  void *p, const gchar * function_id);

/* rationals */
void *
  rfm_rational (const gchar * librarydir, const gchar * module_name, 
	  void *p, void *q, const gchar * function_id);

/* complex */
void *
  rfm_complex (const gchar * librarydir, const gchar * module_name, 
	  void *p, void *q, void *r, const gchar * function_id);

void *
rfm_vector_run(const gchar * librarydir, const gchar * module_name, 
	void *vector_size_p, const void **vector, const gchar *function_id);

GSList *
  rfm_find_plugins (void);

const gchar * 
rfm_get_plugin_label(const gchar *module_name);

const gchar * 
rfm_get_plugin_icon(const gchar *module_name);

gboolean 
rfm_is_root_plugin(const gchar *module_name);

#endif
