//
//
static void
entry_activate (GtkWidget * entry, GdkEventKey * event, gpointer data) {
    GtkWidget *dialog = g_object_get_data(G_OBJECT(entry), "dialog");
    gtk_dialog_response  (GTK_DIALOG(dialog), GTK_RESPONSE_YES);
    return;
}

static GtkWidget *
passwd_dialog (widgets_t * widgets_p, const gchar * ptext, gint option, const gchar * qtext, const gchar *default_value) {

    GtkWidget *dialog = gtk_dialog_new ();

    gtk_window_set_resizable (GTK_WINDOW (dialog), FALSE);
    gtk_container_set_border_width (GTK_CONTAINER (dialog), 5);
    gtk_window_set_modal (GTK_WINDOW (dialog), TRUE);
    gtk_window_set_title(GTK_WINDOW (dialog), _("User Input"));
    gtk_window_set_keep_above(GTK_WINDOW (dialog), TRUE);

    gtk_widget_realize (dialog);

    GtkWidget *hbox = rfm_hbox_new (FALSE, 0);
    gtk_container_set_border_width (GTK_CONTAINER (hbox), 5);
    gtk_box_pack_start (
	    GTK_BOX (gtk_dialog_get_content_area(GTK_DIALOG(dialog))),
	    hbox, TRUE, TRUE, 0);
    gtk_widget_show (hbox);

    GtkWidget *label = gtk_label_new("");
    if(ptext){
	gtk_label_set_markup  (GTK_LABEL(label), ptext);
    } else {
	const gchar *c = "WTF";
	if (option == 2) c = _("Please enter a passphrase to use.");
	else if (option == 1) c = _("Password associated to the user");
	else if (option == 0) {
	    c = _("Username for authentication");
	}
	gtk_label_set_markup  (GTK_LABEL(label), c);	    
    }

    gtk_box_pack_start (GTK_BOX (hbox), label, EXPAND, FILL, 0);
    gtk_widget_show (label);

    GtkWidget *bhbox=rfm_hbox_new (FALSE, 0);
    gtk_box_pack_start (GTK_BOX (gtk_dialog_get_content_area(GTK_DIALOG(dialog))), 
	    bhbox, TRUE, TRUE, 0);
    gtk_widget_show (bhbox);

    GtkWidget *vbox=rfm_vbox_new (FALSE, 0);
    gtk_box_pack_start (GTK_BOX (bhbox), vbox, TRUE, TRUE, 0);
    // put image here
    GdkPixbuf *pixbuf=rfm_get_pixbuf("xffm/stock_dialog-authentication",BIG_ICON_SIZE);
    GtkWidget *image=gtk_image_new_from_pixbuf(pixbuf);
    gtk_box_pack_start (GTK_BOX (vbox), image, TRUE, TRUE, 0);

    gtk_widget_show (image);
    gtk_widget_show (vbox);
    vbox=rfm_vbox_new (FALSE, 0);
    gtk_box_pack_start (GTK_BOX (bhbox), vbox, TRUE, TRUE, 0);
    gtk_widget_show (vbox);

    hbox = rfm_hbox_new (FALSE, 0);
    gtk_container_set_border_width (GTK_CONTAINER (hbox), 5);
    gtk_box_pack_start (GTK_BOX (vbox), hbox, TRUE, TRUE, 0);
    gtk_widget_show (hbox);

    if (option == 2) {
	label = gtk_label_new (_("Enter passphrase:"));
    } else if (option == 1) {
	label = gtk_label_new (_("User Password:"));
    } else if (qtext){
	label = gtk_label_new (qtext);
    } else {
	label = gtk_label_new (_("Username:"));
    }

    gtk_box_pack_start (GTK_BOX (hbox), label, NOEXPAND, NOFILL, 0);
    gtk_widget_show (label);

    GtkWidget *passwd = gtk_entry_new ();
    g_object_set_data(G_OBJECT(passwd), "dialog", dialog);
    gtk_box_pack_start (GTK_BOX (hbox), passwd, EXPAND, NOFILL, 0);
    gtk_entry_set_visibility ((GtkEntry *) passwd, (option)?FALSE:TRUE);
    g_signal_connect (G_OBJECT (passwd), "activate", G_CALLBACK (entry_activate), NULL);
    gtk_widget_show (passwd);
    g_object_set_data(G_OBJECT(dialog), "passwd", passwd);
    if (default_value) gtk_entry_set_text(GTK_ENTRY(passwd), default_value);

    GtkWidget *button = rfm_dialog_button ((widgets_p)?"xffm/stock_ok":NULL, _("Ok"));
    gtk_widget_show (button);
    gtk_dialog_add_action_widget (GTK_DIALOG (dialog), button, GTK_RESPONSE_YES);

    
    button = rfm_dialog_button ((widgets_p)?"xffm/stock_cancel":NULL, _("Cancel"));
    gtk_widget_show (button);
    gtk_dialog_add_action_widget (GTK_DIALOG (dialog), button, GTK_RESPONSE_NO);

    if(widgets_p){
	// This borks things bigtime.
        //gtk_window_set_transient_for (GTK_WINDOW (dialog), GTK_WINDOW (widgets_p->window));
    }
    gtk_widget_show (dialog);

    return dialog;
}

static
GtkWidget *
confirm_dialog (widgets_t * widgets_p, 
	gint type,
//	GtkMessageType type,
	const gchar * text, 
	const gchar * action_false,
	const gchar * action_true 
	) {
    GtkWidget *dialog;
    GtkWidget *button;
	// type: GTK_MESSAGE_INFO, GTK_MESSAGE_WARNING, GTK_MESSAGE_QUESTION, GTK_MESSAGE_ERROR

    TRACE ("DIAGNOSTICS: rfm_confirm_dialog\n");
    gchar *q = rfm_utf_string (text);
    dialog = gtk_message_dialog_new (
	    NULL, GTK_DIALOG_DESTROY_WITH_PARENT,
	    (type!=-1)?type:GTK_MESSAGE_INFO, GTK_BUTTONS_NONE, 
	    NULL);
    gtk_message_dialog_set_markup (GTK_MESSAGE_DIALOG(dialog), q);
    g_free (q);
    if (widgets_p) {
	GdkPixbuf *pixbuf=NULL;
	switch (type){
	    case GTK_MESSAGE_INFO:
		pixbuf=rfm_get_pixbuf("xffm/stock_dialog-info", 96);
		break;
	    case GTK_MESSAGE_WARNING:
		pixbuf=rfm_get_pixbuf("xffm/stock_dialog-warning", 96);
		break;
	    case GTK_MESSAGE_QUESTION:
		pixbuf=rfm_get_pixbuf("xffm/stock_dialog-question", 96);
		break;
	    case GTK_MESSAGE_ERROR:
		pixbuf=rfm_get_pixbuf("xffm/stock_dialog-error", 96);
		break;
	    case GTK_MESSAGE_OTHER:
		pixbuf=rfm_get_pixbuf("xffm/places_user-history", 96);
		break;
	    case -1:
		pixbuf = rfm_get_pixbuf("xffm/actions_folder-new", 250);
	}
	if (pixbuf) {
	    GtkWidget *image=gtk_image_new_from_pixbuf(pixbuf);
	    gtk_widget_show(image);
	    gtk_message_dialog_set_image (GTK_MESSAGE_DIALOG(dialog), image);
	}
    }
    if(widgets_p) {
	view_t *view_p=widgets_p->view_p;
        if(view_p && view_p->flags.type == DESKVIEW_TYPE) {
	    gtk_window_set_keep_above (GTK_WINDOW(dialog), TRUE);
	    gtk_window_stick (GTK_WINDOW(dialog));
	} else {   
            gtk_window_set_modal (GTK_WINDOW (dialog), TRUE);
            gtk_window_set_transient_for (GTK_WINDOW (dialog), GTK_WINDOW (widgets_p->window));
        } 
    } else {
	gtk_window_set_modal (GTK_WINDOW (dialog), TRUE);
    }

    if(action_false) {
        button = rfm_dialog_button ((widgets_p)?"xffm/stock_no":NULL, action_false);
        gtk_widget_show (button);
        gtk_dialog_add_action_widget (GTK_DIALOG (dialog), button, GTK_RESPONSE_NO);
        g_object_set_data (G_OBJECT (dialog), "action_false_button", button);
    }
    button = rfm_dialog_button ((widgets_p)?"xffm/stock_yes":NULL, (action_true) ? action_true : _("Ok"));
    gtk_widget_show (button);
    g_object_set_data (G_OBJECT (dialog), "action_true_button", button);
    gtk_dialog_add_action_widget (GTK_DIALOG (dialog), button, GTK_RESPONSE_YES);


    gtk_widget_show (dialog);
    return dialog;
}

