#ifndef PRIMARY_MISC_H
#define PRIMARY_MISC_H
#include <X11/Xlib.h>
// this split routine only allocates memory for gchar **, and populates
// it with pointers to the original locations, substituting the token
// for 0.
gchar **
rfm_split(const gchar *text, const gchar token);

void 
rfm_set_store_data_from_list(GtkListStore *list_store, GSList **list);

char *
  rfm_display_host_name (GtkWidget * widget);

GtkWidget *
  rfm_mk_little_button (const gchar * icon_id, 
	  void *callback, void *callback_data, const gchar * tooltip_text);

void
  rfm_cursor_wait (GtkWidget * w);

void
  rfm_cursor_reset (GtkWidget * w);

GtkWidget *
  rfm_create_diagnostics_window (widgets_t * widgets_p);

gboolean 
  rfm_confirm (widgets_t * widgets_p, 
	// type: GTK_MESSAGE_INFO, GTK_MESSAGE_WARNING, GTK_MESSAGE_QUESTION, GTK_MESSAGE_ERROR, GTK_MESSAGE_OTHER
	gint type,
	const gchar * text, 
        const gchar * action_false, // if NULL, button not shown
	const gchar * action_true   // if NULL, "Ok" button shown
	);
void
rfm_clear_text (widgets_t * widgets_p);

void
  rfm_clear_text_window (GtkButton * button, gpointer user_data);

void
  rfm_update_status_line (view_t * view_p);

void
  rfm_clear_sh_command_history (view_t * view_p, gboolean disk_too);

void
  rfm_show_text (widgets_t * widgets_p);

void
  rfm_hide_text (widgets_t * widgets_p);

gboolean 
rfm_diagnostics_is_visible (widgets_t * widgets_p);

void
  rfm_status (widgets_t * widgets_p, const gchar * id, ... );

void
  rfm_diagnostics (widgets_t * widgets_p, const gchar * id, ... );

void
  rfm_dump_output (void *user_data, void *stream, int childFD);

void
  rfm_operate_stdout (void *user_data, void *stream, int childFD);

void
  rfm_operate_stderr (void *user_data, void *stream, int childFD);

void
  rfm_progress_generic (widgets_t * widgets_p, int count, int total, int caso);

gchar *
  rfm_get_passphrase (widgets_t * widgets_p, const gchar * ptext);

gchar *
  rfm_get_password (widgets_t * widgets_p, const gchar * ptext);

gchar *
  rfm_get_password_with_default (widgets_t * widgets_p, const gchar * ptext, const gchar * default_value);

gchar *
rfm_get_user (widgets_t * widgets_p, const gchar * ptext);

gchar *
rfm_get_user_with_default (widgets_t * widgets_p, const gchar * ptext, const gchar * default_value);

gchar *
rfm_get_string (widgets_t * widgets_p, const gchar * ptext, const gchar * qtext);

void
rfm_set_font_family (GtkWidget * widget, const gchar *in_family);

#if 0
  deprecated
  const gchar *
  rfm_get_password (widgets_t * widgets_p, const gchar * ptext);

const gchar *
  rfm_get_smbuserpass (widgets_t * widgets_p, record_entry_t * en);
#endif

gboolean rfm_confirm_sudo(widgets_t *widgets_p,
       const gchar *tgt, 
       const gchar *failed, 
       const gchar *operation);
#endif
