//
//
#if 0
static GStaticMutex pixbuf_mutex = G_STATIC_MUTEX_INIT;
// This way we use a gdk mutex to protect. But this does not always work.
// (problem part is "get pixbuf from file ")
# define LOCK_PIXBUF_MUTEX(x)   g_static_mutex_lock(&pixbuf_mutex);LOCK_DISPLAY
# define UNLOCK_PIXBUF_MUTEX(x)  UNLOCK_DISPLAY;g_static_mutex_unlock(&pixbuf_mutex)
#else
//# define LOCK_PIXBUF_MUTEX(x)   
//# define UNLOCK_PIXBUF_MUTEX(x) 
# define LOCK_PIXBUF_MUTEX(x)   LOCK_DISPLAY
# define UNLOCK_PIXBUF_MUTEX(x) UNLOCK_DISPLAY
#endif
static GMutex *winner_mutex = NULL;
static GMutex *pixbuf_hash_mutex = NULL;

// internal hash record structure
static GHashTable *pixbuf_hash = NULL;

typedef struct pixbuf_t {
    time_t mtime; // stat mtime info for thumbnails
    gint   size;  // pixbuf icon size
    off_t  st_size; // stat st_size for thumbnails
    ino_t  st_ino; // stat st_ino for thumbnails
    GdkPixbuf *pixbuf;
    union {
        gchar *mime_id;
        gchar *path;
    };
} pixbuf_t;

static
GdkPixbuf *
get_pixbuf (const gchar * key, gint size, gboolean hash);

static 
const gchar *
resolve_folder_icon_type (gint type){
 	/*if (en->st && rfm_write_ok(en->st)) {
	    return g_strconcat (id, "/composite/emblem_write-ok", NULL);
	}*/
	const gchar *t;
        if(IS_NOACCESS_TYPE (type)) {
		t = "xffm/stock_directory/composite2/emblem_no-access";
        } else if(IS_NOWRITE_TYPE (type)) {
        // without write access: xffm/stock_directory
		t = "xffm/stock_directory";
        } else {
	// with write access: xffm/stock_directory
		t = "xffm/stock_directory/composite/emblem_write-ok";
        }
    return t;
}

/* some of the code in this function contributed by Thomas Leonard: */
static void
save_thumbnail (const gchar * thumbnail_path, 
	const gchar * original_path, 
	GdkPixbuf * tgt)
{
    if(!tgt || !GDK_IS_PIXBUF (tgt)) return;
    
    gint original_width, original_height;
    gchar *swidth, *sheight, *ssize, *smtime;
    struct stat st;
    GError *error = NULL;

    if(!thumbnail_path || !original_path)
        return;
    DBG ("creating thumbnail for %s (%s)\n", original_path, thumbnail_path);

    original_width = gdk_pixbuf_get_width (tgt);
    original_height = gdk_pixbuf_get_height (tgt);

    if(stat (original_path, &st) != 0)
        return;

    swidth = g_strdup_printf ("%d", original_width);
    sheight = g_strdup_printf ("%d", original_height);
    ssize = g_strdup_printf ("%ld", (long int)st.st_size);
    smtime = g_strdup_printf ("%ld", st.st_mtime);

    LOCK_PIXBUF_MUTEX();
    gdk_pixbuf_save (tgt, thumbnail_path, "png", &error,
                     /*"tEXt::Thumb::Image::Width", swidth,
                        "tEXt::Thumb::Image::Height", sheight,
                        "tEXt::Thumb::Size", ssize, 
                        "tEXt::Thumb::MTime", smtime, */
                     "tEXt::Software", "Rodent", NULL);
    UNLOCK_PIXBUF_MUTEX();
    if(error)
        g_error_free (error);
    g_free (swidth);
    g_free (sheight);
    g_free (ssize);
    g_free (smtime);
}

static
    void
insert_pixbuf_tag (const GdkPixbuf * tag, GdkPixbuf * composite_pixbuf, const gchar * where, double scale_factor, gint overall_alpha) {
    if (!composite_pixbuf || !GDK_IS_PIXBUF(composite_pixbuf)) return;
    int width = gdk_pixbuf_get_width (composite_pixbuf);
    int height = gdk_pixbuf_get_height (composite_pixbuf);
    // "SW"
    int dest_x = 0;
    int dest_y = 0;
    int dest_width = width;
    int dest_height = height;
    double scale_x = 1.0 / scale_factor;
    double scale_y = 1.0 / scale_factor;
    // default SW
#define WW ((double)width / scale_factor / 4)
#define HH ((double)height / scale_factor / 8)
    double offset_x = 0.0;
    double offset_y = height - ((double)height) / scale_factor;
    if(strcmp (where, "SE") == 0) {
        offset_x = width - ((double)width) / scale_factor;
    } else if(strcmp (where, "NW") == 0) {
        offset_y = 0.0;
    } else if(strcmp (where, "NE") == 0) {
        offset_x = width - ((double)width) / scale_factor;
        offset_y = 0.0;
    } else if(strcmp (where, "C") == 0) {
        offset_x = ((double)width) / 2 - ((double)width) / scale_factor / 2 - WW;
        offset_y = ((double)height) / 2 - ((double)height) / scale_factor / 2 + HH;
    } else if(strcmp (where, "SC") == 0) {
        offset_x = ((double)width) / 2 - ((double)width) / scale_factor / 2 - WW;
    } else if (strcmp (where, "NC") == 0) {
        offset_y = 0.0;
        offset_x = ((double)width) / 2 - ((double)width) / scale_factor / 2 - WW;
    }

    LOCK_PIXBUF_MUTEX();
    gdk_pixbuf_composite (tag, composite_pixbuf,
                          dest_x, dest_y,
                          dest_width, dest_height, offset_x, offset_y, scale_x, scale_y, GDK_INTERP_BILINEAR, overall_alpha);
    UNLOCK_PIXBUF_MUTEX();
    return;
}

typedef struct composite_t{
    const gchar *sub_id;
    const gchar *where;
    double scale_factor;
    gint overall_alpha;    
}composite_t;

// This routine is mainly here to cover up when the icon module
// plugin is not available or fails to load.
static GdkPixbuf *
fallback_pixbuf(const gchar * id, int size){
    GdkPixbuf *pixbuf=NULL;
    gchar *fullpath=NULL;
	gint gtksize;
        if (size >= SMALL_ICON_SIZE)
	    gtksize = GTK_ICON_SIZE_DIALOG;
	else 
	    gtksize = GTK_ICON_SIZE_LARGE_TOOLBAR;
	    //gtksize = GTK_ICON_SIZE_BUTTON;
	gchar *gtk_id=NULL;
	if (strstr(id, "xffm/stock_")){
	    gtk_id = g_strdup_printf("gtk-%s", 
		    id+strlen("xffm/stock_"));
	}
	    
	NOOP("fallback icon for id=%s at size %d\n", id, size);


	if (gtk_id){
	    // XXX: these should most probably have gdk mutex enabled...
	    //      but at this point this would block main thread...
	    //      so let's just use the pixbuf mutex...
	    LOCK_PIXBUF_MUTEX();
	    GtkWidget *image=gtk_image_new_from_file("whatever");
#ifdef USE_GTK2
	    pixbuf = 
		gtk_widget_render_icon (image, gtk_id, 
			gtksize,NULL);
#else
	    pixbuf = 
		gtk_widget_render_icon_pixbuf (image, gtk_id, 
			gtksize);
#endif
	    UNLOCK_PIXBUF_MUTEX();
	    if (pixbuf && size > SMALL_ICON_SIZE) {
		LOCK_PIXBUF_MUTEX();
		GdkPixbuf *new_pixbuf = 
		    gdk_pixbuf_scale_simple (pixbuf, 
			    size, size, GDK_INTERP_BILINEAR);
		UNLOCK_PIXBUF_MUTEX();
		g_object_unref(pixbuf);
		pixbuf=new_pixbuf;
	    }
	    
	    g_free(gtk_id);
	    if (pixbuf) return pixbuf;
	} else {
	    // These are hardcoded paths....
	    if (strcmp(id, "xffm/emblem_write-ok")==0) {
		fullpath = g_strdup_printf("%s/%s/%s", 
			PACKAGE_ICON_DIR, "emblems", "emblem-write-ok.svg");
	    }
	    else if (strcmp(id, "xffm/emblem_link")==0) {
		fullpath = g_strdup_printf("%s/%s/%s", 
			PACKAGE_ICON_DIR, "emblems", "emblem-symbolic-link.svg");
	    }
	    else if (strcmp(id, "xffm/composite2/emblem_unreadable")==0 ||
		    strcmp(id, "xffm/composite2/emblem_no-access")==0 ||
		    strcmp(id, "xffm/composite2/emblem_no-read")==0) {
		fullpath = g_strdup_printf("%s/%s/%s", 
			PACKAGE_ICON_DIR, "emblems", "emblem-unreadable.svg");
	    }
	    else if (strcmp(id, "xffm/emblem_show-hidden")==0 ) {
		fullpath = g_strdup_printf("%s/%s/%s", 
			PACKAGE_ICON_DIR, "emblems", "emblem-show-hidden.svg");
	    }
	    else if (strcmp(id, "xffm/emblem_show-previews")==0 ) {
		fullpath = g_strdup_printf("%s/%s/%s", 
			PACKAGE_ICON_DIR, "places", "folder-images.svg");
	    }
	    else if (strcmp(id, "xffm/device_computer")==0 ) {
		fullpath = g_strdup_printf("%s/%s/%s", 
			PACKAGE_ICON_DIR, "devices", "computer.svg");
	    }
	    else if (strcmp(id, "xffm/places_user-bookmarks")==0 ) {
		fullpath = g_strdup_printf("%s/%s/%s", 
			PACKAGE_ICON_DIR, "places", "user-bookmarks.svg");
	    }
	    /*if (!g_file_test(fullpath, G_FILE_TEST_EXISTS)){
		g_free(fullpath);
		return NULL;
	    }*/

	}

	if (fullpath) {
	    pixbuf = 
		get_pixbuf(fullpath, size, TRUE);
	    if (!pixbuf) {
		DBG("incorrect icon fullpath: %s", fullpath);
	    }
	    g_free(fullpath);
	}
	if (!pixbuf && !strstr(id, "xffm/")) {
	    LOCK_PIXBUF_MUTEX();
	    GtkWidget *image=gtk_image_new_from_file("whatever");
#ifdef USE_GTK2
	    pixbuf = 
		gtk_widget_render_icon (image, "gtk-file", 
			gtksize,NULL);
#else
	    pixbuf = gtk_widget_render_icon_pixbuf (image, "gtk-file", 
			gtksize);
#endif
	    // gtk-file is broken in some releases...
	    if (!pixbuf) {
#ifdef USE_GTK2
	    pixbuf = 
		gtk_widget_render_icon (image, "gtk-dnd", 
			gtksize,NULL);
#else
		pixbuf = gtk_widget_render_icon_pixbuf (image, "gtk-dnd", 
			gtksize);
#endif
	    }
	    UNLOCK_PIXBUF_MUTEX();
	    if (pixbuf && size > SMALL_ICON_SIZE) {
		LOCK_PIXBUF_MUTEX();
		GdkPixbuf *new_pixbuf = 
		    gdk_pixbuf_scale_simple (pixbuf, 
			    size, size, GDK_INTERP_BILINEAR);
		UNLOCK_PIXBUF_MUTEX();
		g_object_unref(pixbuf);
		pixbuf=new_pixbuf;
	    }
	}

	return pixbuf;
/*	pixbuf = 
		gtk_widget_render_icon_pixbuf (image, GTK_STOCK_FILE, 
			gtksize);*/
}

static GdkPixbuf *
make_pixbuf_from_id (const gchar * id, int size, gboolean hash) {
    GdkPixbuf *pixbuf=NULL;

    NOOP ("ICONx:make_pixbuf_from_id: %s\n", id);
    if(!id || !strlen (id))
        return NULL;
    const gchar *c_key="/composite";
    const gchar *cc_key="/composite/";
    const gchar *ccc_key="composite/";
	    const gchar *position="C";
	    gdouble scale_f=1.8;
	    gint overall_alpha=180;
    if (strstr(id, "/composite2/")){
	c_key="/composite2";
	cc_key="/composite2/";
	ccc_key="composite2/";
	position="C";
	scale_f=2.2;
	overall_alpha=255;
	//overall_alpha=175;
    }
    if (strstr(id, "/composite3/")){
	c_key="/composite3";
	cc_key="/composite3/";
	ccc_key="composite3/";
	position="SW";
	scale_f=2.0;
	overall_alpha=220;
    }

    if(strstr (id, c_key)) {
        gchar *basic_type = g_strdup (id);
        NOOP ("composite type = %s\n", id);

        GdkPixbuf *basic_pixbuf, *composite_pixbuf;
        *(strstr (basic_type, c_key)) = 0;

        basic_pixbuf = get_pixbuf (basic_type, size, hash);
        g_free (basic_type);
        if(GDK_IS_PIXBUF(basic_pixbuf)) {
	    LOCK_PIXBUF_MUTEX();
            composite_pixbuf = gdk_pixbuf_copy (basic_pixbuf);
	    UNLOCK_PIXBUF_MUTEX();
        } else {
            composite_pixbuf = NULL;
            NOOP ("cannot get basic pixbuf for %s", id);
            return NULL;
        }

        if(strstr (id, cc_key) == NULL) {
            // incomplete composite specification.
            return composite_pixbuf;
        }
	composite_t composite_a[]={
	    {"/places_network-server", "SE", 2.0, 220},
	    {"/stock_dialog-authentication", "NW", 2.0, 220},

	    {"/stock_dialog-error", "SE", 2.0, 180},
	//    {"/show-previews", "SW", 6.0, 180},
	    {"/book", "NE", 2.0, 220},
	    {"/places_user-bookmarks", "NE", 2.0, 220},
	//    {"/show-hidden", "NE", 3.0, 180},
	    {"/status_user-offline", "NW", 3.0, 180},
	    {"/status_user-idle", "NW", 3.0, 180},
	    {"/status_user-away", "NW", 3.0, 180},
	    {"/stock_yes", "NW", 3.0, 180},
	    {"/stock_no", "NW", 3.0, 180},
	    {"/stock_connect", "NW", 3.0, 180},
	//    {"/stock_directory", "SE", 1.7, 180},
	    {"/stock_execute", "NE", 1.7, 255},
	//    {"/emblem_no-read", "SE", 2.0, 180},
	//    {"/emblem_no-access", "NE", 2.0, 180},
	    {"/emblem_write-ok", "SE", 1.7, 180},
	    {NULL, NULL, 0.0, 180}
	};
	

        gchar *composite_id = g_strdup(strstr(id, cc_key) + strlen(cc_key));

	// split
	gint count=0;
	gchar *p;
	gchar *comp_id[10];
	p=comp_id[count]=composite_id;
	count++;
	while (strchr(p,'/')){
	    *strchr(p,'/')=0;
	    p += (strlen(p)+1);
	    if (strncmp(p,ccc_key,strlen(ccc_key)!=0)){
		NOOP(" composite type= %s\n", p);
		comp_id[count]=p;
		count++; 
	    }
	}
	gint j;
	const gchar *group="xffm";
	for (j=0; j<count; j++){
	    // Determine the group to which the icon belongs to
	    gchar *groups[]={
		"application", "audio", 
		"chemical", "image", 
		"inode", "message",
		"model", "multipart", 
		"text", "video", 
		"x-conference",	"x-content", 
		"x-epoc", "x-world",
		NULL};
	    gchar **pp=groups;
	    for(; pp && *pp; pp++){
		if (strcmp(comp_id[j],*pp)==0){
		    group=*pp;
		    continue;
		}
	    }
	    // Don't composite with group names (only with xffm group).
	    if (strcmp(group, comp_id[j])==0) continue;
	    gchar *c_id = NULL;

	    gint i;
	    // special position pixbufs (xffm group):
	    if (strstr(id, "/composite/")) for(i = 0; composite_a[i].sub_id; i++) {
		if(strstr (composite_a[i].sub_id, comp_id[j])) {
		    position=composite_a[i].where;
		    c_id = g_strdup_printf ("xffm%s", composite_a[i].sub_id);
		    scale_f=composite_a[i].scale_factor;
		    overall_alpha=composite_a[i].overall_alpha;
		    break;
		}
	    }
	    if (!c_id) {
		// no special position found
		c_id = g_strdup_printf ("%s/%s", group, comp_id[j]);
	    }
	    NOOP("composite=%s\n", c_id);
		    
	    GdkPixbuf *tag = get_pixbuf (c_id, size, hash);
	    if(!tag) {
		DBG ("cannot get pixbuf for id: %s\n", c_id);
		return composite_pixbuf;
	    }
	    insert_pixbuf_tag (tag, composite_pixbuf, position, scale_f, overall_alpha);
	    //g_object_unref(front);
	    g_free(c_id);
	}
	g_free(composite_id);
        return composite_pixbuf;
    }

    GError *error = NULL;
    gchar *file = NULL;
    if (strcmp(id, _("unknown"))==0) {
	file = ICON_get_filename_from_id ("xffm/stock_file");
    } else {
	file = ICON_get_filename_from_id (id);
    }

    if(!file) {
	// fallback for missing icons plugin or borked id...
	DBG("fallback for %s\n", id);
	pixbuf = fallback_pixbuf(id, size);	
    }
    NOOP ("ICON_get_filename_from_id(%s) ---> %s\n", id, file);
    /////////////////////////////////////////////////
    //        gdk_pixbuf_new is not thread safe and must
    //        be run with GDK mutex, but not from main thread.
    //        (how about a private mutex, just for gdkpixbuf functions)?
    //        That should work if gdkpixbuf does not overstep its
    //        own boundaries...
    // taxing and probably overkill:
    // if (file && rfm_g_file_test(file, G_FILE_TEST_EXISTS)){
    if (file){
	LOCK_PIXBUF_MUTEX();
	// We do not use gdk_pixbuf_new_from_file_at_size() because it
	// is buggy in some supported gtk+ versions (ppm files fail, plus
	// the fact that the gdk thread unsafeness always comes from this
	// function...)
	GdkPixbuf *src = gdk_pixbuf_new_from_file (file, &error);
	if (error) {
	    DBG("make_pixbuf_from_id(): Cannot create pixbuf from %s: %s", file, error->message);
	    g_error_free(error);
	} else {
	    pixbuf = gdk_pixbuf_scale_simple (src, size, size, GDK_INTERP_BILINEAR);
	    g_object_unref(src);
	}
	UNLOCK_PIXBUF_MUTEX();
    }

    if (!pixbuf) {
        DBG ("make_pixbuf_from_id(%s, %d): returns NULL!\n", id, size);
    }
    g_free(file);
    return pixbuf;
}




static gpointer
thread_preview_manager (gpointer data) {
    preview_manager_t *preview_manager_p = data;
    view_t *view_p = preview_manager_p->view_p;
    NOOP ("PREVIEWS: thread_preview_manager\n");
    // gtk icon theme barrier:
    g_static_rw_lock_reader_lock(&(rfm_global_p->icon_theme_lock));
    
    ///// READLOCK ON //////////
    if (!rfm_population_read_lock (view_p)) return NULL;
 
    increment_view_ref(view_p);

//    g_thread_yield();
  
    //
    // What elements of the population items do we really need after the
    // initial read lock?
    // For the manager:
    // 1. population_p->flags, to check if the item is already thumbnailed.
    // NO 2a. population_p->en, for rfm_is_image() test.  
    // 2b. population_p->en->path, for mimetype winner tag.  
    // 2c. population_p->en->type, for continue condition in loop
    //
    // So we can get away with a specialized structure for each population_p:
    //
    // typedef struct fireup_thread_manager_t {
    //     population_t *population_p;
    //     gint flags;
    //     record_entry_t *en;
    //     preview_manager_t preview_manager_v;
    // } fireup_thread_manager_t;
    //
    // A GSList of this stuff instead of a copy of population_pp array.
    // The thread manager requires only read access.
    //
    // How about the worker threads? These require access to:
    // 1. view_p (view may be gone before last worker completes).
    //           The check for valid view_p is done with the *widgets_p->diagnostics
    //           or  *widgets_p->diagnostics_window. This would also be needed
    //           by the manager, although the manager would never lose the
    //           race.
    // 2. population_p: requires a read lock.
    //    a) population_p->pixbuf
    //    b) population_p->pixbufW
    //    c) population_p->pixbufH
    //    d) population_p->flags
    //
    // typedef struct preview_manager_t{
    //	   view_t *view_p;
    //	   gint population_serial;
    //	   GtkWidget **diagnostics;
    //	   GtkWidget **diagnostics_window;
    //} preview_manager_t;  
    //
    // preview_manager_v instead of preview_manager_p because
    // preview_manager_p will be disposed of by the thread manager.
    //
    GSList *fireup_list=NULL;
    gint j=0;
    // create a list of items to be considered, only.
    // Not stuff for directory contents:  // __NOWRITE_TYPE
    // ((__UP_TYPE | __NOACCESS_TYPE | __SLNK |__MOUNTED_TYPE) & 0xffffffff)
    gint not_stuff=((__UP_TYPE | __NOACCESS_TYPE | __SLNK |__MOUNTED_TYPE) & 0xffffffff);
    // 
    gboolean user_requested_abort=FALSE;
    gboolean have_mime_plugin=GPOINTER_TO_INT(rfm_void(MODULE_DIR, "mime", "module_active"));
    gboolean have_icons_plugin=GPOINTER_TO_INT(rfm_void(MODULE_DIR, "icons", "module_active"));

    for (; view_p->population_pp && view_p->population_pp[j]; j++){
	record_entry_t *en=view_p->population_pp[j]->en;
	// Check for abort condition
	g_mutex_lock(view_p->mutexes.status_mutex);
	gboolean status = view_p->flags.status;
	g_mutex_unlock(view_p->mutexes.status_mutex);
	if (view_p->flags.user_wants_lock || status==STATUS_EXIT) {
	    user_requested_abort=TRUE;
	    break;
	}
	// update pixbuf with mime and mimemagic,
	// but only if this has not already been done.
	gboolean update_icon = 
	    view_p->population_pp[j]->flags & POPULATION_SHORT_ICON 
	    &&
	    !(view_p->population_pp[j]->flags & POPULATION_THUMBNAILED);


	if (update_icon){
	    GdkPixbuf *pixbuf = NULL;
	    DBG("updating icon...\n");
	    gchar *id =  rfm_get_entry_icon_id(view_p->population_pp[j]->en, TRUE);
	    pixbuf =
	       	  get_pixbuf (id, REDUCED_ICONSIZE(view_p), TRUE);
	    view_p->population_pp[j]->flags &= (POPULATION_SHORT_ICON ^ 0xffffffff);
	    g_free(view_p->population_pp[j]->icon_id);
	    view_p->population_pp[j]->icon_id = id;
	    if (GDK_IS_PIXBUF(pixbuf)) {
		view_p->population_pp[j]->pixbuf = pixbuf;
		g_free(view_p->population_pp[j]->icon_id);
		view_p->population_pp[j]->icon_id = id;
		GdkRectangle rect;
		if (rfm_get_population_icon_rect(view_p, view_p->population_pp[j], &rect)){
		    rfm_thread_expose_rect (view_p, &rect);
	    }
	    } else {
		DBG("thread_preview_manager(): cannot get pixbuf from %s\n",id);
		g_free(id);
	    }
	}


	// default is to show thumbnails.
	// (but not for nonlocal fs like obexfs)
	// XXX : this is too enredoso...
	//
	// Today I'm setting to show thumbnails if
	// preview images are also shown...
	//
	gboolean directory_condition = en &&
	    !IS_UP_TYPE(en->type) && view_p->en &&
	    have_mime_plugin && have_icons_plugin &&
	    IS_SDIR(en->type) &&
	    en->path &&
	    !FSTAB_is_in_fstab(en->path) &&
	    !IS_MOUNTED_TYPE(en->type) &&
	    !view_p->module &&
	    !(en->type & not_stuff) &&
	    strcmp(en->path, g_get_home_dir()) &&
	    strcmp(view_p->en->path, "/") &&
	    strcmp(view_p->en->path, "/usr")&&
	    strcmp(view_p->en->path, "/usr/lib")&&
	    strcmp(view_p->en->path, "/usr/local/lib")&&
	    strcmp(view_p->en->path, "/usr/local");

        //if(view_p->en && IS_LOCAL_TYPE(view_p->en->type) &&
        if(view_p->en && (view_p->flags.preferences & __SHOW_IMAGES) &&
		(directory_condition || rfm_is_image (en))) {
    	    fireup_thread_manager_t *fireup_thread_manager_p = 
		(fireup_thread_manager_t *)malloc(sizeof(fireup_thread_manager_t));
	    if (fireup_thread_manager_p==NULL) {
		g_error("cannot allocate fireup_thread_manager_p\n");
	    }
	    memset(fireup_thread_manager_p, 0, sizeof(fireup_thread_manager_t));
	    fireup_thread_manager_p->population_p = view_p->population_pp[j];
	    // FIXME: get copy of population_p?
	    fireup_thread_manager_p->flags = view_p->population_pp[j]->flags;
	    fireup_thread_manager_p->path = g_strdup(view_p->population_pp[j]->en->path);
	    fireup_thread_manager_p->type = view_p->population_pp[j]->en->type;
	    memcpy(&(fireup_thread_manager_p->preview_manager_v),
	       preview_manager_p, sizeof(preview_manager_t));
	    fireup_list = g_slist_prepend(fireup_list, fireup_thread_manager_p);
	}
    }

    view_p->flags.thumbnailer_active=TRUE;
    rfm_population_read_unlock (view_p);
    ///// READLOCK OFF //////////
    //if (view_p->icon_size < SMALL_ICON_SIZE) goto abort;
    if (user_requested_abort) goto abort;
    if (fireup_list) fireup_list = g_slist_reverse(fireup_list);

    /* schedule image previews... */
    gint active_threads = 0;
    GThread *thread_id[PREVIEW_THREAD_LIMIT];


    GSList *list = fireup_list;
    for(; list && list->data; list=list->next) {
	if (view_p->flags.user_wants_lock) {
	    NOOP("-- view_p->flags.user_wants_lock\n");
	    break;
	}
	g_mutex_lock(view_p->mutexes.status_mutex);
	gboolean status = view_p->flags.status;
	g_mutex_unlock(view_p->mutexes.status_mutex);	
	if (status == STATUS_EXIT || view_p->flags.thumbnailer_exit) break;
	fireup_thread_manager_t *fireup_thread_manager_p = list->data;
	g_mutex_lock(view_p->mutexes.population_serial);
	gint population_serial = view_p->flags.population_serial;
	g_mutex_unlock(view_p->mutexes.population_serial);
	if(population_serial   != preview_manager_p->population_serial) {
	    NOOP("-- invalid_population\n");
	    break;
	}	
	if(fireup_thread_manager_p->flags & POPULATION_THUMBNAILED) {
            NOOP ("fireup_thread_manager_p->flags & POPULATION_THUMBNAILED\n");
            continue;
        }
	GError *error=NULL;
	gint retries=1;
retry:
	
       thread_id[active_threads] = 
	    g_thread_create (rfm_preview_thread_f, 
		    (gpointer) fireup_thread_manager_p, TRUE, &error);
       NOOP("Wthread (0x%x) rfm_preview_thread_f\n", 
	       GPOINTER_TO_INT(thread_id[active_threads]));
	if (thread_id[active_threads] == NULL){
	    if (retries++ >= 3){
		g_warning("cannot create thread %d for %s: %s",
		    active_threads, fireup_thread_manager_p->population_p->en->path,
		    (error)?error->message:"shucks! no error message!");
		continue;
	    }
	    NOOP("%s: Taking a breath...\n",
		    (error)?error->message:"shucks! no error message!");
	    if (error) g_error_free(error);
	    g_thread_yield();

	    goto retry;
	}
        active_threads++;

        //every PREVIEW_THREAD_LIMIT threads, don't spawn more until joined
	if(active_threads == PREVIEW_THREAD_LIMIT) {
	    do {
		NOOP ("SEMAPHORE: thread_preview_manager: inner-join %d\n", active_threads);
		g_thread_join (thread_id[active_threads - 1]);
		NOOP("Wthread done for 0x%x\n", GPOINTER_TO_INT(thread_id[active_threads - 1]));
		
		active_threads--;
	    }
	    while(active_threads > 0);
	}
    } // en loop

    while(active_threads > 0) {
        NOOP ("SEMAPHORE: thread_preview_manager outer-join %d\n", active_threads);
        g_thread_join (thread_id[active_threads - 1]);
	NOOP("Wthread done for 0x%x\n", GPOINTER_TO_INT(thread_id[active_threads - 1]));
        active_threads--;
    }
abort:
    if (fireup_list) g_slist_free(fireup_list);
    view_p->flags.thumbnailer_active=FALSE;
    view_p->flags.thumbnailer_exit=FALSE;
    decrement_view_ref(view_p);

    g_free (preview_manager_p);

    g_static_rw_lock_reader_unlock(&(rfm_global_p->icon_theme_lock));



    return NULL;
}


static GdkPixbuf *
create_preview (const gchar * file, gint size) {
    GdkPixbuf *src=NULL;
    GError *error = NULL;
    gchar *thumbnail_path = rfm_get_thumbnail_path (file, size);
    //if(!file || g_file_test(file, G_FILE_TEST_IS_DIR)){
    if(!file){
        return NULL;
    }

    if(thumbnail_path && g_file_test (thumbnail_path, G_FILE_TEST_EXISTS)) {
        struct stat st;
        struct stat file_st;
        stat (thumbnail_path, &st);
        stat (file, &file_st);
        if(st.st_mtime > file_st.st_mtime) {
            DBG ("PREVIEW thread: retrieving thumbnail for %s (%s)\n", file, thumbnail_path);
	    if (g_file_test(thumbnail_path, G_FILE_TEST_EXISTS)){
	        LOCK_PIXBUF_MUTEX();
		src = gdk_pixbuf_new_from_file (thumbnail_path, NULL);
	        UNLOCK_PIXBUF_MUTEX();

	    }
            if(src) {
                g_free (thumbnail_path);
                return src;
            }
        }
    }
    DBG ("PREVIEW thread: no thumbnail for %s (%s)\n", file, thumbnail_path);

    if (g_file_test(file, G_FILE_TEST_EXISTS)){
		NOOP("file=%s at size %d\n", file, size);
		LOCK_PIXBUF_MUTEX();
		GdkPixbuf *in_src = gdk_pixbuf_new_from_file (file, &error);
		UNLOCK_PIXBUF_MUTEX();
		if(error) {
			DBG ("create_preview() %s:%s\n", error->message, file);
			g_error_free (error);
			error = NULL;
			g_free (thumbnail_path);
			return NULL;
		}

		gint ph = gdk_pixbuf_get_height (in_src);
		gint pw = gdk_pixbuf_get_width (in_src);

		if (ph > pw) {
			gint w = size * pw / ph;
			src = gdk_pixbuf_scale_simple (in_src, w, size, GDK_INTERP_HYPER);
		} else {
			gint h = size * ph / pw;
			src = gdk_pixbuf_scale_simple (in_src, size, h, GDK_INTERP_HYPER);
		}
		g_object_unref(G_OBJECT(in_src));
#if 0
		// this does not work for ppm files (gtk bug)
		src = gdk_pixbuf_new_from_file_at_size (file, size, -1, &error);
		gint ph = gdk_pixbuf_get_height (src);
		gint pw = gdk_pixbuf_get_width (src);
		if (ph > pw) {
			// other way around
			g_object_unref(src);
			src = gdk_pixbuf_new_from_file_at_size (file, -1, size, &error);
			ph = gdk_pixbuf_get_height (src);
			pw = gdk_pixbuf_get_width (src);
		}
#endif
    }

    if(src) {
		save_thumbnail (thumbnail_path, file, src);
		NOOP ("save_thumbnail %s\n", thumbnail_path);
    }
    g_free (thumbnail_path);
    return src;
}




static
    void
init_pixbuf_hash () {
    if(!pixbuf_hash) {
	if(!pixbuf_hash_mutex) pixbuf_hash_mutex = g_mutex_new ();
        pixbuf_hash = g_hash_table_new (g_str_hash, g_str_equal);
    }
    return;
}

static void
update_pixbuf_f (gpointer key, gpointer value, gpointer data){
    pixbuf_t *pixbuf_p = value;
    if (g_path_is_absolute(pixbuf_p->path)){
	// don't touch thumbnails.
	return;
    }
    GdkPixbuf *pixbuf=get_pixbuf(pixbuf_p->mime_id, pixbuf_p->size, FALSE);
    if (pixbuf && GDK_IS_PIXBUF(pixbuf)) {
	    NOOP("updating pixbuf: %s (%d)\n", pixbuf_p->mime_id, pixbuf_p->size);
	    gint width=gdk_pixbuf_get_width(pixbuf_p->pixbuf);
	    gint height=gdk_pixbuf_get_height(pixbuf_p->pixbuf);
	    gdk_pixbuf_scale  (pixbuf, pixbuf_p->pixbuf,
			    0, 0,
                          width, height, 
			  0, 0, 
			  1.0, 1.0, 
			  GDK_INTERP_NEAREST);
                                                          
	    g_object_unref(pixbuf);
    }
}

static
pixbuf_t *
find_in_pixbuf_hash (const gchar * key, int size) {
    if (!key) return NULL;
    if (size > MAX_PIXBUF_HASH_SIZE) return NULL;
    init_pixbuf_hash ();
    gchar *hash_key = rfm_get_hash_key (key, size);
    //NOOP("HASH: find in hash: %s --> %s\n",key, hash_key);

    g_mutex_lock (pixbuf_hash_mutex);
    pixbuf_t *pixbuf_p = (pixbuf_hash)?g_hash_table_lookup (pixbuf_hash, hash_key):NULL;
    g_mutex_unlock (pixbuf_hash_mutex);
    // mime_id or NULL return immediately:
    if(!pixbuf_p) return NULL;
    //NOOP("found  %s --> %s in hash!\n",key, hash_key);
    if(!g_path_is_absolute (key))
        return pixbuf_p;
    // check if item is out of date
    if(g_file_test (key, G_FILE_TEST_EXISTS)) {
        struct stat st;
        stat (key, &st);
        if(pixbuf_p->mtime != st.st_mtime || 
		pixbuf_p->st_size != st.st_size||
		pixbuf_p->st_ino != st.st_ino)
       	{
	    // Obsolete item must be removed from pixbuf hash
	    // and eliminated from thumnail cache.
	    //
	    //Eliminate from thumbnail cache:
	    gchar *thumbnail_path = rfm_get_thumbnail_path (key, size);
	    if (g_file_test(thumbnail_path, G_FILE_TEST_EXISTS)) {
		if (unlink(thumbnail_path) < 0) {
		    g_warning("Cannot unlink thumbnail file: %s (%s)",
			thumbnail_path, strerror(errno));
		}
	    }
	    g_free (thumbnail_path);
	    // Eliminate from pixbuf hash:
            g_mutex_lock (pixbuf_hash_mutex);
            g_hash_table_steal (pixbuf_hash, hash_key);
            g_mutex_unlock (pixbuf_hash_mutex);
            g_free (pixbuf_p->path);
            g_object_unref (pixbuf_p->pixbuf);
            g_free (pixbuf_p);
            return NULL;
        }
    }
    return pixbuf_p;
}


static
GdkPixbuf *
get_pixbuf (const gchar * key, gint size, gboolean hash) {
    NOOP ("rfm_get_pixbuf(%s, %d)\n", key, size);
    if(!key) {
        NOOP ("rfm_get_pixbuf(): key is NULL!\n");
	return NULL;
    }
    // find in pixbuf hash
    pixbuf_t *pixbuf_p = (hash)?find_in_pixbuf_hash (key, size):NULL;
    if(pixbuf_p) {
        NOOP ("HASH-primary-icons.c: %s found in pixbuf hash\n", key);
        return pixbuf_p->pixbuf;
    }
    pixbuf_p = (pixbuf_t *) malloc (sizeof (pixbuf_t));
    memset (pixbuf_p, 0, sizeof (pixbuf_t));

    gchar *fullpath=NULL;
    if(g_path_is_absolute (key)) {
	if (g_file_test (key, G_FILE_TEST_EXISTS)){
	    fullpath=g_strdup(key);
	} else { 
	    g_free (pixbuf_p);
	    NOOP ("rfm_get_pixbuf(%s): file does not exist!", key);
	    return NULL;
	}
    } 
    if(fullpath) {
	NOOP ("rfm_get_pixbuf(%s) maps to %s\n", key, fullpath);
        pixbuf_p->pixbuf = create_preview (fullpath, size);
        if(!pixbuf_p->pixbuf) {
            g_free (pixbuf_p);
            NOOP ("create_preview(%s, %d): returns NULL!\n", fullpath, size);
            return NULL;
        }
        struct stat st;
        stat (fullpath, &st);
        pixbuf_p->mtime = st.st_mtime;
        pixbuf_p->st_size = st.st_size;
        pixbuf_p->st_ino = st.st_ino;
	g_free(fullpath);
    } else {
	NOOP ("doing make_pixbuf_from_id\n");
        pixbuf_p->pixbuf = make_pixbuf_from_id (key, size, hash);
        if(!pixbuf_p->pixbuf) {
            g_free (pixbuf_p);
            NOOP ("rfm_get_pixbuf(%s, %d): returns NULL!\n", key, size);
            return NULL;
        }
    }
    pixbuf_p->path = g_strdup (key);
    pixbuf_p->size = size;
        
    //g_object_ref (pixbuf_p->pixbuf);
    //g_object_ref_sink(pixbuf_p->pixbuf);

    if(hash && pixbuf_hash && size <= MAX_PIXBUF_HASH_SIZE) {
        gchar *hash_key = rfm_get_hash_key (key, size);
	if (!G_IS_OBJECT (pixbuf_p->pixbuf)){
	    g_warning("!G_IS_OBJECT (pixbuf) at rfm_get_pixbuf()");
	}
        g_object_ref (pixbuf_p->pixbuf);
	// This will screw up popup previews, since these are added to tooltips
	//g_object_ref_sink(pixbuf_p->pixbuf);
        NOOP ("HASH: inserting into pixbuf hash: %s --> %s\n", key, hash_key);
        g_mutex_lock (pixbuf_hash_mutex);
        g_hash_table_insert (pixbuf_hash, hash_key, pixbuf_p);
        g_mutex_unlock (pixbuf_hash_mutex);
    }
    return pixbuf_p->pixbuf;
}

