//
//

#define POPUP_ID "private_ps_module_popup"


static gchar **
compact_split(gchar **split){
    gint count=0;
    while (split && split[count]) count++;
    gchar **c_split =(gchar **)malloc((count+1)*sizeof(gchar *));
    if (!c_split) g_error("malloc: %s\n", strerror(errno));

    gchar **src=split;
    gchar **tgt=c_split;
    for (;src && *src; src++){
	if (strlen(*src)){
	    *tgt=*src;
	    TRACE ("----> %s\n", *tgt);
	    tgt++;
	}
    }
    *tgt=NULL;
    return c_split;
}

static 
void
ps_nice(GtkMenuItem *m, gpointer data){
    record_entry_t *en=(record_entry_t *)data;
    //widgets_t *widgets_p=g_object_get_data(G_OBJECT(m),"widgets_p");
    //view_t *view_p=widgets_p->view_p;
    if (!en || !en->st) return;
    if (fork()){
	gchar pid[64];
	gchar ni[64];
	sprintf(pid,"%d",(int)en->st->st_uid);
	sprintf(ni,"+%d",(int)en->st->st_ctime+1);
	execlp("renice","renice",ni,"-p",pid,NULL);
	_exit(123);
    }
    //if (view_p->xfdir_p) view_p->xfdir_p->invalidate_icons=TRUE;
    return;
}

static 
void
ps_signal(GtkMenuItem *m, gpointer data){
    record_entry_t *en=(record_entry_t *)data;
    if (!m) return;
    widgets_t *widgets_p=g_object_get_data(G_OBJECT(m),"widgets_p");
    view_t *view_p=widgets_p->view_p;

    // is entry still valid?
    if (!rfm_is_valid_entry(view_p, en)){
	g_warning("ps_signal(): dropping invalid entry");
	return;
    }

    int sig=GPOINTER_TO_INT(g_object_get_data(G_OBJECT(m),"signal"));
    if (!en || !en->st || !sig) return;
    kill((pid_t)en->st->st_uid, sig);
    //if (view_p->xfdir_p) view_p->xfdir_p->invalidate_icons=TRUE;
    return;
}

static
void
dialog_pipe(gchar *ps,widgets_t *widgets_p){
    FILE *pipe;
    rfm_show_text(widgets_p);
    pipe = popen(ps, "r");
    if(pipe) {
	gchar line[256];
	memset(line,0,256);
	while (fgets(line, 255, pipe)){
	    rfm_diagnostics(widgets_p,NULL,line,NULL);
	}
	pclose(pipe);	
    } else {
	gchar *g=g_strdup_printf("%s: %s",strerror(EINVAL),ps);
	rfm_diagnostics(widgets_p,"xffm/stock_dialog-error",g,"\n",NULL);
	g_free(g);
    }	
}

static 
void
ps_info(GtkMenuItem *m, gpointer data){
    record_entry_t *en=(record_entry_t *)data;
    widgets_t *widgets_p=g_object_get_data(G_OBJECT(m),"widgets_p");
    gchar *ps;
    if (!en || !en->st) return;
#ifdef  HAVE_BSD_L
    ps=g_strdup_printf("ps lp %u",(unsigned)en->st->st_uid);
#else
#ifdef HAVE_UNIX_LY
    ps=g_strdup_printf("ps -lyp %u",(unsigned)en->st->st_uid);
#else 
    ps=g_strdup_printf("ps -lp %u",(unsigned)en->st->st_uid);
#endif
#endif
    dialog_pipe(ps,widgets_p);   
    return;
}

static 
void
ps_tree(GtkMenuItem *m, gpointer data){
    gchar *ps=NULL;
    widgets_t *widgets_p=g_object_get_data(G_OBJECT(m),"widgets_p");
    gint ps_module_flags = 
	    GPOINTER_TO_INT(g_object_get_data(
		G_OBJECT(widgets_p->paper),
		"ps_module_flags"));
#ifdef  HAVE_BSD_XF
    if (ps_module_flags & ALL_PROCS) ps=g_strdup_printf("ps axf");
    else ps=g_strdup_printf("ps xf");
#else
#ifdef HAVE_UNIX_JH
    if (ps_module_flags & ALL_PROCS) ps=g_strdup_printf("ps -jHe");
    else ps=g_strdup_printf("ps -jHU %u",getuid()); 

#endif
#endif
    if (!ps){
	g_warning("neither ps xf nor ps -jHU is available");
	return;
    }

    rfm_show_text(widgets_p);
    rfm_diagnostics(widgets_p,"xffm/stock_yes",ps,"\n",NULL);
    RFM_THREAD_RUN2ARGV (widgets_p, ps, FALSE);
    g_free(ps);
    return;
}

static 
void
ps_set(GtkMenuItem *m, gpointer data){
    widgets_t *widgets_p=g_object_get_data(G_OBJECT(m),"widgets_p");
    view_t *view_p=widgets_p->view_p;
    gint flag=GPOINTER_TO_INT(data);
    gint ps_module_flags = 
	    GPOINTER_TO_INT(g_object_get_data(G_OBJECT(widgets_p->paper),
	    "ps_module_flags"));
    ps_module_flags ^= flag;
    g_object_set_data( G_OBJECT(widgets_p->paper),
	    "ps_module_flags", GINT_TO_POINTER(ps_module_flags));
        
    // reset to module root
    //
    g_static_mutex_lock(&reload_mutex);
    g_free(view_p->en->st);
    view_p->en->st=NULL;
    //view_p->xfdir_p->invalidate_icons=TRUE;
    g_static_mutex_unlock(&reload_mutex);
    //
    // refresh (leave to monitor...)
    // 

    return;
}

static
void *
private_date_column_string(void * p){
    gchar *tag;
    record_entry_t *en=p;
    if (!en || !en->st) return ("");

    tag=g_strdup_printf("%02d:%02d:%02d",
	    (int)(en->st->st_mtime/3600),
	    (int)((en->st->st_mtime%3600)/60),
	    (int)((en->st->st_mtime%3600)%60)
	    );
    return tag;
}

static
void *
private_size_column_string(void * p){
    gchar *tag=NULL;
    record_entry_t *en=p;
    if (!en || !en->st) return ("");

    if (!p) return ("");
    tag=g_strdup_printf("%d",(int)en->st->st_size);
    return tag;
}

static void *
ps_entry_tip(void *p)
{
    gchar *tip;
    record_entry_t *en=p;
    if (!en || !en->path || !strlen(en->path) || !en->st) return NULL;

    gchar *children;
    children = g_strdup_printf("%s = %d",
		_("Children"),(gint) en->st->st_nlink);
    
    tip=g_strdup_printf("%s: %s\n\n%s\nPID = %d\nPPID = %d\n%s = %s\nCPU = %s\nNICE = %d \nCPU%% = %d%%\n\nPID = %s\nPPID = %s\n%s = %s\nCPU = %s\nNICE = %s\nCPU%% = %s\n",
        _("Command"), (strchr(en->path,':'))?strchr(en->path,':')+1:en->path,
	children,
	en->st->st_uid,
	en->st->st_gid,
#ifdef HAVE_UNIX_O_RSS
	"RSS",
#else 
	"VSZ",
#endif
	(gchar *)private_size_column_string(p), 
	(gchar *)private_date_column_string(p),
	(gint)(en->st->st_ctime),  
	en->st->st_mode,
	_("The PID of the program"),
	_("Parent ID"),
#ifdef HAVE_UNIX_O_RSS
	"RSS",
#else 
	"VSZ",
#endif
	_("Resident Memory"),
	_("CPU Time"),
	_("The nice value of a thread, -20 indicates a high priority thread and +19 a low priority one that is 'nice' to others"),
	_("CPU Usage")
	);
/*    
    tip=g_strdup_printf("%s: %s\n\n%d = PID (%s)\n\nPPID = %d (%s)\n\n%s = %s (%s)\n\nCPU = %s (%s)\n\nNICE = %d (%s)\n\nCPU%% = %d%% (%s)\n",
        _("Command"), en->path,
	en->st->st_uid,	_("The PID of the program"),
	en->st->st_gid, _("Parent ID"),
#ifdef HAVE_UNIX_O_RSS
	"RSS",
#else 
	"VSZ",
#endif
	(char *)private_size_column_string(p), _("Resident Memory"), //RSS
	(char *)private_date_column_string(p), _("The CPU time spent in the system for this thread"), //CPU
	(gint)(en->st->st_ctime), _("The nice value of a thread, -20 indicates a high priority thread and +19 a low priority one that is 'nice' to others"), 
	en->st->st_mode, _("CPU Usage")
	);*/
    g_free(children);
    return (void *)tip;
}

static void *
ps_item_icon_id (void *p) {

    int f=0;
    record_entry_t *en=(record_entry_t *)p;

    if(IS_UP_TYPE (en->type)) {
        return "xffm/stock_go-up";
    }
    static gchar *icon=NULL;
    if (en->path && strcmp(en->path,_("System Processes"))==0) {
	if (icon == NULL){
	    icon = 
		g_strdup_printf("%s/icons/Rodent/scalable/actions/system-run.svg", PACKAGE_DATA_DIR);
	}
	return icon;
//	return  "xffm/stock_execute";
//	return  "xffm/stock_directory/composite/stock_run";
    }

    if (!en->st) return "xffm/device_chardevice";

    if (en->st->st_gid ==1)f = 0x01; // PPID is init daemon. Follows no one.
    else 		   f = 0x02; // Parent is not init 
    if (en->st->st_nlink) f |= 0x04; // has followers.
    if (en->st->st_blocks) f |= 0x08; // is following.
    TRACE ("ps_item_icon_id: %s --> 0x%x\n",(en->path)? en->path:"null", f);

    switch (f) {
	case 0x09: // showing all processes, has no followers

	case 0x0a: // non-init process with only parent
	case 0x01: // init process without children
	case 0x02: // non-init process without children or known parents
	    switch (en->st->st_rdev) {
		case SLEEPING:
		    return "xffm/stock_execute/composite/status_user-idle";
		case DEEPSLEEP:
		    return "xffm/stock_execute/composite/status_user-away";
		case RUNNING:
		    return "xffm/stock_execute/composite/stock_yes";
		case STOPPED:
		    return "xffm/stock_execute/composite/stock_no";
		case ZOMBIE:
		    return "xffm/stock_execute/composite/status_user-offline/";
	    }
	    return "xffm/stock_execute";

	case 0x0d: // showing all processes, has followers

	case 0x0e: // non-init process with parent and children
	case 0x06: // non-init process with only children
	case 0x05: // init process with children    
	    switch (en->st->st_rdev) {
		case SLEEPING:
		    return "xffm/stock_execute/composite/stock_execute/status_user-idle";
		case DEEPSLEEP:
		    return "xffm/stock_execute/composite/stock_execute/status_user-away";
		case RUNNING:
		    return "xffm/stock_execute/composite/stock_execute/stock_yes";
		case STOPPED:
		    return "xffm/stock_execute/composite/stock_execute/stock_no";
		case ZOMBIE:
		    return "xffm/stock_execute/composite/stock_execute/status_user-offline";
	    }
	    return "xffm/stock_execute/composite/stock_execute";
    }

    return "xffm/device_optical";
}


static
int parse_int(gchar *string){
    gint r=atoi(string);
    return r;
}

static
long parse_long(gchar *string){
    gchar *f=string; 
    if (!f) {
        g_warning("incorrect parsing...");
	return 0;
    }
    return atol(f);
}

static gint
ps_xfdir_get (void *pp) {
    GSList *ps_list=NULL;
    xfdir_t *xfdir_p = pp;
    FILE *pipe;
    GSList *tmp;
    gint i;

    //if (xfdir_p->view_p->flags.status == STATUS_EXIT) return 0;
    
    NOOP(stderr, "module_xfdir_get\n");
    record_entry_t *en;
    if (!xfdir_p->en) {
	NOOP(stderr, "entry is null!\n");
	return 0;
    }
    
    record_entry_t *p_en=rfm_copy_entry(xfdir_p->en);
    gint parent_pid=0;
    if (p_en && p_en->st) {
	parent_pid=p_en->st->st_uid;
	// this is very important, since xfdir_p->st gets
	// put into view_p->en->st, which is used for reload
	memcpy(xfdir_p->en->st, p_en->st, sizeof(struct stat));
    }
    NOOP(stderr, "ps-module: parent is %d\n",parent_pid);

    gint ps_module_flags = 0;
    if (xfdir_p->view_p->widgets.paper) {
	ps_module_flags =     
	    GPOINTER_TO_INT(g_object_get_data(
		G_OBJECT(xfdir_p->view_p->widgets.paper),
		"ps_module_flags"));
    }



    gchar *ps=NULL;
#ifdef HAVE_UNIX_O_RSS
    const gchar *fmt="state,pid,ppid,pgid,pcpu,nice,rss,time,args";
#else 
    const gchar *fmt="state,pid,ppid,pgid,pcpu,nice,vsz,time,args";
#endif


    
#ifdef HAVE_UNIX_O
 #ifdef HAVE_UNIX_W
    if (ps_module_flags & ALL_PROCS) 
	ps=g_strdup_printf("ps -wwe -o %s",fmt);
    else
	ps=g_strdup_printf("ps -wwU %u -o %s",(unsigned)getuid(),fmt);
 #else
    if (ps_module_flags & ALL_PROCS) 
	ps=g_strdup_printf("ps -e -o %s",fmt);
    else
	ps=g_strdup_printf("ps -U %u -o %s",(unsigned)getuid(),fmt);
 #endif
#else
 #ifdef HAVE_BSD_O
  #ifdef HAVE_BSD_W
    if (ps_module_flags & ALL_PROCS) 
	ps=g_strdup_printf("ps awwo %s",fmt);
    else
	ps=g_strdup_printf("ps wwo %s",fmt);
  #else
    if (ps_module_flags & ALL_PROCS) 
        ps=g_strdup_printf("ps ao %s",fmt);
    else
        ps=g_strdup_printf("ps o %s",fmt);
  #endif
 #endif   
#endif
     
    NOOP(stderr, "ps=%s\n",ps);
    GHashTable *visible_processes=g_hash_table_new_full(g_str_hash, g_str_equal, g_free, NULL);
    GHashTable *parent_hash=g_hash_table_new_full(g_str_hash, g_str_equal, g_free, NULL);
    GHashTable *entry_hash=g_hash_table_new_full(g_str_hash, g_str_equal, g_free, NULL);

    xfdir_p->pathc=0;
    pipe = popen(ps, "r");
    g_free(ps);
    if(pipe) {
	gchar *f;
	gchar line[4096];
	memset(line,0,4096);
	while (fgets(line, 4095, pipe)){
	    if (!strchr(line,'\n')){
		g_warning("memory overrun averted (this never happens)");
		break;
	    }
	    if (!strstr(line,"PPID")) {
		en=rfm_mk_entry(0);
		en->type=0; /* remove local-type attributes */
		en->st = (struct stat *)malloc(sizeof(struct stat));
		if (!en->st) g_error("malloc: %s\n", strerror(errno));
		memset(en->st,0,sizeof(struct stat));
		TRACE("line=%s",line);
		// split
		gchar **src_split=rfm_split(line,' ');
		if (!src_split) {
		    g_warning("ps-module ps_xfdir_get(): split barfed");
		}
		gint is=0;
	    
		gchar **split=compact_split(src_split);
		/* state: */
		switch (*split[is]) {
		    case 'Z': //zombie
			en->st->st_rdev=ZOMBIE;
			break;
		    case 'T': //stopped
			en->st->st_rdev=STOPPED;
			break;
		    case 'R': //running
			en->st->st_rdev=RUNNING;
			break;
		    case 'S': //Interruptible sleep (waiting for an event to complete)
			en->st->st_rdev=SLEEPING;
			break;
		    case 'D': //Uninterruptible sleep (usually IO)
			en->st->st_rdev=DEEPSLEEP;
			break;		    
		}
		parse_int(split[is++]); //PID
		/* PID: */
		en->st->st_uid=(uid_t)parse_int(split[is++]); //PID

		/* PPID: */
		en->st->st_gid=(gid_t)parse_int(split[is++]); //PPID

		// Feed hash tables
		g_hash_table_replace(visible_processes, 
			g_strdup_printf("%d", (gint) en->st->st_uid),
			GINT_TO_POINTER(1)); 
		g_hash_table_replace(parent_hash, 
			g_strdup_printf("%d", (gint) en->st->st_gid),
			GINT_TO_POINTER(1)); 
		g_hash_table_replace(entry_hash, 
			g_strdup_printf("%d", (gint) en->st->st_uid),
			en); 



		/* PGID: */

		en->st->st_ino=(ino_t)parse_int(split[is++]); //PGID
		/* PCPU */

		en->st->st_mode=(mode_t)parse_int(split[is++]);

		/* NICE */

		en->st->st_ctime=(time_t)parse_int(split[is++]);
		TRACE("time=%d\n",(int)en->st->st_ctime);
		/* RSS/VSZ */
		
		en->st->st_size=(off_t)parse_long(split[is++]);
		/* TIME */
		{
		    gint h=0,m=0,s=0;
		    gchar *xp,*c=split[is++];
		    xp=strchr(c,':');
		    if (!xp) goto ko;
		    *xp=0;
		    h=atoi(c);
		    c=xp+1;
		    xp=strchr(c,':');
		    if (!xp) {
			m=h;
			h=0;
			s=atoi(c);
			goto ko;
		    } else {
			*xp=0;
			m=atoi(c);
			c=xp+1;
			s=atoi(c);
		    }
ko:
		    en->st->st_mtime=(time_t)(h*3600+m*60+s);
		}
		/* ARGS */
		f=g_strdup(split[is++]); 
		while (split[is]) {
		    gchar *ff=g_strconcat(f," ",split[is++],NULL);
		    g_free(f);
		    f=ff;
		}
		if (strchr(f, '\n')) *strchr(f, '\n')=0;
		//en->path=g_strdup(f);
		en->path=g_strdup_printf("%d:%s",en->st->st_uid,f);
		g_free(f);

		TRACE("path=%s\n",en->path);

		//if (strchr(f,' ')) strtok(f," ");
		en->module=MODULE_NAME;
		ps_list=g_slist_append(ps_list,en);
		g_free(split[0]);
		g_free(src_split);
		g_free(split);
		//TRACE("pid=%d ppid=%d gid=%d\n",en->st->st_uid, en->st->st_gid, (gint)en->st->st_ino);
	    }
	}		
	pclose(pipe);
    } else {
	g_warning("rodent-ps: unable to pipe");
    }
	
    /* tag parent and child processes...*/

    if (!(ps_module_flags & PROC_CHILDREN)) {
	for (tmp=ps_list; tmp; tmp=tmp->next){
	    en=(record_entry_t *)tmp->data;
	    gchar *key = g_strdup_printf("%d", en->st->st_uid);
	    // is en a parent?
	    if (g_hash_table_lookup(parent_hash, key)) {
		    SET_SDIR(en->type);
		    en->st->st_nlink++; // yes
	    }
	    // is en a child?
	    gchar *p_key = g_strdup_printf("%d", en->st->st_gid);
	    if (g_hash_table_lookup(visible_processes, p_key)) {
		en->st->st_blocks++;
	    } 
	}
    }

    // select appropriate elements
    GSList *list=NULL;
    for (tmp=ps_list; tmp; tmp=tmp->next){
	en=(record_entry_t *)tmp->data;
	if (parent_pid){
	    // Only children of parent_pid considered.
	    if (parent_pid == en->st->st_gid){
		TRACE("PS: 1.pid=%d adding %d = %s\n", parent_pid, en->st->st_uid, (const char *)en->path);
		list=g_slist_prepend(list, tmp->data);
	    }
	} else  if (en->st->st_blocks==0){
	    // Add if process if it is an orphan.
	    TRACE("PS: 2. adding %d = %s\n",en->st->st_uid, (const char *)en->path);
	    list=g_slist_prepend(list, tmp->data);
	}
    }

    xfdir_p->pathc=g_slist_length(list);	
    // up item: 
    xfdir_p->pathc++;

    xfdir_p->gl = (dir_t *)malloc(xfdir_p->pathc*sizeof(dir_t));
    if (!xfdir_p->gl) g_error("malloc: %s\n", strerror(errno));
    memset(xfdir_p->gl,0,xfdir_p->pathc*sizeof(dir_t));

    // Up icon determination.
    if (parent_pid) {
	// Parent specified on function call.
	gchar *p_key = g_strdup_printf("%d", parent_pid);
	// Is the parent mapable?
	if (g_hash_table_lookup(visible_processes, p_key)) {
	    // Get the grandparent.
	    record_entry_t *p_en = g_hash_table_lookup(entry_hash, p_key);
	    gchar *g_key = g_strdup_printf("%d", p_en->st->st_gid);
	    if (g_hash_table_lookup(visible_processes, g_key)) {
		// Up is the grandparent.
		// Parent has a parent too.
		record_entry_t *g_en = g_hash_table_lookup(entry_hash, g_key);
		xfdir_p->gl[0].en=rfm_copy_entry(g_en);
		SET_DUMMY_TYPE (xfdir_p->gl[0].en->type);
		SET_UP_TYPE(xfdir_p->gl[0].en->type);
		NOOP(stderr, "PS: up set to %d\n",xfdir_p->gl[0].en->st->st_uid);
		xfdir_p->gl[0].pathv = g_strdup (g_en->path);
	    } else {
		// No grandparent.
		// Up is the module root.
		// The parent an orphan. 
		xfdir_p->gl[0].en=rfm_mk_entry(0);
		xfdir_p->gl[0].en->st = NULL;	
		xfdir_p->gl[0].en->path=g_strdup(MODULE_LABEL);
		xfdir_p->gl[0].en->tag = g_strdup(MODULE_LABEL);
		xfdir_p->gl[0].en->module = MODULE_NAME;
		SET_DUMMY_TYPE (xfdir_p->gl[0].en->type);
		SET_UP_TYPE(xfdir_p->gl[0].en->type);
		NOOP(stderr, "PS: parent is an orphan. Up is set to module root.\n");
		xfdir_p->gl[0].pathv = g_strdup(MODULE_LABEL);	  
	    }
	    g_free(g_key);
	}
	g_free(p_key);
    } else {
	// No parent specified on function call.
	// Up is rodent root level.
	xfdir_p->gl[0].en = NULL;
	NOOP(stderr, "PS: up set to root level\n");
	xfdir_p->gl[0].pathv = g_strdup (g_get_host_name ());
    }
    
    // add the rest of the items to the xfdir structure.
    for (i=1,tmp=list; tmp && tmp->data; tmp=tmp->next,i++){
	en=(record_entry_t *)tmp->data;
	xfdir_p->gl[i].en=rfm_copy_entry(en);
	xfdir_p->gl[i].pathv = g_strdup(xfdir_p->gl[i].en->path);
        xfdir_p->gl[i].en->module = MODULE_NAME;
	TRACE("%d = %s\n",xfdir_p->gl[i].en->st->st_uid, (const char *)xfdir_p->gl[i].en->path);
	//TRACE("pid=%d ppid=%d gid=%d\n",en->st->st_uid, en->st->st_gid, (gint)en->st->st_ino);
    }

    // Cleanup

    g_hash_table_destroy(visible_processes);
    g_hash_table_destroy(parent_hash);
    g_hash_table_destroy(entry_hash);
    
   
    g_slist_free(list);

    for (tmp=ps_list; tmp; tmp=tmp->next){
	en=(record_entry_t *)tmp->data;
	rfm_destroy_entry(en);
    }
    g_slist_free(ps_list);


/*    for (i=0; i<xfdir_p->pathc; i++){
	if (xfdir_p->gl[i].en && xfdir_p->gl[i].en->st) {
	    TRACE("*0x%xd = %s\n",GPOINTER_TO_INT(xfdir_p->gl[i].en->st), (const char *)xfdir_p->gl[i].en->path);
	    TRACE("pid=%d ppid=%d gid=%d\n",xfdir_p->gl[i].en->st->st_uid, 
		    xfdir_p->gl[i].en->st->st_gid, (gint)xfdir_p->gl[i].en->st->st_ino);
		TRACE("pid=%d RSS=%d\n", 
			(gint) xfdir_p->gl[i].en->st->st_uid,
			(gint) xfdir_p->gl[i].en->st->st_size);
	}
    }*/
    rfm_destroy_entry(p_en);
    return 1;
}

static gpointer 
add_rfm_menu_items(gpointer data){
#ifdef RFM_MENU_ITEMS
    widgets_t *widgets_p=data;
    const gchar *id = POPUP_ID;
    GtkWidget *popup_widget=g_object_get_data(G_OBJECT(widgets_p->paper),id);
    if (!popup_widget) {
	g_warning("This is wrong. popup_widget should not be null");
	return NULL;
    }

    rodent_add_navigation_menu_items (widgets_p, popup_widget);
    rodent_add_exec_menu_items (widgets_p, popup_widget);
	
    rodent_add_size_menu_items (widgets_p, popup_widget);
    
    rodent_add_general_menu_items (widgets_p, popup_widget);
    // Reparent applications menu
    // This works today because only the ps-module has an alternate
    // main menu. When more than one coexist, we must use a specific
    // name for each one in rodent_popup.i:2273 in lieu of
    // "nonmain_applications_menu", or else the last created menu item will
    // be the one that owns the id  "nonmain_applications_menu".
    // XXX That's homework for Rodent-Delta.
    gboolean have_dotdesktop =
	GPOINTER_TO_INT(rfm_void(PLUGIN_DIR, "dotdesktop", "is_root_module"));
    if (have_dotdesktop) {
	GtkWidget *applications_menu=
	    g_object_get_data(G_OBJECT(widgets_p->paper), 
		    "nonmain_applications_menu");
	if (GTK_IS_WIDGET(applications_menu)) {
	    GtkWidget *popup_widget=
		rfm_rational(PLUGIN_DIR, "dotdesktop",widgets_p,
			applications_menu, 
			"dotdesktop_nondetached_menu");
	    if (popup_widget) {
		gtk_widget_show_all(applications_menu);
	    }
	}
    }
#endif

    return NULL;
}

static void *
ps_popup(void *p, void *q){
    GtkWidget *w;
    widgets_t *widgets_p=(widgets_t *)p;
    view_t *view_p = widgets_p->view_p;
    g_mutex_trylock (view_p->mutexes.monitor_loop);
    gchar *label=_("System Processes"),*altlabel=NULL;
    const gchar *id = POPUP_ID;
    record_entry_t *en=(record_entry_t *)q;
    
    
    if (!en) {
	TRACE("ps_popup en==NULL\n");
    }
    else {
	TRACE("en->st=0x%x",GPOINTER_TO_INT(en->st));
	// if (en->st==NULL){return NULL;}
    }

    GtkWidget *popup_widget=g_object_get_data(G_OBJECT(widgets_p->paper), id);
    GtkWidget *old_popup_widget=popup_widget;

    
    if (en && en->st && en->path) {
	label=en->path;
	if (strlen(label)>30) {
	    altlabel=g_strdup(en->path);
	    altlabel[30]=0;
	    label=altlabel;
	}
    }
    
    // rodent_mk_menu autoprotects with GDK mutex when called from non main thread
    popup_widget=rodent_mk_menu(
	  widgets_p,  	/* window */
	  label, 	/* label */
	  "ps_popup_menu",   	/* name */
	  NULL, 	/* parent */
	  NULL,		/* callback (or NULL)*/
	  NULL); 	/* icon id*/
    g_free(altlabel);
    g_object_set_data(G_OBJECT(widgets_p->paper), id, popup_widget);
    // register popumenu with xfdir monitor
    xfdir_register_popup(view_p, popup_widget);
	    
	    
    if (en==NULL){
	/* no population item under the pointer */
     

	w = gtk_image_menu_item_new_with_mnemonic (_("Display process tree"));
	g_object_set_data(G_OBJECT(w),"widgets_p",widgets_p);
	gtk_container_add (GTK_CONTAINER (popup_widget), w);
	g_signal_connect ((gpointer) w, "activate", G_CALLBACK (ps_tree), NULL);
#ifdef HAVE_BSD_XF
	gtk_widget_show (w);
#endif
#ifdef HAVE_UNIX_JH
	gtk_widget_show (w);
#endif
	
	{
	    gint ps_module_flags = 
		GPOINTER_TO_INT(g_object_get_data(
			    G_OBJECT(widgets_p->paper),"ps_module_flags"));


	    int flags[]={ALL_PROCS,PROC_CHILDREN};
	    char *hideS[]={N_("Show all processes"),N_("Monitor child processes"),NULL};
	    char *showS[]={N_("Show user own process"),N_("Show parent/child relationship between processes"),NULL};
	    int i;
	    for (i=0; hideS[i]; i++){
		if (ps_module_flags & flags[i]){
		    w = gtk_image_menu_item_new_with_mnemonic (_(showS[i]));
		     rodent_mk_pixmap_menu("xffm/stock_no",
			       w,MENU_PIXMAP);
		} else {
		    w = gtk_image_menu_item_new_with_mnemonic (_(hideS[i]));
		    rodent_mk_pixmap_menu("xffm/stock_yes",
			    w,MENU_PIXMAP);
		}
		g_object_set_data(G_OBJECT(w),"widgets_p",widgets_p);
		g_object_set_data(G_OBJECT(w),"flag",GINT_TO_POINTER(flags[i]));
		gtk_container_add (GTK_CONTAINER (popup_widget), w);
		g_signal_connect ((gpointer) w, "activate", 
			G_CALLBACK (ps_set), GINT_TO_POINTER(flags[i]));
		gtk_widget_show (w);
	    }
	}
	g_thread_join (g_thread_create(add_rfm_menu_items, (void *)widgets_p, TRUE, NULL));
	//g_thread_create(add_rfm_menu_items, (void *)widgets_p, FALSE, NULL);
    } else {

    /* should test for ps capabilities and go the full
     * yard with gnu ps (like find-moduel_gui.c): */
    w = gtk_image_menu_item_new_with_mnemonic (_("Process description"));
    g_object_set_data(G_OBJECT(w),"widgets_p",widgets_p);
#ifdef HAVE_BSD_L
	gtk_widget_show (w);
#endif
#ifdef HAVE_UNIX_LY
	gtk_widget_show (w);
#endif


    
    gtk_container_add (GTK_CONTAINER (popup_widget), w);
    rodent_mk_pixmap_menu("xffm/stock_dialog-question",w,MENU_PIXMAP);
    g_signal_connect ((gpointer) w, "activate", G_CALLBACK (ps_info), en);
    w = gtk_image_menu_item_new_with_mnemonic (_("Renice Process"));
    g_object_set_data(G_OBJECT(w),"widgets_p",widgets_p);
    gtk_widget_show (w);
    gtk_container_add (GTK_CONTAINER (popup_widget), w);
    rodent_mk_pixmap_menu("xffm/apps_accessibility",w,MENU_PIXMAP);
    g_signal_connect ((gpointer) w, "activate", G_CALLBACK (ps_nice), en);
    
    {
	gchar **p;
	gint *ip;
	gchar *t[]={
	    N_("Suspend (STOP)"),
	    N_("Continue (CONT)"),
	    N_("Interrupt (INT)"),
	    N_("Hangup (HUP)"),
	    N_("User 1 (USR1)"),
	    N_("User 2 (USR2)"),
	    N_("Terminate (TERM)"),
	    N_("Kill (KILL)"),
	    N_("Crash Information (backtrace)"),
	    NULL
	};
	gint sig[]={
	    SIGSTOP,
	    SIGCONT,
	    SIGINT,
	    SIGHUP,
	    SIGUSR1,
	    SIGUSR2,
	    SIGTERM,
	    SIGKILL,
	    SIGSEGV,
	    0
	};
	gchar *t_icon[]={
	    "xffm/actions_reset",
	    "xffm/actions_insert-object",
	    "xffm/stock_no",
	    "xffm/stock_no",
	    "xffm/stock_no",
	    "xffm/stock_no",
	    "xffm/stock_no",
	    "xffm/stock_no",
	    "application/x-coredump"
	};

	gchar **ti;
	for (ip=sig,p=t,ti=t_icon; *p; p++,ip++,ti++){
	    w = gtk_image_menu_item_new_with_mnemonic (_(*p));
	    g_object_set_data(G_OBJECT(w),"widgets_p",widgets_p);
	    if (*ip) 
		g_object_set_data(G_OBJECT(w),"signal",GINT_TO_POINTER(*ip));
	    gtk_widget_show (w);
	    gtk_container_add (GTK_CONTAINER (popup_widget), w);
	    rodent_mk_pixmap_menu(*ti,w,MENU_PIXMAP);
	    g_signal_connect ((gpointer) w, "activate", G_CALLBACK (ps_signal), en);

	    if (*ip==SIGSTOP || *ip==SIGCONT){
		if (*ip==SIGSTOP) {
		    if (en->st->st_rdev == STOPPED){
			// deactivate the stop item
			gtk_widget_set_sensitive(w, FALSE);
		    }
		} else { // SIGCONT
		    if (en->st->st_rdev != STOPPED){
			// deactivate the cont item
			gtk_widget_set_sensitive(w, FALSE);
		    }
		}
	    }

	}
    }}

    gtk_menu_popup(GTK_MENU(popup_widget), NULL, NULL, NULL, NULL, 3, view_p->mouse_event.eventtime);	
    if (old_popup_widget) {
	gtk_widget_destroy(old_popup_widget);
    }

    g_mutex_unlock (view_p->mutexes.monitor_loop);
    return GINT_TO_POINTER(1);
}

static
void *
ps_list_layout(void *p, void *q){
    if (p==NULL || q==NULL) return GINT_TO_POINTER(1);
    view_t * view_p=p;
    population_t *population_p=q;
    record_entry_t *en=population_p->en;
    if (!en || !en->path || !en->st){
	return NULL;
    }
    TRACE("make_list_layout2: population_p->en->st=0x%x path=%s\n",GPOINTER_TO_INT(population_p->en->st), population_p->en->path);

    //nice
    //if (en->st->st_ctime > 0) change to nice color
    gchar *tip=g_strdup_printf("PID = %d; PPID = %d; %s = %s; CPU = %s (%d%%) NICE = %d",
	en->st->st_uid, // PID
	en->st->st_gid, // PPID
#ifdef HAVE_UNIX_O_RSS
	"RSS",
#else 
	"VSZ",
#endif
	(char *)private_size_column_string(en), // RSS
	(char *)private_date_column_string(en), // CPU
	en->st->st_mode, // CPU%
	(gint)(en->st->st_ctime));  // NICE

    // Use layout2 for file details (if applicable)
    // This function is used by monitor for updates on stat changes.
    gchar *layout2_text=g_strdup_printf("   <span><i>%s</i> </span>", tip);
    g_free(tip);
    // Do you have to unref layout2 before hand?
    //     No. This function is called when you create the population
    //     item. When the population item is destroyed, the destroy
    //     function will take care of doing the respective unref.
    population_p->layout2 = 
	gtk_widget_create_pango_layout (view_p->widgets.paper, NULL);
    pango_layout_set_markup(population_p->layout2, layout2_text, -1);
    g_free(layout2_text);
    return GINT_TO_POINTER(1);
}

static void *
ps_module_argv(void *p, void *q){
    record_entry_t *en=p;
    if (!en) {
	g_warning("ps-module: en == NULL");
	return NULL;
    }
    gchar **argv=q;
    if (!argv) {
	g_warning("ps-module: argv == NULL");
	return NULL;
    }

    if (argv[1]!=NULL) {
	gint pid=atoi(argv[1]);
	if (!en->st) {
	    en->st=(struct stat *)malloc(sizeof(struct stat));
	    memset(en->st, 0, sizeof(struct stat));
	}
	en->st->st_uid=pid;
	// Set the window title
	g_free(en->path);
	en->path = g_strdup("rodent");
	// This is different from what ps reports, since ps follows symlinks:
	// en->path = g_strdup(rfm_global_p->argv[0]);
    }
    return GINT_TO_POINTER(1);
}
#if 0
// FIXME if to keep
static void *
ps_module_icon_size (void *p, void *q) {
    view_t *view_p=p;
    gint size=GPOINTER_TO_INT(q);
    gint default_size = rfm_get_default_size();
    
    if (p && q){
	g_object_set_data(G_OBJECT(view_p->widgets.paper), 
		"ps_module-iconsize", GINT_TO_POINTER(size));
	TRACE("** setting ps_module-iconsize to %d\n", size);
	return q;
    }
    if (p){
	size = GPOINTER_TO_INT(g_object_get_data(G_OBJECT(view_p->widgets.paper), 
		    "ps_module-iconsize"));
	if (size) {
	    TRACE("** got ps_module-iconsize %d\n", size);
	    return GINT_TO_POINTER(size);
	}
	TRACE("**no ps_module-iconsize has been set\n");
	g_object_set_data(G_OBJECT(view_p->widgets.paper), 
		"ps_module-iconsize", GINT_TO_POINTER(default_size));
    TRACE("** default ps_module-iconsize %d\n", -1);
    }
    return GINT_TO_POINTER (default_size);
}
#endif

static
void *
ps_double_click(void * p, void *q){
    record_entry_t *en=q;
    if (en && en->st && en->st->st_nlink == 0){
	// do not do anything with double click
	// and tell Rodent that double click is taken
	// care of so Rodent will not default the double
	// click action.
	return GINT_TO_POINTER(1);
    }
    // go for the Rodent default double click action (navigate)
    return NULL;
}

G_MODULE_EXPORT 
void *
monitor_skipwait (void *p) {
    // Skip wait only.
    return GINT_TO_POINTER(1);
}


