/*
 * Edscott Wilson Garcia Copyright 2012
 *
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */
#ifdef HAVE_CONFIG_H
# include <config.h>
#endif

#ifndef SHARES_MODULE_C
#define SHARES_MODULE_C 1
#endif

#include "rodent_libs.h"
/* this should be first 2 lines after headers: */
G_MODULE_EXPORT LIBRFM_MODULE

#define MODULE_NAME "shares"
#define SUBMODULE_NAME "shares" 
#define MODULE_LABEL _("Microsoft Network Protocol")
#define MODULE_ICON_ID "xffm/device_display"

#define MODULE_ENTRY_TIP _("SMB Device")
#define PARENT_MODULE_NAME "workgroup"
#define MODULE_DATA_ID "smb_shares_data_p"

#include "module-skeleton.h"
// Skeleton definitions

G_MODULE_EXPORT RFM_MODULE_NAME
G_MODULE_EXPORT RFM_SUBMODULE_NAME
G_MODULE_EXPORT RFM_MODULE_LABEL
G_MODULE_EXPORT RFM_MODULE_ICON_ID
G_MODULE_EXPORT RFM_MODULE_ENTRY_TIP

G_MODULE_EXPORT RFM_MODULE_PREFERENCES_KEY("RODENT-SHARES")
G_MODULE_EXPORT RFM_IS_ROOT_MODULE(FALSE)
G_MODULE_EXPORT RFM_PLUGIN_INFO(_("Shares folders over your network"))
G_MODULE_EXPORT RFM_MODULE_ACTIVE(TRUE)
G_MODULE_EXPORT RFM_MODULE_MONITOR(TRUE)
G_MODULE_EXPORT RFM_IS_SELECTABLE(FALSE)

#include "passfile.i"
#include "samba-common.i"



static GStaticMutex list_mutex = G_STATIC_MUTEX_INIT;



void *    
g_module_check_init (GModule * module) {
    BIND_TEXT_DOMAIN;
    return NULL;
}

// This is a thread function, must have GDK mutex set for gtk commands...
static void 
stdout_smb_shares (void *user_data, void *stream, int childFD){
// thread function
    widgets_t *widgets_p = user_data;
    view_t *view_p = widgets_p->view_p;
    smb_data_t *smb_data_p = 
	g_object_get_data(G_OBJECT(view_p->widgets.paper), MODULE_DATA_ID);
    if (!smb_data_p) g_error("!smb_data_p\n");
    char *line;
    line = (char *)stream;
    NOOP ("FORK stdout: %s\n", line);

    if(line[0] == '\n')
        return;
    gchar *smb_server = g_object_get_data(G_OBJECT(view_p->widgets.paper), "smb_server");
    if (!smb_server) smb_server = g_object_get_data(G_OBJECT(view_p->widgets.window), "smb_server");
    if (!smb_server) {
	g_warning("Confound! Cannot determine what smb_server to query!\n");
	return;
    }
    gchar *server_shares = g_strconcat(smb_server, "Shares", NULL);
    GSList **list_p = g_object_get_data(G_OBJECT(view_p->widgets.window), server_shares );
    g_free(server_shares);
    if(strncmp (line, "Tubo-id exit:", strlen ("Tubo-id exit:")) == 0) {
            if(strchr (line, '\n')) *strchr (line, '\n') = 0;
// debug:
	// get list

      GSList *list = (list_p)? *list_p : NULL;
GDK_THREADS_ENTER ();
      //rfm_diagnostics (widgets_p, "xffm_tag/command_id", "stdout_smb_shares DONE\n",NULL); 
      NOOP(stderr, "examining list at 0x%x\n", GPOINTER_TO_INT(list_p));

      for (;list && list->data; list = list->next){
            rfm_diagnostics (widgets_p, "xffm_tag/command_id", "share: ", 
		    (gchar *)list->data, "\n", NULL);
      }
GDK_THREADS_LEAVE ();


GDK_THREADS_ENTER ();
            rfm_diagnostics (widgets_p, "xffm/stock_stop", NULL);
            rfm_diagnostics (widgets_p, "xffm_tag/command_id", strchr (line, ':') + 1, ".", NULL);
            rfm_diagnostics (widgets_p, NULL, "\n", NULL);
GDK_THREADS_LEAVE ();
	g_mutex_lock(smb_data_p->mutex);
	smb_data_p->condition |= QUERY_DONE; 
	smb_data_p->condition |= RELOAD; 
	DBG( "stdout_smb_shares(): Now condition is set to 0x%x\n",
		smb_data_p->condition);
	g_cond_signal(smb_data_p->signal);
	g_mutex_unlock(smb_data_p->mutex);
    
    } else {
//#ifdef DEBUG
GDK_THREADS_ENTER ();
          rfm_diagnostics (widgets_p, NULL, line, NULL);
GDK_THREADS_LEAVE ();
//#endif
  if ( (strstr (line, "Workgroup") && strstr (line, "Master")) ||
       (strstr (line, "Server") && strstr (line, "Comment")) ) {
	g_mutex_lock(smb_data_p->mutex);
    smb_data_p->condition &= (PARSE^0xffffffff);
	g_mutex_unlock(smb_data_p->mutex);
    return;
  }
  if (strstr (line, "Sharename") && strstr (line, "Comment"))  {
	g_mutex_lock(smb_data_p->mutex);
    smb_data_p->condition |= PARSE;
	g_mutex_unlock(smb_data_p->mutex);
    return ;
  }
  if (strstr (line, "--------")) {
      return;
  }
  if (strstr (line, "Anonymous login successful"))  {
  	  return ;
  } 
  if (strstr (line, "NT_STATUS_LOGON_FAILURE"))  {
      //  clear smb-user here.
	gchar *user = g_object_get_data(G_OBJECT(widgets_p->paper), 
	    "smb-user");  
	g_free(user);
	g_object_set_data(G_OBJECT(widgets_p->paper), 
		"smb-user", NULL);
GDK_THREADS_ENTER ();
      rfm_diagnostics (widgets_p, "xffm/stock_dialog-error", NULL); 
      rfm_diagnostics (widgets_p, "xffm_tag/stderr", 
	      "Temporary authentication failure", "\n",NULL);
      rfm_diagnostics (widgets_p, NULL, 
	      "This probably means that your server requires you to specify the Windows domain name \nas part of your username (eg, quot;DOMAIN\\userquot;).\n\nOr you might have just typed your password wrong.",
	      "\n",NULL); 
GDK_THREADS_LEAVE ();

  	  return ;
  } 
  if (smb_data_p->condition & PARSE){
      if (!strstr(line, "Disk")) return;
      g_strstrip(line);
      if (strchr(line, ' ')) *strchr(line, ' ') = 0;
      if (strchr(line, '\n')) *strchr(line, '\n') = 0;
      if (strchr(line, '\t')) *strchr(line, '\t') = 0;
      

      GSList *list = (list_p)? *list_p : NULL;
      gboolean found = FALSE;
      for (; list && list->data; list=list->next){
	  if (strcmp((gchar *)list->data, line)==0){
	      found = TRUE;
	      break;
	  }
      }
      if (!found) {
	NOOP(stderr, "adding %s to list 0x%x\n", line, GPOINTER_TO_INT(list_p));
	*list_p = g_slist_prepend(*list_p, g_strdup(line));
      }
 

GDK_THREADS_ENTER ();
      rfm_diagnostics(widgets_p, "xffm_tag/red", _("Share:"), " ", NULL);
      rfm_diagnostics(widgets_p, "xffm_tag/green", line, "\n", NULL);
GDK_THREADS_LEAVE ();

  }


    }
    return;
}

// This is a thread function, must have GDK mutex set for gtk commands...
static
void
fork_finished_function (void *user_data) {
    widgets_t *safe_widgets_p = user_data;

    gchar *passfile = g_object_get_data(G_OBJECT(safe_widgets_p->paper), "passfile");
    g_object_set_data(G_OBJECT(safe_widgets_p->paper), "passfile", NULL);
    g_free(passfile);

    gchar *g = g_strdup_printf ("%d> (%d)", Tubo_id () - 1, getpid());
GDK_THREADS_ENTER ();
    if(rfm_diagnostics_is_visible (safe_widgets_p)) {
        rfm_diagnostics (safe_widgets_p, "xffm_tag/command_id", g, NULL);
        rfm_diagnostics (safe_widgets_p, "xffm/stock_no", "\n", NULL);
        GDK_THREADS_LEAVE ();
    }
GDK_THREADS_LEAVE ();
    g_free (g);
    g_free (safe_widgets_p);

}



static void *
query_shares(void *data){
  void **p=data;
  widgets_t *widgets_p = p[0];
  gchar *server = p[1];
  gchar *passfile = p[2];
  gchar *argument[20];

  gint i=0;
  argument[i++]=  "smbclient";
  argument[i++]=  "-N";
  if (passfile) {
    argument[i++]=  "-A";
    argument[i++]=  passfile;
  } else {
      NOOP(stderr, "XXXX p_data_p->authentication_file==NULL\n");
  }
  argument[i++]=  "-L";
  argument[i++]=  server;
  argument[i++]=  0;

GDK_THREADS_ENTER ();
  rfm_show_text(widgets_p);
  rfm_diagnostics (widgets_p, "xffm/status_network-transmit", NULL);
  for (i=0; argument[i]; i++) {
      rfm_diagnostics (widgets_p, "xffm_tag/command", " ", argument[i], NULL);
  }
  rfm_diagnostics (widgets_p, "xffm_tag/command","\n", NULL);
GDK_THREADS_LEAVE ();
  rfm_thread_run_argv_full (widgets_p, argument, FALSE, NULL, stdout_smb_shares, NULL, fork_finished_function);
  if (passfile) {
    THREAD_CREATE(zap_passfile, g_strdup(passfile), "zap_passfile");
  }
  g_free(p);
  
  return NULL;

}


// FIXME: this is cutpaste from fuse-common.c
// Create a function in fuse to use instead. This function should get the value set
// in the keyfile, if any, or else return the default value below.
// Then check how the thing works if fuse module is not present.
static
gchar *
get_default_mnt_point(const gchar *url){
    gchar *computer=NULL;
    gchar *remote_path=NULL;
    gchar *u = NULL;
    if (url){
	u = g_strdup(url);
	gchar *p = strstr(u, "://");
	if (p) {
	    p = p+strlen("://");
	    if (strchr(p,'/')){
		*strchr(p,'/') = 0;
		computer = g_strdup(p);
		remote_path = g_strdup_printf("/%s",p + strlen(p) + 1);
	    }
	}
	g_free(u);
    }

    	gchar *user = g_path_get_basename(g_get_home_dir ());
	gchar *dir;
	gchar *device = NULL;
	if (remote_path) {
	    device = g_path_is_absolute(remote_path)? remote_path+1: remote_path;
	}
	if (computer && remote_path) {
	    dir = g_strdup_printf("%s\\%s", computer, device);
	} else {
	    dir = g_strdup((computer)? computer : device);
	}
	gchar *default_value = 
	    g_build_filename (g_get_tmp_dir (), user, "mnt", dir, NULL);
	g_free(user);
	g_free(dir);
	g_free(computer);
	g_free(remote_path);
	return default_value;
}

static gchar *
get_url(widgets_t *widgets_p, const gchar *share){
    const gchar *smb_server = g_object_get_data(G_OBJECT(widgets_p->paper), 
	"smb_server");   
    if (!smb_server) {
	smb_server = g_object_get_data(G_OBJECT(widgets_p->window), 
	"smb_server");
	if (smb_server) g_object_set_data(G_OBJECT(widgets_p->paper), "smb_server",
		g_strdup(smb_server));
    }
    if (!smb_server) smb_server = "FIXME";
    const gchar *user = g_object_get_data(G_OBJECT(widgets_p->paper), 
	"smb-user");
    if (!user) user = g_object_get_data(G_OBJECT(widgets_p->window), 
	"smb-user");
    if (!user) user = "GUEST";

    gchar *url = g_strdup_printf("cifs://%s@%s/%s", user, smb_server, share);
    return url;
}


static 
void cache_xfdir_setup(xfdir_t *xfdir_p, smb_data_t *smb_data_p) {


    if (!smb_data_p){
	g_error("this is broken: smb_data_p==NULL\n");
    }
    view_t *view_p = smb_data_p->view_p;
	
    gchar *smb_server = g_object_get_data(G_OBJECT(view_p->widgets.paper), 
	    "smb_server");
    if (!smb_server) {
	smb_server = g_object_get_data(G_OBJECT(view_p->widgets.window), 
	"smb_server");
	if (smb_server) g_object_set_data(G_OBJECT(view_p->widgets.paper), "smb_server",
		g_strdup(smb_server));
    }
    // Server list shared across views.
    gchar *server_shares= g_strconcat(smb_server, "Shares", NULL);
    GSList **list_p = g_object_get_data(G_OBJECT(view_p->widgets.window), server_shares );
    if (list_p == NULL){
	list_p = (GSList **)malloc(sizeof(GSList *));
	if (!list_p) g_error("malloc: %s", strerror(errno));
	*list_p = NULL;
	NOOP(stderr, "New list for %s --> 0x%x\n",
		  smb_server, GPOINTER_TO_INT(list_p));
	g_object_set_data(G_OBJECT(view_p->widgets.window), server_shares, list_p);
    } 
    g_free(server_shares);

    g_static_mutex_lock(&list_mutex);
    gint load_count = (*list_p)?g_slist_length(*list_p):0;
    DBG("mastersip list length count load = %d\n", load_count);

    xfdir_p->pathc = load_count + 1;	
    xfdir_p->gl = (dir_t *)malloc(xfdir_p->pathc*sizeof(dir_t));
    if (!xfdir_p->gl) g_error("malloc: %s", strerror(errno));
    memset(xfdir_p->gl,0,xfdir_p->pathc*sizeof(dir_t));
    set_up_item(xfdir_p);
    if (load_count==0) {
	g_static_mutex_unlock(&list_mutex);
	return;
    }

    GSList *tmp = *list_p;
    gint i = 1;
    gchar *user = g_object_get_data(G_OBJECT(xfdir_p->view_p->widgets.paper), 
    "smb-user");
    if (!user) g_object_get_data(G_OBJECT(xfdir_p->view_p->widgets.window), 
    "smb-user");
    if (!user) user = "GUEST";
    widgets_t *widgets_p = &(xfdir_p->view_p->widgets);
    for (; tmp && tmp->data; tmp=tmp->next, i++){
	xfdir_p->gl[i].en=rfm_mk_entry(0);
	xfdir_p->gl[i].en->st = NULL;
	xfdir_p->gl[i].en->parent_module = MODULE_NAME;
	 xfdir_p->gl[i].en->module = "shares"; 
	
	// get share info from list data

	 
	xfdir_p->gl[i].en->pseudo_path = get_url(widgets_p, (gchar *)tmp->data);
	xfdir_p->gl[i].en->path =
	    get_default_mnt_point(xfdir_p->gl[i].en->pseudo_path);
	if (!xfdir_p->gl[i].en->path)
	    xfdir_p->gl[i].en->path=g_strdup("FIXME...");
	xfdir_p->gl[i].en->tag =  
	    g_strdup_printf("%s //%s/%s", _("Share:"),
		    smb_server, (gchar *)tmp->data);
	xfdir_p->gl[i].pathv = g_strdup((gchar *)tmp->data);
	NOOP(stderr, "count adding %s\n", xfdir_p->gl[i].en->tag);
    }
    g_static_mutex_unlock(&list_mutex);
    return;
}

// gboolean
// This function fills in previously allocated xfdir_p
// with glob records and entries of the module population.
// Records which are filled in are:
// xfdir_p->pathc: Number of icons for Rodent to display
// xfdir_p->gl[0 ... pathc-1].pathv: Labels to display with each icon
// xfdir_p->gl[0 ... pathc-1].en: Record_entry_t of each icon 
// 				  (NULL entries will point to Rodent root) 
G_MODULE_EXPORT
void *
module_xfdir_get (void *p) {
    DBG("module_xfdir_get\n");
    view_t *view_p = ((xfdir_t *)p)->view_p;
    // Check whether necessary program is installed or not.
    if (!smb_check_program(&(view_p->widgets), "smbclient")) {
	return NULL;
    }

    smb_data_t *smb_data_p = 
	g_object_get_data(G_OBJECT(view_p->widgets.paper), MODULE_DATA_ID);

    if (!smb_data_p) {
	smb_data_p = (smb_data_t *)malloc(sizeof(smb_data_t));
	if (!smb_data_p) g_error("malloc: %s", strerror(errno));
        memset(smb_data_p, 0, sizeof(smb_data_t));	
	smb_data_p->mutex = g_mutex_new();
	smb_data_p->signal = g_cond_new();
    } 
    smb_data_p->xfdir_p = p;
    smb_data_p->view_p = smb_data_p->xfdir_p->view_p;
    g_object_set_data(G_OBJECT(view_p->widgets.paper), MODULE_DATA_ID, smb_data_p);
    
    DBG( "module_xfdir_get(): THREAD 0x%x condition=0x%x\n",
		GPOINTER_TO_INT(g_thread_self()),
		smb_data_p->condition);
#if 0
    // check for list...
    const gchar *smb_server = g_object_get_data(G_OBJECT(view_p->widgets.paper), 
	    "smb_server");
    if (smb_server) {
	gchar *server_list = g_strconcat(smb_server, "Shares", NULL);
	GSList **list_p = g_object_get_data(G_OBJECT(view_p->widgets.window), server_list );
	g_free(server_list);
	    g_mutex_lock(smb_data_p->mutex);
	if (list_p == NULL || *list_p == NULL) {
	    // No cache list.
	    smb_data_p->condition = 0;
	} else {
	    smb_data_p->condition = QUERY_DONE|QUERY_LOADED;
	}
	    g_mutex_unlock(smb_data_p->mutex);
    }
#endif

    gboolean cache_load = TRUE;

    
    if (!(smb_data_p->condition & QUERY_DONE)) {
	// rodent reload thread enters here.
	// Set initial load items:
	xfdir_t *xfdir_p = smb_data_p->xfdir_p;

	cache_xfdir_setup(xfdir_p, smb_data_p);
	// Create passfile, either from memory data or dialogs
	passfile_double_click(&(view_p->widgets), view_p->en);
	gchar *passfile = g_object_get_data(G_OBJECT(view_p->widgets.paper),
		"passfile");

	NOOP( "THREAD 0x%x creating query_workgroup thread\n",
		GPOINTER_TO_INT(g_thread_self()));
	void **q=(void *)malloc(3*sizeof(void *));
	if (!q) g_error("malloc: %s", strerror(errno));
	q[0] = &(view_p->widgets);
	q[1] = xfdir_p->en->path;
	q[2] = passfile;
	g_thread_create(query_shares, q, FALSE, NULL);
	NOOP( "THREAD 0x%x return on !QUERY_DONE: QUERY_DONE=%d\n",
		GPOINTER_TO_INT(g_thread_self()),
		smb_data_p->condition);

	cache_load = FALSE;
	return xfdir_p;
    }
    // From here on down, the monitor thread is at work.
    // QUERY is DONE. Reload IPs.
    //
    if (smb_data_p->condition & RELOAD && 
	    !(smb_data_p->condition & QUERY_LOADED)) {
	NOOP( "1a. THREAD 0x%x will RELOAD, condition 0x%x \n",
		GPOINTER_TO_INT(g_thread_self()),
		smb_data_p->condition);
	xfdir_t *xfdir_p = smb_data_p->xfdir_p;
	cache_xfdir_setup(xfdir_p, smb_data_p);
	g_mutex_lock(smb_data_p->mutex);
	smb_data_p->condition |= QUERY_LOADED;
	g_mutex_unlock(smb_data_p->mutex);
	NOOP( "1b. THREAD 0x%x, RELOADED. condition set to 0x%x \n",
		GPOINTER_TO_INT(g_thread_self()),
		smb_data_p->condition);

	cache_load = FALSE;
	return xfdir_p;
    }
    NOOP( "2. THREAD 0x%x  condition 0x%x \n",
		GPOINTER_TO_INT(g_thread_self()),
		smb_data_p->condition);
    // QUERY is COMPLETE, RELOAD is still active for monitor thread.
    // 
    if (cache_load && (smb_data_p->condition & QUERY_LOADED) ) {
	NOOP( "THREAD 0x%x cache load\n",
		GPOINTER_TO_INT(g_thread_self()));
	xfdir_t *xfdir_p = smb_data_p->xfdir_p;
	cache_xfdir_setup(xfdir_p, smb_data_p);
    }
    // Monitor thread is of no more use.
    NOOP( "5. THREAD 0x%x  condition 0x%x \n",
		GPOINTER_TO_INT(g_thread_self()),
		smb_data_p->condition);
    g_mutex_lock(smb_data_p->mutex);
    smb_data_p->condition |= DELAY_MONITOR;
    smb_data_p->condition &= (RELOAD ^ 0xffffffff);
    g_mutex_unlock(smb_data_p->mutex);
    // not really: rfm_increment_monitor((xfdir_t *)p);
	NOOP( "return on RESOLVE_COMPLETE (2)\n");
    return p;
}


// const gchar * 
// This function returns a const pointer to the entry's icon
// identifier. 
// Parameter p is the item's entry pointer. 
// Identifier may be returned as a mimetype or an absolute path.
G_MODULE_EXPORT
void *
item_icon_id (void *p) {
    record_entry_t *en = p;
    if (!en) return "xffm/actions_log-out"; //error
    if (en->pseudo_path && strncmp(en->pseudo_path, "cifs://", strlen("cifs://"))==0) {
	return "xffm/places_network-server/composite3/places_folder-remote-smb";
    }
    return "xffm/places_network-server";

}

/*
static 
gboolean
mount_test(widgets_t *widgets_p, record_entry_t *en) {
    gboolean mounted = FSTAB_entry_is_mounted (en);
    if (!mounted) {
	gchar *text = g_strdup_printf("%s\n%s\n\n%s\n%s\n\n%s",
		_("Path:"), en->pseudo_path,
		_("Mount Point:"), en->path, 
		_("The volume is not mounted."));
	rfm_confirm(widgets_p, GTK_MESSAGE_ERROR, text, NULL, NULL);
	g_free(text);
    }
    return mounted;
}
*/
// gboolean
// This function informs Rodent by returning TRUE that the double click
// action will be processed by the module. If function returns FALSE
// (or is not defined in the module) then Rodent will attempt the default
// double click action.
// Parameter p is the view's widgets_p pointer.
// Parameter q is the icon's record entry.
G_MODULE_EXPORT
void *
double_click(void * p, void *q){
    widgets_t *widgets_p = p;
    record_entry_t *en = q;
    NOOP(stderr, ">>>>>>> shares double click\n");
    if (strcmp(en->parent_module, MODULE_NAME)) {
	passfile_double_click(p, q);	
	return NULL;
    }
    //if (!mount_test(widgets_p, en)) 
    {
	// run dialog.
	void *retval =
	    rfm_rational(PLUGIN_DIR, "cifs", p, q, "double_click");
	return retval;
    }
    // goto mount point.
    record_entry_t *t_en = rfm_copy_entry(en);
    t_en->module=NULL;
    // if cannot stat, rfm_confirm (cannot load)
    stat(t_en->path, t_en->st);
    // This is for the navigation history
    view_t *view_p = widgets_p->view_p;
    rodent_push_view_go_history (view_p);
    if(!rodent_refresh (widgets_p, t_en)) {
	// cannot load
	// rfm_confirm();
	rfm_destroy_entry(t_en);

    }
    return  GINT_TO_POINTER(1);
}

G_MODULE_EXPORT 
void *
reload (void *p) {
    view_t *view_p = p;
    smb_data_t *smb_data_p = 
	g_object_get_data(G_OBJECT(view_p->widgets.paper), MODULE_DATA_ID);

    const gchar *smb_server = g_object_get_data(G_OBJECT(view_p->widgets.paper), 
	    "smb_server");
    if (!smb_server) return NULL;
   
    g_mutex_lock(smb_data_p->mutex);
    if (smb_data_p) smb_data_p->condition = 0;
    g_mutex_unlock(smb_data_p->mutex);
    
    gchar *server_list = g_strconcat(smb_server, "Shares", NULL);
      g_static_mutex_lock(&list_mutex);
    GSList **list_p = g_object_get_data(G_OBJECT(view_p->widgets.window), server_list );
    GSList *list= *list_p;
    for (; list && list->data; list=list->next){
	g_free(list->data);
    }
    g_slist_free(*list_p);
    g_object_set_data(G_OBJECT(view_p->widgets.window), server_list, NULL);
    g_free(server_list);
      g_static_mutex_unlock(&list_mutex);
    return NULL; 
}

