
static void *
zap_passfile(void *data){
    if (!data) return NULL;
    sleep(3);
    unlink((gchar *)data);
    g_free(data);
    return NULL;
}

// clear smb-user to requery
//
static gchar *
get_passfile(widgets_t *widgets_p, const gchar *user, 
	const gchar *password, const gchar *domain){
    if (!password ||strlen(password)==0) return NULL;
    gint fd = -1;
    gchar *passfile = NULL;
    time_t seconds;
    time (&seconds);
    gint try=0;
retry:
    srand ((unsigned)seconds);
    gint divide = RAND_MAX / 10000;
    if (divide == 0) divide++;
    if((seconds = rand () / divide) > 100000L){
	seconds = 50001;
    }
    passfile = g_strdup_printf("%s/.smb-%ld", 
	    g_get_home_dir(), (long)seconds);
    // if the file exists, retry with a different seudo-random number...
    if (rfm_g_file_test(passfile, G_FILE_TEST_EXISTS)){
	if (seconds > 0) seconds--;
	else seconds++;
	if (try++ < 300) {
	    g_free(passfile);
	    goto retry;
	} else {
	    g_error("This is a what some people call \"a bean that weighs a pound\"\n");
	}
    }
    NOOP(stderr, "passfile=%s on try %d\n", passfile, try);

    fd = open (passfile, O_CREAT|O_TRUNC|O_RDWR, 0600);
    if (fd > 0) {
	if (write(fd, (void *)"username = ", strlen("username = ")) < 0){
	    g_warning("write %s: %s", passfile, strerror(errno));
	}
	if (write(fd, (void *)user, strlen(user)) < 0){
	    g_warning("write %s: %s", passfile, strerror(errno));
	}
	
	if (write(fd, (void *)"\npassword = ", strlen("\npassword = ")) < 0)
	{
	    g_warning("write %s: %s", passfile, strerror(errno));
	}
	if (write(fd, (void *)password, strlen(password)) < 0){
	    g_warning("write %s: %s", passfile, strerror(errno));
	}

	if (domain && strlen(domain)){
	  if (write(fd, (void *)"\ndomain   = ", strlen("\ndomain   = ")) < 0)
	  {
	    g_warning("write %s: %s", passfile, strerror(errno));
	  }
	  if (write(fd, (void *)domain, strlen(domain)) < 0){
	    g_warning("write %s: %s", passfile, strerror(errno));
	  }
	}
	if (write(fd, (void *)"\n", strlen("\n")) < 0){
	    g_warning("write %s: %s", passfile, strerror(errno));
	}
	close(fd);
    } else {
	g_warning("cannot open %s: %s", passfile, strerror(errno));
    }
    return passfile;
}

static
void *
passfile_double_click(void * p, void *q){
    if (p == NULL){
	g_warning("passfile_double_click: widgets_p cannot be null\n");
	return NULL;
    }
    widgets_t *widgets_p = p;
    record_entry_t *en = q;
    if (en && strcmp(en->module, "workgroup") && strcmp(en->module, "shares")){
	//return NULL;
    }
    if (en && IS_UP_TYPE(en->type)) return NULL;
    gchar *user = g_object_get_data(G_OBJECT(widgets_p->paper), 
	    "smb-user");
    gchar *password = g_object_get_data(G_OBJECT(widgets_p->paper), 
	    "smb-password");
    gchar *domain = g_object_get_data(G_OBJECT(widgets_p->paper), 
	    "smb-domain");

    if (!user) {
	user = g_object_get_data(G_OBJECT(widgets_p->window), 
	    "smb-user");
	if (user) g_object_set_data(G_OBJECT(widgets_p->paper), "smb-user", g_strdup(user));
    }
    if (!password) {
	password = g_object_get_data(G_OBJECT(widgets_p->window), 
	    "smb-password");
	if (password) g_object_set_data(G_OBJECT(widgets_p->paper), "smb-password", g_strdup(password));
    }
    if (!domain) {
	domain = g_object_get_data(G_OBJECT(widgets_p->window), 
	    "smb-domain");
	if (domain) g_object_set_data(G_OBJECT(widgets_p->paper), "smb_workgroup", g_strdup(domain));
    }

    const gchar *default_user = getenv("USER");
    if (!default_user) default_user = getenv("LOGNAME");
    if (!default_user) default_user = "GUEST";

    if (!user) {
	user = rfm_get_user_with_default (widgets_p,
	    _("User ID; leave blank for anonymous / nonauthenticated"),
	    default_user);
	if (!user){
	    user = g_strdup("GUEST");
	}
	g_object_set_data(G_OBJECT(widgets_p->paper), "smb-user", user);
	g_object_set_data(G_OBJECT(widgets_p->window), "smb-user", (user)?
		g_strdup(user):NULL);
	if (user && strlen(user) && strcmp(user,"GUEST")) {
	    g_free(password);
	    password = rfm_get_password (widgets_p, NULL);
	    g_object_set_data(G_OBJECT(widgets_p->paper), "smb-password", password);
	    g_object_set_data(G_OBJECT(widgets_p->window), "smb-password", (password)?
		    g_strdup(password):NULL);
	}
	if (password && strlen(password)) {
	    g_free(domain);
	    gchar *t = g_strconcat(_("Optional information:"), " ",
		    _("Authentication domain"),NULL);
	    domain = rfm_get_string (widgets_p,
		    t, _("Domain:"));
	    g_free(t);
	    g_object_set_data(G_OBJECT(widgets_p->paper), "smb-domain", domain);
	    g_object_set_data(G_OBJECT(widgets_p->window), "smb-domain", (domain)?
		    g_strdup(domain):NULL);
	}
    }
    gchar *passfile = g_object_get_data(G_OBJECT(widgets_p->paper), "passfile");
    if (passfile) THREAD_CREATE(zap_passfile, g_strdup(passfile), "zap_passfile");
    g_object_set_data(G_OBJECT(widgets_p->paper), "passfile", NULL);
    g_free(passfile);
    passfile=NULL;
    if (password) {
	passfile = 
	    get_passfile(widgets_p, user, password, domain);
	g_object_set_data(G_OBJECT(widgets_p->paper), "passfile", passfile);
	DBG( "SET passfile=%s\n", passfile);
    }
  
    return  NULL;
}


static 
void reset_user_credentials(GtkMenuItem *m, gpointer data){
    widgets_t *widgets_p = data;
    // Clear out data elements for user, password and domain
    gchar *items[]={"smb-user", "smb-password", "smb-domain", NULL};
    gchar **p=items;
    for (p=items; p && *p; p++){
	void *q=g_object_get_data(G_OBJECT(widgets_p->paper), *p);
	g_free(q);
	q=g_object_get_data(G_OBJECT(widgets_p->window), *p);
	g_free(q);
	g_object_set_data(G_OBJECT(widgets_p->paper), *p, NULL);
	g_object_set_data(G_OBJECT(widgets_p->window), *p, NULL);
    }
    //
    // Fire up password dialog
    passfile_double_click(widgets_p, NULL);
    //
    // That's all, folks.
}

