//
//
// Helper functions to sshfs-fuse module.
/*
 * Edscott Wilson Garcia Copyright 2012
 *
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

static void 
do_properties (GtkMenuItem * menuitem, gpointer user_data) {
    widgets_t *widgets_p = (widgets_t *) user_data;
    record_entry_t *en = g_object_get_data(G_OBJECT(menuitem), "entry");
    const gchar *url = en->pseudo_path;
    confirm_ssh_host(widgets_p, url);
    return ;
}


static void
mount_url (widgets_t *widgets_p, const gchar *url) {
#ifndef THIS_IS_LINUX
    int old_p=0;
    size_t size=sizeof(int);
    if (sysctlbyname("vfs.usermount", &old_p, &size, NULL, 0) < 0){
	g_warning("sysctlbyname: %s\n", strerror(errno));
    }
    if (old_p != 1){
	rfm_show_text(widgets_p);
	rfm_diagnostics(widgets_p, "xffm/stock_dialog-warning", NULL);
	rfm_diagnostics(widgets_p, "xffm_tag/stderr", "sysctl vfs.usermount=0", "\n", NULL);
	rfm_diagnostics(widgets_p, "xffm/stock_help", NULL);
	rfm_diagnostics(widgets_p, "xffm_tag/green", 
		    _("Use sysctl or add this line to \"/etc/sysctl.conf\":"),"\n", NULL);
	rfm_diagnostics(widgets_p, "xffm_tag/magenta", 
		"   ","vfs.usermount=1","\n", NULL);
	return;
    } else {
	struct stat st;
	const gchar *mnt_src="/dev/fuse0";
	stat(mnt_src, &st);
	if (!(st.st_mode & S_IWGRP)){
	    rfm_show_text(widgets_p);
	    rfm_diagnostics(widgets_p, "xffm/stock_dialog-warning", NULL);
	    rfm_diagnostics(widgets_p, "xffm_tag/stderr", _("No write access to "),
		    mnt_src, "\n", NULL);
	    rfm_diagnostics(widgets_p, "xffm/stock_help", NULL);
	    rfm_diagnostics(widgets_p, "xffm_tag/green", 
		    _("Add these lines to /etc/devfs.rules:"),"\n", NULL);
	    rfm_diagnostics(widgets_p, "xffm_tag/magenta", 
		    "[localrules=5]","\n", NULL);
	    rfm_diagnostics(widgets_p, "xffm_tag/magenta", 
		    _("add path 'fuse*' mode 0660 group operator"),"\n", NULL);
	    rfm_diagnostics(widgets_p, "xffm/stock_help", NULL);
	    rfm_diagnostics(widgets_p, "xffm_tag/green", 
		    _("Add this line to /etc/rc.conf:"),"\n", NULL);
	    rfm_diagnostics(widgets_p, "xffm_tag/magenta", 
		    "   ","devfs_system_ruleset=\"localrules\"","\n", NULL);
	    return;
	}
    }  
#endif 
    
    gchar **options_ssh = NULL;
    gchar **options_fuse = NULL;
    gchar **options_module = NULL;
 
    gchar *mount_point = group_options_get_key_value (url, "FUSE_MOUNT_POINT");

    NOOP(stderr, "mount point is %s\n", mount_point);

    if (!fuse_mkdir(widgets_p, mount_point)){
	g_free(mount_point);
	return;
    }
    gchar *computer = group_options_get_key_value (url, "FUSE_COMPUTER");
    gchar *remote_path = group_options_get_key_value (url, "FUSE_REMOTE_PATH");
    gchar *login = group_options_get_key_value (url, "FUSE_LOGIN");
    gboolean ssh_key = group_options_get_key_boolean (url, "FUSE_SECURE_SHELL_KEY");
    gboolean empty_passphrase = group_options_get_key_boolean (url, "FUSE_ALLOW_EMPTY_PASSPHRASE");
    gboolean broadband = group_options_get_key_boolean (url, "FUSE_BROADBAND");
    gboolean monitor = group_options_get_key_boolean (url, "FUSE_MONITOR");
    gchar *argv[MAX_COMMAND_ARGS];
    gchar *remote = g_strdup_printf("%s@%s:%s", 
	    (login)?login:g_get_user_name(), computer, remote_path);
    if (strncmp(remote, "sftp://", strlen("sftp://"))==0) {
	remote += strlen("sftp://");
    }
    gchar *fsname=NULL;
    gint i=0;
    argv[i++] = "sshfs";
    argv[i++] = remote;
    argv[i++] = mount_point;
    // options from standard option pages...

    // fuse options is FLAG_1
    gint flag_id=1;
    options_fuse = 
	group_options_get_key_options(url, flag_id, 
	    fuse_options);
    // module options is FLAG_2
    flag_id=2;
    options_module =
	group_options_get_key_options(url, flag_id, 
	    module_options);
    // sshfs options is FLAG_3
    flag_id=3;
    options_ssh =
	group_options_get_key_options(url, flag_id, 
	    sshfs_options);
    gchar **o;
    for (o=options_ssh; o && *o && i+1 < MAX_COMMAND_ARGS; o++) {
	argv[i++] = *o;
    }
    for (o=options_fuse; o && *o && i+1 < MAX_COMMAND_ARGS; o++) {
	argv[i++] = *o;
    }
    for (o=options_module; o && *o && i+1 < MAX_COMMAND_ARGS; o++) {
	argv[i++] = *o;
    }
    // other options which may override option page settings
    argv[i++] = "-o";
    argv[i++] = "KbdInteractiveAuthentication=no";
    if (broadband){
	NOOP(stderr, "%s: broadband\n", mount_point);
	rfm_set_local_type(mount_point);
 /*	argv[i++] = "-o";
	fsname =  g_strdup_printf("fsname=broadsshfs-%s",remote);
	argv[i++] = fsname;*/
    } else if (monitor) {
	NOOP(stderr, "%s: monitor\n", mount_point);
	rfm_set_monitor_type(mount_point);
 /*	argv[i++] = "-o";
	fsname =  g_strdup_printf("fsname=monitor-%s",remote);
	argv[i++] = fsname;*/
    } 
    if (ssh_key) {
 	argv[i++] = "-o";
	argv[i++] = "PubkeyAuthentication=yes";
 	argv[i++] = "-o";
	argv[i++] = "PasswordAuthentication=no";

    } else {
 	argv[i++] = "-o";
	argv[i++] = "PasswordAuthentication=yes";
 	argv[i++] = "-o";
	argv[i++] = "PubkeyAuthentication=no";
   }

    gchar *text = NULL;
    if (ssh_key && !empty_passphrase) {
	
	text = g_strdup_printf("\n<b>%s</b>\n\n(<i>%s@%s</i>)", _("Please supply the passphrase for your SSH private key."), 
		g_get_user_name(), g_get_host_name());
    } else if (!ssh_key) {
	gchar *account = g_strdup_printf("<i>%s@%s</i>", (login)?login:g_get_user_name(), computer);
	text = g_strdup_printf(_("Enter your password for account\n%s"), 
		account);
	g_free(account);
    }
    gchar *passwd=NULL;
    if (ssh_key && empty_passphrase) {
	passwd = g_strdup("");
    } else if (ssh_key){
	passwd = rfm_get_passphrase (widgets_p, text);
    }
    if (ssh_key){
	argv[i++] = "-o";
	argv[i++] = "ChallengeResponseAuthentication=no";
	argv[i++] = "-o";
	argv[i++] = "BatchMode=yes";

    } else {
	argv[i++] = "-o";
	argv[i++] = "ChallengeResponseAuthentication=yes";
    }

    g_free(text);


    argv[i++] = NULL;

     rfm_show_text(widgets_p);
    if (passwd) {
	gint fd;
	rfm_thread_run_argv_with_stdin (widgets_p, argv, FALSE, &fd);
	
	if (write(fd, passwd, strlen(passwd)) < 0){
	    DBG("error writing passphrase to stdin...\n");
	}
    // flush
	if (write(fd, "\n", strlen("\n")) < 0){
	    DBG("error writing passphrase to stdin...\n");
	}
	memset(passwd, 0, strlen(passwd));
	g_free(passwd);
	close(fd);
    } else {
	rfm_thread_run_argv (widgets_p, argv, FALSE);
    }
//done:
    g_free(fsname);
    g_free(remote);
    g_free(login);
    g_free(computer);
    g_free(remote_path);
    g_free(mount_point);

    g_strfreev(options_ssh);
    g_strfreev(options_fuse);
    g_strfreev(options_module);
}


#if 0
static void *
mount_host_f(void *data){
    void **arg = data;
    widgets_t *widgets_p = arg[0];
    gchar *url = arg[1];
    mount_url(widgets_p, url);
    g_free(url);
    g_free(arg);
    return NULL;
}


static void
mount_host (GtkMenuItem * menuitem, gpointer user_data) {
    record_entry_t *en = g_object_get_data(G_OBJECT(menuitem), "entry");
    if (!en || !en->pseudo_path) return;
    gchar *url = g_strdup(en->pseudo_path);
    widgets_t *widgets_p = (widgets_t *) user_data;
    void **arg = (void **)malloc(2*sizeof(void *));
    arg[0] = widgets_p;
    arg[1] = url;
    // Do it in a thread to release the GDK mutex.
    THREAD_CREATE(mount_host_f, arg, "mount_host_f");

    //mount_url(widgets_p, en->pseudo_path);
}
#else

static void
mount_host (GtkMenuItem * menuitem, gpointer user_data) {
    record_entry_t *en = g_object_get_data(G_OBJECT(menuitem), "entry");
    if (!en) return;
    widgets_t *widgets_p = (widgets_t *) user_data;
    mount_url(widgets_p, en->pseudo_path);
}
#endif
