//
//
//linux options:

static gchar **nfs_option_keys = NULL;
static  GroupOptions nfs_options[]={
    {
	.sensitive = 2, .flag = "-o", .id = "soft", 
        .tip = N_("Determines  the  recovery  behavior  of the NFS client after an NFS request times out.  If neither option is specified (or if the  hard option  is  specified),  NFS requests are retried indefinitely.  If the soft option is specified, then the  NFS  client  fails  an  NFS request  after  retrans retransmissions have been sent, causing the NFS client to return an error to the calling application.\n\n NB: A so-called \"soft\" timeout can cause silent data corruption  in certain  cases.  As  such,  use  the  soft  option only when client responsiveness is more important than data  integrity.   Using  NFS over TCP or increasing the value of the retrans option may mitigate some of the risks of using the soft option."), 
	.entry = NULL
    },
    
    {
	.sensitive = 1, .flag = "-o", .id = "hard", 
        .tip = N_("Determines  the  recovery  behavior  of the NFS client after an NFS request times out.  If neither option is specified (or if the  hard option  is  specified),  NFS requests are retried indefinitely.  If the soft option is specified, then the  NFS  client  fails  an  NFS request  after  retrans retransmissions have been sent, causing the NFS client to return an error to the calling application.\n\n NB: A so-called \"soft\" timeout can cause silent data corruption  in certain  cases.  As  such,  use  the  soft  option only when client responsiveness is more important than data  integrity.   Using  NFS over TCP or increasing the value of the retrans option may mitigate some of the risks of using the soft option."), 
	.entry = NULL
    },

    {
	.sensitive = 1, .flag = "-o", .id = "timeo=", 
        .tip = N_("The time (in tenths of  a  second)  the  NFS  client  waits  for  a response  before  it  retries an NFS request. If this option is not specified, requests are retried every 60 seconds for NFS over  TCP.  The NFS client does not perform any kind of timeout backoff for NFS over TCP.\n\n However, for NFS over UDP, the client uses an adaptive algorithm to estimate  an  appropriate timeout value for frequently used request types (such as READ and WRITE requests), but uses the timeo setting for  infrequently used request types (such as FSINFO requests).  If the timeo option is not specified, infrequently used request  types are  retried after 1.1 seconds.  After each retransmission, the NFS client doubles the timeout for that request, up to a maximum  timeout length of 60 seconds."), 
	.entry = "60"
    },

    {
	.sensitive = 1, .flag = "-o", .id = "retrans=", 
        .tip = N_("The  number  of  times  the  NFS client retries a request before it attempts further recovery action. If  the  retrans  option  is  not specified, the NFS client tries each request three times.  \n\n The  NFS  client  generates a \"server not responding\" message after retrans retries,  then  attempts  further  recovery  (depending  on whether the hard mount option is in effect)."), 
	.entry = "3"
    },

    {
	.sensitive = 1, .flag = "-o", .id = "rsize=", 
        .tip = N_("The  maximum  number of bytes in each network READ request that the NFS client can receive when reading data from  a  file  on  an  NFS server.   The  actual data payload size of each NFS READ request is equal to or smaller than the rsize setting. The largest  read  payload  supported  by  the  Linux  NFS client is 1,048,576 bytes (one megabyte).  \n\n The rsize value is a positive integral multiple of 1024.  Specified rsize  values lower than 1024 are replaced with 4096; values larger than 1048576 are replaced with 1048576. If  a  specified  value  is within  the  supported  range  but  not  a  multiple of 1024, it is rounded down to the nearest multiple of 1024.  \n\n If an rsize value is not specified, or if the specified rsize value is  larger  than  the maximum that either client or server can support, the client and server negotiate the largest rsize value  that they can both support.  \n\n The  rsize  mount  option as specified on the mount(8) command line appears in the /etc/mtab file. However, the effective  rsize  value negotiated by the client and server is reported in the /proc/mounts file."), 
	.entry = "n"
    },

    {
	.sensitive = 1, .flag = "-o", .id = "wsize=", 
        .tip = N_(" The maximum number of bytes per network WRITE request that the  NFS client  can  send when writing data to a file on an NFS server. The actual data payload size of each NFS WRITE request is equal  to  or smaller than the wsize setting. The largest write payload supported by the Linux NFS client is 1,048,576 bytes (one megabyte).  \n\n Similar to rsize , the wsize value is a positive integral  multiple of  1024.  Specified wsize values lower than 1024 are replaced with 4096; values larger than 1048576 are replaced with  1048576.  If  a specified value is within the supported range but not a multiple of 1024, it is rounded down to the nearest multiple of 1024.  \n\n If a wsize value is not specified, or if the specified wsize  value is  larger  than  the maximum that either client or server can support, the client and server negotiate the largest wsize value  that they can both support.  \n\n The  wsize  mount  option as specified on the mount(8) command line appears in the /etc/mtab file. However, the effective  wsize  value negotiated by the client and server is reported in the /proc/mounts file."), 
	.entry = "n"
    },

    {
	.sensitive = 1, .flag = "-o", .id = "ac", 
        .tip = N_("Selects whether the client may cache file  attributes.  If  neither option is specified (or if ac is specified), the client caches file attributes.  \n\n To improve performance, NFS clients cache  file  attributes.  Every few  seconds,  an  NFS  client  checks the server's version of each file's attributes for updates.  Changes that occur on the server in those small intervals remain undetected until the client checks the server again. The noac option prevents clients  from  caching  file attributes  so  that  applications  can  more  quickly  detect file changes on the server.  \n\n In addition to preventing the client from caching file  attributes, the  noac option forces application writes to become synchronous so that local changes to a file become visible on the  server  immediately.   That  way,  other clients can quickly detect recent writes when they check the file's attributes.  \n\n Using the noac option provides greater cache  coherence  among  NFS clients  accessing  the  same  files, but it extracts a significant performance penalty.  As such, judicious use  of  file  locking  is encouraged  instead."), 
	.entry = NULL
    },

    {
	.sensitive = 1, .flag = "-o", .id = "noac", 
        .tip = N_("Selects whether the client may cache file  attributes.  If  neither option is specified (or if ac is specified), the client caches file attributes.  \n\n To improve performance, NFS clients cache  file  attributes.  Every few  seconds,  an  NFS  client  checks the server's version of each file's attributes for updates.  Changes that occur on the server in those small intervals remain undetected until the client checks the server again. The noac option prevents clients  from  caching  file attributes  so  that  applications  can  more  quickly  detect file changes on the server.  \n\n In addition to preventing the client from caching file  attributes, the  noac option forces application writes to become synchronous so that local changes to a file become visible on the  server  immediately.   That  way,  other clients can quickly detect recent writes when they check the file's attributes.  \n\n Using the noac option provides greater cache  coherence  among  NFS clients  accessing  the  same  files, but it extracts a significant performance penalty.  As such, judicious use  of  file  locking  is encouraged  instead."), 
	.entry = NULL
    },

    {
	.sensitive = 1, .flag = "-o", .id = "acregmin=", 
        .tip = N_("The minimum time (in seconds) that the NFS client caches attributes of  a  regular  file before it requests fresh attribute information from a server.  If this option is not  specified,  the  NFS  client uses a 3-second minimum."), 
	.entry = "n"
    },

    {
	.sensitive = 1, .flag = "-o", .id = "acregmax=", 
        .tip = N_("The maximum time (in seconds) that the NFS client caches attributes of a regular file before it requests  fresh  attribute  information from  a  server.   If  this option is not specified, the NFS client uses a 60-second maximum."), 
	.entry = "60"
    },

    {
	.sensitive = 1, .flag = "-o", .id = "acdirmin=", 
        .tip = N_("The minimum time (in seconds) that the NFS client caches attributes of  a directory before it requests fresh attribute information from a server.  If this option is not specified, the NFS client  uses  a 30-second minimum."), 
	.entry = "30"
    },

    {
	.sensitive = 1, .flag = "-o", .id = "acdirmax=", 
        .tip = N_("The maximum time (in seconds) that the NFS client caches attributes of a directory before it requests fresh attribute information  from a  server.   If this option is not specified, the NFS client uses a 60-second maximum."), 
	.entry = "60"
    },

    {
	.sensitive = 1, .flag = "-o", .id = "actimeo=", 
        .tip = N_("Using  actimeo  sets  all  of  acregmin,  acregmax,  acdirmin,  and acdirmax  to  the same value.  If this option is not specified, the NFS client uses the defaults  for  each  of  these  options  listed above."), 
	.entry = "n"
    },

    {
	.sensitive = 1, .flag = "-o", .id = "bg", 
        .tip = N_("Determines  how the mount(8) command behaves if an attempt to mount an export fails.  The fg option causes mount(8)  to  exit  with  an error  status  if  any part of the mount request times out or fails outright.  This is called a \"foreground\" mount, and is the  default behavior if neither the fg nor bg mount option is specified. \n\n If  the  bg  option  is  specified, a timeout or failure causes the mount(8) command to fork a child  which  continues  to  attempt  to mount  the export.  The parent immediately returns with a zero exit code.  This is known as a \"background\" mount.  \n\n If the local mount point directory is missing, the mount(8) command acts  as  if  the mount request timed out.  This permits nested NFS mounts specified in /etc/fstab to proceed in any order during  system initialization, even if some NFS servers are not yet available.  Alternatively these issues can be addressed  using  an  automounter (refer to automount(8) for details)."), 
	.entry = NULL
    },

    {
	.sensitive = 1, .flag = "-o", .id = "fg", 
        .tip = N_("Determines  how the mount(8) command behaves if an attempt to mount an export fails.  The fg option causes mount(8)  to  exit  with  an error  status  if  any part of the mount request times out or fails outright.  This is called a \"foreground\" mount, and is the  default behavior if neither the fg nor bg mount option is specified. \n\n If  the  bg  option  is  specified, a timeout or failure causes the mount(8) command to fork a child  which  continues  to  attempt  to mount  the export.  The parent immediately returns with a zero exit code.  This is known as a \"background\" mount.  \n\n If the local mount point directory is missing, the mount(8) command acts  as  if  the mount request timed out.  This permits nested NFS mounts specified in /etc/fstab to proceed in any order during  system initialization, even if some NFS servers are not yet available.  Alternatively these issues can be addressed  using  an  automounter (refer to automount(8) for details)."), 
	.entry = NULL
    },

    {
	.sensitive = 1, .flag = "-o", .id = "retry=", 
        .tip = N_("The  number  of  minutes  that  the mount(8) command retries an NFS mount operation in the foreground or background before  giving  up.  If  this  option is not specified, the default value for foreground mounts is 2 minutes, and the default value for background mounts is 10000  minutes (80 minutes shy of one week).  If a value of zero is specified, the mount(8) command exits immediately after the  first failure."), 
	.entry = "n",
    },

    {
	.sensitive = 1, .flag = "-o", .id = "sec=", 
        .tip = N_("The RPCGSS security flavor to use for accessing files on this mount point.  If the sec option is not specified, or if sec=sys is specified,  the NFS client uses the AUTH_SYS security flavor for all NFS requests on this mount point.  Valid  security  flavors  are  none, sys,  krb5,  krb5i,  krb5p,  lkey,  lkeyi,  lkeyp, spkm, spkmi, and spkmp."), 
	.entry = "sys"
    },

    {
	.sensitive = 1, .flag = "-o", .id = "sharecache", 
        .tip = N_("Determines how the client\'s data  cache  and  attribute  cache  are shared  when  mounting the same export more than once concurrently.  Using the same cache reduces memory requirements on the client  and presents  identical  file  contents  to  applications when the same remote file is accessed via different mount points.  \n\n If neither option is specified, or  if  the  sharecache  option  is specified,  then  a  single cache is used for all mount points that access the same export.  If the nosharecache option  is  specified, then that mount point gets a unique cache.  Note that when data and attribute caches are shared, the mount options from the first mount point  take  effect  for  subsequent  concurrent mounts of the same export.  \n\n As of kernel 2.6.18, the  behavior  specified  by  nosharecache  is legacy  caching behavior. This is considered a data risk since multiple cached copies of the same file on the same client can  become out of sync following a local update of one of the copies."), 
	.entry = NULL
    },

    {
	.sensitive = 1, .flag = "-o", .id = "nosharecache", 
        .tip = N_("Determines how the client\'s data  cache  and  attribute  cache  are shared  when  mounting the same export more than once concurrently.  Using the same cache reduces memory requirements on the client  and presents  identical  file  contents  to  applications when the same remote file is accessed via different mount points.  \n\n If neither option is specified, or  if  the  sharecache  option  is specified,  then  a  single cache is used for all mount points that access the same export.  If the nosharecache option  is  specified, then that mount point gets a unique cache.  Note that when data and attribute caches are shared, the mount options from the first mount point  take  effect  for  subsequent  concurrent mounts of the same export.  \n\n As of kernel 2.6.18, the  behavior  specified  by  nosharecache  is legacy  caching behavior. This is considered a data risk since multiple cached copies of the same file on the same client can  become out of sync following a local update of one of the copies."), 
	.entry = NULL
    },

    {
	.sensitive = 1, .flag = "-o", .id = "resvport", 
        .tip = N_("Specifies  whether  the  NFS  client should use a privileged source port when communicating with an NFS server for  this  mount  point.  If  this  option is not specified, or the resvport option is specified, the NFS client uses a privileged source port.  If the noresvport  option  is  specified,  the  NFS client uses a non-privileged source port.  This option is supported in kernels 2.6.28 and later.  \n\n Using non-privileged source ports helps increase the maximum number of  NFS  mount  points allowed on a client, but NFS servers must be configured to allow clients to connect  via  non-privileged  source ports."), 
	.entry = NULL
    },

    {
	.sensitive = 1, .flag = "-o", .id = "noresvport", 
        .tip = N_("Specifies  whether  the  NFS  client should use a privileged source port when communicating with an NFS server for  this  mount  point.  If  this  option is not specified, or the resvport option is specified, the NFS client uses a privileged source port.  If the noresvport  option  is  specified,  the  NFS client uses a non-privileged source port.  This option is supported in kernels 2.6.28 and later.  \n\n Using non-privileged source ports helps increase the maximum number of  NFS  mount  points allowed on a client, but NFS servers must be configured to allow clients to connect  via  non-privileged  source ports."), 
	.entry = NULL
    },

    {
	.sensitive = 1, .flag = "-o", .id = "lookupcache=", 
        .tip = N_("Specifies how the kernel manages its cache of directory entries for a given mount point.  mode can be one of all, none, pos,  or  positive.  This option is supported in kernels 2.6.28 and later.  \n\n The  Linux NFS client caches the result of all NFS LOOKUP requests.  If the requested directory entry exists on the server,  the  result is  referred to as positive.  If the requested directory entry does not exist on the server, the result is referred to as negative.  \n\n If this option is not specified, or if all is specified, the client assumes both types of directory cache entries are valid until their parent directory's cached attributes expire.  \n\n If pos or  positive  is  specified,  the  client  assumes  positive entries  are valid until their parent directory's cached attributes expire, but always revalidates negative entires before an  application can use them.  \n\n If  none  is specified, the client revalidates both types of directory cache entries before an application can use them.   This  permits quick detection of files that were created or removed by other clients, but can impact application and server performance."), 
	.entry = "all"
    },
    {
	.sensitive = 1, .flag = "-o", .id = "proto=", 
        .tip = N_("The transport protocol name and protocol family the NFS client uses to transmit requests to the NFS server for this mount point.  If an NFS server has both an IPv4 and an IPv6 address, using  a  specific netid  will force the use of IPv4 or IPv6 networking to communicate with that server.  \n\n If support for TI-RPC is built into the mount.nfs command, netid is a  valid netid listed in /etc/netconfig.  The value \"rdma\" may also be specified.  If the mount.nfs command does not have  TI-RPC  support,  then  netid is one of \"tcp\", \"udp\", or \"rdma\", and only IPv4 may be used.  \n\n Each transport protocol uses different default  retrans  and  timeo settings.   Refer to the description of these two mount options for details.  \n\n In addition to controlling how the NFS client transmits requests to the  server,  this mount option also controls how the mount(8) command communicates with the server's rpcbind  and  mountd  services.  Specifying  a  netid  that  uses  TCP  forces  all traffic from the mount(8) command and the NFS client to use TCP.  Specifying a netid that uses UDP forces all traffic types to use UDP.  \n\n If  the  proto  mount option is not specified, the mount(8) command discovers which protocols the server supports and chooses an appropriate  transport for each service.\n\nAll NFS version 4 servers are required to support TCP, so  if  this mount  option  is  not specified, the NFS version 4 client uses the TCP protocol."), 
	.entry = "netid"
    },
    {
	.sensitive = 1, .flag = "-o", .id = "port=", 
        .tip = N_("The numeric value  of  the  server\'s  NFS  service  port.   If  the server\'s  NFS  service  is not available on the specified port, the mount request fails.  \n\n If this option is not specified, or if the specified port value  is 0,  then the NFS client uses the NFS service port number advertised by the server's rpcbind service.  The mount request  fails  if  the server\'s rpcbind service is not available, the server's NFS service is not registered with its rpcbind service,  or  the  server\'s  NFS service is not available on the advertised port.\n\nOn NFS V4 the NFS client uses the standard NFS  port  number  of  2049  without  first  checking  the server\'s  rpcbind  service.  This allows an NFS version 4 client to contact an NFS version 4 server through a firewall that  may  block rpcbind requests."), 
	.entry = "0"
    },
    {
	.sensitive = 1, .flag = "-o", .id = "intr", 
        .tip = N_("Selects whether to allow signals to interrupt  file  operations  on this  mount  point. If neither option is specified (or if nointr is specified), signals do not interrupt NFS file operations.  If  intr is specified, system calls return EINTR if an in-progress NFS operation is interrupted by a signal.  \n\n Using the intr option is preferred to using the soft option because it is significantly less likely to result in data corruption.  \n\n The  intr  / nointr mount option is deprecated after kernel 2.6.25.  Only SIGKILL can interrupt a pending NFS operation  on  these  kernels,  and  if  specified,  this mount option is ignored to provide backwards compatibility with older kernels."), 
	.entry = NULL
    },

    {
	.sensitive = 1, .flag = "-o", .id = "nointr", 
        .tip = N_("Selects whether to allow signals to interrupt  file  operations  on this  mount  point. If neither option is specified (or if nointr is specified), signals do not interrupt NFS file operations.  If  intr is specified, system calls return EINTR if an in-progress NFS operation is interrupted by a signal.  \n\n Using the intr option is preferred to using the soft option because it is significantly less likely to result in data corruption.  \n\n The  intr  / nointr mount option is deprecated after kernel 2.6.25.  Only SIGKILL can interrupt a pending NFS operation  on  these  kernels,  and  if  specified,  this mount option is ignored to provide backwards compatibility with older kernels."), 
	.entry = NULL
    },

    {
	.sensitive = 1, .flag = "-o", .id = "cto", 
        .tip = N_("Selects whether to use close-to-open cache coherence semantics.  If neither  option  is  specified (or if cto is specified), the client uses close-to-open cache coherence semantics. If the  nocto  option is specified, the client uses a non-standard heuristic to determine when files on the server have changed.\n\n Using the  nocto  option  may  improve  performance  for  read-only mounts,  but  should be used only if the data on the server changes only occasionally.\n\n NFS V4: If neither cto nor nocto is specified, the default is  to  use  close-to-open  cache  coherence semantics for directories.  \n\n File  data  caching  behavior  is not affected by this option."), 
	.entry = NULL
    },

    {
	.sensitive = 1, .flag = "-o", .id = "nocto", 
        .tip = N_("Selects whether to use close-to-open cache coherence semantics.  If neither  option  is  specified (or if cto is specified), the client uses close-to-open cache coherence semantics. If the  nocto  option is specified, the client uses a non-standard heuristic to determine when files on the server have changed.\n\n Using the  nocto  option  may  improve  performance  for  read-only mounts,  but  should be used only if the data on the server changes only occasionally.\n\n NFS V4: If neither cto nor nocto is specified, the default is  to  use  close-to-open  cache  coherence semantics for directories.  \n\n File  data  caching  behavior  is not affected by this option."), 
	.entry = NULL
    },
    {.sensitive = 1, NULL, NULL, NULL, .entry = NULL}
};

/////////////////////////////////////////////////////////////////////////////////////

static gchar **nfsV23_option_keys = NULL;
static  GroupOptions nfsV23_options[]={


    {
	.sensitive = 1, .flag = "-o", .id = "udp", 
        .tip = N_("The udp option is an alternative to specifying  proto=udp.   It  is included for compatibility with other operating systems."), 
	.entry = NULL
    },

    {
	.sensitive = 1, .flag = "-o", .id = "tcp", 
        .tip = N_("The  tcp  option  is an alternative to specifying proto=tcp.  It is included for compatibility with other operating systems."), 
	.entry = NULL
    },

    {
	.sensitive = 1, .flag = "-o", .id = "rdma", 
        .tip = N_("The rdma option is an alternative to specifying proto=rdma."), 
	.entry = NULL
    },


    {
	.sensitive = 1, .flag = "-o", .id = "mountport=", 
        .tip = N_("The  numeric  value  of  the server\'s mountd port.  If the server\'s mountd service is not available on the specified  port,  the  mount request fails.  \n\n If  this option is not specified, or if the specified port value is 0, then the mount(8) command uses the mountd  service  port  number advertised  by  the  server's  rpcbind  service.  The mount request fails if  the  server\'s  rpcbind  service  is  not  available,  the server\'s mountd service is not registered with its rpcbind service, or the server's mountd service is not available on  the  advertised port.  \n\n This option can be used when mounting an NFS server through a firewall that blocks the rpcbind protocol."), 
	.entry = "n"
    },

    {
	.sensitive = 1, .flag = "-o", .id = "mountproto=", 
        .tip = N_("The transport protocol name and protocol family the NFS client uses to  transmit  requests to the NFS server\'s mountd service when performing this mount request, and when later  unmounting  this  mount point.  \n\n If support for TI-RPC is built into the mount.nfs command, netid is a valid netid listed in /etc/netconfig.  Otherwise, netid is one of \"tcp\" or \"udp\", and only IPv4 may be used.  \n\n This option can be used when mounting an NFS server through a firewall that blocks a particular transport.  When used in  combination with the proto option, different transports for mountd requests and NFS requests can be specified.  If the server\'s mountd  service  is not available via the specified transport, the mount request fails."), 
	.entry = "netid"
    },

    {
	.sensitive = 1, .flag = "-o", .id = "mounthost=", 
        .tip = N_("The hostname of the host running mountd.  If  this  option  is  not specified,  the  mount(8)  command  assumes that the mountd service runs on the same host as the NFS service."), 
	.entry = "name"
    },

    {
	.sensitive = 1, .flag = "-o", .id = "mountvers=", 
        .tip = N_("The RPC version number used to contact  the  server\'s  mountd.   If this  option  is  not  specified,  the client uses a version number appropriate to the requested NFS version.  This  option  is  useful when  multiple  NFS  services are running on the same remote server host."), 
	.entry = "n"
    },

    {
	.sensitive = 1, .flag = "-o", .id = "namlen=", 
        .tip = N_("The maximum length of a pathname component on this mount.  If  this option  is not specified, the maximum length is negotiated with the server. In most cases, this maximum length is 255 characters.  \n\n Some early versions of NFS did not support this negotiation.  Using this  option  ensures  that  pathconf(3) reports the proper maximum component length to applications in such cases."), 
	.entry = "n"
    },

    {
	.sensitive = 1, .flag = "-o", .id = "nfsvers=", 
        .tip = N_("The NFS protocol version number used to contact  the  server\'s  NFS service.  If the server does not support the requested version, the mount request fails.  If this option is not specified,  the  client negociate  a  suitable  version  with  the server, trying version 4 first, version 3 second, and version 2 last."), 
	.entry = "n"
    },

    {
	.sensitive = 1, .flag = "-o", .id = "vers=", 
        .tip = N_("This option is  an  alternative  to  the  nfsvers  option.   It  is included for compatibility with other operating systems."), 
	.entry = "n"
    },

    {
	.sensitive = 1, .flag = "-o", .id = "lock", 
        .tip = N_("Selects  whether  to use the NLM sideband protocol to lock files on the server.  If neither option is specified (or if lock  is  specified),  NLM  locking  is used for this mount point.  When using the nolock option, applications can lock files, but such locks  provide exclusion  only  against  other  applications  running  on the same client.  Remote applications are not affected by these locks.  \n\n NLM locking must be disabled with the nolock option when using  NFS to mount /var because /var contains files used by the NLM implementation on Linux.  Using the nolock option  is  also  required  when mounting  exports on NFS servers that do not support the NLM protocol."), 
	.entry = NULL
    },

    {
	.sensitive = 1, .flag = "-o", .id = "nolock", 
        .tip = N_("Selects  whether  to use the NLM sideband protocol to lock files on the server.  If neither option is specified (or if lock  is  specified),  NLM  locking  is used for this mount point.  When using the nolock option, applications can lock files, but such locks  provide exclusion  only  against  other  applications  running  on the same client.  Remote applications are not affected by these locks.  \n\n NLM locking must be disabled with the nolock option when using  NFS to mount /var because /var contains files used by the NLM implementation on Linux.  Using the nolock option  is  also  required  when mounting  exports on NFS servers that do not support the NLM protocol."), 
	.entry = NULL
    },


    {
	.sensitive = 1, .flag = "-o", .id = "acl", 
        .tip = N_("Selects  whether  to use the NFSACL sideband protocol on this mount point.  The NFSACL sideband  protocol  is  a  proprietary  protocol implemented  in  Solaris  that manages Access Control Lists. NFSACL was never made a standard part of the NFS protocol specification.  \n\n If neither acl nor noacl option is specified, the NFS client  negotiates  with the server to see if the NFSACL protocol is supported, and uses it if the server supports it.  Disabling the NFSACL  sideband  protocol  may be necessary if the negotiation causes problems on the client or server."), 
	.entry = NULL
    },

    {
	.sensitive = 1, .flag = "-o", .id = "noacl", 
        .tip = N_("Selects  whether  to use the NFSACL sideband protocol on this mount point.  The NFSACL sideband  protocol  is  a  proprietary  protocol implemented  in  Solaris  that manages Access Control Lists. NFSACL was never made a standard part of the NFS protocol specification.  \n\n If neither acl nor noacl option is specified, the NFS client  negotiates  with the server to see if the NFSACL protocol is supported, and uses it if the server supports it.  Disabling the NFSACL  sideband  protocol  may be necessary if the negotiation causes problems on the client or server."), 
	.entry = NULL
    },


    {
	.sensitive = 1, .flag = "-o", .id = "rdirplus", 
        .tip = N_(" Selects whether to use NFS version 3 READDIRPLUS requests.  If this option is not specified, the NFS client uses  READDIRPLUS  requests on  NFS  version 3 mounts to read small directories.  Some applications perform better if the client uses only READDIR  requests  for all directories."), 
	.entry = NULL
    },


    {
	.sensitive = 1, .flag = "-o", .id = "nordirplus", 
        .tip = N_(" Selects whether to use NFS version 3 READDIRPLUS requests.  If this option is not specified, the NFS client uses  READDIRPLUS  requests on  NFS  version 3 mounts to read small directories.  Some applications perform better if the client uses only READDIR  requests  for all directories."), 
	.entry = NULL
    },
    {.sensitive = 1, NULL, NULL, NULL, .entry = NULL}
};

////////////////////////////////////////////////////////////////////////////////////

static gchar **nfsV4_option_keys = NULL;
static  GroupOptions nfsV4_options[]={

    {
	.sensitive = 1, .flag = "-o", .id = "clientaddr=", 
        .tip = N_("Specifies  a  single  IPv4 address (in dotted-quad form), or a nonlink-local IPv6 address, that the NFS client  advertises  to  allow servers to perform NFS version 4 callback requests against files on this mount point. If  the  server is unable to  establish  callback connections  to  clients,  performance  may degrade, or accesses to files may temporarily hang.  \n\n If this option is not specified, the mount(8) command  attempts  to discover  an appropriate callback address automatically.  The automatic discovery process is not perfect, however.  In  the  presence of multiple client network interfaces, special routing policies, or atypical network topologies, the exact address to use for callbacks may be nontrivial to determine."), 
	.entry = "n.n.n.n"
    },


    {.sensitive = 1, NULL, NULL, NULL, .entry = NULL}
};

