/*
 * Edscott Wilson Garcia Copyright 2012
 *
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */
#ifdef HAVE_CONFIG_H
# include <config.h>
#endif
#include "rodent_libs.h"
/* this should be first 2 lines after headers: */
G_MODULE_EXPORT LIBRFM_MODULE

#define MODULE_NAME "fuse"
#define SUBMODULE_NAME "fuse"
#define MODULE_LABEL _("Custom Data Filesystems")
//#define MODULE_LABEL _("FUSE Volume")
#define MODULE_ICON_ID "xffm/places_folder-remote"
//#define MODULE_ENTRY_TIP _("Filesystems")
//#define MODULE_ENTRY_TIP _("Mount user-space filesystems (FUSE)")
#define MODULE_ENTRY_TIP _("Custom Data Filesystems")

#include "module-skeleton.h"
// Skeleton definitions
G_MODULE_EXPORT RFM_G_MODULE_CHECK_INIT

G_MODULE_EXPORT RFM_MODULE_NAME
G_MODULE_EXPORT RFM_SUBMODULE_NAME
G_MODULE_EXPORT RFM_MODULE_LABEL
G_MODULE_EXPORT RFM_MODULE_ICON_ID
G_MODULE_EXPORT RFM_MODULE_ENTRY_TIP

G_MODULE_EXPORT RFM_MODULE_PREFERENCES_KEY("RODENT-FUSE")
G_MODULE_EXPORT RFM_IS_ROOT_MODULE(TRUE)
G_MODULE_EXPORT RFM_PLUGIN_INFO(_("Network Servers"))
G_MODULE_EXPORT RFM_MODULE_ACTIVE(TRUE)
G_MODULE_EXPORT RFM_MODULE_MONITOR(FALSE)
G_MODULE_EXPORT RFM_IS_SELECTABLE(FALSE)

// This plugin is a master plugin which has child plugins, namely:
//   --cifs 
//   --sftp
//   --ftp
//   --obex
//   --ecrypt
//   --nfs
//


// gboolean
// This function fills in previously allocated xfdir_p
// with glob records and entries of the module population.
// Records which are filled in are:
// xfdir_p->pathc: Number of icons for Rodent to display
// xfdir_p->gl[0 ... pathc-1].pathv: Labels to display with each icon
// xfdir_p->gl[0 ... pathc-1].en: Record_entry_t of each icon 
// 				  (NULL entries will point to Rodent root) 
G_MODULE_EXPORT
void *
module_xfdir_get (void *p) {
    gchar *item_v[]={ 
        "sftp", "nfs", 
#ifdef EXPERIMENTAL_CONFIGURED
        "cifs", "ftp", "obex", "ecryptfs", 
#endif
        NULL};
    gint items;
    gint first = 1;
    for(items=0; item_v[items]; items++);
    xfdir_t *xfdir_p = p;
    if (rfm_void(PLUGIN_DIR, "fstab", "module_active")){
	first = 2;
    }
    xfdir_p->pathc=items+first;

    xfdir_p->gl = (dir_t *)malloc(xfdir_p->pathc*sizeof(dir_t));
    if (!xfdir_p->gl) g_error("malloc: %s", strerror(errno));
    memset(xfdir_p->gl,0,xfdir_p->pathc*sizeof(dir_t));
    // Up icon
    xfdir_p->gl[0].en = NULL;	
    xfdir_p->gl[0].pathv = g_strdup (g_get_host_name ());
    if (rfm_void(PLUGIN_DIR, "fstab", "module_active")){
	xfdir_p->gl[1].en=rfm_mk_entry(0);
	xfdir_p->gl[1].en->st = NULL;
	xfdir_p->gl[1].en->parent_module = MODULE_NAME;
	xfdir_p->gl[1].en->module = "fstab";
	gchar *g = rfm_void(PLUGIN_DIR, "fstab", "module_label");
	if (!g) g=g_strdup_printf("FIXME: no module label for \"%s\"", "fuse");
	xfdir_p->gl[1].en->path=g;
	xfdir_p->gl[1].pathv = g_strdup(g);
        SET_DUMMY_TYPE (xfdir_p->gl[1].en->type);
	//SET_UP_TYPE(xfdir_p->gl[1].en->type);
    }


/*	xfdir_p->gl[0].en->parent_module=g_strdup(MODULE_NAME);
	xfdir_p->gl[0].en->path=g_strdup(MODULE_LABEL);
        SET_DUMMY_TYPE (xfdir_p->gl[0].en->type);
	SET_UP_TYPE(xfdir_p->gl[0].en->type);
	NOOP("parent is an orphan. Up is set to module root.\n");
        xfdir_p->gl[0].pathv = g_strdup(MODULE_LABEL);*/
    gchar **v = item_v;
    gint i;
    for (i=first; v && *v;  v++){
	if (!rfm_void(PLUGIN_DIR, *v, "module_active")) {
	//    continue;
	}
	xfdir_p->gl[i].en=rfm_mk_entry(0);
	xfdir_p->gl[i].en->st = NULL;
	xfdir_p->gl[i].en->parent_module = MODULE_NAME;
	xfdir_p->gl[i].en->module = *v;
	const gchar *g = rfm_void(PLUGIN_DIR, *v, "module_label");
	if (!g) {
	    xfdir_p->gl[i].en->path = g_strdup_printf("Cannot load \"%s\"", *v);
	} else{
	    xfdir_p->gl[i].en->path = g_strdup(g);
	}
        xfdir_p->gl[i].pathv = g_strdup(xfdir_p->gl[i].en->path);
	DBG("fuse: %s\n", *v);
	i++;
    }  
    xfdir_p->pathc=i;


    return p;
}

// This routine solve for two icons, namely,
//   1. the plugin icon shown on rodent root
//   2. the up icon shown in modules contained by this module.
G_MODULE_EXPORT
void *
item_icon_id (void *p){
    record_entry_t *en=(record_entry_t *)p;
    if (!en) return "xffm/places_folder-scouts"; // Error.
    if (IS_UP_TYPE(en->type)){
	return "xffm/places_folder-remote/composite3/stock_go-up";
    }
    if (IS_DUMMY_TYPE(en->type)){
	return "xffm/places_folder-remote/composite3/stock_jump-to";
    }
    return MODULE_ICON_ID;
}

G_MODULE_EXPORT
void *
private_popup(void *p, void *q){
    if (!q) return NULL;
    // no popup menu for module items...
    record_entry_t *en = q;
    gchar *entry_tip = rfm_void(PLUGIN_DIR, en->module, "module_entry_tip");
    gchar *label = rfm_void(PLUGIN_DIR, en->module, "module_label");
    gchar *message= g_strconcat("<big>", label, ":</big>\n", entry_tip, NULL);
    gchar *text = g_strdup_printf("<big><b>%s</b></big>\n\n<i>%s</i>", 
	    MODULE_ENTRY_TIP, message);
    rfm_confirm(p, GTK_MESSAGE_INFO, text, NULL, NULL);
    g_free(text);
    g_free(message);
    g_free(label);
    g_free(entry_tip);
    return GINT_TO_POINTER(1);
}


// Leave all the tip text to the module if this function
// exists and returns TRUE
G_MODULE_EXPORT
void *
no_rfm_tip_text(void *p){
    return GINT_TO_POINTER(1);
}

//  gchar *  
// This function returns a newly allocated string with the general information
// of the entry (parameter p). Rodent uses this to construct the popup tip.
// Returned value should be freed when no longer used.
G_MODULE_EXPORT
void *
item_entry_tip(void *p){
    if (!p) return NULL;
    record_entry_t *en = p;
    if (!en->path) return NULL;
    if (en->module && strcmp(en->module, MODULE_NAME)){
	const gchar *c = rfm_void(PLUGIN_DIR, en->module, "module_label");
	if (c) {
	    return g_strdup(c);
	}
    } else return MODULE_LABEL;
    return NULL;
}


