//
//
//
//
// ftp submodule option dialog window y anexas.
/*
 * Edscott Wilson Garcia Copyright 2011
 *
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */
static void
mount_url (widgets_t *widgets_p, const gchar *url);


static gchar *
accept (fuse_data_t *fuse_data_p, const gchar *url){
    // url is the keyfile group
    fuse_data_p->url = url;
    if (!FUSE_get_login_info (fuse_data_p)) return NULL;

    // Extra ftp stuff: (beyond flag 10...)
    const gchar *proxy_port = NULL;
    const gchar *proxy_user = NULL;
    const gchar *proxy_host = NULL;
    GtkWidget *check;
    check = g_object_get_data(G_OBJECT(fuse_data_p->dialog), "FTP_PASSIVE");
    gboolean passive = gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(check));
 
    check = g_object_get_data(G_OBJECT(fuse_data_p->dialog), "FTP_USE_PROXY");
    gboolean use_proxy = 
	gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(check));

    GtkEntry *entry = g_object_get_data(G_OBJECT(fuse_data_p->dialog), "FTP_PROXY_HOST");
    if (entry) proxy_host = gtk_entry_get_text(entry);
    // Get mandatory proxy host.
    if (use_proxy && (!proxy_host || strlen(proxy_host)==0))
    {
	widgets_t *widgets_p = 
	    g_object_get_data(G_OBJECT(fuse_data_p->dialog), "widgets_p");
	gchar *item = g_strdup_printf("<i>%s</i>", _("FTP proxy host name"));
	gchar *text = g_strdup_printf(_("Missing: %s"), item);
	gchar *msg = g_strdup_printf("<b>%s</b>", text);
	rfm_confirm (widgets_p, GTK_MESSAGE_ERROR, msg, NULL, NULL);
	g_free(item);
	g_free(text);
	g_free(msg);
	return FALSE;
    } 

    // Get optional proxy port.
    entry = g_object_get_data(G_OBJECT(fuse_data_p->dialog), "FTP_PROXY_PORT");
    if (entry) proxy_port = gtk_entry_get_text(entry);
    // Get optional proxy user.
    entry = g_object_get_data(G_OBJECT(fuse_data_p->dialog), "FTP_PROXY_USER");
    if (entry) proxy_user = gtk_entry_get_text(entry);

    // Put extra stuff into open keyfile.
    key_options_t *key_options_p = 
	g_object_get_data(G_OBJECT(fuse_data_p->dialog), "key_options_p");
    if (!key_options_p) g_error("key_options_p cannot be null\n");
    if (passive){
	g_key_file_set_boolean(key_options_p->key_file, key_options_p->group,
		"FTP_PASSIVE", TRUE); 
    }
    if (use_proxy){
	g_key_file_set_boolean(key_options_p->key_file, key_options_p->group,
		"FTP_USE_PROXY", TRUE); 
    }
    if (proxy_host && strlen(proxy_host)){
	g_key_file_set_value (key_options_p->key_file,  key_options_p->group, 
	    "FTP_PROXY_HOST", proxy_host);
    }
    if (proxy_port && strlen(proxy_port)){
	g_key_file_set_value (key_options_p->key_file,  key_options_p->group, 
	    "FTP_PROXY_PORT", proxy_port);
    }
    if (proxy_user && strlen(proxy_user)){
	g_key_file_set_value (key_options_p->key_file,  key_options_p->group, 
		"FTP_PROXY_USER", proxy_user);
    }
    


    // FLAG_0 is done.

    // FLAG_1: fuse options.    
    fuse_data_p->flag_id = 1;
    fuse_data_p->options_p = fuse_options;
    fuse_data_p->options_keys_p = &fuse_option_keys;
    FUSE_set_options(fuse_data_p);     
    // FLAG_2: module options
    fuse_data_p->flag_id = 2;
    fuse_data_p->options_p = module_options;
    fuse_data_p->options_keys_p = &module_option_keys;
    FUSE_set_options(fuse_data_p);     
    // FLAG_3: sshfs options 
    // FLAG_4: ftp options (submodule specific)
    fuse_data_p->flag_id = 4;
    fuse_data_p->options_p = ftp_options;
    fuse_data_p->options_keys_p = &ftp_option_keys;
    FUSE_set_options(fuse_data_p);    
    // FLAG_5: curlftpfs options (submodule specific)
    fuse_data_p->flag_id = 5;
    fuse_data_p->options_p = curlftpfs_options;
    fuse_data_p->options_keys_p = &curlftpfs_option_keys;
    FUSE_set_options(fuse_data_p);    
    //
    // FLAG_6: mount options 
    // FLAG_7: nfs options 
    // FLAG_8: nfs v23 options 
    // FLAG_9: nfs v4 options 
    // FLAG_10: cifs options 
   
    // Here we save and cleanup key_file.
    return FUSE_save_keyfile(fuse_data_p);
}

static void 
toggle_proxy(GtkToggleButton *togglebutton , gpointer data){
    GtkWidget *dialog = data;

    GtkWidget *ftp_proxy_host = g_object_get_data(G_OBJECT(dialog), "FTP_PROXY_HOST");
    GtkWidget *ftp_proxy_port = g_object_get_data(G_OBJECT(dialog), "FTP_PROXY_PORT");
    GtkWidget *ftp_proxy_user = g_object_get_data(G_OBJECT(dialog), "FTP_PROXY_USER");
    // Login page stuff:
    if (gtk_toggle_button_get_active(togglebutton)){
	gtk_widget_set_sensitive(GTK_WIDGET(ftp_proxy_host), TRUE);
	gtk_widget_set_sensitive(GTK_WIDGET(ftp_proxy_port), TRUE);
	gtk_widget_set_sensitive(GTK_WIDGET(ftp_proxy_user), TRUE);

    } else {
	gtk_widget_set_sensitive(GTK_WIDGET(ftp_proxy_host), FALSE);
	gtk_widget_set_sensitive(GTK_WIDGET(ftp_proxy_port), FALSE);
	gtk_widget_set_sensitive(GTK_WIDGET(ftp_proxy_user), FALSE);
    }

    // FTP page stuff:
    gchar *ftp_o[]={"httpproxy", "proxy=", "proxy_user=", "proxytunnel", 
	"socks4", "socks5", NULL};
    gchar **p;
    for (p=ftp_o; p && *p; p++){
	gchar *id_x[]={"-o", *p, NULL};
        gchar *id = FUSE_get_option_id(id_x);
	GtkToggleButton *b = g_object_get_data(G_OBJECT(dialog), id);
	if (b) {
	    if (gtk_toggle_button_get_active(togglebutton)){
		gtk_widget_set_sensitive(GTK_WIDGET(b), FALSE);
		gtk_toggle_button_set_active(b, FALSE);

	    } else {
		gtk_widget_set_sensitive(GTK_WIDGET(b), TRUE);
	    }
	}
	g_free(id);
	gchar *id_e[]={"-o", *p, "Entry", NULL};
        id = FUSE_get_option_id(id_e);
	GtkEntry *e = g_object_get_data(G_OBJECT(dialog), id);
	if (e) {
	    if (gtk_toggle_button_get_active(togglebutton)){
		gtk_widget_set_sensitive(GTK_WIDGET(e), FALSE);
	    } else {
		gtk_widget_set_sensitive(GTK_WIDGET(e), TRUE);
	    }
	}
	g_free(id);
    }

}

static void 
toggle_passive(GtkToggleButton *togglebutton , gpointer data){
    GtkWidget *dialog = data;

    // FTP page stuff:
    gchar *ftp_o[]={"disable_epsv", "enable_epsv", NULL};
    gchar **p;
    for (p=ftp_o; p && *p; p++){
	gchar *id_x[]={"-o", *p, NULL};
        gchar *id = FUSE_get_option_id(id_x);
	GtkToggleButton *b = g_object_get_data(G_OBJECT(dialog), id);
	if (b) {
	    if (gtk_toggle_button_get_active(togglebutton)){
		gtk_widget_set_sensitive(GTK_WIDGET(b), FALSE);
		gtk_toggle_button_set_active(b, FALSE);

	    } else {
		gtk_widget_set_sensitive(GTK_WIDGET(b), TRUE);
	    }
	}
	g_free(id);
    }

}


static
fuse_data_t *
confirm_ftp_host_dialog (widgets_t * widgets_p, const gchar *url) {
    fuse_data_t *fuse_data_p = (fuse_data_t *)FUSE_data_new(NULL);
    if (!fuse_data_p) g_error("cannot allocate fuse_data_p\n");

    fuse_data_p->widgets_p = widgets_p;
    fuse_data_p->url = url;
    fuse_data_p->info1 = FTP_INFO1;
    fuse_data_p->info2 = FTP_INFO2;

    fuse_data_p->dialog = FUSE_init_dialog(fuse_data_p);

    g_object_set_data(G_OBJECT(fuse_data_p->dialog), 
	    "fuse_data_p", fuse_data_p);
    g_object_set_data(G_OBJECT(fuse_data_p->dialog), 
	    "url_template", "ftp");

    GtkWidget *hbox;

    fuse_data_p->item_string = FUSE_COMPUTER;
    fuse_data_p->item_id = "FUSE_COMPUTER";
    FUSE_add_entry(fuse_data_p);

    fuse_data_p->item_string = FUSE_LOGIN;
    fuse_data_p->item_id = "FUSE_LOGIN";
    FUSE_add_entry(fuse_data_p);



    fuse_data_p->item_string = FUSE_MOUNT_POINT;
    fuse_data_p->item_id = "FUSE_MOUNT_POINT";
    hbox =
	FUSE_add_entry(fuse_data_p);
    if (rfm_void(PLUGIN_DIR, "fstab", "module_active")) {
	gtk_widget_set_sensitive(hbox, FALSE);
    }


    fuse_data_p->item_string = FUSE_URL;
    fuse_data_p->item_id = "FUSE_URL";
    FUSE_add_entry(fuse_data_p);
    GtkWidget *entry = g_object_get_data(G_OBJECT(fuse_data_p->dialog), "FUSE_URL");
    const gchar *url_template = g_object_get_data(G_OBJECT(fuse_data_p->dialog),"url_template");
    gchar *u =g_strconcat(url_template, "://", NULL);
    gtk_entry_set_text(GTK_ENTRY(entry), u);
    g_free(u);
    gtk_widget_set_sensitive(entry, FALSE);


    
    fuse_data_p->extra_text = FUSE_CAUTION;
    fuse_data_p->item_string = FUSE_MONITOR;
    fuse_data_p->item_id = "FUSE_MONITOR";
    FUSE_add_check(fuse_data_p);

    fuse_data_p->item_string = FUSE_BROADBAND;
    fuse_data_p->item_id = "FUSE_BROADBAND";
    FUSE_add_check(fuse_data_p);


    fuse_data_p->label = _("FUSE");
    fuse_data_p->options_p = fuse_options;
    fuse_data_p->flag_id = 1;
    FUSE_add_option_page(fuse_data_p);

    fuse_data_p->label = _("FTP");
    fuse_data_p->options_p = ftp_options;
    fuse_data_p->flag_id = 4;
    FUSE_add_option_page(fuse_data_p);

    fuse_data_p->label = _("curlFTPfs");
    fuse_data_p->options_p = curlftpfs_options;
    fuse_data_p->flag_id = 5;
    FUSE_add_option_page(fuse_data_p);

 
    fuse_data_p->label = _("Module");
    fuse_data_p->options_p = module_options;
    fuse_data_p->flag_id = 2;
    FUSE_add_option_page(fuse_data_p);
 

    // Add extra useful items (insensitive)
    //fuse_data_p->key_file = g_object_get(G_OBJECT(fuse_data_p->dialog), "key_file");
    GtkWidget *check;
    
    fuse_data_p->extra_text = NULL;
    fuse_data_p->item_string = FTP_PASSIVE;
    fuse_data_p->item_id = "FTP_PASSIVE";
    FUSE_add_check(fuse_data_p);
    
    fuse_data_p->item_string = FTP_USE_PROXY;
    fuse_data_p->item_id = "FTP_USE_PROXY";
    FUSE_add_check(fuse_data_p);
    check = g_object_get_data(G_OBJECT(fuse_data_p->dialog), "FTP_USE_PROXY");

    fuse_data_p->item_string = FTP_PROXY_HOST;
    fuse_data_p->item_id = "FTP_PROXY_HOST";
    FUSE_add_entry(fuse_data_p);
 
    fuse_data_p->item_string = FTP_PROXY_PORT;
    fuse_data_p->item_id = "FTP_PROXY_PORT";
    FUSE_add_entry(fuse_data_p);
 
    fuse_data_p->item_string = FTP_PROXY_USER;
    fuse_data_p->item_id = "FTP_PROXY_USER";
    FUSE_add_entry(fuse_data_p);


    GtkToggleButton *togglebutton;
    togglebutton = 
	g_object_get_data(G_OBJECT(fuse_data_p->dialog), "FTP_USE_PROXY");
    if (togglebutton){
	g_signal_connect (G_OBJECT(togglebutton), "toggled", G_CALLBACK (toggle_proxy), 
		fuse_data_p->dialog);
    }
    toggle_proxy(togglebutton, fuse_data_p->dialog); 

    togglebutton = 
	g_object_get_data(G_OBJECT(fuse_data_p->dialog), "FTP_PASSIVE");
    if (togglebutton){
	g_signal_connect (G_OBJECT(togglebutton), "toggled", G_CALLBACK (toggle_passive), 
		fuse_data_p->dialog);
    }
    toggle_passive(togglebutton, fuse_data_p->dialog);                                                  
    // This here will clear out the memory key_file, so do any stuff on
    // keyfile before this function call.
    FUSE_reset_url_field(fuse_data_p);
    return fuse_data_p;
}



static gboolean
confirm_ftp_host (widgets_t * widgets_p, const gchar *url) {
    GCond *signal = fuse_hold_monitor(widgets_p);
    fuse_data_t *fuse_data_p = confirm_ftp_host_dialog (widgets_p, url);
    if(!fuse_data_p || !fuse_data_p->dialog){
        return FALSE;
    }
    gint response;
retry:
    response = gtk_dialog_run (GTK_DIALOG (fuse_data_p->dialog));
    gtk_widget_hide (fuse_data_p->dialog);

    gboolean retval;
    if(response == GTK_RESPONSE_YES || response == GTK_RESPONSE_APPLY){
	gchar *new_url = accept(fuse_data_p, url);
	if (!new_url) {
	    gtk_widget_show (fuse_data_p->dialog);
	    goto retry;
	}
	if(response == GTK_RESPONSE_YES) {
	    mount_url(widgets_p, new_url);
	}
	gtk_widget_destroy (fuse_data_p->dialog);
	view_t *view_p = widgets_p->view_p;
	record_entry_t *t_en = rfm_copy_entry(view_p->en);
	if(!rodent_refresh (widgets_p, t_en)) {
	    rfm_destroy_entry(t_en);
	}
        retval = TRUE;
    } else {
	gtk_widget_destroy (fuse_data_p->dialog);
        retval = FALSE;
    }
    g_cond_signal(signal);
    return retval;
}
//////////////////////////////////////////////////////////////////////////////////


