//
//

static gchar **cifs_option_keys = NULL;
static  GroupOptions cifs_options[]={
//linux options:
    {
	.sensitive = 0, .flag = "-o", .id = "user=", 
        .tip = N_("Specifies the username to connect as. If this is not given, then the environment variable USER is used.\n\n This option can also take the form \"user\%password\" or \"workgroup/user\" or \"workgroup/user\%password\" to allow the password and workgroup to be specified as part of the username."), 
	.entry = "USER"
    },

    {
	.sensitive = 1, .flag = "-o", .id = "password=", 
	.tip = N_("Specifies the CIFS password.\n\n If this option is not given then the environment variable PASSWD is used.\n\n If the password is not specified directly or indirectly via an argument to mount, mount.cifs will prompt for a password, unless the guest option is specified.\n\n Note that a password which contains the delimiter character (i.e. a comma \',\') will fail to be parsed correctly on the command line.\n\n However, the same password defined in the PASSWD environment variable or via a credentials file (see below) or entered at the password prompt will be read correctly."), 
	.entry = "PASSWD"
    },


    {
	.sensitive = 1, .flag = "-o", .id = "credentials=", 
        .tip = N_("Specifies a file that contains a username and/or password and optionally the name of the workgroup.\n\n The format of the file is:\n\n\tusername=value\n\tpassword=value\n\tdomain=value\n\nThis is preferred over having passwords in plaintext in a shared file, such as /etc/fstab.\n\n Be sure to protect any credentials file properly.\n"),

	.entry = "filename"
    },


    {
	.sensitive = 1, .flag = "-o", .id = "uid=", 
        .tip = N_("Sets the uid that will own all files or directories on the mounted filesystem when the server does not provide ownership information.\n\n It may be specified as either a username or a numeric uid.\n\n When not specified, the default is uid 0.\n\n The mount.cifs helper must be at version 1.10 or higher to support specifying the uid in non-numeric form."),

	.entry = "uid"
    },


    {
	.sensitive = 1, .flag = "-o", .id = "forceuid", 
        .tip = N_("Instructs the client to ignore any uid provided by the server for files and directories and to always assign the owner to be the value of the uid= option."), 
	.entry = NULL
    },


    {
	.sensitive = 1, .flag = "-o", .id = "gid=", 
        .tip = N_("Sets the gid that will own all files or directories on the mounted filesystem when the server does not provide ownership information.\n\n It may be specified as either a groupname or a numeric gid.\n\n When not specified, the default is gid 0.\n\n The mount.cifs helper must be at version 1.10 or higher to support specifying the gid in non-numeric form."), 
	.entry = "gid"
    },


    {
	.sensitive = 1, .flag = "-o", .id = "forcegid", 
        .tip = N_("Instructs the client to ignore any gid provided by the server for files and directories and to always assign the owner to be the value of the gid= option."), 
	.entry = NULL
    },


    {
	.sensitive = 1, .flag = "-o", .id = "port=", 
        .tip = N_("Sets the port number on the server to attempt to contact to negotiate CIFS support.\n\n If the CIFS server is not listening on this port or if it is not specified, the default ports will be tried i.e. port 445 is tried and if no response then port 139 is tried."), 
	.entry = "arg"
    },



    {
	.sensitive = 1, .flag = "-o", .id = "servern=", 
        .tip = N_("Specify the server netbios name (RFC1001 name) to use when attempting to setup a session to the server.\n\n Although rarely needed for mounting to newer servers, this option is needed for mounting to some older servers (such as OS/2 or Windows 98 and Windows ME) since when connecting over port 139 they, unlike most newer servers, do not support a default server name.\n\n A server name can be up to 15 characters long and is usually uppercased."), 
	.entry = "arg"
    },



    {
	.sensitive = 1, .flag = "-o", .id = "netbiosname=", 
        .tip = N_("When mounting to servers via port 139, specifies the RFC1001 source name to use to represent the client netbios machine name when doing the RFC1001 netbios session initialize."), 
	.entry = "arg"
    },



    {
	.sensitive = 1, .flag = "-o", .id = "file_mode=", 
        .tip = N_("If the server does not support the CIFS Unix extensions this overrides the default file mode."), 
	.entry = "arg"
    },



    {
	.sensitive = 1, .flag = "-o", .id = "dir_mode=", 
        .tip = N_("If the server does not support the CIFS Unix extensions this overrides the default mode for directories."), 
	.entry = "fillme"
    },



    {
	.sensitive = 1, .flag = "-o", .id = "ip=", 
        .tip = N_("Sets the destination IP address.\n\n This option is set automatically if the server name portion of the requested UNC name can be resolved so rarely needs to be specified by the user."), 
	.entry = "arg"
    },



    {
	.sensitive = 1, .flag = "-o", .id = "domain=", 
        .tip = N_("Sets the domain (workgroup) of the user"), 
	.entry = "arg"
    },



    {
	.sensitive = 1, .flag = "-o", .id = "guest", 
        .tip = N_("Don\'t prompt for a password"), 
	.entry = NULL
    },




    {
	.sensitive = 1, .flag = "-o", .id = "iocharset", 
        .tip = N_("Charset used to convert local path names to and from Unicode.\n\n Unicode is used by default for network path names if the server supports it.\n\n If iocharset is not specified then the nls_default specified during the local client kernel build will be used. If server does not support Unicode, this parameter is unused."), 
	.entry = NULL
    },




    {
	.sensitive = 1, .flag = "-o", .id = "ro", 
        .text = N_("Mount read-only"), 
	.entry = NULL
    },



    {
	.sensitive = 1, .flag = "-o", .id = "rw", 
        .text = N_("Mount read-write"), 
	.entry = NULL
    },



    {
	.sensitive = 1, .flag = "-o", .id = "setuids", 
        .tip = N_("If the CIFS Unix extensions are negotiated with the server the client will attempt to set the effective uid and gid of the local process on newly created files, directories, and devices (create, mkdir, mknod).\n\n If the CIFS Unix Extensions are not negotiated, for newly created files and directories instead of using the default uid and gid specified on the the mount, cache the new file\'s uid and gid locally which means that the uid for the file can change when the inode is reloaded (or the user remounts the share)."), 
	.entry = NULL
    },




    {
	.sensitive = 1, .flag = "-o", .id = "nosetuids", 
        .tip = N_("The client will not attempt to set the uid and gid on on newly created files, directories, and devices (create, mkdir, mknod) which will result in the server setting the uid and gid to the default (usually the server uid of the user who mounted the share).\n\n Letting the server (rather than the client) set the uid and gid is the default.\n\nIf the CIFS Unix Extensions are not negotiated then the uid and gid for new files will appear to be the uid (gid) of the mounter or the uid (gid) parameter specified on the mount."), 
	.entry = NULL
    },




    {
	.sensitive = 1, .flag = "-o", .id = "perm", 
        .tip = N_("Client does permission checks (vfs_permission check of uid and gid of the file against the mode and desired operation).\n\n Note that this is in addition to the normal ACL check on the target machine done by the server software. Client permission checking is enabled by default."), 
	.entry = NULL
    },




    {
	.sensitive = 1, .flag = "-o", .id = "noperm", 
        .tip = N_("Client does not do permission checks.\n\n This can expose files on this mount to access by other users on the local client system.\n\n It is typically only needed when the server supports the CIFS Unix Extensions but the UIDs/GIDs on the client and server system do not match closely enough to allow access by the user doing the mount.\n\n Note that this does not affect the normal ACL check on the target machine done by the server software (of the server ACL against the user name provided at mount time)."), 
	.entry = NULL
    },




    {
	.sensitive = 1, .flag = "-o", .id = "dynperm", 
        .tip = N_("Instructs the server to maintain ownership and permissions in memory that can\'t be stored on the server.\n\n This information can disappear at any time (whenever the inode is flushed from the cache), so while this may help make some applications work, it\'s behavior is somewhat unreliable."), 
	.entry = NULL
    },




    {
	.sensitive = 1, .flag = "-o", .id = "directio", 
        .tip = N_("Do not do inode data caching on files opened on this mount. This precludes mmaping files on this mount.\n\n In some cases with fast networks and little or no caching benefits on the client (e.g. when the application is doing large sequential reads bigger than page size without rereading the same data) this can provide better performance than the default behavior which caches reads (readahead) and writes (writebehind) through the local Linux client pagecache if oplock (caching token) is granted and held.\n\n Note that direct allows write operations larger than page size to be sent to the server.\n\n On some kernels this requires the cifs.ko module to be built with the CIFS_EXPERIMENTAL configure option."), 
	.entry = NULL
    },




    {
	.sensitive = 1, .flag = "-o", .id = "mapchars", 
        .tip = N_("Translate six of the seven reserved characters (not backslash, but including the colon, question mark, pipe, asterik, greater than and less than characters) to the remap range (above 0xF000), which also allows the CIFS client to recognize files created with such characters by Windows\'s POSIX emulation.\n\n This can also be useful when mounting to most versions of Samba (which also forbids creating and opening files whose names contain any of these seven characters).\n\n This has no effect if the server does not support Unicode on the wire.\n\n Please note that the files created with mapchars mount option may not be accessible if the share is mounted without that option."), 
	.entry = NULL
    },




    {
	.sensitive = 1, .flag = "-o", .id = "nomapchars", 
        .tip = N_("Do not translate any of these seven reserved characters (not backslash, but including the colon, question mark, pipe, asterik, greater than and less than characters).\n\n This is the default."), 
	.entry = NULL
    },




    {
	.sensitive = 1, .flag = "-o", .id = "intr", 
        .text = N_("Currently unimplemented"), 
	.entry = NULL
    },




    {
	.sensitive = 1, .flag = "-o", .id = "nointr", 
        .text = N_("Currently unimplemented (default)"), 
	.entry = NULL
    },




    {
	.sensitive = 1, .flag = "-o", .id = "hard", 
        .tip = N_("The program accessing a file on the cifs mounted file system will hang when the server crashes."), 
	.entry = NULL
    },


    {
	.sensitive = 1, .flag = "-o", .id = "soft", 
        .tip = N_("(default) The program accessing a file on the cifs mounted file system will not hang when the server crashes and will return errors to the user application."), 
	.entry = NULL
    },



    {
	.sensitive = 1, .flag = "-o", .id = "noacl", 
        .tip = N_("Do not allow POSIX ACL operations even if server would support them.\n\n  The CIFS client can get and set POSIX ACLs (getfacl, setfacl) to Samba servers version 3.0.10 and later.\n\n Setting POSIX ACLs requires enabling both XATTR and then POSIX support in the CIFS configuration options when building the cifs module.\n\n POSIX ACL support can be disabled on a per mount basis by specifying \"noacl\" on mount."), 
	.entry = NULL
    },



    {
	.sensitive = 1, .flag = "-o", .id = "nocase", 
        .tip = N_("Request case insensitive path name matching (case sensitive is the default if the server suports it)."), 
	.entry = NULL
    },



    {
	.sensitive = 1, .flag = "-o", .id = "sec=", 
        .tip = N_("Security mode. Allowed values are:\n\n\t- none attempt to connection as a null user (no name)\n\t- krb5 Use Kerberos version 5 authentication\n\t- krb5i Use Kerberos authentication and packet signing\n\t- ntlm Use NTLM password hashing (default)\n\t- ntlmi Use NTLM password hashing with signing (if /proc/fs/cifs/PacketSigningEnabled on or if server requires signing also can be the default)\n\t- ntlmv2 Use NTLMv2 password hashing\n\t- ntlmv2i Use NTLMv2 password hashing with packet signing \n\n[NB This [sec parameter] is under development and expected to be available in cifs kernel module 1.40 and later]"), 
	.entry = "arg"
    },



    {
	.sensitive = 1, .flag = "-o", .id = "nobrl", 
        .tip = N_("Do not send byte range lock requests to the server.\n\nThis is necessary for certain applications that break with cifs style mandatory byte range locks (and most cifs servers do not yet support requesting advisory byte range locks)."), 
	.entry = NULL
    },


    {
	.sensitive = 1, .flag = "-o", .id = "sfu", 
        .tip = N_("When the CIFS Unix Extensions are not negotiated, attempt to create device files and fifos in a format compatible with Services for Unix (SFU).\n\n In addition retrieve bits 10-12 of the mode via the SETFILEBITS extended attribute (as SFU does). In the future the bottom 9 bits of the mode mode also will be emulated using queries of the security descriptor (ACL). [NB: requires version 1.39 or later of the CIFS VFS.\n\n To recognize symlinks and be able to create symlinks in an SFU interoperable form requires version 1.40 or later of the CIFS VFS kernel module."), 
	.entry = NULL
    },


    {
	.sensitive = 1, .flag = "-o", .id = "serverino", 
        .tip = N_("Use inode numbers (unique persistent file identifiers) returned by the server instead of automatically generating temporary inode numbers on the client.\n\n Although server inode numbers make it easier to spot hardlinked files (as they will have the same inode numbers) and inode numbers may be persistent (which is userful for some sofware), the server does not guarantee that the inode numbers are unique if multiple server side mounts are exported under a single share (since inode numbers on the servers might not be unique if multiple filesystems are mounted under the same shared higher level directory).\n\n Note that not all servers support returning server inode numbers, although those that support the CIFS Unix Extensions, and Windows 2000 and later servers typically do support this (although not necessarily on every local server filesystem). Parameter has no effect if the server lacks support for returning inode numbers or equivalent."), 
	.entry = NULL
    },


    {
	.sensitive = 1, .flag = "-o", .id = "noserverino", 
        .tip = N_("Client generates inode numbers (rather than using the actual one from the server) by default."), 
	.entry = NULL
    },


    {
	.sensitive = 1, .flag = "-o", .id = "nounix", 
        .tip = N_("Disable the CIFS Unix Extensions for this mount.\n\n This can be useful in order to turn off multiple settings at once.\n\n This includes POSIX acls, POSIX locks, POSIX paths, symlink support and retrieving uids/gids/mode from the server.\n\n This can also be useful to work around a bug in a server that supports Unix Extensions."), 
	.entry = NULL
    },


    {
	.sensitive = 1, .flag = "-o", .id = "nouser_xattr", 
        .tip = N_("(default) Do not allow getfattr/setfattr to get/set xattrs, even if server would support it otherwise."), 
	.entry = NULL
    },


    {
	.sensitive = 1, .flag = "-o", .id = "rsize=", 
        .tip = N_("Default network read size (usually 16K).\n\n The client currently can not use rsize larger than CIFSMaxBufSize.\n\n CIFSMaxBufSize defaults to 16K and may be changed (from 8K to the maximum kmalloc size allowed by your kernel) at module install time for cifs.ko. Setting CIFSMaxBufSize to a very large value will cause cifs to use more memory and may reduce performance in some cases.\n\n To use rsize greater than 127K (the original cifs protocol maximum) also requires that the server support a new Unix Capability flag (for very large read) which some newer servers (e.g. Samba 3.0.26 or later) do.\n\n rsize can be set from a minimum of 2048 to a maximum of 130048 (127K or CIFSMaxBufSize, whichever is smaller)"), 
	.entry = "arg"
    },



    {
	.sensitive = 1, .flag = "-o", .id = "wsize=", 
        .tip = N_("default network write size (default 57344) maximum wsize currently allowed by CIFS is 57344 (fourteen 4096 byte pages)"), 
	.entry = "arg"
    },



    {
	.sensitive = 1, .flag = "--verbose", .id = "", 
        .tip = N_("Print additional debugging information for the mount.\n\n Note that this parameter must be specified before the -o. For example:\n\n\t mount -t cifs //server/share /mnt --verbose -o user=username"), 
	.entry = NULL
    },


    
    {.sensitive = 1, NULL, NULL, NULL, .entry = NULL}
};


