//
//

/*
 * Copyright (C) 2002-2012 Edscott Wilson Garcia
 * EMail: edscott@xfce.org
 *
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */
typedef struct thread_run_t {
    char *wd;
    char **argv;
} thread_run_t;

typedef struct run_data_t {
    widgets_t *widgets_p;
    pid_t pid;
    gchar *command;
    gchar *workdir;
    GtkWidget *button;
} run_data_t;

/***************  threaded ****************/


static
  gboolean
check_sudo (void) {
    return TRUE;
}
#if 0
FIXME: do the sudo check in configure, or else... tough luck
    // 1. check for sudo askpass option
    FILE *pipe;
    gboolean askpass = FALSE;
    pipe = popen ("sudo -L", "r");
    if(pipe) {
#define PAGE_LINE 2048*8
        char line[PAGE_LINE];
        line[PAGE_LINE - 1] = 0;
        while(fgets (line, PAGE_LINE - 1, pipe) && !feof (pipe)) {
            if(strstr (line, "askpass"))
                askpass = TRUE;
        }
        pclose (pipe);
    }
    if(!askpass) {
        g_warning ("Sudo version obsolete. Please update sudo!\n");
    }
    return askpass;
}
#endif

// This is a thread function, must have GDK mutex set for gtk commands...
static
void
run_fork_finished_function (void *user_data) {
    widgets_t *safe_widgets_p = user_data;

#if 0
    gchar *g = g_strdup_printf ("Cleanup: %d> pid=%d", Tubo_id () - 1, getpid());
GDK_THREADS_ENTER ();
    if(rfm_diagnostics_is_visible (safe_widgets_p)) {
        rfm_diagnostics (safe_widgets_p, "xffm_tag/command_id", g, NULL);
        rfm_diagnostics (safe_widgets_p, "xffm/stock_no", "\n", NULL);
        GDK_THREADS_LEAVE ();
    }
GDK_THREADS_LEAVE ();
    g_free (g);
#endif
    g_free (safe_widgets_p);

}

static GMutex *fork_mutex=NULL;
static void
fork_function (void *data) {
    gchar **argv = (char **)data;

    gint i = 0;
    static gchar *sudo_cmd=NULL;
    if (!fork_mutex) fork_mutex=g_mutex_new();
    g_mutex_lock(fork_mutex);
    g_free(sudo_cmd);
    sudo_cmd=NULL;
    for(i=0; argv && argv[i] && i < 5; i++) {
	if(!sudo_cmd && 
		(strstr (argv[i], "sudo") ||
		 strstr (argv[i], "ssh"))) {
	    sudo_cmd=g_strdup_printf("<b>%s</b> ", argv[i]);
	    continue;
	} 	
	if (sudo_cmd){
	    if (strchr(argv[i], '&')){
	        gchar **a = g_strsplit(argv[i], "&", -1);
		gchar **p=a;
		for (;p && *p; p++){
		    gchar *space = (strlen(*p))?" ":"";
		    gchar *amp = (*(p+1))?"&amp;":"";
		    gchar *g = g_strconcat(sudo_cmd,  space, "<i>",*p, amp, "</i>", NULL);
		    g_free(sudo_cmd);
		    sudo_cmd=g;
		}
		g_strfreev(a);
	    } else {
		gchar *a = g_strdup(argv[i]);
		if (strlen(a) >13) {
		    a[12] = 0;
		    a[11] = '.';
		    a[10] = '.';
		    a[9] = '.';
		}
		gchar *g = g_strconcat(sudo_cmd,  " <i>",a, "</i>", NULL);
		g_free(a);
		g_free(sudo_cmd);
		sudo_cmd=g;
	    }
	}
    }


    if (i>=MAX_COMMAND_ARGS - 1) {
    	DBG("%s: (> %d)\n", strerror(E2BIG), MAX_COMMAND_ARGS);
	argv[MAX_COMMAND_ARGS - 1]=NULL;
    }

    if (sudo_cmd) {
	gchar *g = g_strconcat(sudo_cmd,  "\n", NULL);
	g_free(sudo_cmd);
	sudo_cmd = g;
	setenv("RFM_SUDO_COMMAND", sudo_cmd, 1);
    }
    g_mutex_unlock(fork_mutex);
    execvp (argv[0], argv);
    g_warning ("CHILD could not execvp: this should not happen\n");
    g_warning ("Do you have %s in your path?\n", argv[0]);
    rfm_threadwait ();
    _exit (123);
}

static gboolean
destroy_run_button (GtkWidget * widget, GdkEvent * event, gpointer data) {
    run_data_t *run_data_p = (run_data_t *) data;
    NOOP ("destroy_run_button now!\n");
    if(!data)
        return TRUE;
    run_data_p->button = NULL;
    NOOP ("run_data_p->button = NULL\n");
    return TRUE;
}


static void
show_run_info (GtkButton * button, gpointer data) {
    run_data_t *run_data_p = data;
    if (rfm_void(PLUGIN_DIR, "ps", "module_active")){
	gchar *ps_module = g_find_program_in_path("rodent-ps");
	if (ps_module) {
	    gchar *command=g_strdup_printf("%s %d",
		    ps_module, (gint) run_data_p->pid);
	    GError *error=NULL;
	    if (!g_spawn_command_line_async (command, &error)){
		g_warning("%s: %s", ps_module, error->message);
		g_error_free(error);
		g_free(command);
		// here we default to the terminate dialog...
	    } else {
		g_free(command);
		return;
	    }
	}
    } else { // no rodent-ps
	gchar *text2 =g_strdup_printf ("%s %s: %s\n\n%s %s (%d)?",
		_("Kill (KILL)"), run_data_p->command, 
		strerror(ETIMEDOUT), 
		_("Kill"), run_data_p->command, run_data_p->pid);
	GDK_THREADS_ENTER ();
	if(rfm_confirm (run_data_p->widgets_p, GTK_MESSAGE_QUESTION, text2, _("No"), _("Yes"))) {
	    // SIGUSR2 will pass on a SIGKILL signal
	    gchar *gg = g_strdup_printf ("%d", (int)(run_data_p->pid));
	    rfm_diagnostics (run_data_p->widgets_p, "xffm/stock_dialog-warning", NULL);
	    rfm_diagnostics (run_data_p->widgets_p, "xffm_tag/command_id",
		    _("Kill (KILL)"), " ", gg, "\n", NULL);
	    g_free (gg);
	    kill (run_data_p->pid, SIGUSR2);
	}
	GDK_THREADS_LEAVE ();
	g_free (text2);
    }
}

static GtkWidget *
make_run_data_button (run_data_t * run_data_p) {

    if(run_data_p->widgets_p->button_space) {
	gchar *tip=g_strdup_printf("%s (%d)",  
		run_data_p->command, run_data_p->pid);
	const gchar *icon_id=(rfm_void(PLUGIN_DIR, "ps", "module_active"))?
		"xffm/stock_execute": "xffm/stock_stop";
        run_data_p->button =
            rfm_mk_little_button (icon_id,
                                  (gpointer) show_run_info, run_data_p,
				  tip);
	g_free(tip);
        gtk_box_pack_end (GTK_BOX (run_data_p->widgets_p->button_space), run_data_p->button, FALSE, FALSE, 0);
        g_signal_connect (G_OBJECT (run_data_p->button), "destroy_event", G_CALLBACK (destroy_run_button), run_data_p);
        gtk_widget_show (run_data_p->button);
        NOOP ("DIAGNOSTICS:srun_button made for grandchildPID=%d\n", (int)run_data_p->pid);
    }
    return run_data_p->button;
}

// This is a thread function, must have GDK mutex set for gtk commands...
static gpointer
thread_run_f (gpointer data) {
    run_data_t *run_data_p = (run_data_t *) data;

    /* create little button (note: thread protected within subroutine) */
GDK_THREADS_ENTER ();
    make_run_data_button (run_data_p);
    
    view_t *view_p = run_data_p->widgets_p->view_p;
    if (view_p) {
	increment_view_ref(view_p);
    }

GDK_THREADS_LEAVE ();
    NOOP ("grand---thread waitpid for %d on (%s/%s)\n", run_data_p->pid, run_data_p->command, run_data_p->workdir);

    gint status;
    waitpid (run_data_p->pid, &status, 0);

    NOOP ("grand---thread waitpid for %d complete!\n", run_data_p->pid);
    /* remove little button (thread protect gtk here) */

    // Trigger reload to all tabbed views.
    GSList *list = (rfm_global_p==NULL)?NULL: rfm_global_p->window_view_list;
    for (; list && list->data; list = list->next){
	view_t *view_p = list-> data;
	//rodent_unselect_all_pixbuf(view_p);
	if (!xfdir_monitor_control_greenlight(&(view_p->widgets)))
	{
	    rodent_trigger_reload(view_p);
	}
    }

    if(run_data_p->button && GTK_IS_WIDGET(run_data_p->button)){
	// Run has completed.   
    GDK_THREADS_ENTER ();
	gtk_widget_hide(GTK_WIDGET (run_data_p->button));
        gtk_widget_destroy (GTK_WIDGET (run_data_p->button));
    GDK_THREADS_LEAVE ();
    }
    if (view_p) {
	decrement_view_ref(view_p);
    }
    g_free (run_data_p->command);
    g_free (run_data_p->workdir);
    g_free (run_data_p);

    return NULL;
}


static void
setup_run_button_thread (widgets_t * widgets_p, const gchar * exec_command, pid_t child) {
    TRACE ("setup_run_button_thread(), grandchildPID=%d\n", (int)child);
    run_data_t *run_data_p = (run_data_t *) malloc (sizeof (run_data_t));
    if (!run_data_p) g_error("malloc: %s", strerror(errno));
    memset (run_data_p, 0, sizeof (run_data_t));

    run_data_p->button = NULL;
    run_data_p->pid = child;
    run_data_p->command = g_strdup (exec_command);
    if (widgets_p->workdir) {
	run_data_p->workdir = g_strdup (widgets_p->workdir);
    } else {
	run_data_p->workdir = g_strdup (g_get_home_dir());
    }
    run_data_p->widgets_p = widgets_p;

    THREAD_CREATE (thread_run_f, (gpointer) run_data_p, "thread_run_f");
}

static 
widgets_t *
fallback(widgets_t *widgets_p){
    static widgets_t *fallback_widgets_p=NULL;
    if (widgets_p) {
	return widgets_p;
    } else {
	if (fallback_widgets_p == NULL){
	    fallback_widgets_p = (widgets_t *)malloc(sizeof(widgets_t));
	    memset(fallback_widgets_p, 0, sizeof(widgets_t));
	    fallback_widgets_p->diagnostics_window=(GtkWidget **)malloc(sizeof(GtkWidget *));
	    *(fallback_widgets_p->diagnostics_window) = NULL;
	    fallback_widgets_p->workdir=g_strdup(g_get_home_dir());
	    rfm_create_diagnostics_window (fallback_widgets_p);
	}
	// default is to show the window if desktop
	// verbose diagnostics is enabled.
	// FIXME: This is borked... in properties dialog with 
	// try_sudo, window is shown without output
	// when verbose diagnostics is enabled.
	// For now, we will not show window until
	// issue is resolved
	if(fallback_widgets_p->diagnostics_window && 
	    (!getenv ("RFM_ENABLE_DESKTOP_DIAGNOSTICS") || 
	    strlen (getenv ("RFM_ENABLE_DESKTOP_DIAGNOSTICS"))==0) 
	    )
	{
	    //gtk_widget_show_all(*(fallback_widgets_p->diagnostics_window));
	} else {
	    gtk_widget_hide(*(fallback_widgets_p->diagnostics_window));
	}

    } 
    return fallback_widgets_p;
}
static pid_t
thread_run (
	widgets_t * in_widgets_p, 
	gchar ** argv, 
	gint *stdin_fd,
	void (*stdout_f) (void *stdout_data,
                      void *stream,
                      int childFD),
	void (*stderr_f) (void *stderr_data,
                      void *stream,
                      int childFD),
	void (*tubo_done_f) (void *data)
	) {

    NOOP( "At thread_run()\n");
	
    widgets_t *widgets_p;
    
    if (!in_widgets_p) {
	g_warning("widgets_p == NULL at thread_run() in primary-run.i. Using fallback.\n");
	widgets_p = fallback(in_widgets_p);
    } else {
	widgets_p = in_widgets_p;
    }
    
	

    /*if(!rfm_g_file_test (widgets_p->workdir, G_FILE_TEST_IS_DIR)) {
        g_free (widgets_p->workdir);
        widgets_p->workdir = g_strdup (g_get_home_dir ());
    }*/
    if(widgets_p && widgets_p->workdir && strcmp(g_get_home_dir(),widgets_p->workdir)){
	NOOP( "At chdir(%s)\n", widgets_p->workdir);
	if (chdir (widgets_p->workdir) < 0) {
	    g_warning ("chdir(%s): %s", widgets_p->workdir, strerror (errno));
	}
    } else {
	if (chdir (g_get_home_dir()) < 0) {
	    g_warning ("chdir(%s): %s", g_get_home_dir(), strerror (errno));
	}
    }
    NOOP( "At g_find_program_in_path()\n");
    gchar *g = g_find_program_in_path (argv[0]);
    if(g)
        g_free (g);
    else {
      if (rfm_global_p && g_thread_self() == rfm_global_p->self) {
        rfm_show_text(widgets_p);
        rfm_diagnostics (widgets_p, "xffm/stock_dialog-error", NULL);
        rfm_diagnostics (widgets_p, "xffm_tag/stderr", argv[0], ": ", strerror (ENOENT), "\n", NULL);
        return -1;
    }}


    NOOP( "At safe_widgets_p\n");
    widgets_t *safe_widgets_p;
    safe_widgets_p=(widgets_t *)malloc(sizeof(widgets_t));


    if (widgets_p->diagnostics_window==NULL) {
	memset(safe_widgets_p, 0, sizeof(widgets_t));	
	safe_widgets_p->diagnostics = widgets_p->diagnostics;
	safe_widgets_p->window = widgets_p->window;
	safe_widgets_p->view_p = widgets_p->view_p;
    } else {
	memcpy(safe_widgets_p, widgets_p, sizeof(widgets_t));
	safe_widgets_p->diagnostics=widgets_p->diagnostics;
	safe_widgets_p->diagnostics_window=widgets_p->diagnostics_window;
	safe_widgets_p->window = widgets_p->window;
	//*safe_widgets_p->diagnostics_window=*widgets_p->diagnostics_window;
    }
    pid_t child = 0;
    NOOP( "exec Tubo() now\n");
    child = Tubo_threads (fork_function,
		  (void *)argv,
		  stdin_fd,
		  (stdout_f)?stdout_f:rfm_operate_stdout,
		  (stderr_f)?stderr_f:rfm_operate_stderr,
		  (tubo_done_f)?tubo_done_f:run_fork_finished_function,
		  (void *)safe_widgets_p,
		  FALSE,
		  TRUE);
       
	g_free (widgets_p->workdir);
	widgets_p->workdir = g_strdup (GETWD);

    SETWD();
    // Trigger a monitor reload condition now.
    // This is to get any initial changes to the view before the command completes

    xfdir_monitor_control_greenlight(in_widgets_p);
    
    return child;

}

static
pid_t
private_rfm_thread_run_argv (
	widgets_t * in_widgets_p, 
	gchar ** argv, gboolean interm, 
	gint *stdin_fd,
	void (*stdout_f) (void *stdout_data,
                      void *stream,
                      int childFD),
	void (*stderr_f) (void *stderr_data,
                      void *stream,
                      int childFD),
	void (*tubo_done_f) (void *data)
	) {
    int i = 0;
    gchar *v_argv[MAX_COMMAND_ARGS];
    const gchar *term = NULL;
    NOOP( "At private_rfm_thread_run_argv()\n");
    if(interm) {
	term = rfm_what_term ();
        const gchar *exec_option = rfm_term_exec_option(term);
        v_argv[i++] = (gchar *)term;
        v_argv[i++] = (gchar *)exec_option;
    }

    widgets_t *widgets_p = fallback(in_widgets_p);
 
    gchar **p;
    for(p = argv; p && *p && i < MAX_COMMAND_ARGS - 2; p++) {
        v_argv[i++] = *p;
    }
    v_argv[i] = NULL;
    if (rfm_global_p && g_thread_self() == rfm_global_p->self) {
      if (i==MAX_COMMAND_ARGS - 1) {
	rfm_show_text(widgets_p);
    	rfm_diagnostics(widgets_p,"xffm/stock_dialog-error",NULL);
        gchar *max=g_strdup_printf("%d",MAX_COMMAND_ARGS);
        rfm_diagnostics (widgets_p, "xffm_tag/stderr", strerror(E2BIG)," (> ",max,")","\n", NULL);
        g_free(max);
    }}
    int id=Tubo_id ();
    gchar *command = g_strdup (v_argv[0]);
    gchar *qq;
    for(i = 1; v_argv[i]; i++) {
            qq = command;
            command = g_strconcat (qq, " ", v_argv[i], NULL);
            g_free (qq);
    }
    gchar *s = strstr(command, "password=");
    if (s) {
	s = s + strlen("password=");
	for (; s && *s && *s !=' ' && *s !=','; s++) *s = '*';
    }
	

    pid_t child = thread_run (widgets_p, v_argv, stdin_fd, stdout_f, stderr_f, NULL);
    if (rfm_global_p && g_thread_self() == rfm_global_p->self) {
      if(rfm_diagnostics_is_visible (widgets_p)) {
        gchar *g = g_strdup_printf ("%d> (%d):", id, child);
        rfm_diagnostics (widgets_p, "xffm/stock_execute", NULL);
        rfm_diagnostics (widgets_p, "xffm_tag/command_id", g, NULL);
        rfm_diagnostics (widgets_p, "xffm_tag/command", command, "\n", NULL);
        g_free (g);
    }}


    if(widgets_p && child > 0) {
        setup_run_button_thread (widgets_p, command, child);
    }
    g_free (command);
    return child;
}



/*******************************************/

