/*
 *
 * (C) Edscott Wilson Garcia 2001-2011 edscott@xfce.org.
 *
 *
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#ifdef HAVE_CONFIG_H
# include <config.h>
#endif

#include "rodent_libs.h"

/* this should be first 2 lines after headers: */
G_MODULE_EXPORT LIBRFM_MODULE

typedef struct cache_info_t {
    gchar version[64];
    long long basedir_sum;
    gchar supported_regex[256];
} cache_info_t;

#include "icon-module.h"

gchar *mime_icon_get_local_xml_file (void);
gchar *mime_icon_get_global_xml_file (void);

static GHashTable *basename_hash = NULL;
static GStaticRWLock basename_lock = G_STATIC_RW_LOCK_INIT;


#include "icon-module-mime.i"
#include "icon-module-theme.i"
/******************************************************************/
// Condition variable:
static gboolean load_status = FALSE;
// Condition mutex:
static GMutex *load_status_mutex = NULL;
// Condition signal:
static GCond *load_signal = NULL;

G_MODULE_EXPORT 
void *
module_active (void){
    NOOP ("ICON: module_active...\n");
    void *status;
    g_mutex_lock(load_status_mutex);
    status = GINT_TO_POINTER(load_status);
    g_mutex_unlock(load_status_mutex);
    return status;
}

G_MODULE_EXPORT 
void *
g_module_check_init (GModule * module) {
    NOOP (stderr, "ICON: g_module_check_init...\n");
    load_status_mutex = g_mutex_new();
    load_signal = g_cond_new();
    
    gboolean status = load_rodent_theme ();
    g_mutex_lock(load_status_mutex);
    load_status = status;
    if (status) g_cond_broadcast(load_signal);
    g_mutex_unlock(load_status_mutex);

    return NULL;
}

G_MODULE_EXPORT 
gchar *
mime_icon_get_local_xml_file (void) {
    NOOP ("ICON: mime_icon_get_local_xml_file...\n");
    gchar *mimefile;
    mimefile = g_build_filename (ICON_MODULE_USER_XML, NULL);
    return mimefile;
}


G_MODULE_EXPORT 
gchar *
mime_icon_get_global_xml_file (void) {
    NOOP ("ICON: mime_icon_get_global_xml_file...\n");
    gchar *mimefile = g_build_filename(ICON_MODULE_XML, NULL);

    NOOP ("ICON: mime_icon_get_global_xml_file...3:%s\n", mimefile);
    return mimefile;
}

G_MODULE_EXPORT 
gchar *
mime_icon_get_filename_from_basename (const gchar * basename) {
    g_mutex_lock(load_status_mutex);
    if (!load_status) g_cond_wait(load_signal, load_status_mutex);
    g_mutex_unlock(load_status_mutex);
    NOOP ("ICON: mime_icon_get_filename_from_basename...\n");
    gchar *file = NULL;
    // Use default theme if so configured in the user environment.
    gboolean gtk_theme = (getenv("RFM_USE_GTK_ICON_THEME") &&
			    strlen(getenv("RFM_USE_GTK_ICON_THEME")));
    if (gtk_theme) {
	file = get_dbh_pixmap_path ("GTK", basename);
    }
    // Fallback to Rodent theme in dbh cache...
    if (!file) {
	NOOP("no theme file for %s\n", basename);
	file = get_dbh_pixmap_path (NULL, basename);
    } else {
	NOOP ("gtk default theme: %s --> %s\n", basename, file);
    }

    return (file);
}

G_MODULE_EXPORT 
gchar *
mime_icon_get_filename_from_id (const gchar * id) {
    g_mutex_lock(load_status_mutex);
    if (!load_status) {
	DBG("mime_icon_get_filename_from_id(): WAITING for load_signal\n");
	g_cond_wait(load_signal, load_status_mutex);
    }
    g_mutex_unlock(load_status_mutex);
    NOOP ("ICON: mime_icon_get_filename_from_id...\n");
/*    gchar *id=g_strdup(in_id);
    if (strstr(id, "/composite")){
	*strstr(id, "/composite")=0;
    }*/
    const gchar *basename=NULL;
    NOOP ("ICON: g_hash_table_lookup: %s\n", id);
    // Short circuit builtin stock gtk items, if using gtk icon theme.
    // Nah! problem with stock icon sizes from builtin pixbufs...
    //if (icontheme_hash && strncmp(id, "xffm/stock_", strlen("xffm/stock_"))==0) {
	//return NULL;
    //}
    // Look for basename in hashtable...
    gchar *hash_key=rfm_get_hash_key(id, 0);
    g_static_rw_lock_reader_lock(&basename_lock);
    if (basename_hash){
        NOOP(stderr, "0x%x: lookup 1 basename_hash\n", 
		GPOINTER_TO_INT(g_thread_self()));
	basename = 
	    ((const gchar *) g_hash_table_lookup (basename_hash, hash_key));
    }
    g_free(hash_key);
    NOOP ("ICON: g_hash_table_lookup: %s --> found:  %s\n", id, basename);
    
    if(!basename && basename_hash) {
        if(!strchr (id, '/')) return NULL;
        gchar *g = g_strdup (id);
        *strchr (g, '/') = 0;
        gchar *gg = g_strconcat (g, "/", "default", NULL);
	hash_key=rfm_get_hash_key(gg, 0);
        NOOP(stderr, "0x%x: lookup 2 basename_hash\n", 
		GPOINTER_TO_INT(g_thread_self()));
        basename = (const gchar *)g_hash_table_lookup (basename_hash, hash_key);
	g_free(hash_key);
        NOOP ("ICON: trying g_hash_table_lookup: %s --> found:  %s\n", gg, basename);
        g_free (g);
        g_free (gg);
    }
    g_static_rw_lock_writer_unlock(&basename_lock);
    if(!basename) {
        NOOP (stderr, "cannot get base icon for id=%s\n", id);
        return NULL;
    }
    gchar *file=NULL;
    gboolean gtk_theme = (getenv("RFM_USE_GTK_ICON_THEME") &&
			    strlen(getenv("RFM_USE_GTK_ICON_THEME")));
    if (gtk_theme) {
	file = get_dbh_pixmap_path ("GTK", basename);
      if (!file) {
	// generic fallbacks
	if (strncmp(id, "audio/", strlen("audio/"))==0) {
	    file = get_dbh_pixmap_path("GTK", "audio-x-generic");
	}
	else if (strncmp(id, "application/x-font", strlen("application/x-font"))==0) {
	    file = get_dbh_pixmap_path("GTK", "font-x-generic");
	}
	else if (strncmp(id, "image/", strlen("image/"))==0) {
	    file = get_dbh_pixmap_path("GTK", "image-x-generic");
	}
	else if (strncmp(id, "video/", strlen("video/"))==0) {
	    file = get_dbh_pixmap_path("GTK", "video-x-generic");
	}
	else if (
		(strstr(id, "script")) ||
		(strstr(id, "perl")) ||
		(strstr(id, "python")) ||
		(strstr(id, "awk")) ||
		(strstr(id, "asp")) ||
		(strstr(id, "ruby")) ||
		(strstr(id, "x-csh")) ||
		(strstr(id, "x-ksh")) ||
		(strstr(id, "x-m4")) ||
		(strstr(id, "x-sh")) ||
		(strstr(id, "x-tsh")) 
		) {
	    file = get_dbh_pixmap_path("GTK", "text-x-script");
	}
	else if (strncmp(id, "text/", strlen("text/"))==0) {
	    file = get_dbh_pixmap_path("GTK", "text-x-generic");
	} 
	else if (strncmp(id, "application/", strlen("application/"))==0){
	    file = get_dbh_pixmap_path("GTK", "document");
	} 

      }
    } 
    if (!file) {
	file = get_dbh_pixmap_path (NULL, basename);
    }
    if(!file || !g_file_test (file, G_FILE_TEST_EXISTS)) {
        NOOP ("mime_icon_get_filename_from_id(): %s->%s does not exist\n", 
		id, file);
    }
    return (file);
}
	    // refinements
#if 0	
	    else if (strncmp(id, "/", strlen("/"))==0) {
	    	file = get_dbh_pixmap_path("GTK", "package-x-generic");
	    }
	    else if (strncmp(id, "/", strlen("/"))==0) {
		file = get_dbh_pixmap_path("GTK", "text-x-generic");
	    }
	    else if (strncmp(id, "/", strlen("/"))==0) {
		file = get_dbh_pixmap_path("GTK", "text-x-generic-template");
	    }
	    else if (strncmp(id, "/", strlen("/"))==0) {
		file = get_dbh_pixmap_path("GTK", "text-x-script");
	    }
	    else if (strncmp(id, "/", strlen("/"))==0) {
		file = get_dbh_pixmap_path("GTK", "x-office-address-book");
	    }
	    else if (strncmp(id, "/", strlen("/"))==0) {
		file = get_dbh_pixmap_path("GTK", "x-office-calendar");
	    }
	    else if (strncmp(id, "/", strlen("/"))==0) {
		file = get_dbh_pixmap_path("GTK", "x-office-document");
	    }
	    else if (strncmp(id, "/", strlen("/"))==0) {
		file = get_dbh_pixmap_path("GTK", "x-office-presentation");
	    }
	    else if (strncmp(id, "/", strlen("/"))==0) {
		file = get_dbh_pixmap_path("GTK", "x-office-spreadsheet");
	    }
#endif

