static void
tab_constructor(struct widgets_t *widgets_p, const char *path);

static view_t *
new_view_p (
    GtkWidget * window,
    GtkWidget * notebook,
    record_entry_t * en
) {

    view_t *view_p = rfm_new_view();
    DBG("new_view_p(): RSS request\n"); 
    view_p->widgets.window = window;
    view_p->widgets.notebook=(GtkWidget **)malloc(sizeof(GtkWidget *));
    if (!view_p->widgets.notebook) g_error("malloc: %s", strerror(errno));
    *(view_p->widgets.notebook) = notebook;

    TRACE("THREAD: THREAD_CREATE(rfm_load_sh_command_history) from gridview-notebook.i\n");
    // This thread is not barrier subject
    THREAD_CREATE (rfm_load_sh_command_history, (gpointer) view_p, "rfm_load_sh_command_history");

    /* initializations: */

    view_p->flags.sortcolumn = GTK_TREE_SORTABLE_DEFAULT_SORT_COLUMN_ID;
    view_p->flags.type = ICONVIEW_TYPE;
    view_p->widgets.view_p = view_p;
    view_p->en = rfm_copy_entry (en);
    /* exported functions: */
    view_p->constructor = create_iconview;
    view_p->tab_constructor = tab_constructor;

    return view_p;
}

static
    void
rmpage (
    GtkButton * button,
    gpointer data
) {
    view_t *view_p = data;
    DBG("rmpage(): RSS unrequest\n"); 
     if(!rodent_destroy_view_item (view_p))
        return;
   // page is removed in rodent_destroy_view_item
}


static view_t *
create_notebook_page (
    GtkWidget * window,
    GtkWidget * notebook,
    record_entry_t * en
) {

    DBG("create_notebook_page(): RSS request\n"); 
    view_t *view_p = new_view_p (window, notebook, en);
    GtkWidget *vbox1 = rfm_vbox_new (FALSE, 0);
    GtkWidget *hbox = rfm_hbox_new (FALSE, 0);

    view_p->widgets.page_child = vbox1;
    g_object_set_data (G_OBJECT (view_p->widgets.page_child), "view_p", view_p);
    g_object_set_data (G_OBJECT (view_p->widgets.page_child), "widgets_p", &(view_p->widgets));
    view_p->widgets.page_icon = rfm_hbox_new (FALSE, 0);
    view_p->widgets.page_label = gtk_label_new ("");

    view_p->widgets.page_button = gtk_button_new ();
    GdkPixbuf *pb = rfm_get_pixbuf ("xffm/stock_close", SIZE_BUTTON);
    GtkWidget *image = gtk_image_new_from_pixbuf (pb);
    gtk_widget_show (image);
    gtk_container_add (GTK_CONTAINER (view_p->widgets.page_button), image);

    g_object_set (view_p->widgets.page_button, "image", image, "relief", GTK_RELIEF_NONE, NULL);

    g_signal_connect (view_p->widgets.page_button, "clicked", G_CALLBACK (rmpage), view_p);

    gtk_box_pack_start (GTK_BOX (hbox), view_p->widgets.page_icon, TRUE, TRUE, 0);
    gtk_box_pack_start (GTK_BOX (hbox), gtk_label_new ("  "), TRUE, TRUE, 0);
    gtk_box_pack_start (GTK_BOX (hbox), view_p->widgets.page_label, TRUE, TRUE, 0);
    gtk_box_pack_start (GTK_BOX (hbox), gtk_label_new ("  "), TRUE, TRUE, 0);

    gtk_box_pack_end (GTK_BOX (hbox), view_p->widgets.page_button, TRUE, TRUE, 0);

    gtk_widget_show_all (hbox);

    view_p->widgets.page_menu_label = gtk_label_new ("whatever");

    gint position=gtk_notebook_get_current_page(GTK_NOTEBOOK(notebook))+1;
    
    gtk_notebook_insert_page_menu (GTK_NOTEBOOK(notebook), vbox1, hbox, view_p->widgets.page_menu_label, position);
    gtk_notebook_set_tab_reorderable (GTK_NOTEBOOK(notebook), vbox1, TRUE);


    gtk_widget_show (vbox1);

    view_p->widgets.vpane = rfm_vpaned_new ();
    gtk_widget_show (view_p->widgets.vpane);
    gtk_box_pack_start (GTK_BOX (vbox1), view_p->widgets.vpane, TRUE, TRUE, 0);
    gtk_paned_set_position (GTK_PANED (view_p->widgets.vpane), 1000);

// begin {icon area}

    view_p->widgets.paper = gtk_drawing_area_new ();
    THREAD_CREATE(rodent_create_popup_bythread, (gpointer)view_p, "rodent_create_popup_bythread");
    view_p->widgets.scrolled_window = GTK_SCROLLED_WINDOW(gtk_scrolled_window_new (NULL, NULL));

    gtk_scrolled_window_set_policy (view_p->widgets.scrolled_window, GTK_POLICY_NEVER, GTK_POLICY_AUTOMATIC);

    // scrolled_window goes into vpane1
    gtk_paned_pack1 (GTK_PANED (view_p->widgets.vpane), GTK_WIDGET (view_p->widgets.scrolled_window), FALSE, TRUE);
    gtk_widget_show (GTK_WIDGET (view_p->widgets.scrolled_window));
    // paper goes into scrolled_window 
    gtk_scrolled_window_add_with_viewport (view_p->widgets.scrolled_window, view_p->widgets.paper);

// end {icon area}

    // requires more updated gtk version than that in fbsd-8.0
    //gtk_widget_set_can_focus(view_p->widgets.paper, TRUE);

    view_p->widgets.diagnostics =
	    (GtkWidget **)malloc(sizeof(GtkWidget *));
    if (!view_p->widgets.diagnostics) g_error("malloc: %s", strerror(errno));
    {
        *(view_p->widgets.diagnostics) = gtk_text_view_new ();
        GtkWidget *scrolledwindow5 = gtk_scrolled_window_new (NULL, NULL);
        gtk_widget_show (scrolledwindow5);
        gtk_widget_show (*(view_p->widgets.diagnostics));
	// Man! this crashes under KDE doxygen theme:
        gtk_container_add (GTK_CONTAINER (scrolledwindow5), *(view_p->widgets.diagnostics));
        gtk_paned_pack2 (GTK_PANED (view_p->widgets.vpane), scrolledwindow5, TRUE, TRUE);
        gtk_scrolled_window_set_policy (GTK_SCROLLED_WINDOW (scrolledwindow5), GTK_POLICY_AUTOMATIC, GTK_POLICY_AUTOMATIC);
        gtk_container_set_border_width (GTK_CONTAINER (*(view_p->widgets.diagnostics)), 2);
	gtk_widget_set_can_focus(*(view_p->widgets.diagnostics), FALSE);
        gtk_text_view_set_wrap_mode (GTK_TEXT_VIEW (*(view_p->widgets.diagnostics)), GTK_WRAP_WORD);
        gtk_text_view_set_cursor_visible (GTK_TEXT_VIEW (*(view_p->widgets.diagnostics)), FALSE);
	gint size = 10;
        PangoFontDescription *font_desc = pango_font_description_new ();
        pango_font_description_set_family (font_desc, "monospace");
        pango_font_description_set_size (font_desc, size * PANGO_SCALE);
#ifdef USE_GTK2
	gtk_widget_modify_font (*(view_p->widgets.diagnostics), font_desc);
#else
    gtk_widget_override_font (*(view_p->widgets.diagnostics), font_desc);
#endif
	g_object_set_data(G_OBJECT(*(view_p->widgets.diagnostics)), 
		"font_desc", font_desc);


    }

    view_p->widgets.button_space = rfm_hbox_new (FALSE, 0);
    gtk_widget_show (view_p->widgets.button_space);
    gtk_box_pack_start (GTK_BOX (vbox1), view_p->widgets.button_space, FALSE, FALSE, 0);

    view_p->widgets.progress = gtk_progress_bar_new ();
    gtk_box_pack_start (GTK_BOX (view_p->widgets.button_space), view_p->widgets.progress, FALSE, FALSE, 0);

    RODENT_HOOKUP_OBJECT (view_p->widgets.paper, view_p->widgets.vpane, "vpaned1");
    RODENT_HOOKUP_OBJECT (view_p->widgets.paper, view_p->widgets.progress, "progressbar1");
    /*gtk_widget_show (view_p->widgets.progress); */

    view_p->widgets.status = gtk_text_view_new ();
    gtk_widget_show (view_p->widgets.status);
    gtk_box_pack_start (GTK_BOX (view_p->widgets.button_space), view_p->widgets.status, TRUE, TRUE, 3);
    gtk_text_view_set_cursor_visible (GTK_TEXT_VIEW (view_p->widgets.status), FALSE);
    //gtk_widget_set_can_focus(view_p->widgets.status, TRUE);
    gtk_text_view_set_editable (GTK_TEXT_VIEW (view_p->widgets.status), TRUE);
#if GTK_MAJOR_VERSION==3
    gtk_text_view_set_wrap_mode (GTK_TEXT_VIEW (view_p->widgets.status), GTK_WRAP_CHAR);
#endif
    gtk_text_view_set_cursor_visible (GTK_TEXT_VIEW (view_p->widgets.status), TRUE);
    g_signal_connect (G_OBJECT (view_p->widgets.status), "key_press_event", G_CALLBACK (on_status_key_press), &(view_p->widgets));
    /*  g_signal_connect(G_OBJECT(view_p->widgets.status), "focus",
       G_CALLBACK(on_status_key_press), &(view_p->widgets)); */
    g_object_set_data (G_OBJECT (view_p->widgets.status), "clean", GINT_TO_POINTER(0x01));

 
    if (rfm_void(MODULE_DIR, "icons", "module_active")){
	view_p->widgets.size_scale = 
	    rfm_hscale_new_with_range (0.0, 96.0, 12.0);
    } else {
	view_p->widgets.size_scale = 
	    rfm_hscale_new_with_range (0.0, 48.0, 12.0);
    }

    gtk_scale_set_draw_value (GTK_SCALE(view_p->widgets.size_scale), FALSE);
    gtk_widget_set_can_focus (view_p->widgets.size_scale, FALSE);
    gtk_widget_set_size_request (view_p->widgets.size_scale, 75, 30);
#if GTK_MAJOR_VERSION==2 && GTK_MINOR_VERSION<24
    // this is deprecated and there is no replacement. 
    // That's a pity...
    gtk_range_set_update_policy (GTK_RANGE(view_p->widgets.size_scale), 
	    GTK_UPDATE_DISCONTINUOUS);
#endif
     
    gtk_box_pack_end (GTK_BOX (view_p->widgets.button_space),
	    view_p->widgets.size_scale, FALSE, FALSE, 0);
    gtk_widget_show (view_p->widgets.size_scale);
    g_signal_connect (G_OBJECT (view_p->widgets.size_scale), 
	    "value-changed", G_CALLBACK (rodent_size_scale), &(view_p->widgets));
    // clear diagnostics area button
    view_p->widgets.clear_button = rfm_mk_little_button (
	    "xffm/stock_clear", 
	    (void *) rfm_clear_text_window, 
	    (void *) (&(view_p->widgets)), _("Clear"));
    gtk_box_pack_end (GTK_BOX (view_p->widgets.button_space), 
	    view_p->widgets.clear_button, FALSE, FALSE, 0);
    gtk_widget_show (view_p->widgets.clear_button);

    /* events */
    gtk_widget_add_events (view_p->widgets.paper,
                           GDK_POINTER_MOTION_MASK |
                           GDK_BUTTON_MOTION_MASK |
                           GDK_BUTTON_PRESS_MASK |
                           GDK_BUTTON_RELEASE_MASK | GDK_ENTER_NOTIFY_MASK | GDK_LEAVE_NOTIFY_MASK | GDK_EXPOSURE_MASK);

    g_signal_connect (G_OBJECT
                      (gtk_scrolled_window_get_vadjustment
                       (view_p->widgets.scrolled_window)), "value-changed", G_CALLBACK (adjustment_changed), view_p);

#ifdef USE_GTK2
    g_signal_connect (G_OBJECT (view_p->widgets.paper), "expose-event", G_CALLBACK (rodent_expose), view_p);
#else
    g_signal_connect (G_OBJECT (view_p->widgets.paper), "draw", G_CALLBACK (rodent_draw), view_p);
#endif
    g_signal_connect (G_OBJECT (view_p->widgets.paper), "size-allocate", G_CALLBACK (signal_on_size_paper), view_p);
    //g_signal_connect (G_OBJECT (view_p->widgets.paper), "size-request", G_CALLBACK (signal_on_size_request), view_p);
    g_signal_connect (G_OBJECT (view_p->widgets.paper), "configure-event", G_CALLBACK (signal_on_configure_paper), view_p);
    g_signal_connect (G_OBJECT (view_p->widgets.paper), "button-press-event", G_CALLBACK (rodent_signal_on_button_press), view_p);
    g_signal_connect (G_OBJECT (view_p->widgets.paper), "button-release-event", G_CALLBACK (rodent_signal_on_button_release), view_p);
    g_signal_connect (G_OBJECT (view_p->widgets.paper), "enter-notify-event", G_CALLBACK (rodent_signal_on_enter), view_p);
    g_signal_connect (G_OBJECT (view_p->widgets.paper), "motion-notify-event", G_CALLBACK (rodent_signal_on_motion), view_p);
    g_signal_connect (G_OBJECT (view_p->widgets.paper), "leave-notify-event", G_CALLBACK (rodent_signal_on_leave_paper), view_p);
    g_signal_connect (G_OBJECT (view_p->widgets.window), "leave-notify-event", G_CALLBACK (rodent_signal_on_leave), view_p);

    g_signal_connect (G_OBJECT (view_p->widgets.paper), "scroll-event", G_CALLBACK (scroll_event_callback), &(view_p->widgets));

    /* drag and drop events */
    rodent_create_target_list (view_p);

    g_object_set_data (G_OBJECT (view_p->widgets.paper), "view_p", (gpointer) view_p->widgets.paper);

    g_signal_connect (G_OBJECT (view_p->widgets.paper), "drag-data-received", G_CALLBACK (rodent_signal_drag_data), view_p);
    g_signal_connect (G_OBJECT (view_p->widgets.paper), "drag-data-get", G_CALLBACK (rodent_signal_drag_data_get), view_p);
    g_signal_connect (G_OBJECT (view_p->widgets.paper), "drag-motion", G_CALLBACK (rodent_signal_drag_motion), view_p);
    g_signal_connect (G_OBJECT (view_p->widgets.paper), "drag-end", G_CALLBACK (rodent_signal_drag_end), view_p);
    g_signal_connect (G_OBJECT (view_p->widgets.paper), "drag-begin", G_CALLBACK (rodent_signal_drag_begin), view_p);
    g_signal_connect (G_OBJECT (view_p->widgets.paper), "drag-leave", G_CALLBACK (rodent_signal_drag_leave), view_p);
    g_signal_connect (G_OBJECT (view_p->widgets.paper), "drag-data-delete", G_CALLBACK (rodent_signal_drag_delete), view_p);

    gtk_widget_queue_draw (view_p->widgets.paper);
    rfm_get_drawable_geometry (gdk_x11_get_default_root_xwindow (), 
	    NULL, NULL, &view_p->view_layout.root_w, &view_p->view_layout.root_h, &view_p->view_layout.root_d);

    TRACE ("iconview now flushing events...\n");

    gdk_flush ();

    /* now lets get the text height from pango */
    {
        PangoLayout *layout;
        PangoRectangle logical_rect;
        const gchar *tag = "HECHO EN MEXICO";
        layout = gtk_widget_create_pango_layout (view_p->widgets.paper, tag);
        pango_layout_get_pixel_extents (layout, NULL, &(logical_rect));
        view_p->view_layout.text_height = logical_rect.height;
        g_object_unref (layout);
    }

    gtk_widget_show (view_p->widgets.paper);
    gtk_notebook_set_current_page (GTK_NOTEBOOK (notebook), position);
    rodent_add_view (view_p);
    return view_p;

}

static
    void
newpage (
    GtkButton * button,
    gpointer data
) {
    GtkWidget *window = data;
    view_t *view_p = rodent_get_current_view (window);

    view_t *v_p = create_notebook_page (view_p->widgets.window, *(view_p->widgets.notebook), view_p->en);

    record_entry_t *en = rfm_copy_entry (view_p->en);
    v_p->module = view_p->module;
    rodent_full_reload_view (v_p, en);
    gdk_flush ();
}

static void
tab_constructor(struct widgets_t *widgets_p, const char *path){
    record_entry_t *en=rfm_stat_entry (path, 0);
    view_t *v_p = create_notebook_page (widgets_p->window, *(widgets_p->notebook), en);
    rodent_full_reload_view (v_p, en);
    gdk_flush ();
}

static void
switch_page (
    GtkNotebook * notebook,
    GtkWidget * page,
    guint npage,
    gpointer data
) {
    // "The GtkNotebookPage is an opaque implementation detail of GtkNotebook. "
    // So what the fsk is it doing here? It obviously could be of some use...
    TRACE ("switch_page: %d\n", npage);
    //GtkWidget *window = data;

    GtkWidget *child =gtk_notebook_get_nth_page(notebook, npage);
    view_t *view_p = g_object_get_data (G_OBJECT (child), "view_p");

    g_static_rw_lock_reader_lock (&(rfm_global_p->view_list_lock));

    GSList *view_list = rfm_global_p->window_view_list;
    if(!view_list || g_slist_length(view_list)==0) {
        g_warning ("switch_page: !view_list, should not even happen.");
	g_static_rw_lock_reader_unlock (&(rfm_global_p->view_list_lock));
        return;
    }
        
    int i;
    for(i=0; view_list; view_list = view_list->next,i++) {
            view_t *v_p = view_list->data;
            if (GTK_IS_WIDGET(v_p->widgets.page_button)) 
		gtk_widget_hide (v_p->widgets.page_button);
    }
    if(g_slist_length (rfm_global_p->window_view_list) > 1) {
            gtk_widget_show (view_p->widgets.page_button);
    }
    g_static_rw_lock_reader_unlock (&(rfm_global_p->view_list_lock));

    g_object_set (view_p->widgets.paper, "can-focus", TRUE,
//          "has-default", TRUE,
                  "has-focus", TRUE, "is-focus", TRUE,
//          "receives-default", TRUE,
                  NULL);

    gtk_widget_grab_focus (view_p->widgets.paper);

    const gchar *path = NULL;
    if(view_p->en){
        path = view_p->en->path;
    }
    // This test will load the bookmarks right away.
    if (rodent_path_has_bookmark(path)){
	TRACE("%s is bookmarked\n", path);
    }
    rodent_set_view_title (view_p);

    
    return;
}


