/* Copyright 2005-2011 Edscott Wilson Garca. 
 * Distributed with GPL licence.*/

/* basic callback functions used to set up the iconview 
 *
 * */
static gboolean
scroll_event_callback (GtkWidget *paper, GdkEventScroll  *event, gpointer data){
    TRACE (">>  scroll_event_callback button: %d\n", event->direction);
    if(event->state & GDK_CONTROL_MASK) {
	widgets_t *widgets_p=data;
	if (event->direction==0) {
	    rodent_increase_iconsize (NULL, widgets_p);
	} else if (event->direction==1) {
	    rodent_decrease_iconsize (NULL, widgets_p);
	}
	// 0=up
	// 1=down
	// 2=left
	// 3=right
	return TRUE;
    }

    return FALSE;
} 
static void
adjustment_changed (
    GtkAdjustment * adjustment,
    gpointer data
) {
    view_t *view_p = (view_t *) data;
    TRACE ("geometry: adjustment_changed to %lf\n",
         gtk_adjustment_get_value (gtk_scrolled_window_get_vadjustment (view_p->widgets.scrolled_window)));

    rodent_done_with_rename(data);

    rodent_save_local_view_geometry_p (view_p);
    view_p->tip_event.tooltip_active = FALSE;    
    rodent_unsaturate_item (view_p);
    rodent_label_event (view_p, NULL);
}

static gboolean
invisible_bottom (
    view_t * view_p
) {
    int totally_invisible_items;
    int partially_invisible_items;
    int invisible_items = 0;
    gdouble sp = gtk_adjustment_get_value (gtk_scrolled_window_get_vadjustment (view_p->widgets.scrolled_window));

    totally_invisible_items = ((int) (sp) / CELLWIDTH(view_p)) * view_p->view_layout.grid_columns;
    partially_invisible_items = (((int) (sp) % CELLWIDTH(view_p)) / ICON_SIZE(view_p)) * view_p->view_layout.grid_columns;

    TRACE ("partially=%d, totally=%d, invisible=%d\n", partially_invisible_items, totally_invisible_items, invisible_items);

    invisible_items = totally_invisible_items + partially_invisible_items;
    return invisible_items;
}

static gboolean
invisible_top (
    view_t * view_p
) {
    int invisible_items;
    gdouble sp = gtk_adjustment_get_value (gtk_scrolled_window_get_vadjustment (view_p->widgets.scrolled_window));

    GdkRectangle allocation;
    gtk_widget_get_allocation (view_p->widgets.window, &allocation);
    invisible_items = ((int) (sp + allocation.height) / CELLHEIGHT(view_p)) * view_p->view_layout.grid_columns;

    return invisible_items;
}

static gboolean
signal_destroy_event (
    GtkWidget * window,
    GdkEvent * event,
    gpointer data
) {
    TRACE (">> signal_destroy_event to 0x%u\n", GPOINTER_TO_INT(window));
    view_t *view_p = rodent_get_current_view (window);
    rodent_destroy_view (view_p);
    return TRUE;
}

/*static void
signal_on_size_request(GtkWidget *widget, GtkRequisition *requisition,
	gpointer data){
    NOOP(stderr, "signal_on_size_request w=%d, h=%d\n",
	requisition->width, requisition->height);
}*/

static void
signal_on_size_paper (
    GtkWidget * widget,
    GtkAllocation * allocation,
    gpointer user_data
) {
    TRACE (">>> paper: size-allocate signal -->  signal_on_size_paper()\n");
    view_t *view_p = (view_t *) user_data;
    NOOP(stderr, "signal_on_size_paper() view=0x%x\n", GPOINTER_TO_INT(view_p));
    // First, apply new window size to paper drawing area:
    rodent_init_grid(view_p, view_p->view_layout.max_elements);
    rodent_apply_view_size (view_p);

    rodent_set_scroll_position (view_p);
    TRACE ("PPP on_size_paper:: done w: %d, H:%d\n", allocation->width, allocation->height);
    return;
}

static gboolean
signal_on_configure_paper (
    GtkWidget * widget,
    GdkEventConfigure * event,
    gpointer data
) {
    TRACE (">>> paper: configure-event signal --> signal_on_configure_paper()\n");
    return TRUE;
}

static gboolean
signal_on_configure_window (
    GtkWidget * window,
    GdkEventConfigure * event,
    gpointer data
) {
    TRACE (">>> window: configure-event --> signal_on_configure_window()\n");

    view_t *view_p = rodent_get_current_view (window);
    if (!view_p) return FALSE;
    
    GdkRectangle allocation;
    gtk_widget_get_allocation (window, &allocation);
    NOOP(stderr,"window  w: %d, H:%d\n", allocation.width, allocation.height);
    gtk_widget_get_allocation (view_p->widgets.vpane, &allocation);
    NOOP(stderr,"pane  w: %d, H:%d\n", allocation.width, allocation.height);
    if(view_p->widgets.rename) {
        rodent_done_with_rename ((gpointer) view_p);
    }
    /*if (view_p->widgets.vpane){
	gtk_paned_set_position(GTK_PANED(view_p->widgets.vpane), 10000);
    }*/
    return FALSE;
}


static gchar *
get_text_to_cursor ( GtkTextView * textview) {
    // get current text
    GtkTextIter start, end;
    GtkTextBuffer *buffer = gtk_text_view_get_buffer (textview);
    gint cursor_position;
    g_object_get (G_OBJECT (buffer), "cursor-position", &cursor_position, NULL);
    
    gtk_text_buffer_get_iter_at_offset (buffer, &start, 0);
    gtk_text_buffer_get_iter_at_offset (buffer, &end, cursor_position);
    gchar *t = gtk_text_buffer_get_text (buffer, &start, &end, TRUE);
    g_strchug(t);
    TRACE ("TO cursor position=%d %s\n", cursor_position, t);
    return t;
}


static gchar *
get_current_text ( GtkTextView * textview) {
    // get current text
    GtkTextIter start, end;
    GtkTextBuffer *buffer = gtk_text_view_get_buffer (textview);

    gtk_text_buffer_get_bounds (buffer, &start, &end);
    gchar *t = gtk_text_buffer_get_text (buffer, &start, &end, TRUE);
    g_strchug(t);
    return t;
   /* gchar *tt = t;
    while(*tt == ' ')
        tt++;
    gchar *ttt = g_strdup (tt);
    g_free (t);
    return ttt;*/
}

static void
status_grab_focus ( view_t * view_p, int keyval) {
    widgets_t *widgets_p = &(view_p->widgets);
    if(g_object_get_data (G_OBJECT (widgets_p->status), "clean")) {
        rfm_status (widgets_p, "xffm/apps_terminal", NULL);
	view_p->sh_command_counter=g_list_length(view_p->sh_command)-1;
    } else {
        gchar *t = get_current_text ((GtkTextView *) widgets_p->status);
        rfm_status (widgets_p, "xffm/apps_terminal", t, NULL);
        // keep unclean status...
        g_object_set_data (G_OBJECT (widgets_p->status), "clean", NULL);
        g_free (t);
    }
    gtk_widget_grab_focus (widgets_p->status);
/*    GdkWindow *win = gtk_text_view_get_window((GtkTextView *) widgets_p->status,
                                              GTK_TEXT_WINDOW_TEXT);*/
/*	XSetInputFocus(GDK_DISPLAY(),
	  GDK_WINDOW_XID(gtk_widget_get_parent_window(widgets_p->status)),
	  RevertToParent,CurrentTime);*/
/*	XGrabPointer(GDK_DISPLAY(),
	  GDK_WINDOW_XID(win),
          TRUE,
          0,
          GrabModeSync,
          GrabModeAsync,
          GDK_WINDOW_XID(win),
          None, CurrentTime);*/
    return;
}

static gboolean
signal_keyboard_event (
    GtkWidget * window,
    GdkEventKey * event,
    gpointer data
) {
    TRACE (">> signal_keyboard_event\n");
    view_t *view_p = rodent_get_current_view (window);

    int selected_row;
    int selected_column;
    int selection_id;
    int last_id;
    double scroll_pos = -1;
    widgets_t *widgets_p = &(view_p->widgets);
    gboolean initial = FALSE;
    TRACE("keyboard_event: 0x%x\n", event->keyval);

    /* keybindings are generated with the popup menu: */
    if(!view_p->widgets.popup) {
	// popup menu is generated by thread at startup.
	// remote case where thread has not yet finished:
	g_warning("view_p->widgets.popup has not been created!");
	return FALSE;
    }

    /* asian Input methods */
    if(event->keyval == GDK_KEY_space && (event->state & (GDK_MOD1_MASK | GDK_SHIFT_MASK))) {
        return FALSE;
    }

    if(event->state & (GDK_SHIFT_MASK | GDK_CONTROL_MASK | GDK_MOD1_MASK)) {
        if(rodent_common_mask_key (event, &(view_p->widgets)))
            return TRUE;
    }

    if(!rfm_population_try_read_lock (view_p)) {
        return FALSE;
    }
    if(!view_p->population_pp || !view_p->population_pp[0]) {
        return FALSE;
    }
    rfm_population_read_unlock (view_p);

    // extra keys:

    if (event->keyval == GDK_KEY_Search) {
	rodent_glob_activate (NULL, (gpointer) widgets_p);
        return TRUE;
    }
    if (event->keyval == GDK_KEY_Back) {
	rodent_back_activate (NULL, (gpointer) widgets_p);
        return TRUE;
    }
    if (event->keyval == GDK_KEY_Forward) {
	rodent_jump_to_activate (NULL, (gpointer) widgets_p);
        return TRUE;
    }
    if (event->keyval == GDK_KEY_Reload) {
	rodent_refresh_activate (NULL, (gpointer) widgets_p);
        return TRUE;
    }
    if (event->keyval == GDK_KEY_HomePage) {
	rodent_home_activate (NULL, (gpointer) widgets_p);
        return TRUE;
    }
    if (event->keyval == GDK_KEY_Explorer) {
	rodent_host_activate (NULL, (gpointer) widgets_p);
        return TRUE;
    }

    //TRACE ("status\n");

    if(view_p->selection_list && g_slist_length (view_p->selection_list)) {
        if(event->keyval == GDK_KEY_Delete) {
            rodent_remove_activate ((GtkMenuItem *) window, widgets_p);
            return TRUE;
        }

        if(event->keyval == GDK_KEY_Return || event->keyval == GDK_KEY_KP_Enter) {
            //g_warning("return whatever");
            if(rfm_population_try_read_lock (view_p)) {
                population_t population_v;
                record_entry_t en_v;
                if(view_p->mouse_event.selected_p) {
                    memcpy (&population_v, view_p->mouse_event.selected_p, sizeof (population_t));
                    memcpy (&en_v, view_p->mouse_event.selected_p->en, sizeof (record_entry_t));
                    population_v.en = &en_v;
                    rfm_population_read_unlock (view_p);
                    rodent_double_click (view_p, view_p->mouse_event.selected_p, !(event->state & GDK_CONTROL_MASK));
                }
            }
            return TRUE;
        }
    }

    int ignore[]={
        GDK_KEY_Control_L,
        GDK_KEY_Control_R,
        GDK_KEY_Shift_L,
        GDK_KEY_Shift_R,
        GDK_KEY_Shift_Lock,
        GDK_KEY_Caps_Lock,
        GDK_KEY_Meta_L,
        GDK_KEY_Meta_R,
        GDK_KEY_Alt_L,
        GDK_KEY_Alt_R,
        GDK_KEY_Super_L,
        GDK_KEY_Super_R,
        GDK_KEY_Hyper_L,
        GDK_KEY_Hyper_R,

        0
    };
    int i;
    for (i=0; ignore[i]; i++) {
        if(event->keyval ==  ignore[i]) {
            return TRUE;
        }
    }
    /*if(event->keyval == GDK_KEY_Control_L || event->keyval == GDK_KEY_Control_R) {
        return TRUE;
    }*/

    if(rfm_population_try_read_lock (view_p)) {
        rodent_unselect_all_pixbuf (view_p);
        rodent_unsaturate_item (view_p);
        rodent_label_event (view_p, NULL);
        rfm_population_read_unlock (view_p);
    }

    if(g_object_get_data (G_OBJECT (widgets_p->status), "clean") == NULL) {
        if(event->keyval == GDK_KEY_Escape) {
            gtk_widget_grab_focus (widgets_p->paper);
            rfm_update_status_line (widgets_p->view_p);
            rfm_hide_text (widgets_p);
        } else {
            return FALSE;
        }
    }

    if(event->keyval != GDK_KEY_Escape &&
       event->keyval != GDK_KEY_Page_Up &&
       event->keyval != GDK_KEY_Page_Down &&
       event->keyval != GDK_KEY_Home &&
       event->keyval != GDK_KEY_Left &&
       event->keyval != GDK_KEY_Up &&
       event->keyval != GDK_KEY_Down && event->keyval != GDK_KEY_Right && event->keyval != GDK_KEY_End && event->keyval != GDK_KEY_Down) {
        status_grab_focus (view_p, event->keyval);
        return FALSE;
    }
    if(event->keyval == GDK_KEY_Page_Up || event->keyval == GDK_KEY_Page_Down) {
        int factor = 3 * CELLHEIGHT(view_p);
        if(event->keyval == GDK_KEY_Page_Up) {
            factor *= -1;
        }
        scroll_pos = gtk_adjustment_get_value (gtk_scrolled_window_get_vadjustment (view_p->widgets.scrolled_window)) + factor;
        if(scroll_pos < 0) {
            scroll_pos = 0;
        }
        if(scroll_pos > view_p->view_layout.grid_rows * CELLHEIGHT(view_p)) {
            scroll_pos = view_p->view_layout.grid_rows * CELLHEIGHT(view_p);
        }
        rodent_set_scroll (view_p, scroll_pos);
        return TRUE;
    }

    if(!rfm_population_try_read_lock (view_p)) {
        return FALSE;
    }
    for(selection_id = 0; view_p->population_pp[selection_id]
        && view_p->population_pp[selection_id] != view_p->mouse_event.selected_p; selection_id++) ;

    if(!view_p->population_pp[selection_id]) {
        if(event->keyval != GDK_KEY_End)
            selection_id = 0;
        else
            selection_id = view_p->view_layout.grid_rows * view_p->view_layout.grid_columns - 1;
        initial = TRUE;
    }
    rfm_population_read_unlock (view_p);

    /* is selection id visible? */
    int invisible_items = invisible_bottom (view_p);

    if(selection_id < invisible_items) {
        selection_id = invisible_items;
        initial = TRUE;
    }
    TRACE ("selection_id=%d, invisibleitems=%d, listlength=%d\n",
           selection_id, invisible_items, view_p->view_layout.grid_rows * view_p->view_layout.grid_columns);

    if(selection_id >= view_p->view_layout.grid_rows * view_p->view_layout.grid_columns) {
        selection_id = view_p->view_layout.grid_rows * view_p->view_layout.grid_columns - 1;
        initial = TRUE;
        scroll_pos = (selection_id / view_p->view_layout.grid_columns) * CELLWIDTH(view_p);
        TRACE ("scrollback, scrollpos at %lf\n", scroll_pos);
    }
    //TRACE("at %s\n", view_p->population_pp[selection_id]->en->path);

    last_id = selection_id;

    if(!initial) {
        switch (event->keyval) {
        case GDK_KEY_Escape:
            selection_id = -1;
            break;
        case GDK_KEY_Home:
            selection_id = 0;
            scroll_pos = 0;
            break;
        case GDK_KEY_Left:
            if(selection_id - 1 >= 0) {
                selection_id--;
                if(selection_id / view_p->view_layout.grid_columns
                   != last_id / view_p->view_layout.grid_columns && selection_id < invisible_bottom (view_p)) {
                    scroll_pos =
                        gtk_adjustment_get_value
                        (gtk_scrolled_window_get_vadjustment (view_p->widgets.scrolled_window)) - CELLHEIGHT(view_p);
                    if(scroll_pos < 0)
                        scroll_pos = 0;
                }
            }
            break;
        case GDK_KEY_Right:
            if(rfm_population_try_read_lock (view_p)) {
                if(view_p->population_pp[selection_id + 1]) {
                    selection_id++;
                    if(selection_id / view_p->view_layout.grid_columns
                       != last_id / view_p->view_layout.grid_columns && selection_id >= invisible_top (view_p)) {
                        scroll_pos =
                            CELLHEIGHT(view_p) +
                            gtk_adjustment_get_value (gtk_scrolled_window_get_vadjustment (view_p->widgets.scrolled_window));
                    }
                }
                rfm_population_read_unlock (view_p);
            }
            break;

        case GDK_KEY_End:
            selection_id = view_p->view_layout.max_elements - 1;
            scroll_pos = (selection_id / view_p->view_layout.grid_columns) * CELLWIDTH(view_p);
            break;
        case GDK_KEY_Down:
            if(selection_id + view_p->view_layout.grid_columns < view_p->view_layout.grid_rows * view_p->view_layout.grid_columns) {
                selection_id += view_p->view_layout.grid_columns;
                if(selection_id >= view_p->view_layout.max_elements) {
                    selection_id = view_p->view_layout.max_elements - 1;
                }
                TRACE ("invisible top=%d selection_id=%d\n", invisible_top (view_p), selection_id);
                if(selection_id >= invisible_top (view_p)) {
                    scroll_pos =
                        CELLHEIGHT(view_p) +
                        gtk_adjustment_get_value (gtk_scrolled_window_get_vadjustment (view_p->widgets.scrolled_window));
                }
            }
            break;
        case GDK_KEY_Up:
            if(selection_id - view_p->view_layout.grid_columns >= 0)
                selection_id -= view_p->view_layout.grid_columns;
            TRACE ("invisible bottom=%d selection_id=%d\n", invisible_bottom (view_p), selection_id);
            if(selection_id < invisible_bottom (view_p)) {
                scroll_pos =
                    gtk_adjustment_get_value (gtk_scrolled_window_get_vadjustment (view_p->widgets.scrolled_window)) - CELLHEIGHT(view_p);
                if(scroll_pos < 0)
                    scroll_pos = 0;
            }
            break;
        default:
            return FALSE;
        }                       // end switch
    }                           // end if (!initial)

    if(selection_id >= 0) {
        selected_column = selection_id % view_p->view_layout.grid_columns;
        selected_row = selection_id / view_p->view_layout.grid_columns;
        if(rfm_population_try_read_lock (view_p)) {
            rodent_saturate_item (view_p, view_p->population_pp[selection_id]);
            rodent_select_pixbuf (view_p, view_p->population_pp[selection_id]);
	    rfm_expose_item (view_p, view_p->population_pp[selection_id]);
            rfm_population_read_unlock (view_p);
        }

        if(scroll_pos >= 0) {
            gdouble max = gtk_adjustment_get_upper (gtk_scrolled_window_get_vadjustment (view_p->widgets.scrolled_window));
            if(scroll_pos > max) {
                scroll_pos = max;
            }
            rodent_set_scroll (view_p, scroll_pos);
        }
        TRACE ("KEY: item %d selected row and column=%d,%d (grid_rows=%d,grid_columns=%d)\n", selection_id,
             selected_row, selected_column, view_p->view_layout.grid_rows, view_p->view_layout.grid_columns);
        /* XXX this expose is necessary because the gtk expose event 
	 * is returning
         * weird expose areas, probably because the paper has 
	 * been resized... */
	gint element = selected_row * view_p->view_layout.grid_columns + selected_column;
	if (element < view_p->view_layout.max_elements) {
	    rfm_expose_item (view_p, view_p->population_pp[element]);
	}
	element = (last_id / view_p->view_layout.grid_columns) * view_p->view_layout.grid_columns + 
			(last_id % view_p->view_layout.grid_columns);
	if (element < view_p->view_layout.max_elements) {
	    rfm_expose_item (view_p, view_p->population_pp[element]);
	}
	
        //graphics_expose_item (view_p, selected_row, selected_column, TRUE);
        //graphics_expose_item (view_p, last_id / view_p->view_layout.grid_columns, last_id % view_p->view_layout.grid_columns, TRUE);
        view_p->mouse_event.selected_p = view_p->population_pp[selection_id];
	rodent_saturate_item (view_p, view_p->population_pp[selection_id]);
        //view_p->saturated_p = view_p->population_pp[selection_id];
    }
    rfm_update_status_line (view_p);

    return TRUE;
}
