#define TIMERVAL 1000
#define MAX_LOAD_TIME 2

static gboolean
watch_root ( gpointer data) {

    static gboolean running=FALSE;
    if (running) return TRUE;
    running=TRUE;
    view_t *view_p = (view_t *) data;
    g_mutex_lock(view_p->mutexes.status_mutex);
    gboolean status = view_p->flags.status;
    g_mutex_unlock(view_p->mutexes.status_mutex);
    if (status == STATUS_EXIT) return FALSE;
    increment_view_ref(view_p);
    rodent_bookmark_monitor(view_p);

    static gchar *desktop_color = NULL;
    static gchar *desktop_bg_file = NULL;
    static gdouble margins[4]={0,0,0,0};


    if(getenv ("RFM_ENABLE_DESKTOP_DIAGNOSTICS") && 
	    strlen (getenv ("RFM_ENABLE_DESKTOP_DIAGNOSTICS"))) {
	if (view_p->widgets.diagnostics_window &&
		*(view_p->widgets.diagnostics_window) == NULL) {
	    rfm_create_diagnostics_window (&(view_p->widgets));
	} else if (view_p->widgets.diagnostics_window) {
	    gtk_widget_show_all(*(view_p->widgets.diagnostics_window));
	}
    } else if (view_p->widgets.diagnostics_window && 
	    GTK_IS_WIDGET(*(view_p->widgets.diagnostics_window))){
        gtk_widget_hide(*(view_p->widgets.diagnostics_window));

    }

    gboolean reload = FALSE;
    gboolean regen_background = FALSE;
        
    // Watch out for changes in server window size
    gint root_w;
    gint root_h;
    rfm_get_drawable_geometry (gdk_x11_get_default_root_xwindow (), 
	    NULL, NULL, &root_w, &root_h, NULL);
    if (root_w != view_p->view_layout.root_w || 
	    root_h != view_p->view_layout.root_h) {
	DBG("Root window has been reconfigured...\n");

	gtk_window_resize (GTK_WINDOW(view_p->widgets.window), root_w, root_h);

	view_p->view_layout.root_w = root_w;
	view_p->view_layout.root_h = root_h;
	g_free(view_p->eyecandy.desktop_bg_file);
	view_p->eyecandy.desktop_bg_file = NULL;
	reload = TRUE;
    }

    gint i;
    for (i = RFM_DESKTOP_TOP_MARGIN; i <= RFM_DESKTOP_LEFT_MARGIN; i++){
      gdouble value;
      if (getenv(environ_v[i].env_var) && strlen(getenv(environ_v[i].env_var)))
      {
	value = atof(getenv(environ_v[i].env_var));
      } else {
	  value=margins[i-RFM_DESKTOP_TOP_MARGIN];
      }
      if (value != margins[i-RFM_DESKTOP_TOP_MARGIN]){
	DBG("Margin changed: %s = %lf\n", environ_v[i].env_var, value);
	margins[i-RFM_DESKTOP_TOP_MARGIN]=value;
	switch (i){
	    case RFM_DESKTOP_TOP_MARGIN:
		view_p->view_layout.margin_top=value;
		break;
	    case RFM_DESKTOP_BOTTOM_MARGIN:
		view_p->view_layout.margin_bottom=value;
		break;
	    case RFM_DESKTOP_RIGHT_MARGIN:
		view_p->view_layout.margin_right=value;
		break;
	    case RFM_DESKTOP_LEFT_MARGIN:
		view_p->view_layout.margin_left=value;
		break;
	}
	reload=TRUE;
	rodent_recalc_population_grid(view_p);
      }
    }
    if (reload) {
	rodent_recalc_population_grid(view_p);
	goto soft_reload;
    }
    /* this is necesary when wm is twm... maybe others as well, 
     * but will dunk under nautilus desktop if running... */
    //XLowerWindow(GDK_DISPLAY(),GDK_WINDOW_XID(((GtkWidget *)view_p->widgets.window)->window));

    if(getenv ("RFM_NAVIGATE_DESKTOP")
       && strlen (getenv ("RFM_NAVIGATE_DESKTOP"))) {
        view_p->child_constructor = NULL;
    } else {
        view_p->child_constructor = child_constructor;
    }
#if 10
    if(getenv ("RFM_DESKTOP_DIR") && strlen (getenv ("RFM_DESKTOP_DIR"))) {
	gboolean reload=FALSE;
        if(!view_p->desktop_dir){
            view_p->desktop_dir = g_strdup (getenv ("RFM_DESKTOP_DIR"));
	    reload=TRUE;
	}
	if(strcmp (getenv ("RFM_DESKTOP_DIR"), view_p->desktop_dir) && rfm_g_file_test (getenv ("RFM_DESKTOP_DIR"), G_FILE_TEST_IS_DIR)){
	    reload=TRUE;		
	}
        if(reload) {
            TRACE ("DESKo: watch_root RFM_DESKTOP_DIR =%s != %s (desktop_fir)\n", getenv ("RFM_DESKTOP_DIR"), view_p->desktop_dir);
#if 10
            /*    
             *    this is a hard reload: directory has changed!.
             *    */
             record_entry_t *en=NULL;
             if (view_p->en) {
		 en = rfm_stat_entry(getenv("RFM_DESKTOP_DIR"), view_p->en->type);
	     }
             if (rodent_refresh(&(view_p->widgets), en)) {
		 TRACE("rodent desk-monitor hard refresh done!\n");
                 // reload did not fail 
                 g_free (view_p->desktop_dir);
                 view_p->desktop_dir = g_strdup (getenv ("RFM_DESKTOP_DIR"));
             } else {
                 //reload failed 
                 //so we will try again in next timeout
		 rfm_destroy_entry(en);
             }
#endif
            DBG ("DESK: watch_root RFM_DESKTOP_DIR returns\n");
	    goto done;
        }
    }
#endif
    if(getenv ("RFM_DESKTOP_COLOR") && strlen (getenv ("RFM_DESKTOP_COLOR"))) {
        if(!desktop_color || strcmp (desktop_color, getenv ("RFM_DESKTOP_COLOR"))) {
            TRACE ("DESK: watch_root now reloading RFM_DESKTOP_COLOR %s\n", getenv ("RFM_DESKTOP_COLOR"));
            g_free (desktop_color);
            desktop_color = g_strdup (getenv ("RFM_DESKTOP_COLOR"));
            regen_background = TRUE;
        }
    }
    if(getenv ("RFM_DESKTOP_IMAGE") && strlen (getenv ("RFM_DESKTOP_IMAGE"))) {
        if(!desktop_bg_file || strcmp (desktop_bg_file, getenv ("RFM_DESKTOP_IMAGE"))) {
            TRACE ("DESK: watch_root got RFM_DESKTOP_IMAGE=%s\n", getenv ("RFM_DESKTOP_IMAGE"));
            g_free (desktop_bg_file);
            desktop_bg_file = g_strdup (getenv ("RFM_DESKTOP_IMAGE"));
            regen_background = TRUE;
        }
    } else if (desktop_bg_file != NULL) {
	g_free(desktop_bg_file);
	desktop_bg_file=NULL;
            regen_background = TRUE;
    }
    if(getenv ("RFM_PASTEBOARD_SERIAL") && strlen (getenv ("RFM_PASTEBOARD_SERIAL"))) {
	//TRACE("got pasteboard serial=%s\n",getenv ("RFM_PASTEBOARD_SERIAL"));
	errno = 0;
	long value = strtol (getenv ("RFM_PASTEBOARD_SERIAL"), NULL, 0);
	if(errno != 0 || value != view_p->flags.pasteboard_serial) {
	    view_p->flags.pasteboard_serial = value;
	    rfm_update_pasteboard (view_p);
	    rodent_update_cut_icons (view_p);
	}
    }

    if(regen_background) {
        reload = TRUE;
    }
soft_reload:
    if(reload) {
        TRACE ("DESK: watch_root: reload_deskview\n");
        // just an expose is necesary.
		
	GdkRectangle rect;
	gtk_widget_get_allocation (view_p->widgets.window, &rect);
	rect.x = rect.y = 0;
	rfm_thread_expose_rect (view_p, &rect);


	// may crash on gtk race: rodent_expose_all (view_p);
        TRACE ("DESK: watch_root: rodent_expose_all done\n");
    }
done:
    running=FALSE;
    decrement_view_ref(view_p);
    return TRUE;

}
