/**********************************************************************/
/* Copyright Edscott Wilson Garcia 2005-2011 
 * See attached GPL licence for further information.
 * 
 * ********************************************************************/

#define RFM_DESKVIEW_C

#ifdef HAVE_CONFIG_H
# include <config.h>
#endif

#include "rodent_libs.h"
#include "deskview.h"

static view_t *deskview_pointer;


/* static code */

#include "deskview_desktop.i"
#include "deskview_callbacks.i"
#include "deskview_main.i"
#include "deskview_monitor.i"

/* exportable symbols: */

G_MODULE_EXPORT GtkWidget *
create_desktop ( void) {
    view_t *view_p;
    int i;

    gboolean rodent_root=FALSE;

    for(i = 0; i < rfm_global_p->argc; i++) {
        if(strcmp ("--id", rfm_global_p->argv[i]) == 0 || strcmp ("-id", rfm_global_p->argv[i]) == 0) {
            if(!rodent_running ())
                g_warning ("%s not running", rfm_global_p->argv[0]);
            exit (0);
        }
    }

    desktop_main ();
    gchar *deskdir = NULL;
    record_entry_t *en = NULL;

    if (getenv ("RFM_DESKTOP_DIR")) {
        deskdir = g_strdup (getenv ("RFM_DESKTOP_DIR"));
    }
    else {
default_deskdir:
	// No desktop dir defined. Do the default directory.
        deskdir = g_build_filename (DEFAULT_DESKTOP_DIR, NULL);
	if (!rfm_g_file_test(deskdir, G_FILE_TEST_IS_DIR)){
	    TRACE("Creating desktop dir: %s",deskdir);
	    g_mkdir_with_parents (deskdir, 0700);
	    if (!rfm_g_file_test(deskdir, G_FILE_TEST_IS_DIR)){
		g_error ("Desktop directory does not exist: %s", deskdir);
	    }
	}
	if ((en = rfm_stat_entry (deskdir, 0))==NULL){
	    g_error ("deskview.c: Cannot create entry for %s deskdir", deskdir);
	}
    } 
    if (strlen (deskdir)==0){
	// Deskdir is set to "", which means the Rodent root.
	// This is Ok.
	rodent_root=TRUE;
	//goto default_deskdir;
	// XXX borken method (but should be the correct way): en = NULL;
    } else if (strncmp("module:", deskdir, strlen("module:"))!=0){ 
	// Normal directory specified by user configuration.
	if (!rfm_g_file_test(deskdir, G_FILE_TEST_IS_DIR)){
	    g_warning("%s does not exist", deskdir);
	    g_free(deskdir);
	    goto default_deskdir;
	}
	if ((en = rfm_stat_entry (deskdir, 0))==NULL){
	    g_error ("deskview.c: Cannot create entry for %s deskdir", deskdir);
	}
    } else { // "module:" means a module is defined as the desktop directory
	gchar *module_name=deskdir+strlen("module:");
	en = rfm_mk_entry(0);
	en->module=g_strdup(module_name);
	en->path=g_strdup(rfm_void(PLUGIN_DIR, module_name, "module_label"));
    }

    deskview_pointer = view_p = create_deskview ();
    view_p->desktop_dir=g_strdup(deskdir);
    view_p->module = (en && en->module)?g_strdup(en->module): NULL;
    
    THREAD_CREATE(rodent_create_popup_bythread, view_p, "rodent_create_popup_bythread");
    

    rodent_add_view (view_p);   
    
    if(getenv ("RFM_NAVIGATE_DESKTOP")
       && strlen (getenv ("RFM_NAVIGATE_DESKTOP"))) {
        view_p->child_constructor = NULL;
    } else {
        view_p->child_constructor = child_constructor;
    }


    rodent_full_reload_view ((gpointer) view_p, en);
    if (rodent_root) rodent_refresh(&(view_p->widgets), NULL);


    // This will set/unset child constructor:
    rodent_monitor ((gpointer) g_thread_self ());
    g_timeout_add (160, watch_root, view_p);


    return view_p->widgets.window;
}

