/*
 * Decompiled with CFR 0.152.
 */
package org.openhab.ui.cometvisu.internal.util;

import com.google.gson.Gson;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.apache.commons.io.FileUtils;
import org.eclipse.smarthome.io.net.http.HttpUtil;
import org.openhab.ui.cometvisu.internal.Config;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClientInstaller {
    private final Logger logger = LoggerFactory.getLogger(ClientInstaller.class);
    private static final ClientInstaller INSTANCE = new ClientInstaller();
    private int timeout = 5000;
    private static final String RELEASE_URL = "https://api.github.com/repos/CometVisu/CometVisu/releases";
    private static final byte[] BUFFER = new byte[65535];
    private Map<String, Object> latestRelease;
    private final Pattern semverPattern = Pattern.compile("[\\D]*([\\d]{1,3})\\.([\\d]{1,3})\\.([\\d]{1,3}).*");
    private List<String> alreadyCheckedFolders = new ArrayList<String>();
    private boolean downloadAvailableButBlocked = false;

    private ClientInstaller() {
    }

    public static ClientInstaller getInstance() {
        return INSTANCE;
    }

    public void check() {
        this.check(false);
    }

    public void check(boolean force) {
        File webFolder;
        if (this.alreadyCheckedFolders.contains(Config.cometvisuWebfolder) && !force) {
            this.logger.debug("web folder {} has already been checked", (Object)Config.cometvisuWebfolder);
            return;
        }
        if (!force) {
            this.alreadyCheckedFolders.add(Config.cometvisuWebfolder);
        }
        if (!(webFolder = new File(Config.cometvisuWebfolder)).exists()) {
            this.logger.debug("creating cometvisu webfolder {}", (Object)webFolder.getAbsolutePath());
            webFolder.mkdirs();
        }
        if (webFolder.isDirectory()) {
            if (!new File(webFolder, "index.html").exists() || !new File(webFolder, "package.json").exists()) {
                if (Config.cometvisuAutoDownload || force) {
                    this.downloadLatestRelease();
                } else {
                    this.downloadAvailableButBlocked = true;
                    this.logger.error("No CometVisu client found in '{}' and automatic download is disabled. Please enable this feature by setting 'autoDownload=true' in your 'services/cometvisu.cfg' file.", (Object)webFolder.getAbsolutePath());
                }
            } else {
                Map<String, Object> latestRelease = this.getLatestRelease();
                File version = ClientInstaller.findClientRoot(webFolder, "version");
                if (version.exists()) {
                    try {
                        String currentVersion = FileUtils.readFileToString((File)version);
                        String currentRelease = (String)latestRelease.get("tag_name");
                        if (currentRelease.startsWith("v")) {
                            currentRelease = currentRelease.substring(1);
                        }
                        if (this.isNewer(currentRelease, currentVersion)) {
                            this.logger.info("CometVisu should be updated to version {}, you are using version {}", (Object)currentRelease, (Object)currentVersion);
                        }
                    }
                    catch (IOException e) {
                        this.logger.error("error reading version from installed CometVisu client: {}", (Object)e.getMessage(), (Object)e);
                    }
                }
            }
        } else {
            this.logger.error("webfolder {} is no directory", (Object)webFolder.getAbsolutePath());
        }
    }

    public static File findClientRoot(File webFolder, String fileName) {
        File file = new File(webFolder, fileName);
        if (!file.exists()) {
            File build = new File(webFolder, "build");
            File source = new File(webFolder, "source");
            File src = new File(webFolder, "src");
            if (build.exists()) {
                file = new File(build, fileName);
            } else if (source.exists()) {
                file = new File(source, fileName);
            } else if (src.exists()) {
                file = new File(src, fileName);
            }
        }
        return file;
    }

    public boolean isDownloadAvailableButBlocked() {
        return this.downloadAvailableButBlocked;
    }

    private boolean isNewer(String releaseVersion, String currentVersion) throws NumberFormatException {
        this.logger.debug("checking if {} is newer than {}", (Object)releaseVersion, (Object)currentVersion);
        Matcher release = this.semverPattern.matcher(releaseVersion);
        Matcher current = this.semverPattern.matcher(currentVersion);
        if (!release.matches()) {
            throw new NumberFormatException("release version format error " + releaseVersion);
        }
        if (!current.matches()) {
            throw new NumberFormatException("current version format error " + currentVersion);
        }
        int i = 1;
        while (i <= 3) {
            if (Integer.parseInt(release.group(i)) > Integer.parseInt(current.group(i))) {
                return false;
            }
            ++i;
        }
        return true;
    }

    private Map<String, Object> getLatestRelease() {
        if (this.latestRelease == null) {
            Properties headers = new Properties();
            headers.setProperty("Accept", "application/json");
            try {
                String response = HttpUtil.executeUrl((String)"GET", (String)RELEASE_URL, (Properties)headers, null, null, (int)this.timeout);
                if (response == null) {
                    this.logger.error("No response received from '{}'", (Object)RELEASE_URL);
                } else {
                    List jsonResponse = (List)new Gson().fromJson(response, ArrayList.class);
                    this.latestRelease = (Map)jsonResponse.get(0);
                }
            }
            catch (IOException e) {
                this.logger.error("error downloading release data: {}", (Object)e.getMessage(), (Object)e);
            }
        }
        return this.latestRelease;
    }

    public void downloadLatestRelease() {
        Map<String, Object> latestRelease = this.getLatestRelease();
        List assets = (List)latestRelease.get("assets");
        Map releaseAsset = null;
        for (Object assetObj : assets) {
            Map asset = (Map)assetObj;
            if (!((String)asset.get("content_type")).equalsIgnoreCase("application/zip")) continue;
            releaseAsset = asset;
            break;
        }
        if (releaseAsset == null) {
            this.logger.error("no zip download file found for release {}", latestRelease.get("name"));
        } else {
            File releaseFile = new File("release.zip");
            try {
                try {
                    URL url = new URL((String)releaseAsset.get("browser_download_url"));
                    FileUtils.copyURLToFile((URL)url, (File)releaseFile);
                    ZipFile zip = new ZipFile(releaseFile, 1);
                    this.extractFolder("cometvisu/release/", zip, Config.cometvisuWebfolder);
                }
                catch (IOException e) {
                    this.logger.error("error opening release zip file {}", (Object)e.getMessage(), (Object)e);
                    if (releaseFile.exists()) {
                        releaseFile.delete();
                    }
                }
            }
            finally {
                if (releaseFile.exists()) {
                    releaseFile.delete();
                }
            }
        }
    }

    private void extractFolder(String folderName, ZipFile zipFile, String destDir) {
        for (ZipEntry zipEntry : Collections.list(zipFile.entries())) {
            if (!zipEntry.getName().startsWith(folderName)) continue;
            String target = zipEntry.getName().substring(folderName.length());
            File file = new File(destDir, target);
            if (zipEntry.isDirectory()) {
                file.mkdirs();
                continue;
            }
            if (file.exists() && file.getPath().matches(".*/config/visu_config.*\\.xml")) continue;
            new File(file.getParent()).mkdirs();
            try {
                Throwable throwable = null;
                Object var9_11 = null;
                try {
                    InputStream is = zipFile.getInputStream(zipEntry);
                    try {
                        try (FileOutputStream os = new FileOutputStream(file);){
                            int len;
                            while ((len = is.read(BUFFER)) != -1) {
                                ((OutputStream)os).write(BUFFER, 0, len);
                            }
                            this.logger.info("extracted zip file {} to folder {}", (Object)zipFile.getName(), (Object)destDir);
                        }
                        if (is == null) continue;
                    }
                    catch (Throwable throwable2) {
                        if (throwable == null) {
                            throwable = throwable2;
                        } else if (throwable != throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        if (is != null) {
                            is.close();
                        }
                        throw throwable;
                    }
                    is.close();
                }
                catch (Throwable throwable3) {
                    if (throwable == null) {
                        throwable = throwable3;
                    } else if (throwable != throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    throw throwable;
                }
            }
            catch (IOException e) {
                this.logger.error("error extracting file {}", (Object)e.getMessage(), (Object)e);
            }
        }
    }
}

